/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.base16;
import org.xbill.DNS.utils.base64;
import org.xbill.DNS.utils.hexdump;
import org.xbill.Task.WorkerThread;

public class SimpleResolver
implements Resolver {
    public static final int PORT = 53;
    private InetAddress addr;
    private int port = 53;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private byte EDNSlevel = (byte)-1;
    private TSIG tsig;
    private int timeoutValue = 60000;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }

    public SimpleResolver(String string) throws UnknownHostException {
        String hostname;
        if (string == null && (hostname = FindServer.server()) == null) {
            hostname = defaultResolver;
        }
        this.addr = hostname.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
    }

    public Message send(Message message) throws IOException {
        Message response;
        DatagramPacket dp;
        int udpLength = 512;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.addr.getHostAddress() + ":" + this.port);
        }
        if (message.getQuestion().getType() == 252) {
            return this.sendAXFR(message);
        }
        Message query = (Message)message.clone();
        OPTRecord opt = query.getOPT();
        if (opt != null) {
            byte edns = (byte)opt.getVersion();
            udpLength = opt.getPayloadSize();
        } else if (this.EDNSlevel >= 0) {
            byte edns = this.EDNSlevel;
            udpLength = 1280;
            opt = new OPTRecord((short)udpLength, 0, edns);
            query.addRecord(opt, 3);
        }
        if (this.tsig != null) {
            this.tsig.apply(query, null);
        }
        byte[] out = query.toWire();
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("out", out));
        }
        if (this.useTCP || out.length > udpLength) {
            return this.sendTCP(query, out);
        }
        DatagramSocket s = new DatagramSocket();
        try {
            s.send(new DatagramPacket(out, out.length, this.addr, this.port));
            dp = new DatagramPacket(new byte[udpLength], udpLength);
            s.setSoTimeout(this.timeoutValue);
            try {
                s.receive(dp);
            }
            catch (IOException e) {
                if (Options.check("verbose")) {
                    System.err.println(";;" + e);
                    System.err.println(";; No response");
                }
                throw e;
            }
        }
        catch (Throwable e) {
            Object var10_12 = null;
            s.close();
            throw e;
        }
        Object var10_13 = null;
        s.close();
        byte[] in = new byte[dp.getLength()];
        System.arraycopy(dp.getData(), 0, in, 0, in.length);
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("in", in));
        }
        try {
            response = new Message(in);
        }
        catch (IOException e) {
            if (Options.check("verbose")) {
                e.printStackTrace();
            }
            throw new WireParseException("Error parsing message");
        }
        if (this.tsig != null) {
            boolean ok;
            response.TSIGsigned = true;
            byte error = this.tsig.verify(response, in, query.getTSIG());
            boolean bl = ok = error == 0;
            if (Options.check("verbose")) {
                System.err.println("TSIG verify: " + Rcode.string(error));
            }
            response.TSIGverified = ok;
        }
        s.close();
        if (response.getHeader().getFlag(6) && !this.ignoreTruncation) {
            return this.sendTCP(query, out);
        }
        return response;
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        SimpleResolver simpleResolver = this;
        synchronized (simpleResolver) {
            id = new Integer(uniqueID++);
        }
        String name = this.getClass() + ": " + query.getQuestion().getName();
        WorkerThread.assignThread(new ResolveThread(this, query, id, listener), name);
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message sendAXFR(Message message) throws IOException {
        Message response;
        Socket s;
        block22: {
            Message message2;
            block20: {
                int soacount = 0;
                boolean first = true;
                s = new Socket(this.addr, this.port);
                try {
                    Message query = (Message)message.clone();
                    if (this.tsig != null) {
                        this.tsig.apply(query, null);
                    }
                    byte[] out = query.toWire();
                    if (Options.check("verbosemsg")) {
                        System.err.println(hexdump.dump("out", out));
                    }
                    OutputStream sOut = s.getOutputStream();
                    new DataOutputStream(sOut).writeShort(out.length);
                    sOut.write(out);
                    s.setSoTimeout(this.timeoutValue);
                    response = new Message();
                    response.getHeader().setID(query.getHeader().getID());
                    if (this.tsig != null) {
                        this.tsig.verifyAXFRStart();
                        response.TSIGsigned = true;
                        response.TSIGverified = true;
                    }
                    while (soacount < 2) {
                        block21: {
                            boolean ok;
                            Message m;
                            byte[] in;
                            try {
                                InputStream sIn = s.getInputStream();
                                DataInputStream dataIn = new DataInputStream(sIn);
                                int inLength = dataIn.readUnsignedShort();
                                in = new byte[inLength];
                                dataIn.readFully(in);
                            }
                            catch (IOException e) {
                                if (!Options.check("verbose")) throw e;
                                System.err.println(";;" + e);
                                System.err.println(";; No response");
                                throw e;
                            }
                            if (Options.check("verbosemsg")) {
                                System.err.println(hexdump.dump("in", in));
                            }
                            try {
                                m = new Message(in);
                            }
                            catch (IOException iOException) {
                                throw new WireParseException("Error parsing message");
                            }
                            if (m.getHeader().getRcode() != 0) {
                                if (soacount != 0) {
                                    if (!Options.check("verbosemsg")) throw new WireParseException("Invalid AXFR message");
                                    System.err.println("Invalid AXFR packet: ");
                                    System.err.println(m);
                                    throw new WireParseException("Invalid AXFR message");
                                }
                                message2 = m;
                                Object var11_22 = null;
                                break block20;
                            }
                            if (m.getHeader().getCount(0) > 1 || m.getHeader().getCount(1) <= 0 || m.getHeader().getCount(2) != 0) {
                                if (!Options.check("verbosemsg")) throw new WireParseException("Invalid AXFR message");
                                System.err.println("Invalid AXFR packet: ");
                                System.err.println(m);
                                throw new WireParseException("Invalid AXFR message");
                            }
                            int i = 1;
                            block7: while (true) {
                                if (i >= 4) {
                                    if (this.tsig == null) break block21;
                                }
                                Enumeration e = m.getSection(i);
                                while (true) {
                                    if (!e.hasMoreElements()) {
                                        ++i;
                                        continue block7;
                                    }
                                    Record r = (Record)e.nextElement();
                                    response.addRecord(r, i);
                                    if (!(r instanceof SOARecord)) continue;
                                    ++soacount;
                                }
                                break;
                            }
                            boolean required = soacount > 1 || first;
                            byte error = this.tsig.verifyAXFR(m, in, query.getTSIG(), required, first);
                            boolean bl = ok = error == 0;
                            if (!ok) {
                                response.TSIGverified = false;
                            }
                            if (Options.check("verbose")) {
                                String status = m.getTSIG() == null ? (!ok ? "expected" : "<>") : (!ok ? "failed" : "ok");
                                System.err.println("TSIG verify: " + status);
                            }
                        }
                        first = false;
                    }
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var11_23 = null;
                    s.close();
                    throw throwable;
                }
            }
            s.close();
            return message2;
        }
        Object var11_24 = null;
        s.close();
        return response;
    }

    private Message sendTCP(Message query, byte[] out) throws IOException {
        Message response;
        byte[] in;
        Socket s = new Socket(this.addr, this.port);
        try {
            DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
            dataOut.writeShort(out.length);
            dataOut.write(out);
            s.setSoTimeout(this.timeoutValue);
            try {
                DataInputStream dataIn = new DataInputStream(s.getInputStream());
                int inLength = dataIn.readUnsignedShort();
                in = new byte[inLength];
                dataIn.readFully(in);
                if (Options.check("verbosemsg")) {
                    System.err.println(hexdump.dump("in", in));
                }
            }
            catch (IOException e) {
                if (Options.check("verbose")) {
                    System.err.println(";;" + e);
                    System.err.println(";; No response");
                }
                throw e;
            }
        }
        catch (Throwable e) {
            Object var9_11 = null;
            s.close();
            throw e;
        }
        Object var9_12 = null;
        s.close();
        try {
            response = new Message(in);
        }
        catch (IOException iOException) {
            throw new WireParseException("Error parsing message");
        }
        if (this.tsig != null) {
            boolean ok;
            response.TSIGsigned = true;
            byte error = this.tsig.verify(response, in, query.getTSIG());
            boolean bl = ok = error == 0;
            if (Options.check("verbose")) {
                System.err.println("TSIG verify: " + Rcode.string(error));
            }
            response.TSIGverified = ok;
        }
        return response;
    }

    public static void setDefaultResolver(String hostname) {
        defaultResolver = hostname;
    }

    public void setEDNS(int level) {
        this.EDNSlevel = (byte)level;
    }

    public void setIgnoreTruncation(boolean flag) {
        this.ignoreTruncation = flag;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTCP(boolean flag) {
        this.useTCP = flag;
    }

    public void setTimeout(int secs) {
        this.timeoutValue = secs * 1000;
    }

    public void setTSIGKey(String key) {
        String name;
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("getLocalHost failed");
            return;
        }
        this.setTSIGKey(name, key);
    }

    public void setTSIGKey(String name, String key) {
        byte[] keyArray = key.length() > 1 && key.charAt(0) == ':' ? base16.fromString(key.substring(1)) : base64.fromString(key);
        if (keyArray == null) {
            System.err.println("Invalid TSIG key string");
            return;
        }
        this.tsig = new TSIG(new Name(name), keyArray);
    }

    public void setTSIGKey(Name name, byte[] key) {
        this.tsig = new TSIG(name, key);
    }
}

