/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.gfx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ImagePanel
extends Panel
implements Runnable {
    private MediaTracker mtr = null;
    protected Image imgOrginal = null;
    protected Image imgScaled = null;
    private byte[] bytOrginal = null;
    private Thread thrd = null;
    private String strStatusMessage = "";
    private boolean blnHasError = false;
    private boolean blnImgLoaded = false;
    private boolean blnDrawFrame = false;
    private static final String MSG_LOAD_ERROR = "Ladefehler";
    private static final String MSG_LOADING = "Lade Bild";

    public ImagePanel() {
        this.init();
    }

    public void clearImage() {
        if (this.imgOrginal != null) {
            this.imgOrginal.flush();
            this.imgOrginal = null;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
            this.imgScaled = null;
        }
        this.repaint();
    }

    private void componentHandler(ComponentEvent e) {
        switch (e.getID()) {
            case 101: 
            case 102: {
                this.rescale();
            }
        }
    }

    public void dispose() {
        if (this.mtr == null) {
            return;
        }
        if (this.thrd != null) {
            MediaTracker mediaTracker = this.mtr;
            synchronized (mediaTracker) {
                this.mtr.notify();
            }
        }
        if (this.imgOrginal != null) {
            this.mtr.removeImage(this.imgOrginal);
            this.imgOrginal.flush();
            this.imgOrginal = null;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
            this.imgScaled = null;
        }
        this.bytOrginal = null;
    }

    public byte[] getPicture() {
        while (this.thrd != null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.bytOrginal == null ? new byte[]{} : this.bytOrginal;
    }

    public Dimension getPictureSize() {
        try {
            while (!this.blnImgLoaded) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.blnHasError) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.imgOrginal.getWidth(this), this.imgOrginal.getHeight(this));
    }

    private void init() {
        this.mtr = new MediaTracker(this);
        this.addComponentListener(new ComponentAdapter(this){
            /* synthetic */ ImagePanel this$0;

            public void componentShown(ComponentEvent e) {
                ImagePanel.access$componentHandler(this.this$0, e);
            }

            public void componentResized(ComponentEvent e) {
                ImagePanel.access$componentHandler(this.this$0, e);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private void loadImage(byte[] buffer) {
        if (buffer == null) {
            this.setStatusMessage(null);
            return;
        }
        this.setStatusMessage(MSG_LOADING);
        this.dispose();
        this.bytOrginal = new byte[buffer.length];
        System.arraycopy(buffer, 0, this.bytOrginal, 0, buffer.length);
        this.imgOrginal = Toolkit.getDefaultToolkit().createImage(this.bytOrginal);
        this.mtr.addImage(this.imgOrginal, 0);
        this.thrd = new Thread((Runnable)this, "ImageFetcher");
        this.thrd.setPriority(10);
        this.thrd.start();
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        ((Component)f).setSize(100, 100);
        ImagePanel img = new ImagePanel();
        f.add(img);
        ((Component)f).setVisible(true);
        System.out.println("add");
        img.setPicture("c:\\9\\toaster6.gif");
        System.out.println("end");
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.strStatusMessage != null) {
            g.setFont(new Font("dialog", 1, 14));
            FontMetrics f = g.getFontMetrics();
            int intW = 0;
            int intH = 0;
            if (f != null) {
                intW = f.stringWidth(this.strStatusMessage);
                intH = f.getHeight();
            }
            g.drawString(this.strStatusMessage, this.getSize().width / 2 - intW / 2, this.getSize().height / 2 - intH / 2);
            if (this.blnDrawFrame) {
                g.draw3DRect(0, 0, this.getSize().width, this.getSize().height, true);
            }
            return;
        }
        if (this.imgScaled != null) {
            try {
                g.drawImage(this.imgScaled, 0, 0, this.imgScaled.getWidth(this), this.imgScaled.getHeight(this), this);
            }
            catch (Exception exception) {}
            if (this.blnDrawFrame) {
                g.drawRect(0, 0, this.imgScaled.getWidth(this) - 1, this.imgScaled.getHeight(this) - 1);
            }
            return;
        }
    }

    protected void rescale() {
        if (this.imgOrginal == null) {
            return;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
        }
        int intThisW = this.getSize().width;
        int intThisH = this.getSize().height;
        int intPicW = this.imgOrginal.getWidth(this);
        int intPicH = this.imgOrginal.getHeight(this);
        if (intPicW < 1 || intPicH < 1 || intThisW < 1 || intThisH < 1) {
            return;
        }
        double dblScaleW = (double)intThisW / (double)intPicW;
        double dblScaleH = (double)intThisH / (double)intPicH;
        int intDestW = intPicH;
        int intDestH = intPicH;
        if (dblScaleW > dblScaleH) {
            intDestW = intPicW * intThisH / intPicH;
            intDestH = intThisH;
        }
        if (dblScaleW < dblScaleH) {
            intDestW = intThisW;
            intDestH = -intPicH * intThisW / intPicW;
        }
        if (dblScaleW == dblScaleH) {
            intDestW = intThisW;
            intDestH = intThisH;
        }
        this.imgScaled = this.imgOrginal.getScaledInstance(intDestW, intDestH, 2);
    }

    public void run() {
        this.blnHasError = false;
        try {
            this.mtr.waitForID(0, 60000L);
            this.blnImgLoaded = true;
            this.blnHasError = this.mtr.isErrorID(0);
            this.mtr.removeImage(this.imgOrginal, 0);
            this.rescale();
            this.setStatusMessage(this.blnHasError ? "?" : null);
        }
        catch (InterruptedException interruptedException) {}
        this.thrd = null;
    }

    public void setDrawFrame(boolean b) {
        this.blnDrawFrame = b;
    }

    public void setPicture(File fl) {
        try {
            FileInputStream in = new FileInputStream(fl);
            this.setPicture(in);
            in.close();
        }
        catch (Exception exception) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
            this.repaint();
        }
    }

    public void setPicture(InputStream inPicture) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int i = 0;
        try {
            while ((i = inPicture.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
            this.loadImage(baos.toByteArray());
        }
        catch (IOException iOException) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
        }
    }

    public void setPicture(String strPicture) {
        this.setPicture(new File(strPicture));
    }

    public void setPicture(URL urlPicture) {
        try {
            InputStream in = urlPicture.openStream();
            this.setPicture(in);
            in.close();
        }
        catch (IOException iOException) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
            this.repaint();
        }
    }

    public void setPicture(byte[] buffer) {
        this.loadImage(buffer);
    }

    public void setStatusMessage(String s) {
        this.strStatusMessage = s;
        this.repaint();
    }

    static void access$componentHandler(ImagePanel imagePanel, ComponentEvent componentEvent) {
        imagePanel.componentHandler(componentEvent);
    }
}

