/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.email;

import de.zwanzigeins.codecs.QuotedPrintableCodec;
import de.zwanzigeins.template.TemplateParser;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.VectorString;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class EMail {
    private static final String VERSION = "20/1 EMailObject v1.2";
    protected static final String CRLF = "\r\n";
    protected String strEncoding = null;
    protected boolean blnAddBCCToHeader = false;
    protected StringBuffer strbContent = null;
    protected VectorString svecHeader = null;
    private String strMailFrom = null;
    private VectorString svecMailTo = null;
    private VectorString svecMailCC = null;
    private VectorString svecMailBCC = null;
    private String strReplyTo = null;
    private String strSubject = "";

    public EMail() throws UnsupportedEncodingException {
        this(false);
    }

    public EMail(String strEncoding) throws UnsupportedEncodingException {
        this(strEncoding, false);
    }

    public EMail(String strEncoding, boolean blnAddBCCToHeader) throws UnsupportedEncodingException {
        this.strEncoding = strEncoding;
        this.reset();
        this.blnAddBCCToHeader = blnAddBCCToHeader;
        "".getBytes(strEncoding);
    }

    public EMail(boolean blnAddBCCToHeader) throws UnsupportedEncodingException {
        this("iso-8859-1", blnAddBCCToHeader);
    }

    public void addContent(String string) {
        String strLine;
        if (string.equals(".")) {
            strLine = "..";
        }
        this.strbContent.append(strLine);
        if (!strLine.endsWith(CRLF)) {
            this.strbContent.append(CRLF);
        }
    }

    public void addRecipient(String strAddress) {
        this.svecMailTo.addElement(this.buildAddress(strAddress));
    }

    public void addRecipient(String string, String strAddress) {
        String strName = string.trim();
        this.svecMailTo.addElement("\"" + strName + "\" " + this.buildAddress(strAddress));
    }

    public void addRecipientBCC(String strAddress) {
        this.svecMailBCC.addElement(this.buildAddress(strAddress));
    }

    public void addRecipientBCC(String string, String strAddress) {
        String strName = string.trim();
        this.svecMailBCC.addElement("\"" + strName + "\" " + this.buildAddress(strAddress));
    }

    public void addRecipientCC(String strAddress) {
        this.svecMailCC.addElement(this.buildAddress(strAddress));
    }

    public void addRecipientCC(String string, String strAddress) {
        String strName = string.trim();
        this.svecMailCC.addElement("\"" + strName + "\" " + this.buildAddress(strAddress));
    }

    private String buildAddress(String string) {
        String strAddress = string.trim();
        if (!strAddress.endsWith(">")) {
            strAddress = "<" + strAddress + ">";
        }
        return strAddress;
    }

    private String extractSmtpUser(String str) {
        int intStart = str.lastIndexOf(60) + 1;
        int intEnd = str.indexOf(62, intStart);
        if (intEnd == -1) {
            intEnd = str.length();
        }
        if (intStart == intEnd) {
            return "";
        }
        return str.substring(intStart, intEnd);
    }

    private ByteString generateMail() {
        int i;
        ByteString bsOut = new ByteString(this.strbContent.length() + 1024);
        bsOut.append("From: " + this.strMailFrom + CRLF);
        if (this.svecMailTo.size() > 0) {
            bsOut.append("To: ");
            i = 0;
            while (i < this.svecMailTo.size()) {
                bsOut.append(String.valueOf(this.svecMailTo.elementAt(i)) + ", ");
                ++i;
            }
            bsOut.setLength(bsOut.getLength() - 2);
            bsOut.append(CRLF);
        }
        if (this.svecMailCC.size() > 0) {
            bsOut.append("CC: ");
            i = 0;
            while (i < this.svecMailCC.size()) {
                bsOut.append(String.valueOf(this.svecMailCC.elementAt(i)) + ", ");
                ++i;
            }
            bsOut.setLength(bsOut.getLength() - 2);
            bsOut.append(CRLF);
        }
        if (this.svecMailBCC.size() > 0 && this.blnAddBCCToHeader) {
            bsOut.append("BCC: ");
            i = 0;
            while (i < this.svecMailBCC.size()) {
                bsOut.append(String.valueOf(this.svecMailBCC.elementAt(i)) + ", ");
                ++i;
            }
            bsOut.setLength(bsOut.getLength() - 2);
            bsOut.append(CRLF);
        }
        if (this.strReplyTo.length() != 0) {
            bsOut.append("Reply-To: " + this.strReplyTo + CRLF);
        }
        i = 0;
        while (i < this.svecHeader.size()) {
            bsOut.append(this.svecHeader.elementAt(i));
            bsOut.append(CRLF);
            ++i;
        }
        bsOut.append("Subject: ");
        if (this.strSubject.length() > 0) {
            QuotedPrintableCodec qpCodec = new QuotedPrintableCodec();
            try {
                bsOut.append("=?" + this.strEncoding + "?q?" + qpCodec.encode(this.strSubject.getBytes(this.strEncoding)) + "?=", this.strEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            bsOut.append(CRLF);
        }
        bsOut.append(CRLF);
        try {
            bsOut.append(this.strbContent.toString(), this.strEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        bsOut.append(".");
        bsOut.append(CRLF);
        return bsOut;
    }

    public String getEncoding() {
        return this.strEncoding;
    }

    private int getHeaderIdx(String string) {
        String strHeader = String.valueOf(string) + ":";
        strHeader = strHeader.toLowerCase();
        int i = 0;
        while (i < this.svecHeader.size()) {
            if (this.svecHeader.elementAt(i).toLowerCase().startsWith(strHeader)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public byte[] getMailAsByteArray() {
        return this.generateMail().toByteArray();
    }

    public void getMailAsFile(File flOut) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(flOut);
            ByteString bs = this.generateMail();
            fos.write(bs.getInternalByteArray(), 0, bs.getLength());
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            HelperIO.close(fos);
            throw throwable;
        }
        Object var3_7 = null;
        HelperIO.close(fos);
    }

    public OutputStream getMailAsStream() throws IOException {
        ByteString bs = this.generateMail();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bs.getLength());
        baos.write(bs.getInternalByteArray(), 0, bs.getLength());
        return baos;
    }

    public String[] getSmtpRecipients() {
        VectorString sv = new VectorString(this.svecMailTo.size() + this.svecMailCC.size() + this.svecMailBCC.size());
        int i = 0;
        while (i < this.svecMailTo.size()) {
            sv.addElement(this.svecMailTo.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.svecMailCC.size()) {
            sv.addElement(this.svecMailCC.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < this.svecMailBCC.size()) {
            sv.addElement(this.svecMailBCC.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < sv.size()) {
            String s = sv.elementAt(i);
            if ((s = this.extractSmtpUser(s)).length() == 0) {
                sv.removeElementAt(i);
                --i;
            } else {
                sv.setElementAt(s, i);
            }
            ++i;
        }
        String[] s = new String[sv.size()];
        sv.copyInto(s);
        return s;
    }

    public String getSmtpSender() {
        return this.extractSmtpUser(this.strMailFrom);
    }

    public static void main(String[] args) throws Throwable {
        String[] ss = HelperExtract.getRFC822_Recipients("\"Bernd Hohmann\" <hohmann@harddiskcafe.de>, \"Claudia Bennek\" <bennek@mmdeutschland.de>");
        int i = 0;
        while (i < ss.length) {
            System.out.println(ss[i]);
            ++i;
        }
        EMail em = new EMail(true);
        em.setMailFrom("\"Bernd Hohmann\" <bernd.hohmann@zwanzigeins.de>");
        em.addRecipient("\"Bernd Hohmann\" <hohmann@harddiskcafe.de>");
        em.addRecipient("\"Claudia Bennek\" <bennek@mmdeutschland.de>");
        String s = "Der Datenimport der Shopdaten wurde beendet.\n\nBen\u00f6tigte Zeit: [%duration%]\nEingabedatei  : [%inputfile%]";
        TemplateParser tplTmp = new TemplateParser();
        tplTmp.setVar("duration", "100sek");
        tplTmp.setVar("inputfile", "c:\\test");
        em.setContent(tplTmp.process(s));
        System.out.println(new String(em.getMailAsByteArray(), em.getEncoding()));
        em.getMailAsFile(new File("C:/mail.out"));
    }

    public void reset() {
        this.strbContent = new StringBuffer();
        this.svecHeader = new VectorString();
        this.strMailFrom = "";
        this.svecMailTo = new VectorString();
        this.svecMailCC = new VectorString();
        this.svecMailBCC = new VectorString();
        this.strReplyTo = "";
        this.strSubject = "";
        this.setHeader("Date", new Date().toString());
        this.setHeader("MIME-Version", "1.0");
        this.setHeader("Content-type", "text/plain; charset=" + this.strEncoding);
        this.setHeader("Content-transfer-encoding", "8bit");
        this.setHeader("Priority", "Normal");
        this.setHeader("X-Mailer", VERSION);
    }

    public void setContent(String strLine) {
        this.strbContent.setLength(0);
        StringReader sr = new StringReader(strLine);
        BufferedReader br = new BufferedReader(sr);
        String strBuffer = null;
        try {
            while ((strBuffer = br.readLine()) != null) {
                this.addContent(strBuffer);
            }
        }
        catch (IOException iOException) {}
    }

    public void setHeader(String strHeader, String strContent) {
        int idx = this.getHeaderIdx(strHeader);
        if (idx == -1) {
            this.svecHeader.addElement(String.valueOf(strHeader) + ": " + strContent);
        } else {
            this.svecHeader.setElementAt(String.valueOf(strHeader) + ": " + strContent, idx);
        }
    }

    public void setMailFrom(String strAddress) {
        this.strMailFrom = this.buildAddress(strAddress);
    }

    public void setMailFrom(String strName, String strAddress) {
        this.strMailFrom = "\"" + strName + "\" " + this.buildAddress(strAddress);
    }

    public void setReplyTo(String s) {
        this.strReplyTo = s;
    }

    public void setSubject(String s) {
        this.strSubject = s;
    }
}

