/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class UserRecord
extends StorageRecord
implements Serializable {
    public static final int RESTRICT_IP_NONE = 0;
    public static final int RESTRICT_IP_TO_DOMAIN_SETUP = 1;
    public static final int RESTRICT_IP_TO_USER_SETUP = 2;
    public static final int RESTRICT_IP_TO_DOMAIN_AND_USER_SETUP = 3;
    public static final int SMTP_AFTER_POP3_NO = 0;
    public static final int SMTP_AFTER_POP3_USE_DOMAIN_SETUP = 1;
    public static final int SMTP_AFTER_POP3_YES = 2;
    public static final int PRIVILEGE_NONE = -1;
    public static final int PRIVILEGE_USER = 0;
    public static final int PRIVILEGE_POWERUSER = 1;
    public static final int PRIVILEGE_DOMAINADMIN = 3;
    public static final int PRIVILEGE_SYSTEMADMIN = 4;
    public static final int PRIVILEGE_SUPERUSER = 5;
    public static final int QUOTA_NONE = 0;
    public static final int QUOTA_DOMAIN = 1;
    public static final int QUOTA_INDIVIDUAL = 2;
    private String strUserName = null;
    private String strPassWord = null;
    private String strRedirect = null;
    private String[] strCopy = null;
    private long lngPOP3_Time = -1L;
    private String strPOP3_IP = null;
    private int intSMTP_after_POP3 = -1;
    private int intSessionTimeout = -1;
    private int intRestrictIP_SMTP = -1;
    private int intRestrictIP_POP3 = -1;
    private IP_Network[] ipNetwork = null;
    private boolean blnEnabled = false;
    private int intPrivilege = -1;
    private String strMemo = null;
    private int intQuota_Usage = 1;
    private int intQuota_Days = 0;
    private int intQuota_Mails = 0;
    private int intQuota_MB = 0;
    private long lngLastMailReceived = -1L;
    private boolean blnAllowXREN = false;
    private boolean blnDUMMY1 = true;

    public UserRecord() {
        this.init();
    }

    public boolean getAllowXREN() {
        return this.blnAllowXREN;
    }

    public String[] getCopy() {
        return this.strCopy;
    }

    public String getDomainPart() {
        return HelperExtract.splitUserName_getDomain((String)this.strUserName);
    }

    public boolean getEnabled() {
        return this.blnEnabled;
    }

    public IP_Network[] getIP_Networks() {
        return this.ipNetwork;
    }

    public long getLastMailReceived() {
        return this.lngLastMailReceived;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public String getPassWord() {
        return this.strPassWord;
    }

    public String getPOP3_IP() {
        return this.strPOP3_IP;
    }

    public long getPOP3_Time() {
        return this.lngPOP3_Time;
    }

    public int getPrivilege() {
        return this.intPrivilege;
    }

    public String getPrivilegeAsString() {
        return UserRecord.getPrivilegeString(this.intPrivilege);
    }

    public static final String getPrivilegeString(int i) {
        switch (i) {
            case 0: {
                return "User";
            }
            case 1: {
                return "Poweruser";
            }
            case 3: {
                return "Domainadmin";
            }
            case 4: {
                return "Systemadmin";
            }
            case 5: {
                return "Administrator";
            }
        }
        return "Unknown";
    }

    public int getQuota_Days() {
        return this.intQuota_Days;
    }

    public int getQuota_Mails() {
        return this.intQuota_Mails;
    }

    public int getQuota_MB() {
        return this.intQuota_MB;
    }

    public int getQuota_Usage() {
        return this.intQuota_Usage;
    }

    public String getRedirect() {
        return this.strRedirect;
    }

    public int getRestrictIP_POP3() {
        return this.intRestrictIP_POP3;
    }

    public int getRestrictIP_SMTP() {
        return this.intRestrictIP_SMTP;
    }

    public int getSessionTimeout() {
        return this.intSessionTimeout;
    }

    public int getSMTP_after_POP3() {
        return this.intSMTP_after_POP3;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public void init() {
        this.strUserName = "";
        this.strPassWord = "";
        this.strRedirect = "";
        this.strCopy = new String[0];
        this.lngPOP3_Time = 0L;
        this.strPOP3_IP = "";
        this.intSMTP_after_POP3 = 1;
        this.intSessionTimeout = 30;
        this.intRestrictIP_SMTP = 1;
        this.intRestrictIP_POP3 = 1;
        this.ipNetwork = new IP_Network[0];
        this.blnEnabled = true;
        this.intPrivilege = 0;
        this.strMemo = "";
        this.intQuota_Usage = 1;
        this.intQuota_Days = 0;
        this.intQuota_Mails = 0;
        this.intQuota_MB = 0;
        this.lngLastMailReceived = 0L;
        this.blnAllowXREN = false;
        this.blnDUMMY1 = true;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUserName);
        strb.append('\u0014');
        strb.append(this.strPassWord);
        strb.append('\u0014');
        strb.append(this.strRedirect);
        strb.append('\u0014');
        strb.append(StorageRecord.conv_array2string(this.strCopy));
        strb.append('\u0014');
        strb.append(this.lngPOP3_Time);
        strb.append('\u0014');
        strb.append(this.strPOP3_IP);
        strb.append('\u0014');
        strb.append(this.intSMTP_after_POP3);
        strb.append('\u0014');
        strb.append(this.intSessionTimeout);
        strb.append('\u0014');
        strb.append(this.intRestrictIP_SMTP);
        strb.append('\u0014');
        strb.append(this.intRestrictIP_POP3);
        strb.append('\u0014');
        strb.append(StorageRecord.conv_networks2string(this.ipNetwork));
        strb.append('\u0014');
        strb.append(this.blnEnabled);
        strb.append('\u0014');
        strb.append(this.intPrivilege);
        strb.append('\u0014');
        strb.append(this.strMemo);
        strb.append('\u0014');
        strb.append(this.intQuota_Usage);
        strb.append('\u0014');
        strb.append(this.intQuota_Days);
        strb.append('\u0014');
        strb.append(this.intQuota_Mails);
        strb.append('\u0014');
        strb.append(this.intQuota_MB);
        strb.append('\u0014');
        strb.append(this.lngLastMailReceived);
        strb.append('\u0014');
        strb.append(this.blnAllowXREN);
        strb.append('\u0014');
        strb.append(this.blnDUMMY1);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strUserName = this.nextToken();
        this.strPassWord = this.nextToken();
        this.strRedirect = this.nextToken();
        this.strCopy = StorageRecord.conv_string2array(this.nextToken());
        this.lngPOP3_Time = this.nextTokenLong();
        this.strPOP3_IP = this.nextToken();
        this.intSMTP_after_POP3 = this.nextTokenInteger();
        this.intSessionTimeout = this.nextTokenInteger();
        this.intRestrictIP_SMTP = this.nextTokenInteger();
        this.intRestrictIP_POP3 = this.nextTokenInteger();
        this.ipNetwork = StorageRecord.conv_string2networks(this.nextToken());
        this.blnEnabled = this.nextTokenBoolean();
        this.intPrivilege = this.nextTokenInteger();
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.intQuota_Usage = this.nextTokenInteger();
            this.intQuota_Days = this.nextTokenInteger();
            this.intQuota_Mails = this.nextTokenInteger();
            this.intQuota_MB = this.nextTokenInteger();
        }
        if (this.hasMoreTokens()) {
            this.lngLastMailReceived = this.nextTokenLong();
        }
        if (this.hasMoreTokens()) {
            this.blnAllowXREN = this.nextTokenBoolean();
        }
        if (this.hasMoreTokens()) {
            this.blnDUMMY1 = this.nextTokenBoolean();
        }
    }

    public void setAllowXREN(boolean b) {
        this.blnAllowXREN = b;
    }

    public void setCopy(String[] s) {
        this.strCopy = new String[s.length];
        int i = 0;
        while (i < s.length) {
            this.strCopy[i] = Helper.limit(s[i].toLowerCase(), 129);
            ++i;
        }
    }

    public void setEnabled(boolean b) {
        this.blnEnabled = b;
    }

    public void setIP_Networks(IP_Network[] ip) {
        this.ipNetwork = ip;
    }

    public void setLastMailReceived(long l) {
        this.lngLastMailReceived = l;
    }

    public void setMemo(String str) {
        this.strMemo = Helper.limit(str, 512);
    }

    public void setPassWord(String s) {
        this.strPassWord = Helper.limit(s.toLowerCase(), 32);
    }

    public void setPOP3_IP(String str) {
        this.strPOP3_IP = str;
    }

    public void setPOP3_Time(long lng) {
        this.lngPOP3_Time = lng;
    }

    public void setPrivilege(int i) {
        if (i < 0 || i > 5) {
            throw new IllegalArgumentException("Value " + i + " is out of range");
        }
        this.intPrivilege = i;
    }

    public void setQuota_Days(int i) {
        this.intQuota_Days = i;
    }

    public void setQuota_Mails(int i) {
        this.intQuota_Mails = i;
    }

    public void setQuota_MB(int i) {
        this.intQuota_MB = i;
    }

    public void setQuota_Usage(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                this.intQuota_Usage = i;
                break;
            }
            default: {
                throw new IllegalAccessError("Illegal value for QuotaUsage");
            }
        }
    }

    public void setRedirect(String s) {
        this.strRedirect = Helper.limit(s.toLowerCase(), 129);
    }

    public void setRestrictIP_POP3(int i) {
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException("Value " + i + " is out of range");
        }
        this.intRestrictIP_POP3 = i;
    }

    public void setRestrictIP_SMTP(int i) {
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException("Value " + i + " is out of range");
        }
        this.intRestrictIP_SMTP = i;
    }

    public void setSessionTimeout(int i) {
        this.intSessionTimeout = i;
    }

    public void setSMTP_after_POP3(int i) {
        if (i < 0 || i > 2) {
            throw new IllegalArgumentException("Value " + i + " is out of range");
        }
        this.intSMTP_after_POP3 = i;
    }

    public void setUserName(String s) {
        String strTmp = HelperValidate.validateRFC822_User((String)s);
        if (strTmp == null) {
            throw new IllegalArgumentException(String.valueOf(s) + " isn't a valid domain name");
        }
        this.strUserName = Helper.limit(strTmp.toLowerCase(), 129);
    }

    public String toString() {
        return this.getUserName();
    }

    public boolean validatePassword(String strVerify) {
        return this.strPassWord.equals(strVerify.toLowerCase());
    }
}

