/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class LicenceRecord
extends StorageRecord {
    public static final String KEYFILE = "zerotoaster.key";
    public String strLicence_Serial = null;
    public String strLicence_User1 = null;
    public String strLicence_User2 = null;
    public int intMaxDomains;
    public int intMaxUsers;
    public int intMaxLists;
    public boolean blnAVScan;
    public long lngValidTo = 0L;

    public LicenceRecord() {
        this.init();
    }

    public void init() {
        this.strLicence_Serial = "";
        this.strLicence_User1 = "UNREGISTERED";
        this.strLicence_User2 = "EVALUATION COPY";
        this.intMaxDomains = 2;
        this.intMaxUsers = 5;
        this.intMaxLists = 999;
        this.blnAVScan = true;
        new GregorianCalendar();
        Calendar c = Calendar.getInstance();
        this.lngValidTo = (long)(c.get(2) + 1) * 10000L + (long)c.get(1);
        File fl = new File(KEYFILE);
        if (!fl.exists()) {
            return;
        }
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(new FileInputStream(fl));
                Random rnd = new Random(dis.readInt() & 0xFFFF);
                int intLength = dis.readByte();
                StringBuffer strb = new StringBuffer(intLength);
                int i = 0;
                while (i < intLength) {
                    strb.append((char)(dis.readChar() ^ rnd.nextInt()));
                    ++i;
                }
                this.recordImport(strb.toString());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Damaged licence file");
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            Helper.close(dis);
            throw throwable;
        }
        Object var4_10 = null;
        Helper.close(dis);
    }

    public static final String long2date(long lngDate) {
        String s = String.valueOf(lngDate);
        if (s.length() == 5) {
            s = "0" + s;
        }
        s = String.valueOf(s.substring(0, 2)) + "/" + s.substring(2);
        return s;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strLicence_Serial);
        strb.append('\u0014');
        strb.append(this.strLicence_User1);
        strb.append('\u0014');
        strb.append(this.strLicence_User2);
        strb.append('\u0014');
        strb.append(this.intMaxDomains);
        strb.append('\u0014');
        strb.append(this.intMaxUsers);
        strb.append('\u0014');
        strb.append(false);
        strb.append('\u0014');
        strb.append(false);
        strb.append('\u0014');
        strb.append(this.blnAVScan);
        strb.append('\u0014');
        strb.append(this.lngValidTo);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strLicence_Serial = this.nextToken();
        this.strLicence_User1 = this.nextToken();
        this.strLicence_User2 = this.nextToken();
        this.intMaxDomains = this.nextTokenInteger();
        this.intMaxUsers = this.nextTokenInteger();
        this.nextTokenBoolean();
        this.nextTokenBoolean();
        this.blnAVScan = this.nextTokenBoolean();
        this.lngValidTo = this.hasMoreTokens() ? this.nextTokenLong() : 92004L;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("#" + this.strLicence_Serial + "; " + this.strLicence_User1 + "; " + this.strLicence_User2 + "; ");
        strb.append(" ");
        strb.append(this.intMaxDomains + " Domains; ");
        strb.append(this.intMaxUsers + " Users; ");
        strb.append("AV Scan " + this.blnAVScan + "; ");
        strb.append("Valid to: " + LicenceRecord.long2date(this.lngValidTo));
        return strb.toString();
    }
}

