/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperFilter;
import java.io.IOException;
import java.io.InterruptedIOException;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.main.ServerInstance;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.util.Helper;

public abstract class ServerSocketInstance
extends ServerInstance
implements Runnable,
Constants {
    protected LineSocket lsok = null;
    protected boolean blnSupressSocketOutput = false;
    protected String strLastReceivedPlain = "";

    public ServerSocketInstance(String strInstanceID) {
        super(strInstanceID);
    }

    protected String cmdReceive() throws IOException {
        String strMsg = this.lsok.readln();
        if (strMsg == null) {
            throw new IOException("Got NULL from input stream");
        }
        this.strLastReceivedPlain = strMsg;
        strMsg = strMsg.toLowerCase().trim();
        Configuration.logContext.write("M I:" + strMsg);
        return HelperFilter.filterBackspace((String)strMsg);
    }

    protected boolean cmdSend(String strMsg) throws IOException {
        Configuration.logContext.write("M O:" + strMsg);
        if (!this.blnSupressSocketOutput) {
            this.lsok.println(strMsg);
            this.lsok.flush();
        }
        return true;
    }

    public void dispose() {
        this.blnDisposed = true;
        this.setThreadName();
        Helper.close(this.lsok);
        super.dispose();
        this.resetThreadName();
    }

    public void run() {
        this.init0();
        this.loThreadUp.lo_notify();
        while (!this.blnDisposed) {
            Object var1_1;
            this.loNotify.lo_wait();
            if (this.blnDisposed) {
                Configuration.logContext.write("D Thread end due to shutdown");
                return;
            }
            this.strTransactionID = this.getTransactionID();
            Configuration.logContext.write("# TS " + this.strTransactionID);
            try {
                try {
                    this.service();
                    Helper.flush(this.lsok);
                }
                catch (StorageException e) {
                    Configuration.logContext.write("! Handled exception", (Throwable)e);
                }
                catch (InterruptedIOException interruptedIOException) {
                    Configuration.logContext.write("? Timeout during read/write");
                }
                catch (IOException iOException) {
                    Configuration.logContext.write("? Socket closed by remote");
                }
                catch (Throwable t) {
                    Configuration.logContext.write("? Unhandled exception", t);
                }
            }
            catch (Throwable throwable) {
                var1_1 = null;
                Helper.close(this.lsok);
                throw throwable;
            }
            var1_1 = null;
            Helper.close(this.lsok);
            try {
                this.servicePostProcess();
            }
            catch (Throwable t) {
                Configuration.logContext.write("? servicePostProcess:", t);
            }
            this.lsok = null;
            this.smManager.rollback();
            Configuration.logContext.write("# TE " + this.strTransactionID);
            this.setBusy(false);
        }
    }
}

