/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorStringReverse;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.io.SMTPInputReader;
import net.zerotoaster.mta.main.ServerSocketInstance;
import net.zerotoaster.mta.main.ZeroToaster;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.MailingListRecord;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.HostIP;
import net.zerotoaster.mta.util.RBLCheck;
import net.zerotoaster.mta.util.UserAlias;

public class SMTP_ServerInstance
extends ServerSocketInstance {
    private static final int CMD_NOTFOUND = 0;
    private static final int CMD_HELO = 1;
    private static final int CMD_EHLO = 2;
    private static final int CMD_NOOP = 3;
    private static final int CMD_RSET = 4;
    private static final int CMD_QUIT = 5;
    private static final int CMD_MAIL = 6;
    private static final int CMD_RCPT = 7;
    private static final int CMD_DATA = 8;
    private static final int CMD_HELP = 9;
    private static final int CMD_AUTH = 10;
    private static final int CMD_ILLEGAL_TRANSACTION_STATE = 99;
    private static String[] CMDS = null;
    private boolean blnIllegalTransactionState = false;
    private int intIllegalTransactionCount = 0;
    private boolean blnFatalError = false;
    private UserInfo uiMailFrom = null;
    private Vector vecRecipients = null;
    private int intAdditionalRecipients = 0;
    private Vector vecHeader = null;
    private boolean blnSenderIntern = false;
    private boolean blnTrustedNetwork = false;
    private boolean blnSMTP_AUTH = false;
    private String strSMTP_AUTH_User = null;
    private boolean blnToMailinglist = false;
    private String strAccUser = null;
    boolean blnAVScan = false;
    private FilterRecord[] flFilters = null;
    private static int intInstances = 0;
    private String strHELO = null;
    private RBLCheck rbl = null;
    private UserAlias uaAlias = null;

    public SMTP_ServerInstance(String strInstanceID) {
        super(strInstanceID);
        this.init();
        this.kickThread();
    }

    private String alias_smart_delivery(String strUser) {
        if (strUser.indexOf("@") == -1) {
            return strUser;
        }
        String strTmpUser = HelperExtract.splitUserName_getUser((String)strUser);
        String strTmpDom = HelperExtract.splitUserName_getDomain((String)strUser);
        this.smManager.userRead(strUser);
        DomainRecord domRecord = this.smManager.domainRead(strTmpDom);
        if (domRecord == null) {
            return strUser;
        }
        this.blnAVScan |= domRecord.getAVScan();
        if (this.smManager.userRead(strUser) != null) {
            return strUser;
        }
        boolean blnFound = false;
        int i = 0;
        while (i < this.cnf.strAlias_SmartDelivery.length) {
            if (this.cnf.strAlias_SmartDelivery[i].equalsIgnoreCase(strTmpUser)) {
                blnFound = true;
                break;
            }
            ++i;
        }
        if (!blnFound) {
            return strUser;
        }
        this.logUserRedirection(strUser, strTmpUser, "smart delivery");
        return strTmpUser;
    }

    private void buildNewHeader() {
        this.vecHeader.removeAllElements();
        String TAB = new String(new byte[]{9});
        this.vecHeader.addElement("Received: from " + this.lsok.getInetAddress().getHostName() + " [" + this.lsok.getInetAddress().getHostAddress() + "]");
        this.vecHeader.addElement(String.valueOf(TAB) + "by   " + this.lsok.getLocalAddress().getHostName() + " [" + this.lsok.getLocalAddress().getHostAddress() + "]");
        this.vecHeader.addElement(String.valueOf(TAB) + "MTA  " + ZeroToaster.getVersion());
        this.vecHeader.addElement(String.valueOf(TAB) + "at   " + new Date().toString());
        this.vecHeader.addElement(String.valueOf(TAB) + "id   " + this.strTransactionID);
        this.vecHeader.addElement(String.valueOf(TAB) + "HELO [" + this.strHELO + "]");
        if (this.blnSMTP_AUTH) {
            this.vecHeader.addElement("X-ZeroToaster-Info: SMTP AUTH User was " + this.strSMTP_AUTH_User);
        }
        this.vecHeader.addElement("X-PLACEHOLDER");
    }

    protected boolean cmdSend(String strMsg) throws IOException {
        if (strMsg.startsWith("5")) {
            Configuration.logContext.write("! " + strMsg);
        }
        return super.cmdSend(strMsg);
    }

    private void cmd_auth(String strInput) throws IOException {
        Encoding enc = Encoding.createEncodingInstance((String)"base64");
        String s = Helper.getArg(strInput);
        String strMethod = Helper.getCmd(s);
        String strUsername = "";
        String strPassword = "";
        UserRecord usr = null;
        String strError = "555 Unknown error in AUTH";
        int intAuthMethod = 0;
        if (strMethod.equals("plain")) {
            intAuthMethod = 1;
        }
        if (strMethod.equals("login")) {
            intAuthMethod = 2;
        }
        if (strMethod.equals("cram-md5")) {
            intAuthMethod = 3;
        }
        if (this.cnf.strSMTP_AuthMethods.toLowerCase().indexOf(strMethod) == -1) {
            this.cmdSend("504 SMTP AUTH method not allowed [" + strMethod + "]");
            return;
        }
        switch (intAuthMethod) {
            case 0: {
                strError = "504 Unrecognized authentication type";
                break;
            }
            case 1: {
                StringTokenizer strt = new StringTokenizer(this.strLastReceivedPlain, " ");
                strt.nextToken();
                strt.nextToken();
                if (!strt.hasMoreTokens()) {
                    strError = "500 Missing Base64 domain/user/password phrase in AUTH PLAIN";
                    break;
                }
                String strResp = enc.decodeString(strt.nextToken());
                try {
                    strt = new StringTokenizer(strResp, String.valueOf('\u0000'));
                    strt.nextToken();
                    strUsername = strt.nextToken();
                    strPassword = strt.nextToken();
                }
                catch (Throwable throwable) {
                    try {
                        strt = new StringTokenizer(strResp, String.valueOf('\u0000'));
                        strUsername = strt.nextToken();
                        strPassword = strt.nextToken();
                    }
                    catch (Throwable throwable2) {
                        strError = "500 Error parsing your response [" + strResp + "]";
                        break;
                    }
                }
                usr = this.smManager.userRead(HelperValidate.validateRFC822_User((String)strUsername));
                if (usr == null) {
                    strError = "500 Authentication failed, unknown user [" + strUsername + "]";
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassword);
                    break;
                }
                if (!strPassword.equalsIgnoreCase(usr.getPassWord())) {
                    strError = "500 Authentication failed, wrong password";
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassword);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = strUsername;
                break;
            }
            case 2: {
                this.cmdSend("334 " + enc.encodeString("Username:"));
                this.cmdReceive();
                String strResp1 = enc.decodeString(this.strLastReceivedPlain);
                this.cmdSend("334 " + enc.encodeString("Password:"));
                this.cmdReceive();
                String strResp2 = enc.decodeString(this.strLastReceivedPlain);
                usr = this.smManager.userRead(HelperValidate.validateRFC822_User((String)strResp1));
                if (usr != null) {
                    strUsername = strResp1;
                    strPassword = strResp2;
                } else {
                    usr = this.smManager.userRead(HelperValidate.validateRFC822_User((String)strResp2));
                    strUsername = strResp2;
                    strPassword = strResp1;
                }
                if (usr == null) {
                    strError = "500 AUTH LOGIN Authentication failed, unknown user [" + strUsername + "]";
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassword);
                    break;
                }
                if (!strPassword.equals(usr.getPassWord())) {
                    strError = "500 AUTH LOGIN Authentication failed, wrong password";
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassword);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = strUsername;
                break;
            }
            case 3: {
                String strID = "<" + TimeFactory.createUID() + "@" + this.lsok.getLocalAddress().getHostName() + ">";
                this.cmdSend("334 " + enc.encodeString(strID));
                this.cmdReceive();
                String strResponse = enc.decodeString(this.strLastReceivedPlain);
                strUsername = Helper.getCmd(strResponse);
                String strPassHexa = Helper.getArg(strResponse).toLowerCase();
                usr = this.smManager.userRead(HelperValidate.validateRFC822_User((String)strUsername));
                if (usr == null) {
                    strError = "500 Authentication failed, unknown user";
                    Configuration.logContext.write("! Challenge was: " + strID);
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassHexa);
                    break;
                }
                byte[] digest = Helper.hmac_md5(usr.getPassWord(), strID);
                String strDigest = HelperFormat.hexDigit((byte[])digest);
                if (!strPassHexa.equals(strDigest)) {
                    strError = "500 Authentication failed, wrong password";
                    Configuration.logContext.write("! Challenge was: " + strID);
                    Configuration.logContext.write("! Decoded User/Pass: " + strUsername + " / " + strPassHexa);
                    Configuration.logContext.write("! Needed  User/Pass: " + strUsername + " / " + strDigest);
                    break;
                }
                this.blnSMTP_AUTH = true;
                this.strSMTP_AUTH_User = strUsername;
            }
        }
        enc.dispose();
        if (!this.blnSMTP_AUTH) {
            this.cmdSend(strError);
            return;
        }
        if (usr == null) {
            this.cmdSend("599 Internal error - usr in SMTP AUTH is NULL");
            this.blnSMTP_AUTH = false;
            return;
        }
        if (!usr.getEnabled()) {
            this.blnSMTP_AUTH = false;
            this.cmdSend("500 Account disabled");
            return;
        }
        DomainRecord dom = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)this.strSMTP_AUTH_User));
        if (dom == null) {
            this.cmdSend("599 Internal error - dom in SMTP AUTH is NULL");
            this.blnSMTP_AUTH = false;
            return;
        }
        this.blnAVScan |= dom.getAVScan();
        this.strAccUser = this.strSMTP_AUTH_User;
        this.cmdSend("235 Authentication successful.");
    }

    private void cmd_data(String strInput) throws IOException {
        if (this.uiMailFrom == null) {
            this.cmdSend("554 Sender not valid");
            return;
        }
        if (this.vecRecipients.size() == 0) {
            this.cmdSend("554 No valid recipients");
            return;
        }
        this.cmdSend("354 Enter your mail, end with \".\" on a line by itself");
        String strUID_Temp = TimeFactory.createUID();
        SMTPInputReader siData = new SMTPInputReader(this.lsok.getLineReader(), this.vecHeader, Configuration.logContext);
        long lngBytesRead = this.lsok.getBytesReceived();
        this.smManager.tempWrite(strUID_Temp, siData);
        lngBytesRead = this.lsok.getBytesReceived() - lngBytesRead;
        if (!siData.canStore()) {
            this.smManager.rollback();
            if (siData.getRejectMessage().length() == 0) {
                this.cmdSend("554 Could not receive data");
            } else {
                this.cmdSend("554 " + siData.getRejectMessage());
            }
            this.blnFatalError = true;
            return;
        }
        if (this.strAccUser == null) {
            this.strAccUser = "<>";
        }
        HelperSort.quick((Vector)this.vecRecipients, (Comparator)new UserInfoSort(this));
        Configuration.logContext.write("D Mail received, size " + HelperFormat.formatMemoryString((long)this.lsok.getBytesReceived()));
        long lngTimeStamp = TimeFactory.getTime();
        MailQueueRecord mqr = new MailQueueRecord(this.vecRecipients.size());
        mqr.blnAVScan = this.blnAVScan;
        mqr.strUID_Queue = strUID_Temp;
        mqr.strUID_Temp = strUID_Temp;
        String strOldDomain = "";
        MailHeaderRecord mhr = null;
        int intRecipientPtr = 0;
        int i = 0;
        while (i < this.vecRecipients.size()) {
            UserInfo uiRecipient = (UserInfo)this.vecRecipients.elementAt(i);
            DomainRecord domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)uiRecipient.strUser));
            UserRecord usrReceiver = this.smManager.userRead(uiRecipient.strUser);
            String strAccountingType = "";
            boolean blnExternalMail = false;
            boolean blnRelayMail = false;
            if (uiRecipient.blnRelayMail) {
                blnExternalMail = true;
                blnRelayMail = true;
                strAccountingType = "R";
            } else if (domReceiver == null) {
                blnExternalMail = true;
                blnRelayMail = false;
                strAccountingType = "I";
            } else {
                blnExternalMail = usrReceiver == null && !uiRecipient.blnHubMail;
                blnRelayMail = false;
                strAccountingType = "I";
            }
            String strDomain = HelperExtract.splitUserName_getDomain((String)uiRecipient.strUser);
            if (!strDomain.equals(strOldDomain) || !blnExternalMail || intRecipientPtr > 10) {
                if (strOldDomain.length() > 0) {
                    mqr.vecMHR.addElement(mhr);
                }
                mhr = new MailHeaderRecord();
                strOldDomain = strDomain;
                intRecipientPtr = 0;
            }
            ++intRecipientPtr;
            mhr.setExternalMail(blnExternalMail);
            mhr.setIsRelayMail(blnRelayMail);
            mhr.setIsHubMail(uiRecipient.blnHubMail);
            mhr.setEnvelopeFrom_Redirected(this.uiMailFrom.strUser);
            mhr.setEnvelopeFrom_Orginal(this.uiMailFrom.strOrgUser);
            mhr.addEnvelopeTo_Redirected(uiRecipient.strUser);
            mhr.addEnvelopeTo_Orginal(uiRecipient.strOrgUser);
            mhr.setMailSize(lngBytesRead);
            mhr.setTimeReceived(lngTimeStamp);
            mhr.setTimeNextRetry(lngTimeStamp);
            mhr.setTimeFetched(0L);
            mhr.setRetryCount(0);
            mhr.setMailDeleted(false);
            mhr.setUID(TimeFactory.createUID());
            mhr.setAccounting(this.strAccUser);
            mhr.setHELO(this.strHELO);
            if (this.strAccUser != null) {
                this.smManager.accountingStore(strAccountingType, this.strAccUser, this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            }
            ++i;
        }
        mqr.vecMHR.addElement(mhr);
        this.smManager.mailProcessQueueAdd(mqr);
        this.smManager.commit();
        this.cmdSend("250 OK DATA Mail received");
        Configuration.logContext.write("# Mail received.");
        this.initSession();
    }

    private void cmd_ehlo(String strInput) throws IOException {
        if (this.strHELO.length() == 0) {
            this.strHELO = Helper.getArg(strInput);
            if (this.strHELO == null) {
                this.strHELO = "";
            }
            this.cmdSend("250-" + this.lsok.getLocalAddress().getHostName() + " Hello " + this.lsok.getInetAddress().getHostName() + ", pleased to meet you");
            if (this.cnf.strSMTP_AuthMethods.length() > 0) {
                this.cmdSend("250-AUTH " + this.cnf.strSMTP_AuthMethods);
            }
            this.cmdSend("250 HELP");
        } else {
            this.cmdSend("550 Additional EHLO ignored");
        }
    }

    private void cmd_helo(String strInput) throws IOException {
        if (this.strHELO.length() == 0) {
            this.strHELO = Helper.getArg(strInput);
            if (this.strHELO == null) {
                this.strHELO = "";
            }
            this.cmdSend("250 OK " + strInput);
        } else {
            this.cmdSend("550 Additional HELO ignored [" + strInput + "]");
        }
    }

    private void cmd_help(String strInput) throws IOException {
        this.cmdSend("214-Help for " + ZeroToaster.getVersion());
        this.cmdSend("214-Implemented commands are:");
        int i = 0;
        while (i < CMDS.length) {
            if (CMDS[i] != null) {
                this.cmdSend("214- " + CMDS[i]);
            }
            ++i;
        }
        this.cmdSend("214 [End of help]");
    }

    private void cmd_illegaltransactionstate(String strInput) throws IOException {
        ++this.intIllegalTransactionCount;
        if (this.intIllegalTransactionCount < 5) {
            this.cmdSend("500 Not a valid transaction state. Try RSET or QUIT");
        } else {
            this.blnFatalError = true;
            this.cmdSend("599 Too many transaction errors, closing connection");
        }
    }

    private void cmd_mail(String strInput) throws IOException {
        String strUser = Helper.getSMTPUser(this.getArgument(strInput));
        if (HelperValidate.validateRFC822_User((String)strUser) == null && strUser.length() > 0) {
            this.cmdSend("550 Username syntactically incorrect '" + strInput + "'");
            return;
        }
        this.uiMailFrom = new UserInfo(this);
        this.uiMailFrom.strUser = strUser;
        this.uiMailFrom.strOrgUser = strUser;
        this.buildNewHeader();
        this.cmdSend("250 OK " + strInput);
    }

    private void cmd_noop(String strInput) throws IOException {
        this.cmdSend("250 OK " + strInput);
    }

    private void cmd_notfound(String strInput) throws IOException {
        ++this.intIllegalTransactionCount;
        if (this.intIllegalTransactionCount < 5) {
            this.cmdSend("500 Command not recognized [" + strInput + "]");
        } else {
            this.blnFatalError = true;
            this.cmdSend("599 Too many transaction errors, closing connection");
        }
    }

    private void cmd_notimplemented(String strInput) throws IOException {
        this.cmdSend("500 Command not implemented [" + strInput + "]");
    }

    private void cmd_quit(String strInput) throws IOException {
        this.cmdSend("221 OK " + this.lsok.getLocalAddress().getHostName() + " says goodbye");
    }

    private void cmd_rcpt(String strInput) throws IOException {
        if (this.uiMailFrom == null) {
            this.cmdSend("550 Missing 'mail from'. Cannot continue");
            return;
        }
        String strUser = Helper.getSMTPUser(this.getArgument(strInput));
        String strXXUser = HelperExtract.splitUserName_getUser((String)strUser);
        String strXXDomain = HelperExtract.splitUserName_getDomain((String)strUser);
        HelperValidate.isNumeric((String)strXXUser);
        strXXDomain.equalsIgnoreCase("harddiskcafe.de");
        String strTmpUser = HelperExtract.splitUserName_getUser((String)strUser);
        String strTmpDom = HelperExtract.splitUserName_getDomain((String)strUser);
        String strTmpOurIP = this.lsok.getLocalAddress().getHostAddress();
        if (strTmpDom.startsWith("[") && strTmpDom.endsWith("]")) {
            String strIP = strTmpDom.substring(1);
            if (!HelperValidate.isIP((String)(strIP = strIP.substring(0, strIP.length() - 1)))) {
                this.cmdSend("550 Not a valid IP4 as domain part [" + strInput + "]");
                return;
            }
            if (!strIP.equals(strTmpOurIP)) {
                this.cmdSend("550 This is not our IP Address [" + strInput + "]");
                return;
            }
            strUser = strTmpUser;
        }
        strUser = this.alias_smart_delivery(strUser);
        String[] strUsers = this.uaAlias.resolve(strUser);
        int u = 0;
        while (u < strUsers.length) {
            if (HelperValidate.validateRFC822_User((String)strUsers[u]) == null) {
                this.cmdSend("550 Username syntactically incorrect [" + strUsers[u] + "]");
            } else {
                UserInfo uiRecipient = new UserInfo(this);
                uiRecipient.strUser = strUsers[u];
                uiRecipient.strOrgUser = strUsers[u];
                uiRecipient.blnRelayMail = false;
                if (!this.blnSenderIntern && this.vecRecipients.size() >= this.cnf.intSMTP_Max_Recipients + this.intAdditionalRecipients) {
                    this.cmdSend("452 Too many recipients, user ignored");
                    return;
                }
                DomainRecord domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)uiRecipient.strUser));
                boolean blnReceiverIntern = domReceiver != null;
                this.uiMailFrom = this.validateMailFrom(this.uiMailFrom, blnReceiverIntern);
                if (this.uiMailFrom == null) {
                    this.blnIllegalTransactionState = true;
                    return;
                }
                if (!this.processML_Message(uiRecipient) && (uiRecipient = this.validateMailTo(uiRecipient)) != null) {
                    if (!(this.blnSenderIntern && !uiRecipient.blnRelayRBLCheck || this.rblCheck())) {
                        this.blnFatalError = true;
                        return;
                    }
                    this.vecRecipients.addElement(uiRecipient);
                    this.cmdSend("250 OK " + strInput + " [" + uiRecipient.strUser + "]");
                }
            }
            ++u;
        }
    }

    private void cmd_rset(String strInput) throws IOException {
        this.initSession();
        this.blnFatalError = false;
        this.blnIllegalTransactionState = false;
        this.intIllegalTransactionCount = 0;
        this.blnAVScan = false;
        this.blnSenderIntern = false;
        this.blnToMailinglist = false;
        if (strInput == null) {
            this.blnSMTP_AUTH = false;
            this.strSMTP_AUTH_User = null;
        }
        this.smManager.rollback();
        if (strInput != null) {
            this.cmdSend("250 OK RSET, Session invalidated");
        }
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        this.uiMailFrom = null;
        this.vecRecipients = null;
        this.vecHeader = null;
        this.rbl.dispose();
        this.resetThreadName();
    }

    private String getArgument(String str) {
        int pp = str.indexOf(58) + 1;
        if (pp == -1) {
            return str;
        }
        return str.substring(pp);
    }

    private int getCommand(String strInput) {
        String strCmd = Helper.getCmd(strInput);
        int intCmd = 0;
        int i = 0;
        while (i < CMDS.length) {
            String strCmp = CMDS[i];
            if (strCmp != null && strCmp.equals(strCmd)) {
                intCmd = i;
                break;
            }
            ++i;
        }
        if (this.blnIllegalTransactionState) {
            switch (intCmd) {
                case 4: 
                case 5: {
                    return intCmd;
                }
            }
            return 99;
        }
        return intCmd;
    }

    private void init() {
        if (CMDS == null) {
            CMDS = new String[11];
            SMTP_ServerInstance.CMDS[1] = "helo";
            SMTP_ServerInstance.CMDS[2] = "ehlo";
            SMTP_ServerInstance.CMDS[3] = "noop";
            SMTP_ServerInstance.CMDS[4] = "rset";
            SMTP_ServerInstance.CMDS[5] = "quit";
            SMTP_ServerInstance.CMDS[6] = "mail";
            SMTP_ServerInstance.CMDS[7] = "rcpt";
            SMTP_ServerInstance.CMDS[8] = "data";
            SMTP_ServerInstance.CMDS[9] = "help";
            SMTP_ServerInstance.CMDS[10] = "auth";
        }
        this.vecRecipients = new Vector(this.cnf.intSMTP_Max_Recipients);
        this.vecHeader = new Vector();
        this.rbl = new RBLCheck(Configuration.logContext, this.cnf);
    }

    private void initSession() {
        this.uiMailFrom = null;
        this.vecRecipients.removeAllElements();
        this.intAdditionalRecipients = 0;
        this.vecHeader.removeAllElements();
        this.blnSenderIntern = false;
        this.strAccUser = null;
        this.strHELO = "";
        this.uiMailFrom = null;
        this.cnf.statrec.lngSMTP_bytes += this.lsok.getBytesTotal();
        this.lsok.resetCount();
        this.uaAlias = new UserAlias(this.cnf.strAliases, Configuration.logContext);
    }

    public boolean kickInstance(Object o) {
        this.lsok = (LineSocket)o;
        this.loNotify.lo_notify();
        return true;
    }

    private void logUserRedirection(String strUserFrom, String strUserTo, String strReason) {
        this.vecHeader.addElement("X-ZeroToaster-Info: Renamed '" + strUserFrom + "' to '" + strUserTo + "' (" + strReason + ")");
        Configuration.logContext.write("D Renamed '" + strUserFrom + "' to '" + strUserTo + "' (" + strReason + ")");
    }

    private void processGroup(String strUser) {
        Vector v = Helper.processGroup(strUser);
        int i = 0;
        while (i < v.size()) {
            UserInfo ui = new UserInfo(this);
            ui.strUser = (String)v.elementAt(i);
            ui.strOrgUser = "<group copy>";
            boolean blnFound = false;
            int u = 0;
            while (u < this.vecRecipients.size()) {
                UserInfo uu = (UserInfo)this.vecRecipients.elementAt(u);
                if (uu.strUser.equals(ui.strUser)) {
                    blnFound = true;
                    break;
                }
                ++u;
            }
            if (!blnFound) {
                this.vecRecipients.addElement(ui);
                ++this.intAdditionalRecipients;
            }
            ++i;
        }
    }

    private boolean processML_Message(UserInfo uiRecipient) throws IOException {
        if (uiRecipient.strUser.length() == 0) {
            return false;
        }
        if (this.uiMailFrom.strUser.length() == 0) {
            return false;
        }
        MailingListRecord mlr = this.smManager.mailinglistRead(uiRecipient.strUser);
        if (mlr == null) {
            return false;
        }
        String[] strOwner = mlr.getOwner();
        if (strOwner.length == 0) {
            return false;
        }
        this.blnSenderIntern = true;
        boolean blnIsFromOwner = false;
        int i = 0;
        while (i < strOwner.length) {
            if (strOwner[i].equals(this.uiMailFrom.strUser)) {
                blnIsFromOwner = true;
                break;
            }
            ++i;
        }
        if (!blnIsFromOwner) {
            uiRecipient.strUser = strOwner[0];
            this.cmdSend("250 OK, Message sent to the list owner");
            return true;
        }
        String[] strSubscribers = mlr.getSubscribers();
        int intValidRecipients = 0;
        int i2 = 0;
        while (i2 < strSubscribers.length) {
            ++this.intAdditionalRecipients;
            UserInfo uiTmp = new UserInfo(this);
            uiTmp.strUser = strSubscribers[i2];
            uiTmp.strOrgUser = uiRecipient.strOrgUser;
            this.blnSupressSocketOutput = true;
            uiTmp = this.validateMailTo(uiTmp);
            this.blnSupressSocketOutput = false;
            if (uiTmp != null) {
                ++intValidRecipients;
                this.vecRecipients.addElement(uiTmp);
            }
            ++i2;
        }
        this.cmdSend("250 OK Mailinglist processed");
        return true;
    }

    private boolean rblCheck() throws IOException {
        if (this.cnf.strRBL_BlackList.length == 0) {
            return true;
        }
        String strIP = this.lsok.getInetAddress().getHostAddress();
        int i = 0;
        while (i < this.cnf.strRBL_WhiteList.length) {
            String strToken = this.cnf.strRBL_WhiteList[i];
            if (strToken.length() != 0) {
                if (Character.isDigit(strToken.charAt(0))) {
                    IP_Network ipn = new IP_Network(strToken);
                    if (ipn.match(strIP)) {
                        Configuration.logContext.write("! RBL passed IP on whitelist");
                        return true;
                    }
                } else if (this.uiMailFrom.strUser.equalsIgnoreCase(strToken)) {
                    Configuration.logContext.write("! RBL passed user on whitelist");
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.cnf.strRBL_BlackList.length) {
            StringTokenizer strt = new StringTokenizer(this.cnf.strRBL_BlackList[i], ",");
            String strZone = "";
            String strResult = "";
            if (strt.hasMoreTokens()) {
                strZone = strt.nextToken().trim();
            }
            if (strt.hasMoreTokens()) {
                strResult = strt.nextToken().trim();
            }
            if (strZone.length() != 0) {
                Configuration.logContext.write("D RBL " + strIP + " on " + strZone + " must match '" + strResult + "'");
                if (this.rbl.check(strIP, strZone, strResult)) {
                    this.cmdSend("556 " + this.rbl.getMessage());
                    return false;
                }
                Configuration.logContext.write("D RBL " + strIP + " " + this.rbl.getMessage());
            }
            ++i;
        }
        return true;
    }

    private boolean sendWelcome() throws IOException {
        if (!this.cnf.blnSMTP_Welcome_Multiline) {
            this.cmdSend("220 " + ZeroToaster.getVersion());
            return true;
        }
        File flMOTD = new File("motd.txt");
        if (flMOTD.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(flMOTD));
            String strBuffer = null;
            while ((strBuffer = br.readLine()) != null) {
                this.cmdSend("220-" + strBuffer);
            }
            this.cmdSend("220 " + ZeroToaster.getVersion());
            Helper.close(br);
            return true;
        }
        this.cmdSend("220-Welcome to " + this.lsok.getLocalAddress().getHostName());
        this.cmdSend("220-Our local Date is " + new Date(TimeFactory.getTime()).toString());
        this.cmdSend("220-Our mailsystem is " + ZeroToaster.getVersion());
        this.cmdSend("220 " + this.cnf.strSMTP_Welcome_Message);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void service() throws Throwable {
        this.cnf.statrec.intSMTP_peak = Math.max(this.cnf.statrec.intSMTP_peak, ++SMTP_ServerInstance.intInstances);
        Configuration.logContext.write("# " + this.lsok.getInetAddress() + " is coming in");
        this.cmd_rset(null);
        v = this.smManager.filterReadAll();
        this.flFilters = new FilterRecord[v.size()];
        i = 0;
        while (i < v.size()) {
            this.flFilters[i] = this.smManager.filterRead((String)v.elementAt(i));
            ++i;
        }
        this.blnTrustedNetwork = false;
        ipn = this.cnf.ipnTrustedNetworks;
        i = 0;
        while (i < ipn.length) {
            if (ipn[i].match(this.lsok.getInetAddress().getHostAddress())) {
                this.blnTrustedNetwork = true;
                this.blnAVScan |= this.cnf.blnTrustedNetworksAVSCAN;
                Configuration.logContext.write("D Trusted Network: " + this.lsok.getInetAddress());
                break;
            }
            ++i;
        }
        if (this.sendWelcome()) ** GOTO lbl71
        return;
lbl-1000:
        // 1 sources

        {
            strInput = null;
            try {
                strInput = this.cmdReceive();
            }
            catch (InterruptedIOException e) {
                this.cmdSend("503 Session timeout");
                throw e;
            }
            switch (this.getCommand(strInput)) {
                case 0: {
                    this.cmd_notfound(strInput);
                    break;
                }
                case 99: {
                    this.cmd_illegaltransactionstate(strInput);
                    break;
                }
                case 1: {
                    this.cmd_helo(strInput);
                    break;
                }
                case 2: {
                    this.cmd_ehlo(strInput);
                    break;
                }
                case 3: {
                    this.cmd_noop(strInput);
                    break;
                }
                case 4: {
                    this.cmd_rset(strInput);
                    break;
                }
                case 6: {
                    this.cmd_mail(strInput);
                    break;
                }
                case 7: {
                    this.cmd_rcpt(strInput);
                    break;
                }
                case 8: {
                    this.cmd_data(strInput);
                    break;
                }
                case 9: {
                    this.cmd_help(strInput);
                    break;
                }
                case 10: {
                    this.cmd_auth(strInput);
                    break;
                }
                case 5: {
                    this.cmd_quit(strInput);
                    return;
                }
                default: {
                    this.cmd_notimplemented(strInput);
                }
            }
lbl71:
            // 13 sources

            ** while (!this.blnFatalError && !this.blnDisposed)
        }
lbl72:
        // 1 sources

    }

    protected void servicePostProcess() {
        --intInstances;
        ++this.cnf.statrec.lngSMTP_accesses;
        this.initSession();
    }

    private UserInfo validateMailFrom(UserInfo ui, boolean blnReceiverIntern) throws IOException {
        boolean blnValidatePOP3;
        this.blnSenderIntern = false;
        if (ui == null) {
            return null;
        }
        this.processGroup(ui.strUser);
        String strSenderIP = this.lsok.getInetAddress().getHostAddress();
        int i = 0;
        while (i < this.flFilters.length) {
            FilterRecord fr = this.flFilters[i];
            if (fr.getFilterType() == 3) {
                if (fr.getType() == 1 && ui.strUser.equals(fr.getMask())) {
                    Configuration.logContext.write("# Rejected user by filter '" + fr.getName() + "'");
                    this.cmdSend("554 We do not accept mail from your user");
                    return null;
                }
                if (fr.getType() == 2 && ui.strUser.endsWith("@" + fr.getMask())) {
                    Configuration.logContext.write("# Rejected domain by filter '" + fr.getName() + "'");
                    this.cmdSend("554 We do not accept mail from your domain");
                    return null;
                }
                if (fr.getType() == 3 && IP_Network.match((String)fr.getMask(), (String)strSenderIP)) {
                    Configuration.logContext.write("# Rejected IP by filter '" + fr.getName() + "'");
                    this.cmdSend("554 We do not accept mail from your network");
                    return null;
                }
            }
            ++i;
        }
        if (this.blnTrustedNetwork) {
            Configuration.logContext.write("D validateMailFrom: OK, user is in trusted network");
            this.blnSenderIntern = true;
            DomainRecord domSender = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)ui.strUser));
            if (domSender != null) {
                this.blnAVScan |= domSender.getAVScan();
            }
            return ui;
        }
        if (this.blnSMTP_AUTH) {
            this.blnSenderIntern = true;
            Configuration.logContext.write("D validateMailFrom: OK, user had SMTP AUTH");
            return ui;
        }
        if (ui.strUser.length() == 0) {
            Configuration.logContext.write("D validateMailFrom: OK, user was <>");
            return ui;
        }
        DomainRecord domSender = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)ui.strUser));
        if (domSender == null) {
            Configuration.logContext.write("D validateMailFrom: OK, domSender == null");
            return ui;
        }
        if (!domSender.getEnable_SMTP()) {
            this.cmdSend("550 SMTP Access isn't allowed for your Domain");
            return null;
        }
        if (blnReceiverIntern && domSender.getCatchAll().length() > 0) {
            Configuration.logContext.write("D validateMailFrom: OK, receiver is intern & catch-all");
            return ui;
        }
        UserRecord usrSender = this.smManager.userRead(ui.strUser);
        if (usrSender == null) {
            this.cmdSend("552 No such user [" + ui.strUser + "]");
            return null;
        }
        if (!usrSender.getEnabled()) {
            this.cmdSend("550 Account disabled [" + ui.strUser + "]");
            return null;
        }
        IP_Network[] ipn = new IP_Network[]{};
        switch (usrSender.getRestrictIP_SMTP()) {
            case 0: {
                break;
            }
            case 1: {
                ipn = domSender.getIP_Networks();
                break;
            }
            case 2: {
                ipn = usrSender.getIP_Networks();
                break;
            }
            case 3: {
                ipn = new IP_Network[domSender.getIP_Networks().length + usrSender.getIP_Networks().length];
                int ii = 0;
                int i2 = 0;
                while (i2 < domSender.getIP_Networks().length) {
                    ipn[ii++] = domSender.getIP_Networks()[i2];
                    ++i2;
                }
                i2 = 0;
                while (i2 < usrSender.getIP_Networks().length) {
                    ipn[ii++] = usrSender.getIP_Networks()[i2];
                    ++i2;
                }
                break;
            }
        }
        String strINA = this.lsok.getInetAddress().getHostAddress();
        boolean blnIPN_Match = false;
        int i3 = 0;
        while (i3 < ipn.length) {
            if (ipn[i3].match(strINA)) {
                blnIPN_Match = true;
                break;
            }
            ++i3;
        }
        boolean blnUseSMTPafterPOP3 = false;
        int intSMTPafterPOP3Timeout = 0;
        switch (usrSender.getSMTP_after_POP3()) {
            case 0: {
                blnUseSMTPafterPOP3 = false;
                intSMTPafterPOP3Timeout = 0;
                break;
            }
            case 2: {
                blnUseSMTPafterPOP3 = true;
                intSMTPafterPOP3Timeout = usrSender.getSessionTimeout();
                break;
            }
            case 1: {
                blnUseSMTPafterPOP3 = domSender.getSMTP_after_POP3();
                intSMTPafterPOP3Timeout = domSender.getSessionTimeout();
            }
        }
        boolean bl = blnValidatePOP3 = !blnIPN_Match;
        if (this.blnSMTP_AUTH) {
            blnValidatePOP3 = false;
        }
        Configuration.logContext.write("D validateMailFrom: validatePOP2=" + blnValidatePOP3 + ",useSmtpAfterPOP3=" + blnUseSMTPafterPOP3);
        if (blnValidatePOP3) {
            if (blnUseSMTPafterPOP3) {
                InetAddress inaOld = InetAddress.getByName(usrSender.getPOP3_IP());
                if (!this.lsok.getInetAddress().equals(inaOld)) {
                    this.cmdSend("554 IP Adress changed after last POP3 login (SMTP after POP3)");
                    return null;
                }
                if (TimeFactory.getTime() - usrSender.getPOP3_Time() > (long)intSMTPafterPOP3Timeout * 1000L) {
                    this.cmdSend("554 SMTP after POP3 session timeout");
                    return null;
                }
            } else if (ipn.length != 0) {
                this.cmdSend("554 Your IP isn't in the range of allowed networks");
                return null;
            }
        }
        this.blnAVScan |= domSender.getAVScan();
        this.strAccUser = ui.strUser;
        this.blnSenderIntern = true;
        Configuration.logContext.write("D validateMailFrom: OK, sender is intern");
        return ui;
    }

    private UserInfo validateMailTo(UserInfo ui) throws IOException {
        String strCatchAll;
        boolean blnReceiverIntern;
        this.processGroup(ui.strUser);
        String strOldUser = ui.strUser.toLowerCase().trim();
        if (HelperExtract.splitUserName_getDomain((String)ui.strUser).length() == 0) {
            Configuration.logContext.write("? Missing domain part in user '" + ui.strUser + "'");
            this.cmdSend("550 Missing domain part in user [" + ui.strUser + "]");
            return null;
        }
        if (HelperExtract.splitUserName_getUser((String)ui.strUser).length() == 0) {
            Configuration.logContext.write("? Missing user part in user '" + ui.strUser + "'");
            this.cmdSend("550 Missing user part in user [" + ui.strUser + "]");
            return null;
        }
        if (HelperValidate.validateRFC822_User((String)ui.strUser) == null) {
            Configuration.logContext.write("? invalid name '" + ui.strUser + "'");
            this.cmdSend("550 Invalid Name [" + ui.strUser + "]");
            return null;
        }
        UserRecord usrReceiver = this.smManager.userRead(ui.strUser);
        if (usrReceiver != null && !usrReceiver.getEnabled()) {
            this.cmdSend("550 User disabled [" + ui.strUser + "]");
            return null;
        }
        DomainRecord domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)ui.strUser));
        boolean bl = blnReceiverIntern = domReceiver != null;
        if (this.blnSenderIntern && !blnReceiverIntern) {
            Configuration.logContext.write("D validateMailTop: OK, sender intern, receiver outside");
            return ui;
        }
        if (!(this.blnSenderIntern || blnReceiverIntern || this.blnSMTP_AUTH)) {
            int i = 0;
            while (i < this.flFilters.length) {
                FilterRecord fr = this.flFilters[i];
                if (fr.getFilterType() == 1) {
                    if (fr.getType() == 1 && ui.strUser.equals(fr.getMask())) {
                        Configuration.logContext.write("# Relay accepted by filter '" + fr.getName() + "'");
                        ui.blnRelayMail = true;
                        ui.blnRelayRBLCheck = fr.getRBLCheck();
                        this.blnAVScan |= fr.getAVScan();
                        break;
                    }
                    if (fr.getType() == 2 && HelperExtract.splitUserName_getDomain((String)ui.strUser).equals(fr.getMask())) {
                        Configuration.logContext.write("# Relay accepted by filter '" + fr.getName() + "'");
                        ui.blnRelayMail = true;
                        ui.blnRelayRBLCheck = fr.getRBLCheck();
                        this.blnAVScan |= fr.getAVScan();
                        break;
                    }
                    if (fr.getType() == 3) {
                        try {
                            HostIP[] hipMX = Helper.getMXHosts(HelperExtract.splitUserName_getDomain((String)ui.strUser), true);
                            if (hipMX != null && IP_Network.match((String)fr.getMask(), (String)hipMX[0].strIP)) {
                                ui.blnRelayMail = true;
                                ui.blnRelayRBLCheck = fr.getRBLCheck();
                                this.blnAVScan |= fr.getAVScan();
                                break;
                            }
                        }
                        catch (Throwable t) {
                            Configuration.logContext.write("? Error in Relaycheck", t);
                        }
                    }
                }
                ++i;
            }
            if (!ui.blnRelayMail) {
                this.cmdSend("550 Relaying denied [" + this.uiMailFrom.strUser + " -> " + ui.strUser + "]");
                return null;
            }
            this.strAccUser = ui.strUser;
            Configuration.logContext.write("D validateMailTop: OK, relaying accepted");
            return ui;
        }
        String strNewUser = Helper.redirectUser(ui.strUser, this.smManager);
        if (!strNewUser.equals(ui.strUser)) {
            this.logUserRedirection(ui.strUser, strNewUser, "User/Domain redirection");
            this.strAccUser = ui.strUser;
            ui.strUser = strNewUser;
        }
        boolean bl2 = blnReceiverIntern = (domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)ui.strUser))) != null;
        if (!blnReceiverIntern) {
            Configuration.logContext.write("D validateMailTop: OK, message to the outside");
            return ui;
        }
        usrReceiver = this.smManager.userRead(ui.strUser);
        if (usrReceiver == null && (strCatchAll = domReceiver.getCatchAll()).length() != 0) {
            strCatchAll = Helper.redirectUser(strCatchAll, this.smManager);
            this.logUserRedirection(ui.strUser, strCatchAll, "Catch-All");
            ui.strUser = strCatchAll;
            if (this.strAccUser == null) {
                this.strAccUser = ui.strUser;
            }
            usrReceiver = this.smManager.userRead(ui.strUser);
            Configuration.logContext.write("D validateMailTop: OK, catchall");
        }
        if (usrReceiver == null) {
            this.cmdSend("552 No such user [" + ui.strUser + "]");
            return null;
        }
        if (this.smManager.quotaExceeded(ui.strUser)) {
            this.cmdSend("550 Quota exceeded [" + ui.strUser + "]");
            return null;
        }
        int i = 0;
        while (i < usrReceiver.getCopy().length) {
            ++this.intAdditionalRecipients;
            UserInfo uiTmp = new UserInfo(this);
            uiTmp.strUser = usrReceiver.getCopy()[i];
            uiTmp.strOrgUser = ui.strUser;
            this.vecRecipients.addElement(uiTmp);
            Configuration.logContext.write("# Created mail copy to " + uiTmp.strUser);
            ++i;
        }
        if (!ui.strUser.equals(strOldUser)) {
            this.processGroup(ui.strUser);
        }
        if (this.strAccUser == null) {
            this.strAccUser = ui.strUser;
        }
        this.blnAVScan |= (domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)ui.strUser))) != null && domReceiver.getAVScan();
        return ui;
    }

    public class UserInfo {
        /* synthetic */ SMTP_ServerInstance this$0;
        String strUser;
        String strOrgUser;
        boolean blnRelayMail = false;
        boolean blnRelayRBLCheck = false;
        boolean blnHubMail = false;
        boolean blnListRobot = false;

        public String toString() {
            StringBuffer strb = new StringBuffer();
            strb.append("User <");
            strb.append(this.strUser);
            strb.append(">; OrgUser:<");
            strb.append(this.strOrgUser);
            strb.append("> RelayMail:");
            strb.append(this.blnRelayMail);
            strb.append("; HubMail:");
            strb.append(this.blnHubMail);
            strb.append("; ListRobot:");
            strb.append(this.blnListRobot);
            strb.append(";");
            return strb.toString();
        }

        public UserInfo(SMTP_ServerInstance this$0) {
            this.this$0 = this$0;
        }
    }

    public class UserInfoSort
    implements Comparator {
        /* synthetic */ SMTP_ServerInstance this$0;
        private ComparatorStringReverse cmp = new ComparatorStringReverse();

        public int compare(Object o1, Object o2) {
            UserInfo ui1 = (UserInfo)o1;
            UserInfo ui2 = (UserInfo)o2;
            return this.cmp.compare((Object)ui1.strUser, (Object)ui2.strUser);
        }

        public UserInfoSort(SMTP_ServerInstance this$0) {
            this.this$0 = this$0;
        }
    }
}

