/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.io;

import de.zwanzigeins.io.DummyOutputStreamWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class LineWriter
extends BufferedWriter {
    private static final int BUFFERSIZE = 8192;
    private static final String LF = "\r\n";
    private long lngCount = 0L;
    private boolean blnDisposed = false;

    public LineWriter(OutputStream out) {
        super((Writer)new DummyOutputStreamWriter(out), 8192);
    }

    public LineWriter(LineWriter out) {
        super(out);
    }

    public void close() throws IOException {
        this.blnDisposed = true;
        super.close();
    }

    public long getBytes() {
        return this.lngCount;
    }

    public void newLine() throws IOException {
        if (this.blnDisposed) {
            throw new IOException("LineWriter closed");
        }
        this.write(LF);
    }

    public void println(String str) throws IOException {
        if (this.blnDisposed) {
            throw new IOException("LineWriter closed");
        }
        this.write(str, 0, str.length());
        this.newLine();
    }

    public void resetCount() {
        this.lngCount = 0L;
    }

    public void write(int c) throws IOException {
        if (this.blnDisposed) {
            throw new IOException("LineWriter closed");
        }
        ++this.lngCount;
        super.write(c);
    }

    public void write(String s, int off, int len) throws IOException {
        if (this.blnDisposed) {
            throw new IOException("LineWriter closed");
        }
        this.lngCount += (long)len;
        super.write(s, off, len);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.blnDisposed) {
            throw new IOException("LineWriter closed");
        }
        this.lngCount += (long)len;
        super.write(cbuf, off, len);
    }
}

