/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.io;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.util.Helper;

public class LineSocket {
    private Socket sok = null;
    private LineWriter lwOut = null;
    private LineReader lrIn = null;
    private boolean blnDisposed = false;
    private InetAddress inaLocal = null;
    private InetAddress inaRemote = null;

    public LineSocket(Socket sok) throws IOException {
        this.sok = sok;
        this.inaLocal = sok.getLocalAddress();
        this.inaRemote = sok.getInetAddress();
        this.lrIn = new LineReader(sok.getInputStream());
        this.lwOut = new LineWriter(sok.getOutputStream());
    }

    public void close() {
        if (this.blnDisposed) {
            return;
        }
        this.blnDisposed = true;
        Helper.flush(this.lwOut);
        Helper.close(this.lwOut);
        Helper.close(this.lrIn);
        Helper.close(this.sok);
        this.sok = null;
    }

    public void finalize() throws Throwable {
        if (!this.blnDisposed) {
            this.close();
        }
    }

    public void flush() throws IOException {
        this.lwOut.flush();
    }

    public long getBytesReceived() {
        return this.lrIn.getBytes();
    }

    public long getBytesSent() {
        return this.lwOut.getBytes();
    }

    public long getBytesTotal() {
        return this.getBytesReceived() + this.getBytesSent();
    }

    public InetAddress getInetAddress() {
        return this.inaRemote;
    }

    public LineReader getLineReader() throws IOException {
        return this.lrIn;
    }

    public LineWriter getLineWriter() throws IOException {
        return this.lwOut;
    }

    public InetAddress getLocalAddress() {
        return this.inaLocal;
    }

    public void println(String s) throws IOException {
        if (this.blnDisposed) {
            throw new IOException("Socket disposed");
        }
        this.lwOut.println(s);
    }

    public String readln() throws IOException {
        if (this.blnDisposed) {
            throw new IOException("Socket disposed");
        }
        return this.lrIn.readln();
    }

    public void resetCount() {
        this.lrIn.resetCount();
        this.lwOut.resetCount();
    }

    public void setSoTimeout(long lngMS) throws SocketException {
        this.sok.setSoTimeout((int)lngMS);
    }

    public String toString() {
        return "LineSocket:" + this.sok.toString();
    }
}

