/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.awt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.mta.admin.awt.ConfigFrame;
import net.zerotoaster.mta.admin.awt.MessageBox;
import net.zerotoaster.mta.admin.awt.PrivilegeChanged;
import net.zerotoaster.mta.admin.awt.SeparatorPanel;
import net.zerotoaster.mta.admin.awt.SeparatorPanelProperties;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.io.RemoteFile;
import net.zerotoaster.mta.util.Helper;

public class ConfigFilemanager
extends ConfigFrame
implements ActionListener,
ItemListener,
WindowListener {
    private String strCurrentPath = "";
    private String strRemotePathSeparator = "";
    private RemoteFile[] rfCurrentList = new RemoteFile[0];
    private String strCurrentEdit = "";
    private String strCurrentLocalDirectory = "";
    private Menu ivjmnuFile = null;
    private MenuItem ivjmnuQuit = null;
    private Button ivjbtnDelete = null;
    private Button ivjbtnDownload = null;
    private Button ivjbtnEdit = null;
    private Button ivjbtnSave = null;
    private Button ivjbtnUpload = null;
    private MenuBar ivjConfigFilemanagerMenuBar = null;
    private Label ivjlblPath = null;
    private Label ivjlblStatus = null;
    private List ivjlstFiles = null;
    private Panel ivjpnlAction = null;
    private TextArea ivjtxtContent = null;
    private FlowLayout ivjpnlActionFlowLayout = null;
    private SeparatorPanel ivjSeparatorPanel1 = null;
    private SeparatorPanel ivjSeparatorPanel11 = null;
    private Button ivjbtnHelp = null;
    private SeparatorPanel ivjSeparatorPanel111 = null;
    private Button ivjbtnZeroToasterIni = null;
    private Label ivjLabel1 = null;
    static Class class$java$awt$Window;

    public ConfigFilemanager() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getmnuQuit()) {
            this.connEtoC1();
        }
        if (e.getSource() == this.getlstFiles()) {
            this.connEtoC3();
        }
        if (e.getSource() == this.getbtnEdit()) {
            this.connEtoC5();
        }
        if (e.getSource() == this.getbtnDownload()) {
            this.connEtoC6();
        }
        if (e.getSource() == this.getbtnUpload()) {
            this.connEtoC7();
        }
        if (e.getSource() == this.getbtnDelete()) {
            this.connEtoC8();
        }
        if (e.getSource() == this.getbtnSave()) {
            this.connEtoC9();
        }
        if (e.getSource() == this.getbtnHelp()) {
            this.connEtoC11();
        }
        if (e.getSource() == this.getbtnZeroToasterIni()) {
            this.connEtoC10();
        }
    }

    public void btnCurrentLogfile_ActionEvents() {
    }

    public void btnDelete_ActionEvents() {
        String strRemoteFile = this.ivjlstFiles.getSelectedItem();
        if (strRemoteFile == null) {
            return;
        }
        if (!MessageBox.OK_CANCEL(this, "Warning", "Are you sure to delete " + strRemoteFile + " ?")) {
            return;
        }
        this.remoteFileDelete(strRemoteFile);
    }

    public void btnDownload_ActionEvents() {
        String strRemoteFile = this.ivjlstFiles.getSelectedItem();
        if (strRemoteFile == null) {
            return;
        }
        FileDialog fd = new FileDialog(this);
        fd.setName("FileManager-Filedialog");
        ((Dialog)fd).setTitle("Store File ...");
        fd.setMode(0);
        fd.setFile(strRemoteFile);
        fd.setDirectory(this.strCurrentLocalDirectory);
        fd.setResizable(true);
        fd.addNotify();
        this.windowPos_load(fd);
        ((Component)fd).setVisible(true);
        this.windowPos_save(fd);
        if (fd.getFile() == null) {
            return;
        }
        this.strCurrentLocalDirectory = fd.getDirectory();
        String strLocalFile = String.valueOf(fd.getDirectory()) + fd.getFile();
        this.remoteFileLoad(strRemoteFile, strLocalFile);
    }

    public void btnEdit_ActionEvents() {
        String strRemoteFile = this.ivjlstFiles.getSelectedItem();
        if (strRemoteFile == null) {
            return;
        }
        this.strCurrentEdit = "";
        this.remoteFileLoad(strRemoteFile, null);
    }

    public void btnHelp_ActionEvents() {
        ConfigFrame.frmHelp.showHelp(this);
    }

    public void btnSave_ActionEvents() {
        String strRemoteFile = this.ivjlstFiles.getSelectedItem();
        if (strRemoteFile == null) {
            return;
        }
        String s = this.ivjtxtContent.getText().trim();
        if (s.length() == 0 && !MessageBox.OK_CANCEL(this, "Warning", "Text is empty. Save anyway ?")) {
            return;
        }
        this.remoteFileSave(null, strRemoteFile);
    }

    public void btnUpload_ActionEvents() {
        FileDialog fd = new FileDialog(this);
        fd.setName("FileManager-Filedialog");
        ((Dialog)fd).setTitle("Upload File ...");
        fd.setMode(1);
        fd.setFile("*.*");
        fd.setDirectory(this.strCurrentLocalDirectory);
        fd.setResizable(true);
        fd.setModal(true);
        this.windowPos_load(fd);
        ((Component)fd).setVisible(true);
        this.windowPos_save(fd);
        if (fd.getFile() == null) {
            return;
        }
        this.strCurrentLocalDirectory = fd.getDirectory();
        String strRemoteFile = fd.getFile();
        String strLocalFile = String.valueOf(fd.getDirectory()) + fd.getFile();
        if (!new File(strLocalFile).exists()) {
            MessageBox.OK(this, "Error", "File " + strLocalFile + " doesn't exist");
            return;
        }
        this.remoteFileSave(strLocalFile, strRemoteFile);
    }

    public void btnZeroToasterIni_ActionEvents() {
        this.strCurrentPath = "";
        this.refreshFileManager();
        this.ivjlstFiles.select(-1);
        String[] s = this.ivjlstFiles.getItems();
        int intItem = -1;
        String strIni = "zt_mta.ini";
        int i = 0;
        while (i < s.length) {
            if (s[i].equalsIgnoreCase(strIni)) {
                intItem = i;
                break;
            }
            ++i;
        }
        if (intItem == -1) {
            MessageBox.OK(this, "Error", "Cannot find " + strIni);
            return;
        }
        this.ivjlstFiles.select(intItem);
        this.lstFiles_ItemStateChanged();
        this.btnEdit_ActionEvents();
    }

    private void connEtoC1() {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10() {
        try {
            this.btnZeroToasterIni_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11() {
        try {
            this.btnHelp_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(WindowEvent arg1) {
        try {
            this.mnuQuit_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3() {
        try {
            this.lstFiles_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ItemEvent arg1) {
        try {
            this.lstFiles_ItemStateChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5() {
        try {
            this.btnEdit_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6() {
        try {
            this.btnDownload_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7() {
        try {
            this.btnUpload_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8() {
        try {
            this.btnDelete_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9() {
        try {
            this.btnSave_ActionEvents();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void dispose() {
        super.dispose();
    }

    private Button getbtnDelete() {
        if (this.ivjbtnDelete == null) {
            try {
                this.ivjbtnDelete = new Button();
                this.ivjbtnDelete.setName("btnDelete");
                this.ivjbtnDelete.setLabel("Delete");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnDelete;
    }

    private Button getbtnDownload() {
        if (this.ivjbtnDownload == null) {
            try {
                this.ivjbtnDownload = new Button();
                this.ivjbtnDownload.setName("btnDownload");
                this.ivjbtnDownload.setLabel("Download");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnDownload;
    }

    private Button getbtnEdit() {
        if (this.ivjbtnEdit == null) {
            try {
                this.ivjbtnEdit = new Button();
                this.ivjbtnEdit.setName("btnEdit");
                this.ivjbtnEdit.setActionCommand("Edit");
                this.ivjbtnEdit.setLabel("Edit");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnEdit;
    }

    private Button getbtnHelp() {
        if (this.ivjbtnHelp == null) {
            try {
                this.ivjbtnHelp = new Button();
                this.ivjbtnHelp.setName("btnHelp");
                this.ivjbtnHelp.setLabel("Help");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnHelp;
    }

    private Button getbtnSave() {
        if (this.ivjbtnSave == null) {
            try {
                this.ivjbtnSave = new Button();
                this.ivjbtnSave.setName("btnSave");
                this.ivjbtnSave.setActionCommand("Save");
                this.ivjbtnSave.setLabel("Save");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnSave;
    }

    private Button getbtnUpload() {
        if (this.ivjbtnUpload == null) {
            try {
                this.ivjbtnUpload = new Button();
                this.ivjbtnUpload.setName("btnUpload");
                this.ivjbtnUpload.setLabel("Upload");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnUpload;
    }

    private Button getbtnZeroToasterIni() {
        if (this.ivjbtnZeroToasterIni == null) {
            try {
                this.ivjbtnZeroToasterIni = new Button();
                this.ivjbtnZeroToasterIni.setName("btnZeroToasterIni");
                this.ivjbtnZeroToasterIni.setLabel("ED zt_mta.ini");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjbtnZeroToasterIni;
    }

    private static void getBuilderData() {
    }

    private MenuBar getConfigFilemanagerMenuBar() {
        if (this.ivjConfigFilemanagerMenuBar == null) {
            try {
                this.ivjConfigFilemanagerMenuBar = new MenuBar();
                this.ivjConfigFilemanagerMenuBar.setFont(new Font("dialog", 1, 12));
                this.ivjConfigFilemanagerMenuBar.add(this.getmnuFile());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjConfigFilemanagerMenuBar;
    }

    private Label getLabel1() {
        if (this.ivjLabel1 == null) {
            try {
                this.ivjLabel1 = new Label();
                this.ivjLabel1.setName("Label1");
                this.ivjLabel1.setText(" Shortcuts");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLabel1;
    }

    private Label getlblPath() {
        if (this.ivjlblPath == null) {
            try {
                this.ivjlblPath = new Label();
                this.ivjlblPath.setName("lblPath");
                this.ivjlblPath.setFont(new Font("dialog", 1, 12));
                this.ivjlblPath.setText(".");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblPath;
    }

    private Label getlblStatus() {
        if (this.ivjlblStatus == null) {
            try {
                this.ivjlblStatus = new Label();
                this.ivjlblStatus.setName("lblStatus");
                this.ivjlblStatus.setFont(new Font("dialog", 1, 12));
                this.ivjlblStatus.setText(".");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlblStatus;
    }

    private List getlstFiles() {
        if (this.ivjlstFiles == null) {
            try {
                this.ivjlstFiles = new List(15);
                this.ivjlstFiles.setName("lstFiles");
                this.ivjlstFiles.setFont(new Font("dialog", 1, 12));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjlstFiles;
    }

    private Menu getmnuFile() {
        if (this.ivjmnuFile == null) {
            try {
                this.ivjmnuFile = new Menu();
                this.ivjmnuFile.setFont(new Font("dialog", 1, 12));
                this.ivjmnuFile.setLabel("File");
                this.ivjmnuFile.add(this.getmnuQuit());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjmnuFile;
    }

    private MenuItem getmnuQuit() {
        if (this.ivjmnuQuit == null) {
            try {
                this.ivjmnuQuit = new MenuItem();
                this.ivjmnuQuit.setFont(new Font("dialog", 1, 12));
                this.ivjmnuQuit.setLabel("Quit");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjmnuQuit;
    }

    private Panel getpnlAction() {
        if (this.ivjpnlAction == null) {
            try {
                this.ivjpnlAction = new Panel();
                this.ivjpnlAction.setName("pnlAction");
                this.ivjpnlAction.setLayout(this.getpnlActionFlowLayout());
                this.getpnlAction().add((Component)this.getbtnEdit(), this.getbtnEdit().getName());
                this.getpnlAction().add((Component)this.getbtnSave(), this.getbtnSave().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel1(), this.getSeparatorPanel1().getName());
                this.getpnlAction().add((Component)this.getbtnDownload(), this.getbtnDownload().getName());
                this.getpnlAction().add((Component)this.getbtnUpload(), this.getbtnUpload().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel11(), this.getSeparatorPanel11().getName());
                this.getpnlAction().add((Component)this.getbtnDelete(), this.getbtnDelete().getName());
                this.getpnlAction().add((Component)this.getSeparatorPanel111(), this.getSeparatorPanel111().getName());
                this.ivjpnlAction.add(this.getbtnHelp());
                this.ivjpnlAction.add(this.getLabel1());
                this.getpnlAction().add((Component)this.getbtnZeroToasterIni(), this.getbtnZeroToasterIni().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjpnlAction;
    }

    private FlowLayout getpnlActionFlowLayout() {
        FlowLayout ivjpnlActionFlowLayout = null;
        try {
            ivjpnlActionFlowLayout = new FlowLayout();
            ivjpnlActionFlowLayout.setAlignment(0);
            ivjpnlActionFlowLayout.setVgap(0);
            ivjpnlActionFlowLayout.setHgap(0);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        return ivjpnlActionFlowLayout;
    }

    private SeparatorPanel getSeparatorPanel1() {
        if (this.ivjSeparatorPanel1 == null) {
            try {
                this.ivjSeparatorPanel1 = new SeparatorPanel();
                this.ivjSeparatorPanel1.setName("SeparatorPanel1");
                this.ivjSeparatorPanel1.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSeparatorPanel1;
    }

    private SeparatorPanel getSeparatorPanel11() {
        if (this.ivjSeparatorPanel11 == null) {
            try {
                this.ivjSeparatorPanel11 = new SeparatorPanel();
                this.ivjSeparatorPanel11.setName("SeparatorPanel11");
                this.ivjSeparatorPanel11.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSeparatorPanel11;
    }

    private SeparatorPanel getSeparatorPanel111() {
        if (this.ivjSeparatorPanel111 == null) {
            try {
                this.ivjSeparatorPanel111 = new SeparatorPanel();
                this.ivjSeparatorPanel111.setName("SeparatorPanel111");
                this.ivjSeparatorPanel111.setProperties(new SeparatorPanelProperties("20\u00ad5\u00ad1\u00ad0"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSeparatorPanel111;
    }

    private TextArea gettxtContent() {
        if (this.ivjtxtContent == null) {
            try {
                this.ivjtxtContent = new TextArea();
                this.ivjtxtContent.setName("txtContent");
                this.ivjtxtContent.setFont(new Font("monospaced", 0, 14));
                this.ivjtxtContent.setColumns(0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjtxtContent;
    }

    public void handleException(Throwable t) {
        super.handleException(t);
    }

    protected void init() {
        ConfigFrame.logContext.write("# File manager init");
        super.init();
        ConfigFrame.logContext.write("# File manager ready");
    }

    private void initConnections() {
        this.getmnuQuit().addActionListener(this);
        this.addWindowListener(this);
        this.getlstFiles().addActionListener(this);
        this.getlstFiles().addItemListener(this);
        this.getbtnEdit().addActionListener(this);
        this.getbtnDownload().addActionListener(this);
        this.getbtnUpload().addActionListener(this);
        this.getbtnDelete().addActionListener(this);
        this.getbtnSave().addActionListener(this);
        this.getbtnHelp().addActionListener(this);
        this.getbtnZeroToasterIni().addActionListener(this);
    }

    private void initialize() {
        GridBagConstraints constraintslstFiles = new GridBagConstraints();
        GridBagConstraints constraintstxtContent = new GridBagConstraints();
        GridBagConstraints constraintslblPath = new GridBagConstraints();
        GridBagConstraints constraintslblStatus = new GridBagConstraints();
        GridBagConstraints constraintspnlAction = new GridBagConstraints();
        this.setName("ConfigFilemanager");
        this.setMenuBar(this.getConfigFilemanagerMenuBar());
        this.setLayout(new GridBagLayout());
        ((Component)this).setSize(1010, 341);
        this.setTitle("File manager");
        constraintslstFiles.gridx = 0;
        constraintslstFiles.gridy = 0;
        constraintslstFiles.gridwidth = 1;
        constraintslstFiles.gridheight = 1;
        constraintslstFiles.fill = 1;
        constraintslstFiles.anchor = 17;
        constraintslstFiles.weightx = 1.0;
        constraintslstFiles.weighty = 1.0;
        constraintslstFiles.insets = new Insets(5, 5, 5, 0);
        this.add((Component)this.getlstFiles(), constraintslstFiles);
        constraintstxtContent.gridx = 1;
        constraintstxtContent.gridy = 0;
        constraintstxtContent.gridwidth = 2;
        constraintstxtContent.gridheight = 1;
        constraintstxtContent.fill = 1;
        constraintstxtContent.anchor = 17;
        constraintstxtContent.weightx = 1.25;
        constraintstxtContent.weighty = 1.0;
        constraintstxtContent.insets = new Insets(5, 3, 5, 5);
        this.add((Component)this.gettxtContent(), constraintstxtContent);
        constraintslblPath.gridx = 0;
        constraintslblPath.gridy = 1;
        constraintslblPath.gridwidth = 3;
        constraintslblPath.gridheight = 1;
        constraintslblPath.fill = 2;
        constraintslblPath.anchor = 17;
        constraintslblPath.weightx = 0.0;
        constraintslblPath.weighty = 0.0;
        constraintslblPath.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.getlblPath(), constraintslblPath);
        constraintslblStatus.gridx = 0;
        constraintslblStatus.gridy = 2;
        constraintslblStatus.gridwidth = 3;
        constraintslblStatus.gridheight = 1;
        constraintslblStatus.fill = 2;
        constraintslblStatus.anchor = 17;
        constraintslblStatus.weightx = 0.0;
        constraintslblStatus.weighty = 0.0;
        constraintslblStatus.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.getlblStatus(), constraintslblStatus);
        constraintspnlAction.gridx = 0;
        constraintspnlAction.gridy = 3;
        constraintspnlAction.gridwidth = 3;
        constraintspnlAction.gridheight = 1;
        constraintspnlAction.fill = 2;
        constraintspnlAction.anchor = 17;
        constraintspnlAction.weightx = 0.0;
        constraintspnlAction.weighty = 0.0;
        constraintspnlAction.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.getpnlAction(), constraintspnlAction);
        this.initConnections();
        this.init();
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getlstFiles()) {
            this.connEtoC4(e);
        }
    }

    public void lstFiles_ActionEvents() {
        RemoteFile fl;
        String str = this.ivjlstFiles.getSelectedItem();
        if (str == null) {
            return;
        }
        if (str.endsWith(this.strRemotePathSeparator)) {
            str = str.substring(0, str.length() - 1);
        }
        if (this.strCurrentPath.length() > 0) {
            str = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + str;
        }
        if ((fl = ConfigFrame.smManager.fileGet(str)).isDirectory()) {
            if (str.endsWith("\\..")) {
                int pp = (str = str.substring(0, str.length() - 3)).lastIndexOf(this.strRemotePathSeparator);
                str = pp == -1 ? "" : str.substring(0, pp);
            }
            this.strCurrentPath = str;
            this.refreshFileManager();
        }
    }

    public void lstFiles_ItemStateChanged() {
        String str = this.ivjlstFiles.getSelectedItem();
        if (str == null) {
            return;
        }
        this.ivjtxtContent.setText("");
        String strCmp = str;
        if (strCmp.endsWith(this.strRemotePathSeparator)) {
            strCmp = strCmp.substring(0, strCmp.length() - 1);
        }
        this.ivjlblStatus.setText("");
        boolean blnValidFile = false;
        int i = 0;
        while (i < this.rfCurrentList.length) {
            RemoteFile rf = this.rfCurrentList[i];
            if (rf.getName().equals(strCmp)) {
                String s = "";
                if (rf.isDirectory()) {
                    s = String.valueOf(s) + "Directory: " + rf.getName();
                } else {
                    s = String.valueOf(s) + "File: " + rf.getName();
                    s = String.valueOf(s) + ", Size= " + Helper.formatMemoryString(rf.length());
                    s = String.valueOf(s) + ", Date= " + new Date(rf.lastModified());
                    blnValidFile = true;
                }
                this.ivjlblStatus.setText(s);
                break;
            }
            ++i;
        }
        this.ivjbtnDelete.setEnabled(blnValidFile);
        this.ivjbtnDownload.setEnabled(blnValidFile);
        this.ivjbtnEdit.setEnabled(blnValidFile);
        this.ivjbtnSave.setEnabled(blnValidFile);
    }

    public static void main(String[] args) {
        try {
            ConfigFilemanager aConfigFilemanager = new ConfigFilemanager();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] classArray = new Class[1];
                Class<?> clazz = class$java$awt$Window;
                if (clazz == null) {
                    try {
                        clazz = class$java$awt$Window = Class.forName("java.awt.Window");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class[] parmTypes = classArray;
                Object[] parms = new Object[]{aConfigFilemanager};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {}
            aConfigFilemanager.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("In main() von net.zerotoaster.mta.admin.awt.ConfigFrame trat eine Ausnahmebedingung auf");
            exception.printStackTrace(System.out);
        }
    }

    public void mnuQuit_ActionEvents() {
        this.setVisible(false);
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof PrivilegeChanged) {
            switch (ConfigFrame.intRM_Privilege) {
                case -1: 
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    super.setVisible(false);
                    break;
                }
            }
        }
        super.mtaEvent(e);
    }

    void refreshFileManager() {
        ((Component)this).setCursor(new Cursor(3));
        this.ivjlstFiles.removeAll();
        this.ivjlblStatus.setText("Reading directory");
        Vector<String> vecDirs = new Vector<String>();
        Vector<String> vecFiles = new Vector<String>();
        String strPath = this.strCurrentPath;
        if (strPath.length() == 0) {
            strPath = ".";
        }
        this.rfCurrentList = ConfigFrame.smManager.fileList(strPath);
        if (this.strRemotePathSeparator.length() == 0 && this.rfCurrentList.length > 0) {
            this.strRemotePathSeparator = RemoteFile.separatorChar + "";
        }
        int i = 0;
        while (i < this.rfCurrentList.length) {
            if (this.rfCurrentList[i].isDirectory()) {
                vecDirs.addElement(String.valueOf(this.rfCurrentList[i].getName()) + RemoteFile.separatorChar);
            } else {
                vecFiles.addElement(this.rfCurrentList[i].getName());
            }
            ++i;
        }
        Helper.sortVector(vecDirs);
        Helper.sortVector(vecFiles);
        if (this.strCurrentPath.length() > 0) {
            this.ivjlstFiles.add("..");
        }
        i = 0;
        while (i < vecDirs.size()) {
            this.ivjlstFiles.add((String)vecDirs.elementAt(i));
            ++i;
        }
        i = 0;
        while (i < vecFiles.size()) {
            this.ivjlstFiles.add((String)vecFiles.elementAt(i));
            ++i;
        }
        this.ivjlstFiles.select(0);
        this.lstFiles_ItemStateChanged();
        this.ivjlblPath.setText("Current directory: {ROOT}/" + this.strCurrentPath);
        ((Component)this).setCursor(new Cursor(0));
    }

    void remoteFileDelete(String string) {
        try {
            String strRemoteFile;
            if (this.strCurrentPath.length() > 0) {
                strRemoteFile = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
            }
            ConfigFrame.smManager.fileDelete(strRemoteFile);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        this.refreshFileManager();
    }

    void remoteFileLoad(String string, String strTarget) {
        this.ivjlblStatus.setText("Initiating transfer for " + string + ". Please be patient");
        try {
            String strSource;
            OutputStream out = null;
            out = strTarget != null ? new FileOutputStream(strTarget) : new ByteArrayOutputStream();
            if (this.strCurrentPath.length() > 0) {
                strSource = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
            }
            ConfigFrame.smManager.fileLoad(strSource, new TransferOutputStream(this, out));
            out.flush();
            out.close();
            if (strTarget == null) {
                this.ivjlblStatus.setText("Moving logfile to screen");
                String s = ((ByteArrayOutputStream)out).toString();
                this.ivjtxtContent.setText(s);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        this.ivjlblStatus.setText("Transfer finished");
    }

    void remoteFileSave(String strLocalFile, String string) {
        this.ivjlblStatus.setText("Initiating transfer for " + string + ". Please be patient");
        try {
            String strRemoteFile;
            InputStream in = null;
            in = strLocalFile != null ? new FileInputStream(strLocalFile) : new ByteArrayInputStream(this.ivjtxtContent.getText().getBytes());
            if (this.strCurrentPath.length() > 0) {
                strRemoteFile = String.valueOf(this.strCurrentPath) + this.strRemotePathSeparator + string;
            }
            ConfigFrame.smManager.fileSave(strRemoteFile, new TransferInputStream(this, in));
            in.close();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
        this.ivjlblStatus.setText("Transfer finished");
        this.refreshFileManager();
    }

    public void setVisible(boolean b) {
        switch (ConfigFrame.intRM_Privilege) {
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                super.setVisible(false);
                return;
            }
        }
        super.setVisible(b);
        if (b) {
            this.refreshFileManager();
        } else {
            this.ivjtxtContent.setText("");
            this.ivjlstFiles.removeAll();
            this.ivjlblPath.setText("");
            this.ivjlblStatus.setText("");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC2(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    static Label access$ivjlblStatus(ConfigFilemanager configFilemanager) {
        return configFilemanager.ivjlblStatus;
    }

    public class TransferOutputStream
    extends OutputStream {
        /* synthetic */ ConfigFilemanager this$0;
        private OutputStream out;
        private long lngBytes = 0L;
        private long lngOldBytes = 0L;
        private long lngStartTime = System.currentTimeMillis();

        public TransferOutputStream(ConfigFilemanager this$0, OutputStream out) {
            this.this$0 = this$0;
            this.out = out;
        }

        public void write(int intData) throws IOException {
            this.out.write(intData);
            ++this.lngBytes;
            this.progress();
        }

        public void write(byte[] b) throws IOException {
            this.out.write(b);
            this.lngBytes += (long)b.length;
            this.progress();
        }

        public void write(byte[] b, int i, int k) throws IOException {
            this.out.write(b, i, k);
            this.lngBytes += (long)k;
            this.progress();
        }

        private void progress() {
            if (this.lngBytes - this.lngOldBytes > 4096L) {
                this.lngOldBytes = this.lngBytes;
                long lngTimeDiff = (System.currentTimeMillis() - this.lngStartTime) / 1000L;
                if (lngTimeDiff > 0L) {
                    long lngKB = this.lngBytes / 1024L;
                    long lngKBs = lngKB / lngTimeDiff;
                    ConfigFilemanager.access$ivjlblStatus(this.this$0).setText(lngKB + " kBytes, " + lngKBs + " kBytes/s");
                }
            }
        }
    }

    public class TransferInputStream
    extends InputStream {
        /* synthetic */ ConfigFilemanager this$0;
        private InputStream in;
        private long lngBytes = 0L;
        private long lngOldBytes = 0L;
        private long lngStartTime = System.currentTimeMillis();

        public TransferInputStream(ConfigFilemanager this$0, InputStream in) {
            this.this$0 = this$0;
            this.in = in;
        }

        public int read() throws IOException {
            int i = this.in.read();
            if (i != -1) {
                ++this.lngBytes;
                this.progress();
            }
            return i;
        }

        public int read(byte[] b) throws IOException {
            int i = this.in.read(b);
            this.lngBytes += (long)i;
            this.progress();
            return i;
        }

        public int read(byte[] b, int i, int k) throws IOException {
            int ii = this.in.read(b, i, k);
            this.lngBytes += (long)ii;
            this.progress();
            return ii;
        }

        private void progress() {
            if (this.lngBytes - this.lngOldBytes > 4096L) {
                this.lngOldBytes = this.lngBytes;
                long lngTimeDiff = (System.currentTimeMillis() - this.lngStartTime) / 1000L;
                if (lngTimeDiff > 0L) {
                    long lngKB = this.lngBytes / 1024L;
                    long lngKBs = lngKB / lngTimeDiff;
                    ConfigFilemanager.access$ivjlblStatus(this.this$0).setText(lngKB + " kBytes, " + lngKBs + " kBytes/s");
                }
            }
        }
    }
}

