/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class TimeFactory {
    private static TimeFactory tfImpl;
    private static long lngLastTime;
    private static int intTimeIndex;
    private static final DateFormat dfUID;
    private static final Date dateUID;

    static {
        lngLastTime = 0L;
        intTimeIndex = 0;
        dfUID = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        dateUID = new Date();
    }

    protected TimeFactory() {
    }

    public static synchronized String createUID() {
        StringBuffer strb = new StringBuffer(20);
        long lngNewTime = TimeFactory.getTime();
        intTimeIndex = lngNewTime == lngLastTime ? ++intTimeIndex : 0;
        dateUID.setTime(lngNewTime);
        strb.append(dfUID.format(dateUID));
        strb.append(String.valueOf(1000 + intTimeIndex).substring(1));
        lngLastTime = lngNewTime;
        return strb.toString();
    }

    public static long getTime() {
        if (tfImpl == null) {
            return System.currentTimeMillis();
        }
        return tfImpl.getTimeImpl();
    }

    protected abstract long getTimeImpl();

    public static void setTimeFactoryImpl(TimeFactory tf) {
        tfImpl = tf;
    }
}

