/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class BitStream {
    private InputStream ins = null;
    private RandomAccessFile raf = null;
    int intBuffer = 0;
    int intBitCnt = 99;
    boolean blnEOF = false;

    public BitStream(InputStream ins) {
        this.ins = ins;
        this.reset();
    }

    public BitStream(RandomAccessFile raf) {
        this.raf = raf;
        this.reset();
    }

    public boolean isEOF() {
        return this.blnEOF;
    }

    public static void main(String[] args) throws Exception {
        File fl = new File("p:/videos/die geisha - svcd 3 von 3.mpg");
        FileInputStream in = new FileInputStream(fl);
        BitStream bs = new BitStream(in);
        ((InputStream)in).read();
        ((InputStream)in).read();
        int i = 0;
        while (i < 10) {
            System.out.println(i + " " + Integer.toHexString(bs.read(8)));
            ++i;
        }
        ((InputStream)in).close();
    }

    public int read(int intNbOfBits) throws IOException {
        if (this.blnEOF) {
            return -1;
        }
        if (intNbOfBits == 0) {
            return 0;
        }
        if (intNbOfBits > 32) {
            throw new ArithmeticException("Only a maximum of 32bit can be retrieved at once");
        }
        int intResult = 0;
        int intOutCnt = intNbOfBits - 1;
        int i = 0;
        while (i < intNbOfBits) {
            if (this.intBitCnt < 0) {
                this.intBitCnt = 7;
                this.intBuffer = this.ins != null ? this.ins.read() : this.raf.read();
                if (this.intBuffer == -1) {
                    this.blnEOF = true;
                    return -1;
                }
            }
            if ((this.intBuffer & 1 << this.intBitCnt) != 0) {
                intResult += 1 << intOutCnt;
            }
            --this.intBitCnt;
            --intOutCnt;
            ++i;
        }
        return intResult;
    }

    public int read(int intStartBit, int intNbOfBits) throws IOException {
        this.skip(intStartBit);
        return this.read(intStartBit);
    }

    public void reset() {
        this.intBitCnt = -1;
    }

    public void skip(int intNbOfBits) throws IOException {
        if (intNbOfBits > 32) {
            throw new ArithmeticException("Only a maximum of 32bit can be skipped at once");
        }
        this.read(intNbOfBits);
    }
}

