/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage.file;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.mailfilters.MailFilterChain;
import net.zerotoaster.mta.main.MPA_ServerInstance;
import net.zerotoaster.mta.storage.AccountingRecord;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.LocalStorageManager;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.MailingListRecord;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;

public class FileStorage
extends LocalStorageManager {
    private static final String MAIL_EXT = ".ML";
    private static final String TEMP_EXT = ".TMP";
    private static final String QUEUE_EXT = ".QUE";
    private static final String QUEUE_LOCK_EXT = ".QUL";
    private static final String TRUENAME = "$truename";
    private static final String FILLER = HelperFormat.lset((String)"", (int)200, (char)' ');
    private static final String CONFIG = "filestorage.ini";
    private static Properties prpConfig = null;
    private static Object lckAccounting = new Object();
    private static Object lckUser = new Object();
    private static Object lckDomain = new Object();
    private static Object lckMail = new Object();
    private static Object lckFilter = new Object();
    private static Object lckKeyData = new Object();
    private static Object lckMailingList = new Object();
    private static Object lckProcessQueue = new Object();
    private static boolean blnIsInitialized = false;
    private Vector vecFilesWritten = null;
    private static String strDomainDir = null;
    private static String strUserDir = null;
    private static String strUserMailDir = null;
    private static String strAccDir = null;
    private static String strFilterDir = null;
    private static String strKeyDataDir = null;
    private static String strMailingListDir = null;
    private static String strTempMailDir = null;
    private static String strOutMailDir = null;
    private static int intMailPathPreLen = -1;
    private static int intMailPathCntLen = -1;
    private static String strBackupMailDir = null;
    private static int intBackupMailKeep = 0;
    private SimpleDateFormat sdf = null;
    private Date datBuffer = null;

    public FileStorage() {
        this.setThreadName("File Storage Manager");
        try {
            try {
                this.init();
            }
            catch (InitializationException e) {
                this.dispose();
                throw e;
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Unhandled Exception", t);
                this.dispose();
                throw new InitializationException();
            }
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.resetThreadName();
            throw throwable;
        }
        Object var1_5 = null;
        this.resetThreadName();
    }

    protected Vector accountingReadAll_Impl() {
        String[] strList = new File(strAccDir).list();
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < strList.length) {
            String s = strList[i].toUpperCase();
            if (s.endsWith(".CSV") && (s.startsWith("D") || s.startsWith("M")) && s.charAt(2) == '_') {
                s = String.valueOf(s.substring(0, 2)) + s.substring(3);
                s = s.substring(0, s.length() - 4);
                v.addElement(s);
            }
            ++i;
        }
        return v;
    }

    protected Vector accountingRead_Impl(String strID) throws Throwable {
        File fl = new File(strAccDir, String.valueOf(strID.substring(0, 2)) + "_" + strID.substring(2) + ".CSV");
        if (!fl.exists()) {
            return new Vector(0);
        }
        Vector<AccountingRecord> v = new Vector<AccountingRecord>();
        BufferedReader br = null;
        AccountingRecord acc = null;
        try {
            br = new BufferedReader(new FileReader(fl));
            br.readLine();
            String s = null;
            while ((s = br.readLine()) != null) {
                acc = new AccountingRecord();
                acc.parse(s);
                v.addElement(acc);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Helper.close(br);
            throw throwable;
        }
        Object var6_10 = null;
        Helper.close(br);
        return v;
    }

    protected void accountingStore_Impl(String strID, String strUser, long lngBytesReceived, long lngBytesSent) {
        Configuration.logContext.write("D Updating accounts");
        Configuration.logContext.write("A User " + strUser + ",ID=" + strID + ",RCV=" + lngBytesReceived + ",SND=" + lngBytesSent);
        this.datBuffer.setTime(TimeFactory.getTime());
        String strDate = this.sdf.format(this.datBuffer);
        String strMonth = strDate.substring(0, 6);
        File f = null;
        String strKey = null;
        f = new File(strAccDir, "DU_" + strDate + ".CSV");
        strKey = strUser;
        this.accUpdate(f, strID, strKey, lngBytesReceived, lngBytesSent);
        f = new File(strAccDir, "DD_" + strDate + ".CSV");
        strKey = HelperExtract.splitUserName_getDomain((String)strUser);
        this.accUpdate(f, strID, strKey, lngBytesReceived, lngBytesSent);
        f = new File(strAccDir, "MU_" + strMonth + ".CSV");
        strKey = strUser;
        this.accUpdate(f, strID, strKey, lngBytesReceived, lngBytesSent);
        f = new File(strAccDir, "MD_" + strMonth + ".CSV");
        strKey = HelperExtract.splitUserName_getDomain((String)strUser);
        this.accUpdate(f, strID, strKey, lngBytesReceived, lngBytesSent);
        Configuration.logContext.write("D Accounts updated");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void accUpdate(File f, String strID, String strKey, long lngBytesReceived, long lngBytesSent) {
        RandomAccessFile raf;
        block11: {
            raf = null;
            try {
                try {
                    Object object = lckAccounting;
                    synchronized (object) {
                        raf = new RandomAccessFile(f, "rw");
                        int intRecs = (int)(raf.length() / 157L);
                        if (intRecs == 0) {
                            StringBuffer strb = new StringBuffer();
                            strb.append("*");
                            strb.append(",");
                            strb.append(Helper.lset("Username/Domain", 129, ' '));
                            strb.append(",");
                            strb.append(Helper.rset("Bytes rcv", 11, ' '));
                            strb.append(",");
                            strb.append(Helper.rset("Bytes snd", 11, ' '));
                            strb.append("\r\n");
                            raf.writeBytes(strb.toString());
                            ++intRecs;
                        }
                        String strAcc = null;
                        AccountingRecord rec = new AccountingRecord();
                        int i = 1;
                        while (true) {
                            if (i >= intRecs) {
                                raf.seek(intRecs * 157);
                                rec = new AccountingRecord(strID, strKey, lngBytesReceived, lngBytesSent);
                                raf.writeBytes(rec.toString());
                                break block11;
                            }
                            raf.seek(i * 157);
                            strAcc = raf.readLine();
                            rec.parse(strAcc);
                            if (rec.strKey.equals(strKey)) {
                                rec.lngBytesReceived += lngBytesReceived;
                                rec.lngBytesSent += lngBytesSent;
                                raf.seek(i * 157);
                                raf.writeBytes(rec.toString());
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 7, 9] lbl47 : MonitorExitStatement: MONITOREXIT : var10_7
                                Object var9_14 = null;
                                break;
                            }
                            ++i;
                        }
                    }
                }
                catch (Throwable t) {
                    Configuration.logContext.write("? Cannot update accounting", t);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var9_15 = null;
                Helper.close(raf);
                throw throwable;
            }
            Helper.close(raf);
            return;
        }
        Object var9_16 = null;
        Helper.close(raf);
    }

    private String ascii2hex(String s) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            strb.append(Integer.toHexString(s.charAt(i)));
            strb.append("-");
            ++i;
        }
        if (strb.length() > 0) {
            strb.setLength(strb.length() - 1);
        }
        return strb.toString();
    }

    private String buildShortname(String strRoot, String strLongName) {
        String strMatch = strLongName;
        if (strMatch.length() > intMailPathPreLen) {
            strMatch = strMatch.substring(0, intMailPathPreLen);
        }
        String strShortName = "";
        boolean blnMatch = false;
        int intSuffixCounter = (int)Math.pow(10.0, intMailPathCntLen) - 1;
        int i = 0;
        while (i < intSuffixCounter) {
            Object var10_10;
            strShortName = String.valueOf(strRoot) + strMatch + HelperFormat.rset((long)i, (int)intMailPathCntLen, (char)'0');
            File flTRUENAME = new File(strShortName, TRUENAME);
            if (flTRUENAME.exists()) {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new FileReader(flTRUENAME));
                        blnMatch = br.readLine().equals(strLongName);
                    }
                    catch (FileNotFoundException e) {
                        Configuration.logContext.write((Throwable)e);
                        var10_10 = null;
                        Helper.close(br);
                        return null;
                    }
                    catch (IOException e) {
                        Configuration.logContext.write((Throwable)e);
                        var10_10 = null;
                        Helper.close(br);
                        return null;
                    }
                }
                catch (Throwable e) {
                    var10_10 = null;
                    Helper.close(br);
                    throw e;
                }
                var10_10 = null;
                Helper.close(br);
                if (blnMatch) {
                    break;
                }
            } else {
                new File(strShortName).mkdirs();
                PrintWriter pw = null;
                try {
                    try {
                        pw = new PrintWriter(new FileWriter(flTRUENAME));
                        pw.println(strLongName);
                        pw.flush();
                    }
                    catch (IOException e) {
                        Configuration.logContext.write((Throwable)e);
                        var10_10 = null;
                        pw.close();
                        return null;
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    pw.close();
                    throw throwable;
                }
                var10_10 = null;
                pw.close();
                blnMatch = true;
                break;
            }
            ++i;
        }
        if (!blnMatch) {
            strShortName = null;
        }
        return strShortName;
    }

    private void check() {
        String strDomain;
        boolean blnError = false;
        Configuration.logContext.write("# Integrity check");
        Vector vecDomains = this.domainReadAll_Impl();
        int i = 0;
        while (i < vecDomains.size()) {
            strDomain = (String)vecDomains.elementAt(i);
            try {
                this.domainRead_Impl(strDomain);
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Corrupted domain: " + strDomain + " [" + t.toString() + "]");
                blnError = true;
            }
            ++i;
        }
        int d = 0;
        while (d < vecDomains.size()) {
            strDomain = (String)vecDomains.elementAt(d);
            Vector vecUser = this.userReadAllByDomain_Impl(strDomain);
            int i2 = 0;
            while (i2 < vecUser.size()) {
                String strUser = (String)vecUser.elementAt(i2);
                try {
                    this.userRead_Impl(strUser);
                }
                catch (Throwable t) {
                    Configuration.logContext.write("? Corrupted user: " + strUser + " [" + t.toString() + "]");
                    blnError = true;
                }
                ++i2;
            }
            ++d;
        }
        if (blnError) {
            throw new InitializationException();
        }
        Configuration.logContext.write("# Integrity check end");
    }

    protected void cleanup_Impl(boolean blnStartupMode) throws Throwable {
        Configuration.logContext.write("# Starting Cleanup");
        long lngTime = TimeFactory.getTime();
        if (intBackupMailKeep > 0) {
            Configuration.logContext.write("D Removing mail backup");
            String strDeleteDate = null;
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                this.datBuffer.setTime(TimeFactory.getTime() - (long)intBackupMailKeep * 1000L * 60L * 60L * 24L);
                strDeleteDate = this.sdf.format(this.datBuffer);
            }
            String strBackupDir = Helper.platformPath(strBackupMailDir);
            String[] strDirs = new File(strBackupMailDir).list();
            int i = 0;
            while (i < strDirs.length) {
                File flBackupDir = new File(strBackupDir, strDirs[i]);
                if (flBackupDir.isDirectory() && HelperValidate.isNumeric((String)strDirs[i]) && strDirs[i].compareTo(strDeleteDate) <= 0) {
                    String[] strDeleteFiles = new File(flBackupDir, File.separator).list();
                    int j = 0;
                    while (j < strDeleteFiles.length) {
                        new File(flBackupDir, strDeleteFiles[j]).delete();
                        ++j;
                    }
                    flBackupDir.delete();
                    Configuration.logContext.write("D Removed outdated backup mail directory " + flBackupDir + " with " + strDeleteFiles.length / 2 + " mails");
                }
                ++i;
            }
        }
        String strCurrentDomain = "";
        String strCurrentUser = "";
        Configuration.logContext.write("D Checking usermaildir");
        File flDomainDir = new File(strUserMailDir);
        String[] strDomains = new File(flDomainDir, "").list();
        int intDomains = 0;
        while (intDomains < strDomains.length) {
            File flUserDir = new File(flDomainDir, strDomains[intDomains]);
            if (flUserDir.isDirectory() && (strCurrentDomain = this.readTruename(flUserDir.getPath())) != null) {
                if (this.domainRead_Impl(strCurrentDomain) == null) {
                    Configuration.logContext.write("! Deleting maildirectory for non-existing domain " + strCurrentDomain);
                    this.domainDelete_Impl(strCurrentDomain);
                } else {
                    String[] strUsers = new File(flUserDir, "").list();
                    int intUsers = 0;
                    while (intUsers < strUsers.length) {
                        File flMailDir = new File(flUserDir, strUsers[intUsers]);
                        if (flMailDir.isDirectory() && (strCurrentUser = String.valueOf(this.readTruename(flMailDir.getPath())) + "@" + strCurrentDomain) != null) {
                            if (this.userRead_Impl(strCurrentUser) == null) {
                                Configuration.logContext.write("! Deleting maildirectory for non-existing user " + strCurrentUser);
                                this.userDelete_Impl(strCurrentUser);
                            } else {
                                String[] strMails = new File(flMailDir, "").list();
                                int intMails = 0;
                                while (intMails < strMails.length) {
                                    File flMail;
                                    MailHeaderRecord mhr;
                                    if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal((flMail = new File(flMailDir, strMails[intMails])).getPath())) != null && (lngTime - mhr.getMailLockedTimestamp() >= 1800000L || blnStartupMode)) {
                                        if (mhr.getMailDeleted()) {
                                            Configuration.logContext.write("D Delete mail " + mhr.toString());
                                            flMail.delete();
                                        } else if (mhr.getMailLocked()) {
                                            Configuration.logContext.write("! Unlocked mail " + mhr.toString());
                                            mhr.setMailLocked(false);
                                            this.mailWriteHeader_Impl(mhr);
                                        }
                                    }
                                    ++intMails;
                                }
                            }
                        }
                        ++intUsers;
                    }
                }
            }
            ++intDomains;
        }
        Configuration.logContext.write("D Checking outbound");
        String[] strMails = new File(strOutMailDir, "").list();
        int intMails = 0;
        while (intMails < strMails.length) {
            File flMail;
            MailHeaderRecord mhr;
            if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal((flMail = new File(strOutMailDir, strMails[intMails])).getPath())) != null && (lngTime - mhr.getMailLockedTimestamp() >= 1800000L || blnStartupMode)) {
                if (mhr.getMailDeleted()) {
                    Configuration.logContext.write("D Delete mail " + mhr.toString());
                    flMail.delete();
                } else if (mhr.getMailLocked()) {
                    Configuration.logContext.write("! Unlocked mail " + mhr.toString());
                    mhr.setMailLocked(false);
                    this.mailWriteHeader_Impl(mhr);
                }
            }
            ++intMails;
        }
        Configuration.logContext.write("# Cleanup finished");
    }

    protected void commit_Impl() throws Throwable {
        Configuration.logContext.write("D Commit " + this.vecFilesWritten.size() + " files");
        this.vecFilesWritten.removeAllElements();
    }

    private void convert() {
        String[] strFiles = new File(strUserMailDir).list();
        try {
            int i = 0;
            while (i < strFiles.length) {
                if (strFiles[i].endsWith(MAIL_EXT)) {
                    MailHeaderRecord mhr = this.mailReadHeader_Internal(String.valueOf(strUserMailDir) + strFiles[i]);
                    Configuration.logContext.write("D Converting mail " + mhr.toString());
                    String strTargetDir = null;
                    strTargetDir = mhr.getExternalMail() ? strOutMailDir : this.getStorageDir(mhr.getEnvelopeTo_Redirected()[0]);
                    File flSource = new File(strUserMailDir, strFiles[i]);
                    File flTarget = new File(strTargetDir, String.valueOf(mhr.getUID()) + MAIL_EXT);
                    LineReader lrSource = new LineReader(new FileInputStream(flSource));
                    LineWriter lwTarget = new LineWriter(new FileOutputStream(flTarget));
                    String strBuffer = null;
                    while ((strBuffer = lrSource.readln()) != null) {
                        lwTarget.println(strBuffer);
                    }
                    lwTarget.flush();
                    Helper.close(lrSource);
                    Helper.close(lwTarget);
                    flSource.delete();
                }
                ++i;
            }
        }
        catch (IOException e) {
            Configuration.logContext.write("! Cannot convert mail directory (2.30c12->c13), abort", (Throwable)e);
            throw new StorageException();
        }
    }

    private void deldir(String string) {
        String strDirectory;
        if (string.endsWith("/") || string.endsWith("\\")) {
            strDirectory = string.substring(0, string.length() - 1);
        }
        new File(strDirectory).delete();
    }

    public void dispose() {
        this.setThreadName();
        this.blnDisposed = true;
        this.rollback();
        super.dispose();
        this.vecFilesWritten = null;
        this.resetThreadName();
    }

    protected final void domainDelete_Impl(String strDomain) throws Throwable {
        String strTest = "@" + strDomain;
        File f = new File(strUserDir);
        String[] s = f.list();
        new Vector(s.length);
        int i = 0;
        while (i < s.length) {
            if (s[i].endsWith(strTest)) {
                new File(strUserDir, s[i]).delete();
            }
            ++i;
        }
        new File(strDomainDir, strDomain).delete();
        String strMailDir = this.getStorageDir(strDomain);
        String[] strUsers = new File(strMailDir).list();
        int i2 = 0;
        while (i2 < strUsers.length) {
            File flSubDir = new File(strMailDir, strUsers[i2]);
            if (flSubDir.isDirectory()) {
                String[] strMails = flSubDir.list();
                int t = 0;
                while (t < strMails.length) {
                    new File(flSubDir.getPath(), strMails[t]).delete();
                    ++t;
                }
            }
            flSubDir.delete();
            ++i2;
        }
        this.deldir(strMailDir);
        String[] strFiles = new File(strDomainDir).list();
        int i3 = 0;
        while (i3 < strFiles.length) {
            DomainRecord dom = this.domainRead_Impl(strFiles[i3]);
            if (dom.getDomainAlias().equalsIgnoreCase(strDomain)) {
                dom.setDomainAlias("");
                this.domainWrite_Impl(dom);
            }
            ++i3;
        }
    }

    protected final Vector domainReadAll_Impl() {
        Vector<String> v = new Vector<String>();
        Object object = lckDomain;
        synchronized (object) {
            File f = new File(strDomainDir);
            String[] s = f.list();
            int i = 0;
            while (i < s.length) {
                if (!s[i].equals("$$")) {
                    v.addElement(s[i]);
                }
                ++i;
            }
        }
        Helper.sortVector(v);
        return v;
    }

    protected final DomainRecord domainRead_Impl(String strDomain) throws IOException {
        if (strDomain.length() == 0) {
            return null;
        }
        Object object = lckDomain;
        synchronized (object) {
            File f = new File(strDomainDir, strDomain);
            if (!f.exists()) {
                return null;
            }
            DomainRecord dom = new DomainRecord();
            FileReader fr = new FileReader(f);
            char[] ch = new char[(int)f.length()];
            fr.read(ch);
            dom.recordImport(new String(ch));
            fr.close();
            return dom;
        }
    }

    protected void domainRename_Impl(String strOldDomain, String strNewDomain) throws Throwable {
        DomainRecord domOld = this.domainRead_Impl(strOldDomain);
        if (domOld == null) {
            throw new IOException("Source domain doesn't exist");
        }
        DomainRecord domNew = this.domainRead_Impl(strNewDomain);
        if (domNew != null) {
            throw new IOException("Target domain already exists");
        }
        domNew = new DomainRecord();
        domNew.recordImport(domOld.recordExport());
        domNew.setDomainName(strNewDomain);
        this.domainWrite_Impl(domNew);
        domOld.setDomainAlias(strNewDomain);
        this.domainWrite_Impl(domOld);
        String strDomainDir = this.getStorageDir(strOldDomain);
        String[] strUsers = new File(strDomainDir).list();
        int intUsers = 0;
        while (intUsers < strUsers.length) {
            File flUser = new File(strDomainDir, strUsers[intUsers]);
            if (flUser.isDirectory()) {
                String[] strMails = flUser.list();
                int intMails = 0;
                while (intMails < strMails.length) {
                    MailHeaderRecord mhrOld;
                    if (strMails[intMails].endsWith(MAIL_EXT) && (mhrOld = this.mailReadHeader_Internal(String.valueOf(flUser.getPath()) + File.separator + strMails[intMails])) != null) {
                        MailHeaderRecord mhrNew = new MailHeaderRecord();
                        mhrNew.recordImport(mhrOld.recordExport());
                        String strUsrDom = mhrNew.getEnvelopeTo_Redirected()[0];
                        mhrNew.addEnvelopeTo_Redirected(String.valueOf(HelperExtract.splitUserName_getUser((String)strUsrDom)) + "@" + strNewDomain);
                        this.mailMove_Impl(mhrOld, mhrNew);
                    }
                    ++intMails;
                }
            }
            ++intUsers;
        }
        Vector vecUsers = this.userReadAllByDomain_Impl(strOldDomain);
        int i = 0;
        while (i < vecUsers.size()) {
            String strUser = (String)vecUsers.elementAt(i);
            UserRecord usrOld = this.userRead_Impl(strUser);
            UserRecord usrNew = new UserRecord();
            usrNew.recordImport(usrOld.recordExport());
            usrNew.setUserName(String.valueOf(HelperExtract.splitUserName_getUser((String)strUser)) + "@" + strNewDomain);
            this.userWrite_Impl(usrNew);
            this.userDelete_Impl(strUser);
            ++i;
        }
    }

    protected final void domainWrite_Impl(DomainRecord dom) throws IOException {
        Object object = lckDomain;
        synchronized (object) {
            File flTmp = new File(strDomainDir, "$$" + dom.getDomainName());
            File flNew = new File(strDomainDir, dom.getDomainName());
            FileWriter fw = new FileWriter(flTmp);
            fw.write(dom.recordExport());
            fw.flush();
            fw.close();
            flNew.delete();
            flTmp.renameTo(flNew);
        }
    }

    protected final void filterDelete_Impl(String strFilter) {
        Object object = lckFilter;
        synchronized (object) {
            new File(strFilterDir, strFilter).delete();
        }
    }

    protected final Vector filterReadAll_Impl() throws Throwable {
        Vector<String> v = new Vector<String>();
        Object object = lckFilter;
        synchronized (object) {
            File f = new File(strFilterDir);
            String[] s = f.list();
            int i = 0;
            while (i < s.length) {
                v.addElement(s[i]);
                ++i;
            }
        }
        Helper.sortVector(v);
        return v;
    }

    protected final FilterRecord filterRead_Impl(String strName) throws Throwable {
        if (strName.length() == 0) {
            return null;
        }
        File f = new File(strFilterDir, strName);
        if (!f.exists()) {
            return null;
        }
        Object object = lckFilter;
        synchronized (object) {
            FilterRecord rr = new FilterRecord();
            FileReader fr = new FileReader(f);
            char[] ch = new char[(int)f.length()];
            fr.read(ch);
            rr.recordImport(new String(ch));
            fr.close();
            return rr;
        }
    }

    protected final void filterWrite_Impl(FilterRecord rr) throws Throwable {
        Object object = lckFilter;
        synchronized (object) {
            File flTmp = new File(strFilterDir, "$$" + rr.getName());
            File flNew = new File(strFilterDir, rr.getName());
            FileWriter fw = new FileWriter(flTmp);
            fw.write(rr.recordExport());
            fw.flush();
            fw.close();
            flNew.delete();
            flTmp.renameTo(flNew);
        }
    }

    private String getMailBackupDir() {
        if (strBackupMailDir.length() == 0) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = this.sdf;
        synchronized (simpleDateFormat) {
            String strDate = null;
            this.datBuffer.setTime(TimeFactory.getTime());
            strDate = this.sdf.format(this.datBuffer);
            String strDir = Helper.platformPath(String.valueOf(strBackupMailDir) + strDate + File.separator);
            new File(strDir).mkdirs();
            return strDir;
        }
    }

    private String getPath(String strKey) {
        String strDir = Helper.platformPath(prpConfig.getProperty(strKey));
        if (strDir.length() == 0) {
            return "";
        }
        if (!strDir.endsWith(File.separator)) {
            strDir = String.valueOf(strDir) + File.separator;
        }
        new File(strDir).mkdirs();
        return strDir;
    }

    private String getStorageDir(String strPath) {
        String strDomain = null;
        String strUser = null;
        if (strPath.indexOf("@") == -1) {
            strDomain = strPath;
            strUser = null;
        } else {
            strDomain = HelperExtract.splitUserName_getDomain((String)strPath);
            strUser = HelperExtract.splitUserName_getUser((String)strPath);
        }
        String strRoot = strUserMailDir;
        strRoot = this.buildShortname(strRoot, strDomain);
        if (strRoot == null) {
            Configuration.logContext.write("? Cannot create domain shortname path for " + strPath);
            return null;
        }
        strRoot = String.valueOf(strRoot) + File.separator;
        if (strUser == null) {
            return strRoot;
        }
        if ((strRoot = this.buildShortname(strRoot, strUser)) == null) {
            Configuration.logContext.write("? Cannot create user shortname path for " + strPath);
            return null;
        }
        strRoot = String.valueOf(strRoot) + File.separator;
        return strRoot;
    }

    private String hex2ascii(String s) {
        StringBuffer strb = new StringBuffer();
        StringTokenizer strt = new StringTokenizer(s, "-");
        while (strt.hasMoreTokens()) {
            strb.append((char)Integer.valueOf(strt.nextToken(), 16).intValue());
        }
        return strb.toString();
    }

    private void init() {
        if (!blnIsInitialized) {
            blnIsInitialized = true;
            this.initConfig();
            this.convert();
            this.check();
        }
        this.vecFilesWritten = new Vector();
        this.sdf = new SimpleDateFormat();
        this.sdf.applyPattern("yyyyMMdd");
        this.datBuffer = new Date();
    }

    private void initConfig() {
        prpConfig = new Properties();
        ((Hashtable)prpConfig).put("domaindir", "./domains/");
        ((Hashtable)prpConfig).put("userdir", "./users/");
        ((Hashtable)prpConfig).put("maildir", "./mails/");
        ((Hashtable)prpConfig).put("outmaildir", "./mails/outbound/");
        ((Hashtable)prpConfig).put("tempmaildir", "./mails/temp/");
        ((Hashtable)prpConfig).put("accdir", "./accounting/");
        ((Hashtable)prpConfig).put("filterdir", "./filters/");
        ((Hashtable)prpConfig).put("keydatadir", "./misc/");
        ((Hashtable)prpConfig).put("mailinglistdir", "./mailinglists/");
        ((Hashtable)prpConfig).put("mailpath_pre_len", "38");
        ((Hashtable)prpConfig).put("mailpath_cnt_len", "2");
        ((Hashtable)prpConfig).put("backupmaildir", "");
        ((Hashtable)prpConfig).put("backupmailkeep", "0");
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(CONFIG);
                prpConfig.load(in);
            }
            catch (Throwable throwable) {
                Configuration.logContext.write("? filestorage.ini not found, abort");
                this.dispose();
                throw new InitializationException();
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            Helper.close(in);
            throw throwable;
        }
        Object var2_5 = null;
        Helper.close(in);
        strDomainDir = this.getPath("domaindir");
        strUserDir = this.getPath("userdir");
        strUserMailDir = this.getPath("maildir");
        strOutMailDir = this.getPath("outmaildir");
        strTempMailDir = this.getPath("tempmaildir");
        strAccDir = this.getPath("accdir");
        strFilterDir = this.getPath("filterdir");
        strKeyDataDir = this.getPath("keydatadir");
        strMailingListDir = this.getPath("mailinglistdir");
        intMailPathPreLen = Integer.parseInt(prpConfig.getProperty("mailpath_pre_len"));
        intMailPathCntLen = Integer.parseInt(prpConfig.getProperty("mailpath_cnt_len"));
        strBackupMailDir = this.getPath("backupmaildir");
        intBackupMailKeep = Integer.parseInt(prpConfig.getProperty("backupmailkeep"));
        Configuration.logContext.write("D Domain directory: " + strDomainDir);
        Configuration.logContext.write("D User directory  : " + strUserDir);
        Configuration.logContext.write("D Mail directory  : " + strUserMailDir);
        Configuration.logContext.write("D Outbound dir.   : " + strOutMailDir);
        Configuration.logContext.write("D TempMail dir.   : " + strTempMailDir);
        Configuration.logContext.write("D Accounting      : " + strAccDir);
        Configuration.logContext.write("D Filters         : " + strFilterDir);
        Configuration.logContext.write("D KeyData         : " + strKeyDataDir);
        Configuration.logContext.write("D Mailinglists    : " + strMailingListDir);
        Configuration.logContext.write("D Pathlen         : " + intMailPathPreLen);
        Configuration.logContext.write("D Pathsuffix      : " + intMailPathCntLen);
        Configuration.logContext.write("D Backupmaildir   : " + strBackupMailDir);
        Configuration.logContext.write("D Backupmailkeep  : " + intBackupMailKeep);
        File flUserMailDir = new File(strUserMailDir);
        File flOutMailDir = new File(strOutMailDir);
        File flTempMailDir = new File(strTempMailDir);
        if (flUserMailDir.equals(flOutMailDir)) {
            Configuration.logContext.write("? maildir = outmaildir. Must be different directories");
            throw new InitializationException();
        }
        if (flUserMailDir.equals(flTempMailDir)) {
            Configuration.logContext.write("? maildir = tempmaildir. Must be different directories");
            throw new InitializationException();
        }
        if (flOutMailDir.equals(flTempMailDir)) {
            Configuration.logContext.write("? outmaildir = tempmaildir. Must be different directories");
            throw new InitializationException();
        }
    }

    protected final void keyDataDelete_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        Object object = lckKeyData;
        synchronized (object) {
            new File(strKeyDataDir, String.valueOf(strApplName) + "#" + strUserName + "#" + this.ascii2hex(strKey)).delete();
        }
    }

    protected final Vector keyDataReadAll_Impl(String strApplName, String strUserName) throws Throwable {
        Vector<String> v = new Vector<String>();
        Object object = lckKeyData;
        synchronized (object) {
            File f = new File(strKeyDataDir);
            String[] s = f.list();
            int i = 0;
            while (i < s.length) {
                String ss = s[i];
                int pp1 = ss.indexOf("#") + 1;
                int pp2 = ss.indexOf("#", pp1);
                if (strApplName.length() == 0) {
                    v.addElement(ss.substring(0, pp1));
                } else if (ss.startsWith(String.valueOf(strApplName) + "#")) {
                    if (strUserName.length() == 0) {
                        v.addElement(ss.substring(pp1, pp2));
                    } else if (ss.startsWith(String.valueOf(strApplName) + "#" + strUserName + "#")) {
                        v.addElement(this.hex2ascii(ss.substring(pp2 + 1)));
                    }
                }
                ++i;
            }
        }
        Helper.sortVector(v);
        return v;
    }

    protected final String keyDataRead_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        File fl = new File(strKeyDataDir, String.valueOf(strApplName) + "#" + strUserName + "#" + this.ascii2hex(strKey));
        if (!fl.exists()) {
            return null;
        }
        Object object = lckKeyData;
        synchronized (object) {
            FileReader fr = new FileReader(fl);
            char[] ch = new char[(int)fl.length()];
            fr.read(ch);
            fr.close();
            return new String(ch);
        }
    }

    protected final void keyDataWrite_Impl(String strApplName, String strUserName, String strKey, String strData) throws Throwable {
        Object object = lckKeyData;
        synchronized (object) {
            File flTmp = new File(strKeyDataDir, "$$" + strApplName + "#" + strUserName + "#" + this.ascii2hex(strKey));
            File flNew = new File(strKeyDataDir, String.valueOf(strApplName) + "#" + strUserName + "#" + this.ascii2hex(strKey));
            FileWriter fw = new FileWriter(flTmp);
            fw.write(strData);
            fw.close();
            flNew.delete();
            flTmp.renameTo(flNew);
        }
    }

    protected final Vector mailGetAllHeaders_Impl() throws Throwable {
        Vector<MailHeaderRecord> v = new Vector<MailHeaderRecord>();
        File flDomainDir = new File(strUserMailDir);
        String[] strDomains = new File(flDomainDir, "").list();
        int intDomains = 0;
        while (intDomains < strDomains.length) {
            File flUserDir = new File(flDomainDir, strDomains[intDomains]);
            if (flUserDir.isDirectory()) {
                String[] strUsers = new File(flUserDir, "").list();
                int intUsers = 0;
                while (intUsers < strUsers.length) {
                    File flMailDir = new File(flUserDir, strUsers[intUsers]);
                    if (flMailDir.isDirectory()) {
                        String[] strMails = new File(flMailDir, "").list();
                        int intMails = 0;
                        while (intMails < strMails.length) {
                            File flMail;
                            MailHeaderRecord mhr;
                            if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal((flMail = new File(flMailDir, strMails[intMails])).getPath())) != null) {
                                v.addElement(mhr);
                            }
                            ++intMails;
                        }
                    }
                    ++intUsers;
                }
            }
            ++intDomains;
        }
        String[] strMails = new File(strOutMailDir).list();
        int intMails = 0;
        while (intMails < strMails.length) {
            File flMail;
            MailHeaderRecord mhr;
            if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal((flMail = new File(strOutMailDir, strMails[intMails])).getPath())) != null) {
                v.addElement(mhr);
            }
            ++intMails;
        }
        return v;
    }

    protected final Vector mailGetHeadersForDomain_Impl(String strDomain) throws Throwable {
        Vector<MailHeaderRecord> v = new Vector<MailHeaderRecord>();
        String strDomainDir = this.getStorageDir(strDomain);
        String[] strUsers = new File(strDomainDir).list();
        int intUsers = 0;
        while (intUsers < strUsers.length) {
            File flUser = new File(strDomainDir, strUsers[intUsers]);
            if (flUser.isDirectory()) {
                String[] strMails = flUser.list();
                int intMails = 0;
                while (intMails < strMails.length) {
                    MailHeaderRecord mhr;
                    if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal(String.valueOf(flUser.getPath()) + File.separator + strMails[intMails])) != null && !mhr.getExternalMail() && !mhr.getMailDeleted() && !mhr.getMailLocked()) {
                        v.addElement(mhr);
                    }
                    ++intMails;
                }
            }
            ++intUsers;
        }
        return v;
    }

    protected final Vector mailGetHeadersForUser_Impl(String strUserName) throws Throwable {
        Vector<MailHeaderRecord> v = new Vector<MailHeaderRecord>();
        String strTargetDir = this.getStorageDir(strUserName);
        String[] strMails = new File(strTargetDir).list();
        int intMails = 0;
        while (intMails < strMails.length) {
            MailHeaderRecord mhr;
            if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal(String.valueOf(strTargetDir) + strMails[intMails])) != null && !mhr.getExternalMail() && !mhr.getMailDeleted() && !mhr.getMailLocked() && mhr.getEnvelopeTo_Redirected()[0].equals(strUserName)) {
                v.addElement(mhr);
            }
            ++intMails;
        }
        return v;
    }

    protected final Vector mailGetHeadersToSend_Impl(int intUpperLimit, long lngRetryDelta) throws Throwable {
        Vector<MailHeaderRecord> v = new Vector<MailHeaderRecord>(intUpperLimit);
        long lngCurrentTime = TimeFactory.getTime();
        String[] strMails = new File(strOutMailDir).list();
        int intMails = 0;
        while (intMails < strMails.length) {
            MailHeaderRecord mhr;
            if (strMails[intMails].endsWith(MAIL_EXT) && (mhr = this.mailReadHeader_Internal(String.valueOf(strOutMailDir) + strMails[intMails])) != null && mhr.getExternalMail() && !mhr.getMailDeleted() && !mhr.getMailLocked()) {
                new Date(mhr.getTimeNextRetry());
                new Date(lngCurrentTime);
                if (mhr.getTimeNextRetry() <= lngCurrentTime) {
                    v.addElement(mhr);
                    if (v.size() > intUpperLimit) break;
                }
            }
            ++intMails;
        }
        return v;
    }

    protected final void mailinglistDelete_Impl(String strName) {
        Object object = lckMailingList;
        synchronized (object) {
            new File(strMailingListDir, strName).delete();
        }
    }

    protected final Vector mailinglistReadAll_Impl() {
        Vector<String> v = new Vector<String>();
        Object object = lckMailingList;
        synchronized (object) {
            File f = new File(strMailingListDir);
            String[] s = f.list();
            int i = 0;
            while (i < s.length) {
                v.addElement(s[i]);
                ++i;
            }
        }
        Helper.sortVector(v);
        return v;
    }

    protected final MailingListRecord mailinglistRead_Impl(String strName) throws IOException {
        if (strName.length() == 0) {
            return null;
        }
        File f = new File(strMailingListDir, strName);
        if (!f.exists()) {
            return null;
        }
        Object object = lckMailingList;
        synchronized (object) {
            MailingListRecord mlr = new MailingListRecord();
            FileReader fr = new FileReader(f);
            char[] ch = new char[(int)f.length()];
            fr.read(ch);
            mlr.recordImport(new String(ch));
            fr.close();
            return mlr;
        }
    }

    protected final void mailinglistWrite_Impl(MailingListRecord mlr) throws IOException {
        Object object = lckMailingList;
        synchronized (object) {
            new File(strMailingListDir);
            File flTmp = new File(strMailingListDir, "$$" + mlr.getName());
            File flNew = new File(strMailingListDir, mlr.getName());
            FileWriter fw = new FileWriter(flTmp);
            fw.write(mlr.recordExport());
            fw.flush();
            fw.close();
            flNew.delete();
            flTmp.renameTo(flNew);
        }
    }

    protected final void mailMove_Impl(MailHeaderRecord mhrOld, MailHeaderRecord mhrNew) throws Throwable {
        String strSourceDir = null;
        strSourceDir = mhrOld.getExternalMail() ? strOutMailDir : this.getStorageDir(mhrOld.getEnvelopeTo_Redirected()[0]);
        String strTargetDir = null;
        strTargetDir = mhrNew.getExternalMail() ? strOutMailDir : this.getStorageDir(mhrNew.getEnvelopeTo_Redirected()[0]);
        if (strSourceDir.equals(strTargetDir) && mhrOld.getUID().equals(mhrNew.getUID())) {
            this.mailWriteHeader_Impl(mhrNew);
            return;
        }
        Object object = lckMail;
        synchronized (object) {
            File flSource = new File(String.valueOf(strSourceDir) + mhrOld.getUID() + MAIL_EXT);
            File flTarget = new File(String.valueOf(strTargetDir) + mhrNew.getUID() + MAIL_EXT);
            LineReader lrSource = new LineReader(new FileInputStream(flSource));
            LineWriter lwTarget = new LineWriter(new FileOutputStream(flTarget));
            String strBuffer = null;
            lrSource.readln();
            lwTarget.println(mhrNew.recordExport());
            while ((strBuffer = lrSource.readln()) != null) {
                lwTarget.println(strBuffer);
            }
            Helper.close(lrSource);
            Helper.close(lwTarget);
            flSource.delete();
        }
    }

    protected final void mailProcessQueueAdd_Impl(MailQueueRecord mqr) throws Throwable {
        Configuration.logContext.write("D Adding " + mqr.toString() + " to Queue");
        File f = new File(strTempMailDir, String.valueOf(mqr.strUID_Queue) + QUEUE_EXT);
        LineWriter lw = null;
        try {
            Object object = lckProcessQueue;
            synchronized (object) {
                lw = new LineWriter(new FileOutputStream(f));
                lw.println(mqr.strUID_Queue);
                lw.println(String.valueOf(mqr.blnAVScan));
                lw.println(mqr.strUID_Temp);
                lw.println(String.valueOf(TimeFactory.getTime()));
                lw.println(String.valueOf(mqr.vecMHR.size()));
                int i = 0;
                while (i < mqr.vecMHR.size()) {
                    MailHeaderRecord mhr = (MailHeaderRecord)mqr.vecMHR.elementAt(i);
                    lw.println(mhr.recordExport());
                    ++i;
                }
                lw.flush();
                Helper.close(lw);
            }
            Configuration.logContext.write("D " + mqr.toString() + " added");
        }
        catch (Throwable t) {
            Helper.close(lw);
            f.delete();
            throw t;
        }
    }

    protected final Vector mailProcessQueueNext_Impl(int intUpbMails) throws Throwable {
        File f = new File(strTempMailDir);
        String[] strFiles = f.list();
        Vector<MailQueueRecord> vecMQR = new Vector<MailQueueRecord>(intUpbMails);
        Configuration.logContext.write("D Retrieving next mail from queue");
        int i = 0;
        while (i < strFiles.length) {
            String strFile = strFiles[i].toUpperCase();
            if (strFile.endsWith(QUEUE_EXT)) {
                LineReader lr = null;
                try {
                    File flQueue = new File(strTempMailDir, strFile);
                    Object object = lckProcessQueue;
                    synchronized (object) {
                        lr = new LineReader(new FileInputStream(flQueue));
                        MailQueueRecord mqr = new MailQueueRecord();
                        mqr.strUID_Queue = lr.readln();
                        mqr.blnAVScan = Boolean.valueOf(lr.readln());
                        mqr.strUID_Temp = lr.readln();
                        lr.readln();
                        int intUpb = Integer.parseInt(lr.readln());
                        int j = 0;
                        while (j < intUpb) {
                            MailHeaderRecord mhr = new MailHeaderRecord();
                            mhr.recordImport(lr.readln());
                            mqr.vecMHR.addElement(mhr);
                            ++j;
                        }
                        Helper.close(lr);
                        vecMQR.addElement(mqr);
                        Configuration.logContext.write("D Retrieved " + mqr.toString());
                    }
                    String strLockFile = String.valueOf(strFile.substring(0, strFile.length() - QUEUE_EXT.length())) + QUEUE_LOCK_EXT;
                    File flLocked = new File(strTempMailDir, strLockFile);
                    flQueue.renameTo(flLocked);
                    if (flLocked.exists() && !flQueue.exists()) {
                        Configuration.logContext.write("D Queuefile successfully locked");
                    } else {
                        Configuration.logContext.write("? Queuefile not locked");
                    }
                    if (vecMQR.size() > intUpbMails) {
                        break;
                    }
                }
                catch (Throwable t) {
                    Helper.close(lr);
                    throw t;
                }
            }
            ++i;
        }
        if (vecMQR.size() == 0) {
            Configuration.logContext.write("D Nothing to do, queue empty");
        }
        return vecMQR;
    }

    protected final void mailProcessQueueRemove_Impl(MailQueueRecord mqr) throws Throwable {
        Configuration.logContext.write("D Removing " + mqr.toString() + " from queue");
        File flQueue = new File(strTempMailDir, String.valueOf(mqr.strUID_Queue) + QUEUE_LOCK_EXT);
        String strMove = this.getMailBackupDir();
        if (strMove != null) {
            File flNew = new File(strMove, String.valueOf(mqr.strUID_Queue) + QUEUE_EXT);
            flQueue.renameTo(flNew);
            Configuration.logContext.write("D " + flQueue.getName() + " moved to " + flNew.getPath());
        } else {
            flQueue.delete();
            Configuration.logContext.write("D " + flQueue.getName() + " removed from queue");
        }
        this.tempDelete_Impl(mqr.strUID_Temp);
    }

    protected final LineReader mailReadBody_Impl(MailHeaderRecord mhr) throws Throwable {
        String strStorageDir = null;
        strStorageDir = mhr.getExternalMail() ? strOutMailDir : this.getStorageDir(mhr.getEnvelopeTo_Redirected()[0]);
        File flMail = new File(String.valueOf(strStorageDir) + mhr.getUID() + MAIL_EXT);
        if (!flMail.exists()) {
            Configuration.logContext.write("? Mail " + mhr.getUID() + MAIL_EXT + " / " + mhr.toString() + " not found !");
            throw new StorageException();
        }
        LineReader lr = new LineReader(new FileInputStream(flMail));
        lr.readln();
        return lr;
    }

    protected final void mailReadBody_Impl(MailHeaderRecord mhr, POP3OutputWriter out) throws Throwable {
        LineReader lr = this.mailReadBody_Impl(mhr);
        try {
            String strData = null;
            boolean blnHadDot = false;
            while ((strData = lr.readln()) != null) {
                out.println(strData);
                if (strData.equals(".")) {
                    blnHadDot = true;
                }
                if (out.isFinished()) break;
            }
            if (!blnHadDot) {
                out.println(".");
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            lr.close();
            throw throwable;
        }
        Object var4_8 = null;
        lr.close();
    }

    protected final MailHeaderRecord mailReadHeader_Impl(String strUID) throws Throwable {
        if (strUID.length() == 0) {
            return null;
        }
        File flMail = new File(strUserMailDir, String.valueOf(strUID) + MAIL_EXT);
        if (!flMail.exists()) {
            return null;
        }
        Object object = lckMail;
        synchronized (object) {
            return this.mailReadHeader_Internal(flMail.getPath());
        }
    }

    private final MailHeaderRecord mailReadHeader_Internal(String strFile) throws IOException {
        if (strFile.length() == 0) {
            return null;
        }
        File fl = new File(strFile);
        if (fl.length() == 0L) {
            return null;
        }
        LineReader lr = new LineReader(new FileInputStream(fl));
        MailHeaderRecord mhr = new MailHeaderRecord();
        try {
            mhr.recordImport(lr.readln());
            lr.close();
            return mhr;
        }
        catch (Throwable t) {
            lr.close();
            Configuration.logContext.write("? Renamed corrupted mail " + strFile + " (" + t.getMessage() + ")");
            File flFrom = new File(strFile);
            File flTo = new File(String.valueOf(strFile) + ".damaged");
            flFrom.renameTo(flTo);
            return null;
        }
    }

    protected final void mailWriteFromString_Impl(MailHeaderRecord mhr, String strMail) throws Throwable {
        if (mhr.getUID().length() == 0) {
            Configuration.logContext.write("? Empty UID");
            throw new StorageException();
        }
        String strTargetDir = null;
        strTargetDir = mhr.getExternalMail() ? strOutMailDir : this.getStorageDir(mhr.getEnvelopeTo_Redirected()[0]);
        File flMail = new File(strTargetDir, String.valueOf(mhr.getUID()) + MAIL_EXT);
        RandomAccessFile raf = null;
        Object lr = null;
        try {
            mhr.setMailSize(strMail.length());
            int intHeaderLength = this.mailWriteHeader_Impl(mhr);
            raf = new RandomAccessFile(flMail, "rw");
            raf.seek(intHeaderLength);
            raf.writeBytes(strMail);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            Helper.close(lr);
            Helper.close(raf);
            throw throwable;
        }
        Object var7_10 = null;
        Helper.close(lr);
        Helper.close(raf);
    }

    protected final void mailWriteFromTemp_Impl(MailFilterChain mfc, MailHeaderRecord mhr, String strUID_Temp) throws Throwable {
        if (mhr.getUID().length() == 0) {
            Configuration.logContext.write("? Empty UID");
            throw new StorageException();
        }
        File flTemp = new File(String.valueOf(strTempMailDir) + strUID_Temp + TEMP_EXT);
        if (!flTemp.exists()) {
            Configuration.logContext.write("? Cannot find temporary file " + strUID_Temp + TEMP_EXT);
            throw new StorageException();
        }
        LineReader lrTemp = null;
        if (mfc != null) {
            try {
                lrTemp = new LineReader(new FileInputStream(flTemp));
                String strBuffer = null;
                while ((strBuffer = lrTemp.readln()) != null) {
                    mfc.analyze(strBuffer);
                    if (!mfc.canAbort()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable strBuffer) {
                Object var6_8 = null;
                Helper.close(lrTemp);
                throw strBuffer;
            }
            Object var6_9 = null;
            Helper.close(lrTemp);
            if (mfc.canDelete()) {
                return;
            }
        }
        String strTargetDir = null;
        strTargetDir = mhr.getExternalMail() ? strOutMailDir : this.getStorageDir(mhr.getEnvelopeTo_Redirected()[0]);
        String strHeader = mhr.recordExport();
        File flMail = new File(strTargetDir, String.valueOf(mhr.getUID()) + MAIL_EXT);
        if (!this.vecFilesWritten.contains(flMail.getPath())) {
            this.vecFilesWritten.addElement(flMail.getPath());
        }
        strHeader = String.valueOf(strHeader) + FILLER;
        strHeader = String.valueOf(strHeader) + "\r\n";
        LineWriter lwMail = null;
        try {
            lrTemp = new LineReader(new FileInputStream(flTemp));
            lwMail = new LineWriter(new FileOutputStream(flMail));
            lwMail.write(strHeader);
            lwMail.flush();
            String strBuffer = null;
            while ((strBuffer = lrTemp.readln()) != null) {
                if (mfc != null) {
                    strBuffer = mfc.process(strBuffer);
                }
                if (strBuffer == null) continue;
                lwMail.println(strBuffer);
            }
            lwMail.flush();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            Helper.close(lrTemp);
            Helper.close(lwMail);
            throw throwable;
        }
        Object var10_15 = null;
        Helper.close(lrTemp);
        Helper.close(lwMail);
        mhr.setMailSize(flMail.length() - (long)strHeader.length());
        this.mailWriteHeader_Impl(mhr);
    }

    protected final int mailWriteHeader_Impl(MailHeaderRecord mhr) throws Throwable {
        String strTargetDir = null;
        strTargetDir = mhr.getExternalMail() ? strOutMailDir : this.getStorageDir(mhr.getEnvelopeTo_Redirected()[0]);
        Object object = lckMail;
        synchronized (object) {
            File flMail = new File(String.valueOf(strTargetDir) + mhr.getUID() + MAIL_EXT);
            if (!this.vecFilesWritten.contains(flMail.getPath())) {
                this.vecFilesWritten.addElement(flMail.getPath());
            }
            String strHeader = mhr.recordExport();
            if (!flMail.exists()) {
                strHeader = String.valueOf(strHeader) + FILLER;
            } else {
                LineReader lr = new LineReader(new FileInputStream(flMail));
                int intLen = lr.readLine().length();
                Helper.close(lr);
                strHeader = HelperFormat.lset((String)strHeader, (int)intLen, (char)' ');
            }
            strHeader = String.valueOf(strHeader) + "\r\n";
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(flMail, "rw");
                raf.seek(0L);
                raf.writeBytes(strHeader);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Helper.close(raf);
                throw throwable;
            }
            Object var7_9 = null;
            Helper.close(raf);
            return strHeader.length();
        }
    }

    protected final void quotaCleanup_Impl() throws Throwable {
        Configuration.logContext.write("# Quota cleanup starts");
        long lngTimeCurrent = TimeFactory.getTime();
        int intMailsCleaned = 0;
        Vector vecDomains = this.domainReadAll_Impl();
        int recD = 0;
        while (recD < vecDomains.size()) {
            String strDomain = (String)vecDomains.elementAt(recD);
            DomainRecord domRec = this.domainRead(strDomain);
            if (domRec.getQuota_Days() != 0) {
                long lngDomQuota_Days = (long)domRec.getQuota_Days() * 24L * 60L * 60L * 1000L;
                Vector vecUsers = this.userReadAllByDomain_Impl(strDomain);
                int recU = 0;
                while (recU < vecUsers.size()) {
                    String strUser = (String)vecUsers.elementAt(recU);
                    UserRecord usrRec = this.userRead(strUser);
                    if (usrRec != null && usrRec.getQuota_Usage() != 0) {
                        long lngQuota_Days = lngDomQuota_Days;
                        if (usrRec.getQuota_Usage() == 2) {
                            lngQuota_Days = (long)usrRec.getQuota_Days() * 24L * 60L * 60L * 1000L;
                        }
                        if (lngQuota_Days != 0L) {
                            Vector vecMails = this.mailGetHeadersForUser(strUser);
                            long lngTimeLimit = lngTimeCurrent - lngQuota_Days;
                            Configuration.logContext.write("D Quota (time) cleanup for user " + strUser + " " + vecMails.size() + " Mails");
                            int recM = 0;
                            while (recM < vecMails.size()) {
                                MailHeaderRecord mhr = (MailHeaderRecord)vecMails.elementAt(recM);
                                if (!mhr.getMailDeleted() && mhr.getTimeReceived() < lngTimeLimit) {
                                    mhr.setMailDeleted(true);
                                    this.mailWriteHeader_Impl(mhr);
                                    Configuration.logContext.write("D Quota (time) deleted message " + mhr.toString());
                                    ++intMailsCleaned;
                                }
                                ++recM;
                            }
                        }
                    }
                    ++recU;
                }
            }
            ++recD;
        }
        Configuration.logContext.write("# Quota cleanup finished (" + intMailsCleaned + " deleted)");
    }

    protected final boolean quotaExceeded_Impl(String strUser) throws Throwable {
        String strDomain = HelperExtract.splitUserName_getDomain((String)strUser);
        DomainRecord domRec = this.domainRead(strDomain);
        if (domRec == null) {
            return false;
        }
        UserRecord usrRec = this.userRead(strUser);
        if (usrRec == null) {
            return false;
        }
        if (usrRec.getQuota_Usage() == 0) {
            return false;
        }
        int intQuota_Mails = domRec.getQuota_Mails();
        int intQuota_MB = domRec.getQuota_MB();
        if (usrRec.getQuota_Usage() == 2) {
            intQuota_Mails = usrRec.getQuota_Mails();
            intQuota_MB = usrRec.getQuota_MB();
        }
        if (intQuota_Mails == 0 && intQuota_MB == 0) {
            return false;
        }
        Vector vecMails = this.mailGetHeadersForUser(strUser);
        long lngMailsSize = MPA_ServerInstance.getMailSizeForUser(strUser);
        int intMailsTotal = MPA_ServerInstance.getMailCountForUser(strUser);
        int recM = 0;
        while (recM < vecMails.size()) {
            MailHeaderRecord mhr = (MailHeaderRecord)vecMails.elementAt(recM);
            if (!mhr.getMailDeleted()) {
                lngMailsSize += mhr.getMailSize();
                ++intMailsTotal;
            }
            ++recM;
        }
        if (intQuota_Mails > 0 && intMailsTotal > intQuota_Mails) {
            Configuration.logContext.write("! Quota (amount) exceeded for " + strUser);
            return true;
        }
        if (intQuota_MB > 0 && lngMailsSize > (long)intQuota_MB * 1024L * 1024L) {
            Configuration.logContext.write("! Quota (size) exceeded for " + strUser);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readTruename(String strDir) {
        String string;
        File flTmp = new File(strDir, TRUENAME);
        if (!flTmp.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(flTmp));
                string = br.readLine();
                Object var4_5 = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Object var4_6 = null;
                Helper.close(br);
                return null;
            }
            catch (IOException iOException) {
                Object var4_7 = null;
                Helper.close(br);
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            Helper.close(br);
            throw throwable;
        }
        Helper.close(br);
        return string;
    }

    protected final void rollback_Impl() throws Throwable {
        if (this.vecFilesWritten == null) {
            return;
        }
        Vector vector = this.vecFilesWritten;
        synchronized (vector) {
            int i = 0;
            while (i < this.vecFilesWritten.size()) {
                File f = new File((String)this.vecFilesWritten.elementAt(i));
                Configuration.logContext.write("D Rollback file " + f.toString());
                f.delete();
                ++i;
            }
            this.vecFilesWritten.removeAllElements();
        }
    }

    protected final void tempDelete_Impl(String strUID) throws Throwable {
        File flOld = new File(strTempMailDir, String.valueOf(strUID) + TEMP_EXT);
        String strMove = this.getMailBackupDir();
        if (strMove == null) {
            flOld.delete();
            Configuration.logContext.write("D " + flOld.getName() + " removed from queue");
            return;
        }
        File flNew = new File(strMove, String.valueOf(strUID) + TEMP_EXT);
        flOld.renameTo(flNew);
        Configuration.logContext.write("D " + flOld.getName() + " moved to " + flNew.getPath());
    }

    protected final LineReader tempRead_Impl(String strUID) throws Throwable {
        File flTemp = new File(strTempMailDir, String.valueOf(strUID) + TEMP_EXT);
        if (!flTemp.exists()) {
            Configuration.logContext.write("? Cannot find temporary file " + strUID + TEMP_EXT);
            throw new StorageException();
        }
        return new LineReader(new FileInputStream(flTemp));
    }

    protected final LineWriter tempWrite_Impl(String strUID) throws Throwable {
        File f = new File(strTempMailDir, String.valueOf(strUID) + TEMP_EXT);
        if (!this.vecFilesWritten.contains(f.getPath())) {
            this.vecFilesWritten.addElement(f.getPath());
        }
        return new LineWriter(new FileOutputStream(f));
    }

    protected final void tempWrite_Impl(String strUID, LineReader in) throws Throwable {
        LineWriter lw = null;
        try {
            lw = this.tempWrite_Impl(strUID);
            String strData = null;
            while ((strData = in.readln()) != null) {
                lw.println(strData);
            }
            lw.flush();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Helper.close(lw);
            throw throwable;
        }
        Object var4_7 = null;
        Helper.close(lw);
    }

    public final String toString() {
        return "Local file storage";
    }

    protected final void userDelete_Impl(String strUser) throws Throwable {
        new File(strUserDir, strUser).delete();
        String strMailPath = this.getStorageDir(strUser);
        String[] strFiles = new File(strMailPath).list();
        int i = 0;
        while (i < strFiles.length) {
            new File(strMailPath, strFiles[i]).delete();
            ++i;
        }
        new File(strMailPath.substring(0, strMailPath.length() - 1)).delete();
        strFiles = new File(strUserDir).list();
        i = 0;
        while (i < strFiles.length) {
            UserRecord usr = this.userRead_Impl(strFiles[i]);
            String[] strCopy = usr.getCopy();
            int intDeleted = 0;
            int u = 0;
            while (u < strCopy.length) {
                if (strCopy[u].equalsIgnoreCase(strUser)) {
                    strCopy[u] = null;
                    ++intDeleted;
                }
                ++u;
            }
            if (intDeleted != 0) {
                String[] strN = new String[strCopy.length - intDeleted];
                int intCnt = 0;
                int u2 = 0;
                while (u2 < strCopy.length) {
                    if (strCopy[u2] != null) {
                        strN[intCnt++] = strCopy[u2];
                    }
                    ++u2;
                }
                usr.setCopy(strN);
                this.userWrite_Impl(usr);
            }
            ++i;
        }
    }

    protected final Vector userReadAllByDomain_Impl(String strDomain) {
        Vector<String> v = new Vector<String>();
        Object object = lckUser;
        synchronized (object) {
            String strTest = "@" + strDomain;
            File f = new File(strUserDir);
            String[] s = f.list();
            int i = 0;
            while (i < s.length) {
                if (s[i].endsWith(strTest)) {
                    v.addElement(s[i]);
                }
                ++i;
            }
        }
        Helper.sortVector(v);
        return v;
    }

    protected final UserRecord userRead_Impl(String strUser) throws IOException {
        if (strUser == null || strUser.length() == 0) {
            return null;
        }
        Object object = lckUser;
        synchronized (object) {
            File f = new File(strUserDir, strUser);
            if (!f.exists()) {
                return null;
            }
            UserRecord usr = new UserRecord();
            FileReader fr = new FileReader(f);
            char[] ch = new char[(int)f.length()];
            fr.read(ch);
            usr.recordImport(new String(ch));
            fr.close();
            return usr;
        }
    }

    protected final void userWrite_Impl(UserRecord usr) throws IOException {
        Object object = lckUser;
        synchronized (object) {
            File flTmp = new File(strUserDir, "$$" + usr.getUserName());
            File flNew = new File(strUserDir, usr.getUserName());
            FileWriter fw = new FileWriter(flTmp);
            fw.write(usr.recordExport());
            fw.flush();
            fw.close();
            flNew.delete();
            flTmp.renameTo(flNew);
        }
    }
}

