/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.io.RemoteFile;
import net.zerotoaster.mta.mailfilters.MailFilterChain;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.MailingListRecord;
import net.zerotoaster.mta.storage.RemoteStorageManager_Const;
import net.zerotoaster.mta.storage.StatisticsRecord;
import net.zerotoaster.mta.storage.StorageException;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;

public class RemoteStorageManager_Client
extends StorageManager
implements RemoteStorageManager_Const {
    private Socket sok = null;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private String strRemote_IP = null;
    private int intRemote_Port = 0;
    private String strRemote_User = null;
    private String strRemote_Pass = null;
    private String strRemote_Version = null;
    private NoopThread thrdNoop = null;

    protected Vector accountingReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(100);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected Vector accountingRead_Impl(String strID) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(101);
            this.oos.writeUTF(strID);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected void accountingStore_Impl(String strID, String strUser, long lngBytesReceived, long lngBytesSent) {
        throw new StorageException();
    }

    protected void adminForceFetchmail_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(85);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminFullRestart_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(69);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminRestart_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(68);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void adminShutdown_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(67);
            this.oos.flush();
            this.oos.reset();
        }
    }

    protected void cleanup_Impl(boolean blnStartupMode) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(62);
            this.oos.writeBoolean(blnStartupMode);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void commit_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(60);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    public int connectToServer(String strIP, String strUser, String strPass) {
        if (this.sok != null) {
            this.dispose();
        }
        this.strRemote_User = "";
        this.strRemote_Pass = "";
        this.strRemote_IP = HelperExtract.splitIP_getHost((String)strIP);
        this.intRemote_Port = HelperExtract.splitIP_getPort((String)strIP, (int)411);
        this.strRemote_Version = "";
        try {
            this.sok = new Socket(this.strRemote_IP, this.intRemote_Port);
        }
        catch (Throwable throwable) {
            System.out.println("? Cannot open Socket IP=" + this.strRemote_IP + ", Port=" + this.intRemote_Port);
            throw new InitializationException();
        }
        try {
            this.oos = new ObjectOutputStream(this.sok.getOutputStream());
            this.ois = new ObjectInputStream(this.sok.getInputStream());
        }
        catch (Throwable throwable) {
            System.out.println("? Cannot create streams");
            throw new InitializationException();
        }
        int intResult = -3;
        try {
            this.oos.writeInt(65);
            this.oos.writeUTF(strUser);
            this.oos.writeUTF(strPass);
            this.oos.flush();
            intResult = this.ois.readInt();
            this.strRemote_Version = this.ois.readUTF();
            this.oos.reset();
        }
        catch (Throwable t) {
            System.out.println("? Error during logon " + t);
            throw new InitializationException();
        }
        this.thrdNoop = new NoopThread(this, 30000L);
        this.strRemote_User = strUser;
        this.strRemote_Pass = strPass;
        return intResult;
    }

    public void dispose() {
        if (this.sok != null) {
            if (this.thrdNoop != null) {
                this.thrdNoop.dispose();
                this.thrdNoop = null;
            }
            Socket socket = this.sok;
            synchronized (socket) {
                try {
                    this.oos.writeInt(66);
                    this.oos.flush();
                    this.oos.reset();
                }
                catch (Throwable throwable) {}
                Helper.close(this.oos);
                Helper.close(this.ois);
                Helper.close(this.sok);
            }
            this.oos = null;
            this.ois = null;
            this.sok = null;
        }
        super.dispose();
    }

    protected void domainDelete_Impl(String strDomain) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(10);
            this.oos.writeUTF(strDomain);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected Vector domainReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(11);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected DomainRecord domainRead_Impl(String strDomain) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(12);
            this.oos.writeUTF(strDomain);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (DomainRecord)o;
        }
    }

    protected void domainRename_Impl(String strOldDomain, String strNewDomain) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(14);
            this.oos.writeUTF(strOldDomain);
            this.oos.writeUTF(strNewDomain);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void domainWrite_Impl(DomainRecord dom) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(13);
            this.oos.writeObject(dom);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void fileDelete_Impl(String strFile) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(70);
            this.oos.writeUTF(strFile);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected RemoteFile fileGet_Impl(String strPath) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(74);
            this.oos.writeUTF(strPath);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (RemoteFile)o;
        }
    }

    protected RemoteFile[] fileList_Impl(String strPath) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(73);
            this.oos.writeUTF(strPath);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (RemoteFile[])o;
        }
    }

    protected void fileLoad_Impl(String strFile, OutputStream out) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(71);
            this.oos.writeUTF(strFile);
            this.oos.flush();
            byte[] buffer = new byte[1024];
            int i = 0;
            InflaterInputStream iis = new InflaterInputStream(this.ois);
            while ((i = iis.read(buffer)) != -1) {
                out.write(buffer, 0, i);
            }
            out.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void fileSave_Impl(String strFile, InputStream in) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(72);
            this.oos.writeUTF(strFile);
            this.oos.flush();
            byte[] buffer = new byte[1024];
            int i = 0;
            DeflaterOutputStream dos = new DeflaterOutputStream(this.oos);
            while ((i = in.read(buffer)) != -1) {
                dos.write(buffer, 0, i);
            }
            dos.finish();
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void filterDelete_Impl(String strName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(40);
            this.oos.writeUTF(strName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected Vector filterReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(41);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected FilterRecord filterRead_Impl(String strName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(42);
            this.oos.writeUTF(strName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (FilterRecord)o;
        }
    }

    protected void filterWrite_Impl(FilterRecord fr) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(43);
            this.oos.writeObject(fr);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void keyDataDelete_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(90);
            this.oos.writeUTF(strApplName);
            this.oos.writeUTF(strUserName);
            this.oos.writeUTF(strKey);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected Vector keyDataReadAll_Impl(String strApplName, String strUserName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(91);
            this.oos.writeUTF(strApplName);
            this.oos.writeUTF(strUserName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected String keyDataRead_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(92);
            this.oos.writeUTF(strApplName);
            this.oos.writeUTF(strUserName);
            this.oos.writeUTF(strKey);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (String)o;
        }
    }

    protected void keyDataWrite_Impl(String strApplName, String strUserName, String strKey, String strData) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(93);
            this.oos.writeUTF(strApplName);
            this.oos.writeUTF(strUserName);
            this.oos.writeUTF(strKey);
            this.oos.writeUTF(strData);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected String licenceCheck_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(2);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            if (o == null) {
                return null;
            }
            return (String)o;
        }
    }

    protected String[] logGet_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(82);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            if (o == null) {
                return null;
            }
            return (String[])o;
        }
    }

    protected Vector mailGetAllHeaders_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(25);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected Vector mailGetHeadersForDomain_Impl(String strDomain) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(23);
            this.oos.writeUTF(strDomain);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected Vector mailGetHeadersForUser_Impl(String strUserName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(22);
            this.oos.writeUTF(strUserName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected Vector mailGetHeadersToSend_Impl(int intUpperLimit, long lngRetryDelay) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(24);
            this.oos.writeInt(intUpperLimit);
            this.oos.writeLong(lngRetryDelay);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected void mailinglistDelete_Impl(String strName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(110);
            this.oos.writeUTF(strName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected Vector mailinglistReadAll_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(111);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected MailingListRecord mailinglistRead_Impl(String strName) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(112);
            this.oos.writeUTF(strName);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (MailingListRecord)o;
        }
    }

    protected void mailinglistWrite_Impl(MailingListRecord mlr) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(113);
            this.oos.writeObject(mlr);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void mailMove_Impl(MailHeaderRecord mhrOld, MailHeaderRecord mhrNew) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(31);
            this.oos.writeObject(mhrOld);
            this.oos.writeObject(mhrNew);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void mailProcessQueueAdd_Impl(MailQueueRecord mqr) throws Throwable {
    }

    protected Vector mailProcessQueueNext_Impl(int intUpb) throws Throwable {
        return null;
    }

    protected void mailProcessQueueRemove_Impl(MailQueueRecord mqr) throws Throwable {
    }

    protected LineReader mailReadBody_Impl(MailHeaderRecord mhr) throws Throwable {
        throw new StorageException();
    }

    protected void mailReadBody_Impl(MailHeaderRecord mhr, POP3OutputWriter out) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(26);
            this.oos.writeObject(mhr);
            this.oos.flush();
            String strBuffer = null;
            LineReader lr = new LineReader(this.ois);
            while ((strBuffer = lr.readln()) != null) {
                out.println(strBuffer);
            }
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected MailHeaderRecord mailReadHeader_Impl(String strUID) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(27);
            this.oos.writeUTF(strUID);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (MailHeaderRecord)o;
        }
    }

    protected void mailWriteFromString_Impl(MailHeaderRecord mhr, String strMessage) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(30);
            this.oos.writeObject(mhr);
            this.oos.writeUTF(strMessage);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected void mailWriteFromTemp_Impl(MailFilterChain sfc, MailHeaderRecord mhr, String strUID) throws Throwable {
        throw new StorageException();
    }

    protected int mailWriteHeader_Impl(MailHeaderRecord mhr) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(29);
            this.oos.writeObject(mhr);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Integer)o;
        }
    }

    protected void quotaCleanup_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(121);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected boolean quotaExceeded_Impl(String strUser) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(120);
            this.oos.writeUTF(strUser);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Boolean)o;
        }
    }

    protected void rollback_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(61);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    public void setLogContext(LogContext log) {
        Configuration.logContext = log;
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(81);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            if (o == null) {
                return null;
            }
            return (StatisticsRecord)o;
        }
    }

    protected void tempDelete_Impl(String strUID) throws Throwable {
        throw new StorageException();
    }

    protected LineReader tempRead_Impl(String strUID) throws Throwable {
        throw new StorageException();
    }

    protected LineWriter tempWrite_Impl(String strUID) throws Throwable {
        throw new StorageException();
    }

    protected void tempWrite_Impl(String strUID, LineReader lr) throws Throwable {
        throw new StorageException();
    }

    public String toString() {
        return String.valueOf(this.strRemote_IP) + " / " + this.strRemote_User + " / " + this.strRemote_Version;
    }

    protected void userDelete_Impl(String strUser) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(51);
            this.oos.writeUTF(strUser);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    protected Vector userReadAllByDomain_Impl(String strDomain) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(52);
            this.oos.writeUTF(strDomain);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (Vector)o;
        }
    }

    protected UserRecord userRead_Impl(String strUser) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(53);
            this.oos.writeUTF(strUser);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
            return (UserRecord)o;
        }
    }

    protected void userWrite_Impl(UserRecord usr) throws Throwable {
        Socket socket = this.sok;
        synchronized (socket) {
            this.oos.writeInt(54);
            this.oos.writeObject(usr);
            this.oos.flush();
            Object o = this.ois.readObject();
            this.oos.reset();
            if (o instanceof Throwable) {
                throw (Throwable)o;
            }
        }
    }

    static ObjectOutputStream access$oos(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.oos;
    }

    static Socket access$sok(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.sok;
    }

    static ObjectInputStream access$ois(RemoteStorageManager_Client remoteStorageManager_Client) {
        return remoteStorageManager_Client.ois;
    }

    public class NoopThread
    extends Thread {
        /* synthetic */ RemoteStorageManager_Client this$0;
        private long lngNT_Timer = 0L;
        private boolean blnNT_IsRunning = false;
        private LockObject objNT_Lock = new LockObject();

        public NoopThread(RemoteStorageManager_Client this$0, long lngTimer) {
            this.this$0 = this$0;
            this.lngNT_Timer = lngTimer;
            this.setName("Noop-Thread");
            this.start();
        }

        public void dispose() {
            this.blnNT_IsRunning = false;
            this.objNT_Lock.lo_notify();
            this.objNT_Lock.dispose();
        }

        public void run() {
            this.blnNT_IsRunning = true;
            System.out.println("# Started. Ping: " + this.lngNT_Timer / 1000L + " sec");
            while (true) {
                this.objNT_Lock.lo_wait(this.lngNT_Timer);
                if (!this.blnNT_IsRunning) break;
                Socket socket = RemoteStorageManager_Client.access$sok(this.this$0);
                synchronized (socket) {
                    try {
                        RemoteStorageManager_Client.access$oos(this.this$0).writeInt(1);
                        RemoteStorageManager_Client.access$oos(this.this$0).flush();
                        Object o = RemoteStorageManager_Client.access$ois(this.this$0).readObject();
                        RemoteStorageManager_Client.access$oos(this.this$0).reset();
                        if (o instanceof Throwable) {
                            throw (Throwable)o;
                        }
                    }
                    catch (Throwable e) {
                        System.out.println("? Error in NoopThread " + e);
                        break;
                    }
                }
            }
            System.out.println("# Stop");
        }
    }
}

