/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.KickForwarder;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.main.ZeroToaster;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.UserAlias;

public class Mail {
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 1;
    public static final int PRIORITY_LOW = 0;
    private StorageManager smManager = null;
    private Configuration cnf = null;
    private LogContext logContext = null;
    private String strMailFrom_Name = "";
    private String strMailFrom_EMail = "<>";
    private String strMailTo_Name = "";
    private Vector vecMailTo_EMail = new Vector();
    private String strSubject = "(No Subject)";
    private String strContent = "(no mail)";
    private int intPriority = 1;
    private boolean blnIsBounce = false;

    private Mail() {
    }

    public Mail(LogContext logContext, Configuration cnf, StorageManager smManager) {
        this.smManager = smManager;
        this.cnf = cnf;
        this.logContext = logContext;
    }

    /*
     * WARNING - void declaration
     */
    public void setContent(String s) {
        int pp;
        this.strContent = s;
        while ((pp = this.strContent.indexOf("\r\n.\r\n")) > 0) {
            void var2_2;
            this.strContent = String.valueOf(this.strContent.substring(0, (int)(var2_2 + 3))) + "." + this.strContent.substring((int)(var2_2 + 4));
        }
    }

    public void setIsBounce(boolean b) {
        this.blnIsBounce = b;
    }

    public void setMailFrom_EMail(String s) {
        this.strMailFrom_EMail = s;
    }

    public void setMailFrom_Name(String s) {
        this.strMailFrom_Name = s;
    }

    public void setMailTo_EMail(String s) {
        UserAlias uaAlias = new UserAlias(this.cnf.strAliases, this.logContext);
        String[] strUsers = uaAlias.resolve(s);
        int i = 0;
        while (i < strUsers.length) {
            String strRedirectedUser = strUsers[i];
            UserRecord usrReceiver = this.smManager.userRead(s);
            int j = 0;
            while (j < 5) {
                if (usrReceiver != null && usrReceiver.getRedirect().length() != 0) {
                    strRedirectedUser = usrReceiver.getRedirect();
                    usrReceiver = this.smManager.userRead(strRedirectedUser);
                }
                ++j;
            }
            this.vecMailTo_EMail.addElement(strRedirectedUser);
            ++i;
        }
    }

    public void setMailTo_Name(String s) {
        this.strMailTo_Name = s;
    }

    public void setPriority(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                this.intPriority = i;
                break;
            }
            default: {
                throw new IllegalArgumentException("Priority out of range (" + i + ")");
            }
        }
    }

    public void setSubject(String s) {
        this.strSubject = s;
    }

    public boolean store() {
        long lngTime = TimeFactory.getTime();
        String strUID = TimeFactory.createUID();
        if (this.vecMailTo_EMail.size() == 0) {
            this.logContext.write("? 'Mail' no users to send to ");
            return false;
        }
        StringBuffer strb = new StringBuffer();
        String strHeaderFrom = null;
        strHeaderFrom = this.strMailFrom_Name.length() == 0 ? "<" + this.strMailFrom_EMail + ">" : "\"" + this.strMailFrom_Name + "\" <" + this.strMailFrom_EMail + ">";
        strb.append("From: " + strHeaderFrom + "\r\n");
        String strHeaderTo = null;
        strHeaderTo = this.strMailTo_Name.length() == 0 ? "<" + (String)this.vecMailTo_EMail.elementAt(0) + ">" : "\"" + this.strMailTo_Name + "\" <" + (String)this.vecMailTo_EMail.elementAt(0) + ">";
        strb.append("To: " + strHeaderTo + "\r\n");
        if (this.blnIsBounce) {
            strb.append("X-Envelope-From: <>\r\n");
        } else {
            strb.append("X-Envelope-From: <" + this.strMailFrom_EMail + ">\r\n");
        }
        strb.append("Subject: " + this.strSubject + "\r\n");
        strb.append("Date: " + new Date(lngTime).toString());
        strb.append(" ");
        strb.append(String.valueOf(DateFormat.getTimeInstance().format(new Date(lngTime))) + "\r\n");
        switch (this.intPriority) {
            case 2: {
                strb.append("Priority: High\r\n");
                break;
            }
            case 1: {
                strb.append("Priority: Normal\r\n");
                break;
            }
            case 0: {
                strb.append("Priority: Low\r\n");
            }
        }
        strb.append("Message-ID: <" + strUID + "@" + HelperExtract.splitIP_getHost((String)this.cnf.strFWD_Host) + ">\r\n");
        strb.append("X-Mailer: " + ZeroToaster.getVersion() + "\r\n");
        strb.append("MIME-Version: 1.0\r\n");
        strb.append("Content-Type: text/plain; charset=\"iso-8859-1\"\r\n");
        strb.append("Content-Transfer-Encoding: 8bit\r\n");
        strb.append("\r\n");
        strb.append(this.strContent);
        strb.append("\r\n.\r\n");
        int i = 0;
        while (i < this.vecMailTo_EMail.size()) {
            String strMailTo = (String)this.vecMailTo_EMail.elementAt(i);
            MailHeaderRecord m = new MailHeaderRecord();
            m.setUID(TimeFactory.createUID());
            m.setEnvelopeFrom_Orginal(this.strMailFrom_EMail);
            m.setEnvelopeFrom_Redirected(this.strMailFrom_EMail);
            m.addEnvelopeTo_Orginal(strMailTo);
            m.addEnvelopeTo_Redirected(strMailTo);
            m.setMailSize(strb.length());
            m.setTimeReceived(lngTime);
            m.setTimeNextRetry(lngTime);
            m.setRetryCount(0);
            m.setMailDeleted(false);
            m.setIsBounce(this.blnIsBounce);
            DomainRecord dom = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)strMailTo));
            if (dom == null) {
                m.setExternalMail(true);
            } else {
                m.setExternalMail(false);
            }
            this.smManager.mailWriteFromString(m, strb.toString());
            this.smManager.commit();
            this.logContext.write("# Mail: Stored.");
            if (m.getExternalMail()) {
                MTAEventQueue.postEvent(new KickForwarder());
            }
            ++i;
        }
        return true;
    }
}

