/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import de.zwanzigeins.util.IniManager;
import java.util.Vector;
import net.zerotoaster.mta.mailfilters.MailFilter;

public class StringFilter
extends MailFilter {
    private Vector vecWords = null;
    private String strRedirectTo = "";
    private boolean blnDone = false;

    public StringFilter() {
        this.init();
    }

    private void analyze(String strLine) throws Throwable {
        if (this.blnDone) {
            return;
        }
        String strCmp = strLine.toLowerCase();
        int i = 0;
        while (i < this.vecWords.size()) {
            if (strCmp.indexOf((String)this.vecWords.elementAt(i)) != -1) {
                this.blnDone = true;
                this.doAbort();
                if (this.strRedirectTo.length() == 0) {
                    this.doDelete();
                    this.log("# Stringfilter deleted message to " + this.strRedirectTo);
                } else {
                    this.mhr.recipientReset();
                    this.mhr.addEnvelopeTo_Redirected(this.strRedirectTo);
                    this.mhr.setExternalMail(this.smManager.userRead(this.strRedirectTo) == null);
                    this.log("# Stringfilter redirected message to " + this.strRedirectTo);
                }
                return;
            }
            ++i;
        }
    }

    public void analyzeBody(String strLine) throws Throwable {
        this.analyze(strLine);
    }

    public void analyzeHeader(String strLine) throws Throwable {
        this.analyze(strLine);
    }

    public void analyzePost() throws Throwable {
    }

    public void dispose() {
        if (this.vecWords != null) {
            this.vecWords.removeAllElements();
        }
    }

    private void init() {
        this.vecWords = new Vector();
        IniManager im = new IniManager("zt_mta.ini");
        String[] strWords = im.getPropertiesString("MAILFILTER-STRINGFILTER", "word");
        if (strWords.length == 0) {
            this.filterDisable();
            return;
        }
        int i = 0;
        while (i < strWords.length) {
            this.vecWords.addElement(strWords[i].toLowerCase());
            ++i;
        }
        this.strRedirectTo = im.getPropertyString("MAILFILTER-STRINGFILTER", "redirect", "");
        this.blnDone = false;
    }

    public String processBody(String strLine) throws Throwable {
        return strLine;
    }

    public String processHeader(String strLine) throws Throwable {
        return strLine;
    }

    public String processNewHeaders(String strLine) throws Throwable {
        return strLine;
    }

    public String processPost(String strLine) throws Throwable {
        return strLine;
    }
}

