/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import net.zerotoaster.httpd.servlet.util.MacBinaryDecoderOutputStream;
import net.zerotoaster.httpd.servlet.util.Part;
import net.zerotoaster.httpd.servlet.util.PartInputStream;

public class FilePart
extends Part {
    private String fileName;
    private String filePath;
    private String contentType;
    private PartInputStream partInput;

    FilePart(String name, ServletInputStream in, String boundary, String contentType, String fileName, String filePath) throws IOException {
        super(name);
        this.fileName = fileName;
        this.filePath = filePath;
        this.contentType = contentType;
        this.partInput = new PartInputStream(in, boundary);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public InputStream getInputStream() {
        return this.partInput;
    }

    public boolean isFile() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    long write(OutputStream outputStream) throws IOException {
        int read;
        MacBinaryDecoderOutputStream out;
        if (this.contentType.equals("application/x-macbinary")) {
            out = new MacBinaryDecoderOutputStream(outputStream);
        }
        long size = 0L;
        byte[] buf = new byte[8192];
        while ((read = this.partInput.read(buf)) != -1) {
            void var4_4;
            ((OutputStream)out).write(buf, 0, (int)var4_4);
            size += (long)var4_4;
        }
        return size;
    }

    public long writeTo(File fileOrDirectory) throws IOException {
        long written;
        block4: {
            written = 0L;
            OutputStream fileOut = null;
            try {
                if (this.fileName != null) {
                    File file = fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.fileName) : fileOrDirectory;
                    fileOut = new BufferedOutputStream(new FileOutputStream(file));
                    written = this.write(fileOut);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (fileOut != null) {
                    fileOut.close();
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (fileOut == null) break block4;
            fileOut.close();
        }
        return written;
    }

    public long writeTo(OutputStream out) throws IOException {
        long size = 0L;
        if (this.fileName != null) {
            size = this.write(out);
        }
        return size;
    }
}

