/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.cache.HashedFileContentProducer;
import de.zwanzigeins.cache.PrecomputedFileContentCache;
import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.ByteTokenizer;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.KeyData;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.main.Httpd_Container;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_CGI;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.GlobalStatistics_Record;
import net.zerotoaster.httpd.util.Helper;

public class Mod_SSI
extends Mod_CGI {
    private static final String SSI_START = "<!--";
    private static final String SSI_STOP = "-->";
    private Hashtable hshENV = null;
    private int intSSIRecursion = 0;
    private Http_Request reqCGI = null;
    private IntermediateModuleData imdCGI = null;
    private Http_Response resCGI = null;
    private static final Object objAccessCounterLock = new Object();

    public Mod_SSI(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    protected void handleStreamResponse(CRLFInputStream crlfisCGI, long lngBytes, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        long lngDataLength = lngBytes;
        if (lngDataLength < 0L) {
            lngDataLength = Integer.MAX_VALUE;
        }
        byte[] buffer = new byte[Math.min(this.cnfConfig.intStreamBufferSize, (int)lngDataLength)];
        int i = 0;
        this.logContext.write("C Reading SSI-CGI output");
        while (lngDataLength > 0L) {
            i = lngDataLength >= (long)buffer.length ? crlfisCGI.read(buffer, 0, buffer.length) : crlfisCGI.read(buffer, 0, (int)lngDataLength);
            if (i == -1) break;
            httpRES.osResponse.write(buffer, 0, i);
            lngDataLength -= (long)i;
        }
        this.logContext.write("C Got " + ((ByteArrayOutputStream)httpRES.osResponse).size() + " bytes");
    }

    private final String help_filepath(String strMode, String strFile) {
        if (strMode.equalsIgnoreCase("file")) {
            if (HelperPath.isAbsolutePath((String)strFile)) {
                return HelperPath.pathFixup((String)strFile, (String)File.separator);
            }
            return HelperPath.pathFixup((String)(String.valueOf(this.imdCGI.strConfigDir) + File.separator + strFile), (String)File.separator);
        }
        if (strMode.equalsIgnoreCase("virtual")) {
            String strRoot = (String)this.hshENV.get("DOCUMENT_ROOT");
            return HelperPath.pathFixup((String)(String.valueOf(strRoot) + File.separator + strFile), (String)File.separator);
        }
        throw new RuntimeException("help_filepath: " + strMode + " is an unknown mode to me");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String help_increment(String string) {
        String string2;
        if (Configuration.mode_nofile()) {
            return "";
        }
        String strURL = string.toLowerCase();
        byte[] buffer = new byte[262];
        RandomAccessFile raf = null;
        File fl = null;
        long lngPointer = 0L;
        try {
            try {
                fl = new File(this.imdCGI.strHTDOCS, "pagecounter.dat");
                raf = new RandomAccessFile(fl, "rw");
                long lngRecordFound = -1L;
                long lngRecords = (raf.length() + (long)262 - 1L) / (long)262;
                int intAccess = 0;
                int i = 0;
                while ((long)i < lngRecords) {
                    lngPointer = i * 262;
                    raf.seek(lngPointer);
                    int ii = raf.read(buffer);
                    if (ii == 262) {
                        ByteTokenizer bytt = new ByteTokenizer(buffer, -1);
                        String strAccess = bytt.nextToken();
                        String strFile = bytt.nextToken();
                        if (strFile.equals(strURL)) {
                            lngRecordFound = lngPointer;
                            try {
                                intAccess = Integer.parseInt(strAccess);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                    }
                    ++i;
                }
                if (lngRecordFound == -1L) {
                    lngRecordFound = raf.length();
                }
                ByteString byts = new ByteString(262);
                byts.append(++intAccess);
                byts.append((byte)-1);
                byts.append(strURL);
                byts.append((byte)-1);
                raf.seek(lngRecordFound);
                raf.write(byts.getInternalByteArray(), 0, 262);
                string2 = String.valueOf(intAccess);
                Object var7_18 = null;
            }
            catch (Throwable e) {
                this.logContext.write("? Error in help_increment(" + strURL + "):" + e.toString());
                Object var7_19 = null;
                Helper.close(raf);
                return "";
            }
        }
        catch (Throwable throwable) {
            Object var7_20 = null;
            Helper.close(raf);
            throw throwable;
        }
        Helper.close(raf);
        return string2;
    }

    private final String help_sizefmt(long lngValue) {
        String strFmt = (String)this.hshENV.get("sizefmt");
        if (strFmt.equalsIgnoreCase("bytes")) {
            return String.valueOf(lngValue);
        }
        if (strFmt.equalsIgnoreCase("abbrev")) {
            return HelperFormat.formatMemoryString((long)lngValue);
        }
        throw new RuntimeException("help_sizefmt: " + strFmt + " is an unknown format to me");
    }

    private final String help_timefmt(long lngTime) {
        String strFmt = (String)this.hshENV.get("timefmt");
        StringBuffer strbJFmt = new StringBuffer(25);
        int i = 0;
        while (i < strFmt.length()) {
            char ch = strFmt.charAt(i);
            if (ch != '%') {
                strbJFmt.append(ch);
            } else if (i == strFmt.length() - 1) {
                strbJFmt.append(ch);
            } else {
                ch = strFmt.charAt(++i);
                switch (ch) {
                    case 'a': {
                        strbJFmt.append("EEE");
                        break;
                    }
                    case 'A': {
                        strbJFmt.append("EEEE");
                        break;
                    }
                    case 'b': {
                        strbJFmt.append("MMM");
                        break;
                    }
                    case 'B': {
                        strbJFmt.append("MMMM");
                        break;
                    }
                    case 'd': {
                        strbJFmt.append("dd");
                        break;
                    }
                    case 'e': {
                        strbJFmt.append("d");
                        break;
                    }
                    case 'H': {
                        strbJFmt.append("HH");
                        break;
                    }
                    case 'I': {
                        strbJFmt.append("hh");
                        break;
                    }
                    case 'm': {
                        strbJFmt.append("MM");
                        break;
                    }
                    case 'M': {
                        strbJFmt.append("mm");
                        break;
                    }
                    case 'p': {
                        strbJFmt.append("aa");
                        break;
                    }
                    case 'S': {
                        strbJFmt.append("ss");
                        break;
                    }
                    case 'w': {
                        strbJFmt.append("EE");
                        break;
                    }
                    case 'y': {
                        strbJFmt.append("yy");
                        break;
                    }
                    case 'Y': {
                        strbJFmt.append("yyyy");
                        break;
                    }
                    case 'Z': {
                        strbJFmt.append("zzz");
                    }
                }
            }
            ++i;
        }
        Locale locLocale = Locale.getDefault();
        String strLocale = (String)this.hshENV.get("locale");
        if (strLocale != null && strLocale.length() == 5) {
            locLocale = new Locale(strLocale.substring(0, 2), strLocale.substring(3, 5));
        }
        SimpleDateFormat sfmt = new SimpleDateFormat(strbJFmt.toString(), locLocale);
        String strResult = String.valueOf(strFmt) + " unknown Date/Time Format";
        try {
            strResult = sfmt.format(new Date(lngTime));
        }
        catch (Throwable throwable) {}
        return strResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void process0(String strRessource, ByteString bytstrIn, ByteString bytstrOut) {
        InputStream is;
        block10: {
            block9: {
                is = null;
                try {
                    try {
                        if (Configuration.mode_nofile()) {
                            is = this.getClass().getResourceAsStream(HelperPath.buildRessourcePath((String)strRessource));
                            if (is == null) {
                                this.logContext.write("? Ressource not found: " + strRessource);
                                Object var5_5 = null;
                                break block9;
                            }
                        } else {
                            is = new FileInputStream(strRessource);
                        }
                        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
                        int i = 0;
                        while ((i = is.read(buffer)) != -1) {
                            bytstrIn.append(buffer, 0, i);
                        }
                        break block10;
                    }
                    catch (IOException iOException) {
                        break block10;
                    }
                    catch (Throwable e) {
                        this.logContext.write(e);
                        Object var5_6 = null;
                        Helper.close(is);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    Helper.close(is);
                    throw throwable;
                }
            }
            Helper.close(is);
            return;
        }
        Object var5_8 = null;
        Helper.close(is);
        this.process1(bytstrIn, bytstrOut);
    }

    private final void process1(ByteString bytstrIn, ByteString bytstrOut) {
        if (this.intSSIRecursion > 5) {
            return;
        }
        ++this.intSSIRecursion;
        int pp1 = 0;
        int pp2 = 0;
        int idx = 0;
        while (pp1 < bytstrIn.getLength()) {
            idx = pp1;
            if ((pp1 = bytstrIn.getIndexOf(SSI_START, pp1)) == -1) {
                bytstrOut.append(bytstrIn.getSubstring(idx).toString());
                break;
            }
            pp2 = bytstrIn.getIndexOf(SSI_STOP, pp1);
            if (pp2 == -1) break;
            bytstrOut.append(bytstrIn.getSubstring(idx, pp1).toString());
            String strSSI = bytstrIn.getSubstring(pp1 + SSI_START.length(), pp2).toString().trim();
            if (strSSI.startsWith("#")) {
                this.process2(strSSI, bytstrOut);
            } else {
                bytstrOut.append(SSI_START + strSSI + SSI_STOP);
            }
            pp1 = pp2 + SSI_STOP.length();
        }
        --this.intSSIRecursion;
    }

    private final void process2(String string, ByteString bytstrOut) {
        String strSSI;
        String strSSIElement = null;
        int pp1 = string.indexOf(" ");
        if (pp1 != -1) {
            strSSIElement = string.substring(0, pp1).trim().toLowerCase();
            strSSI = string.substring(pp1).trim();
        } else {
            strSSIElement = strSSI.toLowerCase();
        }
        strSSI = String.valueOf(strSSI) + " ";
        Vector<KeyData> vecValues = new Vector<KeyData>();
        StringBuffer strbAttrib = new StringBuffer();
        StringBuffer strbValue = new StringBuffer();
        boolean blnInAttrib = true;
        boolean blnInQuote = false;
        boolean blnEscaped = false;
        int i = 0;
        while (i < strSSI.length()) {
            char ch = strSSI.charAt(i);
            if (blnInAttrib) {
                if (ch == '=') {
                    blnInAttrib = false;
                } else {
                    strbAttrib.append(ch);
                }
            } else if (ch == '\\') {
                blnEscaped = true;
            } else if (ch == '\"' && !blnEscaped) {
                blnInQuote = !blnInQuote;
            } else if (ch == ' ' && !blnInQuote && !blnEscaped) {
                blnInAttrib = true;
                KeyData kd = new KeyData((Object)strbAttrib.toString().toLowerCase(), (Object)strbValue.toString());
                vecValues.addElement(kd);
                strbAttrib.setLength(0);
                strbValue.setLength(0);
            } else {
                blnEscaped = false;
                strbValue.append(ch);
            }
            ++i;
        }
        try {
            this.process3(strSSIElement, bytstrOut, vecValues);
        }
        catch (Throwable t) {
            this.ssi_error(bytstrOut);
            this.logContext.write("? Error executing " + strSSIElement + ": " + t.toString());
        }
    }

    private final void process3(String string, ByteString bytstrOut, Vector vecValues) {
        String strElement = string.toLowerCase();
        if (strElement.equals("#error")) {
            this.ssi_error(bytstrOut);
            return;
        }
        if (strElement.equals("#config")) {
            this.ssi_config(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#echo")) {
            this.ssi_echo(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#fsize")) {
            this.ssi_fsize(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#flastmod")) {
            this.ssi_flastmod(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#fhash")) {
            this.ssi_fhash(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#include")) {
            this.ssi_include(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#set")) {
            this.ssi_set(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#exec")) {
            this.ssi_exec(bytstrOut, vecValues);
            return;
        }
        if (strElement.equals("#statistics")) {
            this.ssi_statistics(bytstrOut, vecValues);
            return;
        }
        throw new RuntimeException("Unknown SSI command");
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.isEnabled(imd, true)) {
            return false;
        }
        String[] strPATTERN = imd.iniVHOST.getPropertyStringAsArray(this.MOD_NAME, "ssi_pattern", new String[]{".shtml"});
        int intPP = -1;
        String strFile = imd.strFileToServe;
        intPP = strFile.lastIndexOf(File.separator);
        if (intPP != -1) {
            strFile = strFile.substring(intPP + 1);
        }
        intPP = -1;
        int i = 0;
        while (i < strPATTERN.length) {
            String cfr_ignored_0 = strPATTERN[i];
            intPP = strFile.indexOf(strPATTERN[i]);
            if (intPP != -1) break;
            ++i;
        }
        if (intPP == -1) {
            return false;
        }
        this.blnIsRequestForUs = true;
        imd.strCgiScript = httpREQ.strURL;
        int pp = imd.strCgiScript.indexOf("/", intPP);
        if (pp != -1) {
            imd.strCgiExtraPath = imd.strCgiScript.substring(pp);
            imd.strCgiScript = imd.strCgiScript.substring(0, pp);
        }
        return true;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.blnIsRequestForUs) {
            return false;
        }
        if (httpRES.strContentType.length() == 0) {
            httpRES.strContentType = Helper.getMimeType(imd.iniVHOST, imd.strFileToServe);
        }
        this.hshENV = this.createEnvironment(httpREQ, imd, httpRES);
        this.hshENV.put("errmsg", imd.iniVHOST.getPropertyString(this.MOD_NAME, "errmsg", "an error occurred while processing this directive"));
        this.hshENV.put("sizefmt", imd.iniVHOST.getPropertyString(this.MOD_NAME, "sizefmt", "bytes"));
        this.hshENV.put("locale", imd.iniVHOST.getPropertyString(this.MOD_NAME, "locale", String.valueOf(Locale.getDefault().getLanguage()) + "_" + Locale.getDefault().getCountry()));
        this.hshENV.put("timefmt", imd.iniVHOST.getPropertyString(this.MOD_NAME, "errmsg", "%d.%m.%Y, %H:%M"));
        long lngTime = TimeFactory.getTime();
        Properties prp = System.getProperties();
        Enumeration e = ((Hashtable)prp).keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            this.hshENV.put("JAVAPROPERTY." + strKey.toUpperCase(), ((Hashtable)prp).get(strKey));
        }
        this.hshENV.put("DOCUMENT_URI", this.hshENV.get("REQUEST_URI"));
        this.hshENV.put("DOCUMENT_NAME", this.hshENV.get("SCRIPT_NAME"));
        this.hshENV.put("LAST_MODIFIED", this.help_timefmt(new File(imd.strFileToServe).lastModified()));
        this.hshENV.put("DATE_LOCAL", this.help_timefmt(lngTime));
        String s = (String)this.hshENV.get("timefmt");
        this.hshENV.put("timefmt", "%y");
        this.hshENV.put("DATE_LOCAL_YY", this.help_timefmt(lngTime));
        this.hshENV.put("timefmt", "%Y");
        this.hshENV.put("DATE_LOCAL_YYYY", this.help_timefmt(lngTime));
        this.hshENV.put("timefmt", s);
        this.imdCGI = (IntermediateModuleData)imd.clone();
        this.reqCGI = (Http_Request)httpREQ.clone();
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        this.resCGI = httpRES;
        ByteString bytstrIn = new ByteString(4096);
        ByteString bytstrOut = new ByteString(6000);
        this.process0(imd.strFileToServe, bytstrIn, bytstrOut);
        httpRES.lngContentLength = bytstrOut.getLength();
        this.writeResponseHeader(httpREQ, imd, httpRES);
        try {
            httpRES.osResponse.write(bytstrOut.getInternalByteArray(), 0, bytstrOut.getLength());
            httpRES.osResponse.flush();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private final void ssi_config(ByteString bytstr, Vector vecValues) {
        int i = 0;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            this.hshENV.put(kd.objKey, kd.objData);
            ++i;
        }
    }

    private final void ssi_echo(ByteString bytstr, Vector vecValues) {
        int i = 0;
        while (i < vecValues.size()) {
            Object[] s;
            KeyData kd = (KeyData)vecValues.elementAt(i);
            if (kd.objKey.equals("var")) {
                s = (Object[])this.hshENV.get(kd.objData);
                if (s == null) {
                    s = "";
                }
                bytstr.append((String)s);
                bytstr.append(" ");
            }
            if (kd.objKey.equals("dump") && kd.objData.equals("all")) {
                s = new String[this.hshENV.size()];
                int ii = 0;
                Enumeration e = this.hshENV.keys();
                while (e.hasMoreElements()) {
                    String strKey = (String)e.nextElement();
                    String strData = (String)this.hshENV.get(strKey);
                    s[ii++] = String.valueOf(strKey) + "=" + strData;
                }
                HelperSort.quick((Object[])s, (Comparator)new ComparatorString());
                int kk = 0;
                while (kk < s.length) {
                    bytstr.append(String.valueOf(s[kk]) + "\r\n");
                    ++kk;
                }
            }
            ++i;
        }
    }

    private final void ssi_error(ByteString bytstr) {
        bytstr.append("[" + (String)this.hshENV.get("errmsg") + "]");
    }

    private void ssi_exec(ByteString bytstr, Vector vecValues) {
        if (Configuration.mode_nofile()) {
            return;
        }
        if (vecValues.size() == 0) {
            return;
        }
        KeyData kd = (KeyData)vecValues.elementAt(0);
        String strMode = (String)kd.objKey;
        String strExec = (String)kd.objData;
        if (strMode.equalsIgnoreCase("cgi")) {
            this.ssi_exec_cmd(bytstr, vecValues, strExec);
            return;
        }
        if (strMode.equalsIgnoreCase("cmd")) {
            this.ssi_exec_cmd(bytstr, vecValues, strExec);
            return;
        }
        if (strMode.equalsIgnoreCase("srv")) {
            this.ssi_exec_srv(bytstr, vecValues, strExec);
            return;
        }
    }

    private void ssi_exec_cmd(ByteString bytstr, Vector vecValues, String strFile) {
        if (Configuration.mode_nofile()) {
            return;
        }
        String strURL = this.reqCGI.strURL;
        this.reqCGI.strURL = strFile;
        String strMOD_NAMEsav = this.MOD_NAME;
        this.MOD_NAME = "MOD_CGI";
        boolean blnResult = super.processREQ(this.reqCGI, this.imdCGI, null);
        this.MOD_NAME = strMOD_NAMEsav;
        this.reqCGI.strURL = strURL;
        if (!blnResult) {
            return;
        }
        Http_Response httpRES = new Http_Response();
        httpRES.osResponse = new ByteArrayOutputStream();
        blnResult = super.processRES(this.reqCGI, this.imdCGI, httpRES);
        if (!blnResult) {
            return;
        }
        ByteArrayOutputStream baos = (ByteArrayOutputStream)httpRES.osResponse;
        bytstr.append(baos.toByteArray());
    }

    private void ssi_exec_srv(ByteString bytstr, Vector vecValues, String strClass) {
        Hashtable<String, String> hshIniParams = new Hashtable<String, String>();
        int i = 1;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            String strAttrib = (String)kd.objKey;
            String strValue = (String)kd.objData;
            hshIniParams.put(strAttrib, strValue);
            ++i;
        }
        this.imdCGI.iniVHOST.getServletContext()._execSSI(strClass, hshIniParams, this.reqCGI, this.imdCGI, this.resCGI, bytstr);
    }

    private void ssi_fhash(ByteString bytstr, Vector vecValues) {
        if (vecValues.size() < 2) {
            return;
        }
        KeyData kd = (KeyData)vecValues.elementAt(0);
        String strMode = (String)kd.objKey;
        String strFile = (String)kd.objData;
        if (!strMode.equalsIgnoreCase("virtual")) {
            return;
        }
        kd = (KeyData)vecValues.elementAt(1);
        String strMarker = (String)kd.objKey;
        String strAlgorithm = (String)kd.objData;
        if (!strMarker.equalsIgnoreCase("algorithm")) {
            return;
        }
        strAlgorithm = strAlgorithm.toUpperCase();
        PrecomputedFileContentCache pcc = new PrecomputedFileContentCache(this.logContext, this.cnfConfig.intStreamBufferSize, this.cnfConfig.blnDebug);
        File flLocal = new File(this.help_filepath(strMode, strFile));
        File flCache = pcc.getCacheFile_URL(String.valueOf(this.imdCGI.strTEMPFILES) + File.separator + "hashes", String.valueOf(strFile) + "." + strAlgorithm);
        InputStream in = pcc.getContent(flLocal, flCache, (PrecomputedFileContentProducer)new HashedFileContentProducer(strAlgorithm));
        byte[] digest = new byte[128];
        int i = -1;
        try {
            i = in.read(digest);
            bytstr.append(HelperFormat.hexDigit((byte[])digest, (int)0, (int)i));
        }
        catch (IOException iOException) {}
    }

    private void ssi_flastmod(ByteString bytstr, Vector vecValues) {
        int i = 0;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            String strMode = (String)kd.objKey;
            String strFile = (String)kd.objData;
            strFile = this.help_filepath(strMode, strFile);
            File fl = new File(strFile);
            bytstr.append(this.help_timefmt(fl.lastModified()));
            bytstr.append(" ");
            ++i;
        }
    }

    private void ssi_fsize(ByteString bytstr, Vector vecValues) {
        int i = 0;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            String strMode = (String)kd.objKey;
            String strFile = (String)kd.objData;
            strFile = this.help_filepath(strMode, strFile);
            File fl = new File(strFile);
            bytstr.append(this.help_sizefmt(fl.length()));
            bytstr.append(" ");
            ++i;
        }
    }

    private void ssi_include(ByteString bytstr, Vector vecValues) {
        int i = 0;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            String strMode = (String)kd.objKey;
            String strFile = (String)kd.objData;
            ByteString bytstrIn = new ByteString(4096);
            this.process0(this.help_filepath(strMode, strFile), bytstrIn, bytstr);
            ++i;
        }
    }

    private final void ssi_set(ByteString bytstr, Vector vecValues) {
        String strVar = "";
        int i = 0;
        while (i < vecValues.size()) {
            KeyData kd = (KeyData)vecValues.elementAt(i);
            if (kd.objKey.equals("var")) {
                strVar = (String)kd.objData;
            }
            if (kd.objKey.equals("value")) {
                this.hshENV.put(strVar, kd.objData);
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void ssi_statistics(ByteString bytstr, Vector vecValues) {
        i = 0;
        while (i < vecValues.size()) {
            kd = (KeyData)vecValues.elementAt(i);
            if (!kd.objKey.equals("server")) ** GOTO lbl-1000
            if (kd.objData.equals("uptime")) {
                bytstr.append(HelperDT.getRuntimeDHMS((long)(TimeFactory.getTime() - GlobalStatistics_Record.lngServerStarted)));
            } else if (kd.objData.equals("served")) {
                bytstr.append(String.valueOf(Httpd_Container.getConnectionsServed()));
            } else if (kd.objData.equals("vhost_list")) {
                s = this.imdCGI.strVHOSTS;
                k = 0;
                while (k < s.length) {
                    bytstr.append(s[k]);
                    bytstr.append("\r\n");
                    ++k;
                }
            } else if (kd.objData.equals("vhost_count")) {
                bytstr.append(String.valueOf(this.imdCGI.strVHOSTS.length));
            } else if (kd.objKey.equals("page") && kd.objData.equals("requested")) {
                bytstr.append(this.help_increment(this.reqCGI.strURL));
            }
            ++i;
        }
    }
}

