/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";

    protected void doDelete(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = httpservletrequest.getProtocol();
        String s1 = "Http method DELETE is not supported by this URL";
        if (s.endsWith("1.1")) {
            httpservletresponse.sendError(405, s1);
        } else {
            httpservletresponse.sendError(400, s1);
        }
    }

    protected void doGet(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = httpservletrequest.getProtocol();
        String s1 = "HTTP method GET is not supported by this URL";
        if (s.endsWith("1.1")) {
            httpservletresponse.sendError(405, s1);
        } else {
            httpservletresponse.sendError(400, s1);
        }
    }

    protected void doHead(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        NoBodyResponse nobodyresponse = new NoBodyResponse(httpservletresponse);
        this.doGet(httpservletrequest, nobodyresponse);
        nobodyresponse.setContentLength();
    }

    protected void doOptions(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        Method[] amethod = this.getAllDeclaredMethods(this.getClass());
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        boolean flag5 = true;
        boolean flag6 = true;
        int i = 0;
        while (i < amethod.length) {
            Method method = amethod[i];
            if (method.getName().equals("doGet")) {
                flag = true;
                flag1 = true;
            }
            if (method.getName().equals("doPost")) {
                flag2 = true;
            }
            if (method.getName().equals("doPut")) {
                flag3 = true;
            }
            if (method.getName().equals("doDelete")) {
                flag4 = true;
            }
            ++i;
        }
        String s = null;
        if (flag && s == null) {
            s = METHOD_GET;
        }
        if (flag1) {
            s = s == null ? METHOD_HEAD : String.valueOf(s) + ", HEAD";
        }
        if (flag2) {
            s = s == null ? METHOD_POST : String.valueOf(s) + ", POST";
        }
        if (flag3) {
            s = s == null ? METHOD_PUT : String.valueOf(s) + ", PUT";
        }
        if (flag4) {
            s = s == null ? METHOD_DELETE : String.valueOf(s) + ", DELETE";
        }
        if (flag5) {
            s = s == null ? METHOD_TRACE : String.valueOf(s) + ", TRACE";
        }
        if (flag6) {
            s = s == null ? METHOD_OPTIONS : String.valueOf(s) + ", OPTIONS";
        }
        httpservletresponse.setHeader("Allow", s);
    }

    protected void doPost(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = httpservletrequest.getProtocol();
        String s1 = "HTTP method POST is not supported by this URL";
        if (s.endsWith("1.1")) {
            httpservletresponse.sendError(405, s1);
        } else {
            httpservletresponse.sendError(400, s1);
        }
    }

    protected void doPut(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = httpservletrequest.getProtocol();
        String s1 = "HTTP method PUT is not supported by this URL";
        if (s.endsWith("1.1")) {
            httpservletresponse.sendError(405, s1);
        } else {
            httpservletresponse.sendError(400, s1);
        }
    }

    protected void doTrace(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = "\r\n";
        String s1 = "TRACE " + httpservletrequest.getRequestURI() + " " + httpservletrequest.getProtocol();
        Enumeration enumeration = httpservletrequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String s2 = (String)enumeration.nextElement();
            s1 = String.valueOf(s1) + s + s2 + ": " + httpservletrequest.getHeader(s2);
        }
        s1 = String.valueOf(s1) + s;
        int i = s1.length();
        httpservletresponse.setContentType("message/http");
        httpservletresponse.setContentLength(i);
        ServletOutputStream servletoutputstream = httpservletresponse.getOutputStream();
        servletoutputstream.print(s1);
        servletoutputstream.close();
    }

    private Method[] getAllDeclaredMethods(Class class1) {
        if (class1.getName().equals("javax.servlet.http.HttpServlet")) {
            return null;
        }
        int i = 0;
        Method[] amethod = this.getAllDeclaredMethods(class1.getSuperclass());
        Method[] amethod1 = class1.getDeclaredMethods();
        if (amethod != null) {
            Method[] amethod2 = new Method[amethod.length + amethod1.length];
            int j = 0;
            while (j < amethod.length) {
                amethod2[j] = amethod[j];
                i = j++;
            }
            int k = ++i;
            while (k < amethod1.length + i) {
                amethod2[k] = amethod1[k - i];
                ++k;
            }
            return amethod2;
        }
        return amethod1;
    }

    protected long getLastModified(HttpServletRequest httpservletrequest) {
        return -1L;
    }

    private void maybeSetLastModified(HttpServletResponse httpservletresponse, long l) {
        if (httpservletresponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpservletresponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    protected void service(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        String s = httpservletrequest.getMethod();
        if (s.equals(METHOD_GET)) {
            long l = this.getLastModified(httpservletrequest);
            if (l == -1L) {
                this.doGet(httpservletrequest, httpservletresponse);
            } else {
                long l2 = httpservletrequest.getDateHeader(HEADER_IFMODSINCE);
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpservletresponse, l);
                    this.doGet(httpservletrequest, httpservletresponse);
                } else {
                    httpservletresponse.setStatus(304);
                }
            }
        } else if (s.equals(METHOD_HEAD)) {
            long l1 = this.getLastModified(httpservletrequest);
            this.maybeSetLastModified(httpservletresponse, l1);
            this.doHead(httpservletrequest, httpservletresponse);
        } else if (s.equals(METHOD_POST)) {
            this.doPost(httpservletrequest, httpservletresponse);
        } else if (s.equals(METHOD_PUT)) {
            this.doPut(httpservletrequest, httpservletresponse);
        } else if (s.equals(METHOD_DELETE)) {
            this.doDelete(httpservletrequest, httpservletresponse);
        } else if (s.equals(METHOD_OPTIONS)) {
            this.doOptions(httpservletrequest, httpservletresponse);
        } else if (s.equals(METHOD_TRACE)) {
            this.doTrace(httpservletrequest, httpservletresponse);
        } else {
            String s1 = "Method " + s + " is not defined in RFC 2068 and is not supported by the Servlet API";
            httpservletresponse.sendError(501, s1);
        }
    }

    public void service(ServletRequest servletrequest, ServletResponse servletresponse) throws ServletException, IOException {
        HttpServletResponse httpservletresponse;
        HttpServletRequest httpservletrequest;
        try {
            httpservletrequest = (HttpServletRequest)servletrequest;
            httpservletresponse = (HttpServletResponse)servletresponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("non-HTTP request or response");
        }
        this.service(httpservletrequest, httpservletresponse);
    }
}

