/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

public class Cookie
implements Cloneable {
    private String name;
    private String value;
    private String comment;
    private String domain;
    private int maxAge = -1;
    private String path;
    private boolean secure;
    private int version = 0;
    private static final String tspecials = ",;";

    public Cookie(String s, String s1) {
        if (!this.isToken(s) || s.equalsIgnoreCase("Comment") || s.equalsIgnoreCase("Discard") || s.equalsIgnoreCase("Domain") || s.equalsIgnoreCase("Expires") || s.equalsIgnoreCase("Max-Age") || s.equalsIgnoreCase("Path") || s.equalsIgnoreCase("Secure") || s.equalsIgnoreCase("Version")) {
            String s2 = "Cookie name " + s + " is a reserved token";
            throw new IllegalArgumentException(s2);
        }
        this.name = s;
        this.value = s1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            throw new RuntimeException(clonenotsupportedexception.getMessage());
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    private boolean isToken(String s) {
        int i = s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public void setDomain(String s) {
        this.domain = s.toLowerCase();
    }

    public void setMaxAge(int i) {
        this.maxAge = i;
    }

    public void setPath(String s) {
        this.path = s;
    }

    public void setSecure(boolean flag) {
        this.secure = flag;
    }

    public void setValue(String s) {
        this.value = s;
    }

    public void setVersion(int i) {
        this.version = i;
    }
}

