/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.FieldTypes;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatabaseDefinition
implements FieldTypes {
    private Vector vecFields = new Vector(10, 1);
    private Hashtable hshFields = new Hashtable(50);
    private boolean blnHasKeyField = false;
    private int intBytesAllocated = 0;
    private File flDatabase = null;
    private int intPageSize;
    private String strCharset = null;

    public DatabaseDefinition(File flDatabase, int intPageSize) {
        this(flDatabase, intPageSize, "iso-8859-1");
    }

    public DatabaseDefinition(File flDatabase, int intPageSize, String string) {
        if (intPageSize < 65) {
            throw new RuntimeException("Minumum pagesize is 64 bytes");
        }
        this.init();
        this.flDatabase = flDatabase;
        this.intPageSize = intPageSize;
        this.strCharset = string;
        try {
            "".getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String strCharset = "iso-8859-1";
        }
    }

    private void addColumn(byte bytType, String string, int intLength) {
        String strName = string.toUpperCase();
        if (this.hshFields.containsKey(strName)) {
            throw new RuntimeException("Duplicate column name: " + strName);
        }
        Field fld = new Field();
        fld.bytType = bytType;
        fld.strName = strName;
        fld.intLength = intLength;
        fld.intPosStart = this.intBytesAllocated;
        this.intBytesAllocated += intLength;
        fld.intPosEnd = this.intBytesAllocated;
        this.vecFields.addElement(fld);
        this.hshFields.put(strName, new Integer(this.vecFields.size() - 1));
    }

    protected void addColumnBlob(String strColumnName) {
        this.addColumn((byte)1, strColumnName, 20);
    }

    protected void addColumnByte(String strColumnName) {
        this.addColumn((byte)6, strColumnName, 20);
    }

    protected void addColumnChar(String strColumnName) {
        this.addColumn((byte)5, strColumnName, 2);
    }

    protected void addColumnDate(String strColumnName) {
        this.addColumn((byte)7, strColumnName, 8);
    }

    protected void addColumnDouble(String strColumnName) {
        this.addColumn((byte)8, strColumnName, 8);
    }

    protected void addColumnFloat(String strColumnName) {
        this.addColumn((byte)9, strColumnName, 4);
    }

    protected void addColumnInt(String strColumnName) {
        this.addColumn((byte)4, strColumnName, 4);
    }

    protected void addColumnLong(String strColumnName) {
        this.addColumn((byte)3, strColumnName, 8);
    }

    protected void addColumnString(String strColumnName, int intLength) {
        this.addColumn((byte)2, strColumnName, intLength);
    }

    public void defineKeyColumn(int val) {
        this.defineKeyColumn(this.getFieldByIdx(val));
    }

    private void defineKeyColumn(Field fld) {
        fld.blnKeyField = true;
        this.blnHasKeyField = true;
    }

    public void defineKeyColumn(String val) {
        this.defineKeyColumn(this.getFieldByName(val));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatabaseDefinition)) {
            return false;
        }
        DatabaseDefinition that = (DatabaseDefinition)obj;
        if (this.vecFields.size() != that.vecFields.size()) {
            return false;
        }
        int i = 0;
        while (i < this.vecFields.size()) {
            Field fldThis = (Field)this.vecFields.elementAt(i);
            Field fldThat = (Field)that.vecFields.elementAt(i);
            if (fldThis.blnKeyField && fldThis.bytType != fldThat.bytType) {
                return false;
            }
            ++i;
        }
        return true;
    }

    Enumeration fieldEnumerator() {
        return this.vecFields.elements();
    }

    File getBlobFile(String strUID) {
        String strDBPath = HelperPath.splitPath_getPath(this.flDatabase.getPath());
        String strFile = this.getBlobFileName(strUID);
        if (strFile == null) {
            return null;
        }
        return new File(strDBPath, this.getBlobFileName(strUID));
    }

    String getBlobFileName(String strUID) {
        if (strUID.length() == 0) {
            return null;
        }
        return String.valueOf(strUID) + ".blob";
    }

    String getBlobUID() {
        return TimeFactory.createUID();
    }

    String getCharset() {
        return this.strCharset;
    }

    File getDatabaseFile() {
        return this.flDatabase;
    }

    Field getFieldByIdx(int idx) {
        if (idx < 1 || idx > this.vecFields.size()) {
            throw new RuntimeException("Fieldindex out of range: '" + idx + "'");
        }
        return (Field)this.vecFields.elementAt(idx - 1);
    }

    Field getFieldByName(String strName) {
        Integer i = (Integer)this.hshFields.get(strName.toUpperCase());
        if (i == null) {
            throw new RuntimeException("Unknown Field: '" + strName + "'");
        }
        return (Field)this.vecFields.elementAt(i);
    }

    int getPagesize() {
        return this.intPageSize;
    }

    public void init() {
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < this.vecFields.size()) {
            Field fld = (Field)this.vecFields.elementAt(i);
            strb.append("Name: ");
            strb.append(fld.strName);
            strb.append(", Type: ");
            strb.append(Field.type2string(fld.bytType));
            strb.append("; ");
            ++i;
        }
        return strb.toString();
    }
}

