/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TeeInputStream
extends InputStream {
    InputStream in = null;
    FileOutputStream fos = null;

    public TeeInputStream(InputStream in, String strFile) {
        this.in = in;
        try {
            this.fos = new FileOutputStream(strFile);
        }
        catch (IOException e) {
            System.out.println("Cannot create tee-file " + strFile + ": " + e.toString());
        }
    }

    public void close() throws IOException {
        this.in.close();
        if (this.fos != null) {
            this.fos.close();
        }
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (i != -1 && this.fos != null) {
            this.fos.write(i);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        int i = this.in.read(b);
        if (i != -1 && this.fos != null) {
            this.fos.write(b, 0, i);
        }
        return i;
    }

    public int read(byte[] b, int o1, int o2) throws IOException {
        int i = this.in.read(b, o1, o2);
        if (i != -1 && this.fos != null) {
            this.fos.write(b, 0, i);
        }
        return i;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }
}

