/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Statistics;
import net.zerotoaster.httpd.util.Statistics_byHOST;
import net.zerotoaster.httpd.util.Statistics_byURL;

public class Statistics_Record
extends Statistics {
    private Hashtable hshResponses = new Hashtable();
    private Hashtable hshHosts = new Hashtable();
    private String[] strHosts = null;
    private int intVersion = 100;

    public void addResponse(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(TimeFactory.getTime()));
        int intHour = cal.get(11);
        ++this.lngTotalRequestCount;
        this.lngTotalRequestTime += httpRES.lngRequestFinished - httpREQ.lngRequestStarted;
        if (this.strHosts == null) {
            this.strHosts = imd.iniVHOST.getPropertiesString("VHOST", "server_name");
        }
        Hashtable hashtable = this.hshHosts;
        synchronized (hashtable) {
            Statistics_byHOST statHOST = (Statistics_byHOST)this.hshHosts.get(httpREQ.strVHost);
            if (statHOST == null) {
                statHOST = new Statistics_byHOST();
                statHOST.strHost = httpREQ.strVHost;
                this.hshHosts.put(httpREQ.strVHost, statHOST);
            }
            ++statHOST.intAccess;
            if (httpRES.lngTransferredBytes > 0L) {
                statHOST.lngBytes += httpRES.lngTransferredBytes;
            }
        }
        int n = intHour;
        this.intHourRequest[n] = this.intHourRequest[n] + 1;
        if (httpRES.lngTransferredBytes > 0L) {
            int n2 = intHour;
            this.lngHourBytes[n2] = this.lngHourBytes[n2] + httpRES.lngTransferredBytes;
        }
        hashtable = this.hshResponses;
        synchronized (hashtable) {
            String strKey = String.valueOf(httpREQ.strURL) + "\u0000x0" + String.valueOf(httpRES.intStatusCode);
            Statistics_byURL statURL = (Statistics_byURL)this.hshResponses.get(strKey);
            if (statURL == null) {
                statURL = new Statistics_byURL();
                statURL.strURL = httpREQ.strURL;
                statURL.intResponseCode = httpRES.intStatusCode;
                this.hshResponses.put(strKey, statURL);
            }
            ++statURL.intAccess;
            if (httpRES.lngTransferredBytes > 0L) {
                statURL.lngBytes += httpRES.lngTransferredBytes;
            }
        }
    }

    public void addResponse(Statistics_Record sr, boolean blnLastRun) {
        if (blnLastRun) {
            Vector v = new Vector();
            Enumeration e = this.hshHosts.keys();
            while (e.hasMoreElements()) {
                v.addElement(e.nextElement());
            }
            this.strHosts = new String[v.size()];
            v.copyInto(this.strHosts);
            this.lngTotalRequestCount = sr.lngTotalRequestCount;
            this.lngTotalRequestTime = sr.lngTotalRequestTime;
        }
        Enumeration e = sr.hshHosts.keys();
        while (e.hasMoreElements()) {
            String strVHost = (String)e.nextElement();
            Statistics_byHOST statHOSTLocal = (Statistics_byHOST)this.hshHosts.get(strVHost);
            Statistics_byHOST statHOSTAdd = (Statistics_byHOST)sr.hshHosts.get(strVHost);
            if (statHOSTLocal == null) {
                statHOSTLocal = new Statistics_byHOST();
                statHOSTLocal.strHost = strVHost;
                this.hshHosts.put(strVHost, statHOSTLocal);
            }
            statHOSTLocal.addResponse(statHOSTAdd);
        }
        int i = 0;
        while (i < this.intHourRequest.length) {
            int n = i;
            this.intHourRequest[n] = this.intHourRequest[n] + sr.intHourRequest[i];
            ++i;
        }
        i = 0;
        while (i < this.lngHourBytes.length) {
            int n = i;
            this.lngHourBytes[n] = this.lngHourBytes[n] + sr.lngHourBytes[i];
            ++i;
        }
        e = sr.hshResponses.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            Statistics_byURL statURLLocal = (Statistics_byURL)this.hshResponses.get(strKey);
            Statistics_byURL statURLAdd = (Statistics_byURL)sr.hshResponses.get(strKey);
            if (statURLLocal == null) {
                statURLLocal = new Statistics_byURL();
                statURLLocal.strURL = statURLAdd.strURL;
                statURLLocal.intResponseCode = statURLAdd.intResponseCode;
                this.hshResponses.put(strKey, statURLLocal);
            }
            statURLLocal.addResponse(statURLAdd);
        }
    }

    public void export_binary(PrintWriter pw) {
        Object stat;
        pw.println("cp101");
        pw.println(0);
        pw.println(this.hshResponses.size());
        Enumeration e = this.hshResponses.elements();
        while (e.hasMoreElements()) {
            stat = (Statistics_byURL)e.nextElement();
            pw.println(((Statistics_byURL)stat).toString());
        }
        pw.println(this.hshHosts.size());
        e = this.hshHosts.elements();
        while (e.hasMoreElements()) {
            stat = (Statistics_byHOST)e.nextElement();
            pw.println(((Statistics_byHOST)stat).toString());
        }
        int i = 0;
        while (i < this.intHourRequest.length) {
            pw.print(this.intHourRequest[i]);
            pw.print(",");
            ++i;
        }
        pw.println();
        i = 0;
        while (i < this.lngHourBytes.length) {
            pw.print(this.lngHourBytes[i]);
            pw.print(",");
            ++i;
        }
        pw.println();
        pw.println(this.lngTotalRequestTime);
        pw.println(this.lngTotalRequestCount);
        pw.flush();
    }

    public void export_text(PrintWriter pw) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        pw.print("VHosts covered: ");
        if (this.strHosts != null) {
            int i = 0;
            while (i < this.strHosts.length) {
                pw.print(this.strHosts[i]);
                pw.print(" ");
                ++i;
            }
        }
        pw.println();
        pw.println("Total number of requests served so far: " + nf.format(this.lngTotalRequestCount));
        if (this.lngTotalRequestCount > 0L) {
            pw.println("Average in request: " + this.lngTotalRequestTime / this.lngTotalRequestCount + "ms");
        }
        pw.println("VHost Accesses Bytes");
        pw.println("-----------------------------------------------------------------------------");
        Enumeration e = this.hshHosts.elements();
        while (e.hasMoreElements()) {
            Statistics_byHOST stat = (Statistics_byHOST)e.nextElement();
            pw.println(String.valueOf(stat.strHost) + " " + nf.format(stat.intAccess) + " " + nf.format(stat.lngBytes));
        }
        if (this.getDetailLevel() > 0) {
            pw.println("");
            pw.println("Hour / Acesses / Bytes");
            pw.println("----------------------");
            int i = 0;
            while (i < this.intHourRequest.length) {
                pw.print(HelperFormat.rset((long)i, (int)2, (char)'0'));
                pw.print(": ");
                pw.print(nf.format(this.intHourRequest[i]));
                pw.print(" / ");
                pw.print(nf.format(this.lngHourBytes[i]));
                pw.println();
                ++i;
            }
            pw.println("-----------------------------------------------------------------------------");
        }
        if (this.getDetailLevel() > 1) {
            long lngRequests = 0L;
            long lngBytes = 0L;
            pw.println("");
            pw.println("URL Response_Code Accesses Bytes");
            pw.println("-----------------------------------------------------------------------------");
            Enumeration e2 = this.hshResponses.elements();
            while (e2.hasMoreElements()) {
                Statistics_byURL stat = (Statistics_byURL)e2.nextElement();
                pw.println(String.valueOf(stat.strURL) + " " + stat.intResponseCode + " " + nf.format(stat.intAccess) + " " + nf.format(stat.lngBytes));
                lngRequests += (long)stat.intAccess;
                lngBytes += stat.lngBytes;
            }
            pw.println("-----------------------------------------------------------------------------");
            pw.println("Requests served  : " + nf.format(lngRequests));
            pw.println("Body Bytes served: " + HelperFormat.formatMemoryString((long)lngBytes));
        }
        pw.flush();
    }

    public int getVersion() {
        return this.intVersion;
    }

    public void import_binary(BufferedReader br) throws IOException {
        this.intVersion = Integer.parseInt(br.readLine().substring(2));
        br.readLine();
        this.hshResponses = new Hashtable();
        int intURL = Integer.parseInt(br.readLine());
        int i = 0;
        while (i < intURL) {
            Statistics_byURL stat = new Statistics_byURL(br.readLine());
            String strKey = String.valueOf(stat.strURL) + "\u0000x0" + String.valueOf(stat.intResponseCode);
            this.hshResponses.put(strKey, stat);
            ++i;
        }
        this.hshHosts = new Hashtable();
        int intHOST = Integer.parseInt(br.readLine());
        int i2 = 0;
        while (i2 < intHOST) {
            Statistics_byHOST stat = new Statistics_byHOST(br.readLine());
            this.hshHosts.put(stat.strHost, stat);
            ++i2;
        }
        StringTokenizer strtAccess = new StringTokenizer(br.readLine(), ",");
        int i3 = 0;
        while (i3 < this.intHourRequest.length) {
            this.intHourRequest[i3] = Integer.parseInt(strtAccess.nextToken());
            ++i3;
        }
        StringTokenizer strtBytes = new StringTokenizer(br.readLine(), ",");
        int i4 = 0;
        while (i4 < this.lngHourBytes.length) {
            this.lngHourBytes[i4] = Long.parseLong(strtBytes.nextToken());
            ++i4;
        }
        if (this.intVersion > 100) {
            this.lngTotalRequestTime = Long.parseLong(br.readLine());
            this.lngTotalRequestCount = Long.parseLong(br.readLine());
        }
    }

    public void reset() {
        this.hshResponses.clear();
        this.hshHosts.clear();
        this.intHourRequest = new int[this.intHourRequest.length];
        this.lngHourBytes = new long[this.lngHourBytes.length];
        this.intVersion = 100;
    }
}

