/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;

public abstract class Mod_Base
extends Application {
    protected static final String CRLF = "\r\n";
    protected Configuration cnfConfig = null;
    protected LogContext logContext = null;
    protected String MOD_NAME = "you forgot to call super(....)";
    protected boolean blnIsRequestForUs = false;

    public Mod_Base(Configuration cnfConfig, LogContext logContext) {
        this.cnfConfig = cnfConfig;
        this.logContext = logContext;
        String s = ((Object)((Object)this)).getClass().getName();
        int pp = s.lastIndexOf(".");
        this.MOD_NAME = pp != -1 ? s.substring(pp + 1).toUpperCase() : s.toUpperCase();
    }

    protected Hashtable createEnvironment(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("SERVER_SOFTWARE", "ZeroToaster::HTTPD 1.63");
        h.put("SERVER_NAME", imd.strLocalServerName);
        h.put("SERVER_IP", imd.strLocalServerAddress);
        h.put("SERVER_PORT", String.valueOf(imd.intLocalServerPort));
        h.put("SERVER_ROOT", new File("").getAbsolutePath());
        h.put("GATEWAY_INTERFACE", "CGI/1.1");
        h.put("SERVER_PROTOCOL", httpREQ.strProtocol);
        h.put("REQUEST_METHOD", httpREQ.strAction);
        h.put("REQUEST_URI", httpREQ.strURL);
        h.put("REQUEST_URL", httpREQ.getRequestURL(imd.intLocalServerPort));
        h.put("PATH_INFO", imd.strCgiExtraPath);
        if (imd.strCgiExtraPath.length() > 0) {
            h.put("PATH_TRANSLATED", HelperPath.pathFixup((String)(String.valueOf(imd.strHTDOCS) + File.separator + imd.strCgiExtraPath), (String)File.separator));
        }
        if (imd.strCgiScript.length() > 0) {
            h.put("SCRIPT_NAME", imd.strCgiScript);
            h.put("SCRIPT_FILENAME", HelperPath.pathFixup((String)(String.valueOf(imd.strHTDOCS) + File.separator + imd.strCgiScript), (String)File.separator));
        }
        h.put("DOCUMENT_ROOT", imd.strHTDOCS);
        if (httpREQ.strQuery.length() > 0) {
            h.put("QUERY_STRING", httpREQ.strQuery);
            h.put("QUERY_STRING_UNESCAPED", httpREQ.strQueryUnEscaped);
        }
        h.put("AUTH_TYPE", httpREQ.strAuthorization_Type);
        h.put("REMOTE_USER", httpREQ.strAuthorization_User);
        h.put("CONTENT_LENGTH", String.valueOf(httpREQ.lngContentLength));
        h.put("CONTENT_TYPE", httpREQ.strContentType);
        h.put("REMOTE_HOST", imd.strRemoteServerName);
        h.put("REMOTE_ADDR", imd.strRemoteServerAddress);
        h.put("HTTP_ACCEPT", httpREQ.qrtoString(httpREQ.qrAccept));
        h.put("HTTP_ACCEPT_LANGUAGE", httpREQ.qrtoString(httpREQ.qrAccept_Language));
        h.put("HTTP_ACCEPT_ENCODING", httpREQ.qrtoString(httpREQ.qrAccept_Encoding));
        h.put("HTTP_ACCEPT_CHARSET", httpREQ.qrtoString(httpREQ.qrAccept_Charset));
        h.put("HTTP_REFERER", httpREQ.strReferer);
        h.put("HTTP_COOKIE", httpREQ.strCookies);
        h.put("HTTP_USER_AGENT", httpREQ.strUserAgent);
        h.put("HTTP_HOST", httpREQ.strHost);
        h.put("HTTP_VHOST", httpREQ.strVHost);
        h.put("HTTP_VHOST_CONFIGDIR", HelperPath.removeTrailingSlashes((String)imd.strConfigDir));
        String[] strEnv = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "env_param", new String[0]);
        int i = 0;
        while (i < strEnv.length) {
            int pp = strEnv[i].indexOf(",");
            if (pp != -1) {
                h.put(strEnv[i].substring(0, pp).trim(), strEnv[i].substring(pp + 1).trim());
            }
            ++i;
        }
        String strInclude = imd.iniVHOST.getPropertyString(this.MOD_NAME, "env_include");
        if (strInclude.length() > 0) {
            Properties prp = new Properties();
            try {
                prp.load(new FileInputStream(HelperPath.pathFixup((String)(String.valueOf(imd.strConfigDir) + File.separator + strInclude), (String)File.separator)));
                Enumeration e = ((Hashtable)prp).keys();
                while (e.hasMoreElements()) {
                    String strKey = (String)e.nextElement();
                    h.put(strKey, prp.getProperty(strKey));
                }
            }
            catch (IOException iOException) {
                this.logContext.write("? Cannot read init_include " + strInclude);
            }
        }
        return h;
    }

    public void dispose() {
        this.blnDisposed = true;
    }

    protected boolean isEnabled(IntermediateModuleData imd, boolean blnDefault) {
        return imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "enabled", blnDefault);
    }

    public abstract boolean processREQ(Http_Request var1, IntermediateModuleData var2, Http_Response var3);

    public abstract boolean processRES(Http_Request var1, IntermediateModuleData var2, Http_Response var3);

    public void reset() {
        this.blnIsRequestForUs = false;
    }

    public String toString() {
        return this.MOD_NAME;
    }

    protected boolean writeResponseHeader(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        try {
            String[] strHeader = httpRES.getHeader();
            int i = 0;
            while (i < strHeader.length) {
                httpRES.osResponse.write(strHeader[i].getBytes());
                this.logContext.write("H O:" + strHeader[i]);
                ++i;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

