/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.VectorString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;

public class Mod_Auth
extends Mod_Base {
    public Mod_Auth(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.isEnabled(imd, true)) {
            return false;
        }
        String[] strAuth = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "auth", new String[0]);
        if (strAuth.length == 0) {
            return false;
        }
        String strIncludeFile = imd.iniVHOST.getPropertyString(this.MOD_NAME, "include", "");
        if (strIncludeFile.length() != 0) {
            File flInclude;
            if (!HelperPath.isAbsolutePath((String)strIncludeFile)) {
                strIncludeFile = HelperPath.pathFixup((String)(String.valueOf(imd.strConfigDir) + File.separator + strIncludeFile), (String)File.separator);
            }
            if (!(flInclude = new File(strIncludeFile)).exists()) {
                this.logContext.write("! Requested AUTH-Include " + strIncludeFile + " not found");
            } else {
                strAuth = this.readInclude(strAuth, flInclude);
            }
        }
        int i = 0;
        while (i < strAuth.length) {
            String strPass;
            String strUser;
            String strProtectURL;
            StringTokenizer strt = new StringTokenizer(strAuth[i], ",");
            if (strt.hasMoreTokens() && (strProtectURL = strt.nextToken().trim()).length() != 0 && httpREQ.strURL.toLowerCase().startsWith(strProtectURL.toLowerCase()) && strt.hasMoreTokens() && (strUser = strt.nextToken().trim()).length() != 0 && strt.hasMoreTokens() && (strPass = strt.nextToken().trim()).length() != 0) {
                if (httpREQ.strAuthorization_User.length() != 0 && httpREQ.strAuthorization_User.equals(strUser) && httpREQ.strAuthorization_Pass.equals(strPass)) {
                    return false;
                }
                httpRES.intStatusCode = 401;
                httpRES.strWWWAuthenticate_Method = "Basic";
                httpRES.strWWWAuthenticate_Space = httpREQ.strURL;
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    private String[] readInclude(String[] strAuth, File flInclude) {
        try {
            VectorString v = new VectorString(strAuth.length + 10, 5);
            int i = 0;
            while (i < strAuth.length) {
                v.addElement(strAuth[i]);
                ++i;
            }
            BufferedReader br = new BufferedReader(new FileReader(flInclude));
            String strBuffer = "";
            while ((strBuffer = br.readLine()) != null) {
                char ch;
                if ((strBuffer = strBuffer.trim()).length() == 0 || (ch = strBuffer.charAt(0)) == '!' || ch == '#' || ch == ';') continue;
                v.addElement(strBuffer);
            }
            br.close();
            String[] tmp = new String[v.size()];
            v.copyInto(tmp);
            return tmp;
        }
        catch (IOException e) {
            this.logContext.write("? Error reading AUTH include: " + e.toString());
            return strAuth;
        }
    }
}

