/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.main;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.io.ExtendedBufferedOutputStream;
import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.config.VHost_Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.mods.Mod_Dummy;
import net.zerotoaster.httpd.mods.Mod_Statistics;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.CLF_Logger;
import net.zerotoaster.httpd.util.Helper;

public class Httpd_Instance
extends Application
implements Runnable {
    private int intInstanceNb = 0;
    private Configuration cnfConfig = null;
    private LogContext logContext = null;
    private VHost_Configuration vhConfig = null;
    private Thread thrd = null;
    private boolean blnIsRunning = false;
    private LockObject loNotify = null;
    private LockObject loThreadRunning = null;
    private long lngTimeLastUsed = 0L;
    private boolean blnKeepAlive = false;
    private Socket sok = null;
    private Http_Request httpREQ = null;
    private Http_Response httpRES = null;
    private IntermediateModuleData imd = null;
    Vector vecModules = null;
    Hashtable hshModules = null;
    static Class class$de$zwanzigeins$util$LogContext;
    static Class class$net$zerotoaster$httpd$config$Configuration;

    public Httpd_Instance(Configuration cnfConfig, VHost_Configuration vhConfig, LogContext logContext, int intInstanceCounter) {
        this.cnfConfig = cnfConfig;
        this.vhConfig = vhConfig;
        this.logContext = logContext;
        this.intInstanceNb = intInstanceCounter;
        this.setThreadName("Httpd_Instance " + HelperFormat.buildID((int)(intInstanceCounter + 1), (int)cnfConfig.intHTTP_instances));
        this.init();
        this.resetThreadName();
    }

    private void closeStreams() {
        if (this.httpRES != null) {
            Helper.close(this.httpRES.osResponse);
        }
        if (this.httpREQ != null) {
            Helper.close(this.httpREQ.crlfisRequest);
        }
        Helper.close(this.sok);
        this.sok = null;
    }

    public void dispose() {
        this.blnIsRunning = false;
        this.blnDisposed = true;
        if (this.loThreadRunning != null) {
            this.loThreadRunning.dispose();
            this.loThreadRunning = null;
        }
        Helper.close(this.sok);
        this.loNotify.lo_notify();
        Enumeration e = this.hshModules.elements();
        while (e.hasMoreElements()) {
            Mod_Base mod = (Mod_Base)((Object)e.nextElement());
            try {
                mod.dispose();
            }
            catch (Throwable t) {
                this.logContext.write("? Error disposing module " + mod.toString(), t);
            }
        }
        this.loNotify.dispose();
    }

    private Mod_Base getModByName(String strName) {
        Mod_Base mb = (Mod_Base)((Object)this.hshModules.get(strName.toUpperCase()));
        if (mb == null) {
            this.logContext.write("? Cannot find module " + strName);
            mb = new Mod_Dummy(this.cnfConfig, this.logContext);
        }
        return mb;
    }

    private void init() {
        this.loNotify = new LockObject();
        this.loThreadRunning = new LockObject();
        this.vecModules = new Vector();
        this.hshModules = new Hashtable();
        int i = 0;
        while (i < this.cnfConfig.strModules.length) {
            try {
                Object[] objArgs = new Object[]{this.cnfConfig, this.logContext};
                Class[] classArray = new Class[2];
                Class<?> clazz = class$net$zerotoaster$httpd$config$Configuration;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("net.zerotoaster.httpd.config.Configuration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Class<?> clazz2 = class$de$zwanzigeins$util$LogContext;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("de.zwanzigeins.util.LogContext");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz2;
                Class[] clsArgs = classArray;
                Constructor<?> c = Class.forName(this.cnfConfig.strModules[i]).getConstructor(clsArgs);
                Mod_Base mb = (Mod_Base)((Object)c.newInstance(objArgs));
                this.vecModules.addElement(mb);
                this.hshModules.put(mb.toString(), mb);
            }
            catch (Throwable t) {
                this.logContext.write("? Error loading Module " + this.cnfConfig.strModules[i], t);
                throw new InstantiationError();
            }
            ++i;
        }
        this.thrd = new Thread((Runnable)this, this.getThreadName());
        this.thrd.setPriority(5);
        this.thrd.start();
        this.loThreadRunning.lo_wait();
    }

    public boolean isBusy() {
        return this.sok != null;
    }

    public boolean kickInstance(Socket sokIn) {
        if (this.sok != null) {
            return false;
        }
        this.sok = sokIn;
        this.loNotify.lo_notify();
        return true;
    }

    private boolean processREQ() throws Throwable {
        Mod_Base mod;
        try {
            if (!this.blnKeepAlive) {
                this.httpREQ.crlfisRequest = new CRLFInputStream((InputStream)new BufferedInputStream(this.sok.getInputStream(), this.cnfConfig.intStreamBufferSize));
            }
        }
        catch (IOException e) {
            this.logContext.write("? Error getting inputstream from socket", (Throwable)e);
            return false;
        }
        if (!this.httpREQ.loadHeader(this.logContext)) {
            this.httpRES.strConnection = "";
            this.logContext.write("D Keep-alive death");
            return false;
        }
        if (this.httpREQ.strConnection.equals("keep-alive") && this.cnfConfig.blnKeepAlive) {
            this.httpRES.strConnection = "keep-alive";
        }
        this.imd.iniVHOST = this.vhConfig.getIniManager(this.httpREQ.strVHost);
        this.imd.strVHOSTS = this.vhConfig.getAllHosts();
        this.imd.init();
        this.logContext.write("D Processing " + (this.blnKeepAlive ? "keep-alive " : "new connection ") + this.httpREQ.strAction + " " + this.httpREQ.strHost + this.httpREQ.strURL + " " + this.imd.strRemoteServerName);
        int i = 0;
        while (i < this.vecModules.size()) {
            mod = (Mod_Base)((Object)this.vecModules.elementAt(i));
            mod.reset();
            ++i;
        }
        i = 0;
        while (i < this.vecModules.size()) {
            mod = (Mod_Base)((Object)this.vecModules.elementAt(i));
            boolean blnDone = mod.processREQ(this.httpREQ, this.imd, this.httpRES);
            if (this.cnfConfig.blnDebug) {
                this.logContext.write("M REQ " + new Boolean(blnDone).toString() + ": " + mod.toString());
            }
            if (blnDone) break;
            ++i;
        }
        return true;
    }

    private boolean processRES() {
        try {
            if (!this.blnKeepAlive) {
                this.httpRES.osResponse = new ExtendedBufferedOutputStream(this.sok.getOutputStream(), this.cnfConfig.intStreamBufferSize);
            } else {
                ((ExtendedBufferedOutputStream)this.httpRES.osResponse).reset();
            }
        }
        catch (IOException e) {
            this.logContext.write("? Error getting outputstream from socket", (Throwable)e);
            return false;
        }
        if (this.httpREQ.strAction.equals("TEST")) {
            try {
                this.httpRES.osResponse.write("OK\r\n".getBytes());
            }
            catch (IOException iOException) {}
            return true;
        }
        boolean blnDone = false;
        int m = 0;
        while (m < this.vecModules.size()) {
            Mod_Base mod = (Mod_Base)((Object)this.vecModules.elementAt(m));
            blnDone = mod.processRES(this.httpREQ, this.imd, this.httpRES);
            if (this.cnfConfig.blnDebug) {
                this.logContext.write("M RES " + new Boolean(blnDone).toString() + ": " + mod.toString());
            }
            if (blnDone) {
                return true;
            }
            ++m;
        }
        this.httpRES.intStatusCode = 400;
        this.getModByName("MOD_ERROR_RESPONSE").processRES(this.httpREQ, this.imd, this.httpRES);
        return false;
    }

    public void run() {
        this.logContext.write("# started");
        this.blnIsRunning = true;
        this.httpREQ = new Http_Request();
        this.httpRES = new Http_Response();
        while (this.blnIsRunning) {
            block19: {
                block18: {
                    this.blnKeepAlive = false;
                    try {
                        if (this.imd == null || this.imd.iniVHOST == null || this.httpRES.osResponse == null) break block18;
                        this.httpRES.lngRequestFinished = TimeFactory.getTime();
                        CLF_Logger.write(this.httpREQ, this.imd, this.httpRES);
                        Mod_Statistics ms = (Mod_Statistics)((Object)this.hshModules.get("MOD_STATISTICS"));
                        if (ms != null) {
                            ms.statAdd(this.httpREQ, this.imd, this.httpRES);
                        }
                        this.blnKeepAlive = this.cnfConfig.blnKeepAlive;
                        this.blnKeepAlive &= this.httpREQ.strConnection.equalsIgnoreCase("keep-alive");
                        this.blnKeepAlive &= this.httpRES.strConnection.equalsIgnoreCase("keep-alive");
                        try {
                            this.httpRES.osResponse.flush();
                        }
                        catch (IOException e) {
                            this.logContext.write("D Flush: " + e.toString());
                            this.blnKeepAlive = false;
                        }
                        this.logContext.write("D Process time: " + (this.httpRES.lngRequestFinished - this.httpREQ.lngRequestStarted) + "ms " + (this.blnKeepAlive ? "(keep alive)" : "(close)"));
                    }
                    catch (Throwable t) {
                        this.logContext.write("? Died in location 1", t);
                    }
                }
                try {
                    this.imd = null;
                    if (this.blnKeepAlive) break block19;
                    this.closeStreams();
                    this.logContext.write("D Waiting for incoming connection");
                    this.sok = null;
                    this.loThreadRunning.lo_notify();
                    this.loNotify.lo_wait();
                    this.logContext.write("D Got connection");
                    if (!this.blnIsRunning) break;
                    if (this.sok == null) {
                        this.logContext.write("D Connection socked == null!");
                        continue;
                    }
                }
                catch (Throwable t) {
                    this.logContext.write("? Died in location 2 - must abort", t);
                    break;
                }
            }
            try {
                this.logContext.write("D init req/res");
                this.httpREQ.init();
                this.httpRES.init();
                this.lngTimeLastUsed = TimeFactory.getTime();
                this.imd = new IntermediateModuleData();
                this.imd.sok = this.sok;
                if (!this.blnKeepAlive) {
                    this.sok.setSoTimeout((int)this.cnfConfig.lngSocket_timeout);
                }
                this.imd.strLocalServerAddress = this.sok.getLocalAddress().getHostAddress();
                this.imd.strRemoteServerAddress = this.sok.getInetAddress().getHostAddress();
                if (this.cnfConfig.blnResolveNames) {
                    this.imd.strLocalServerName = this.sok.getLocalAddress().getHostName();
                    this.imd.strRemoteServerName = this.sok.getInetAddress().getHostName();
                } else {
                    this.imd.strLocalServerName = this.imd.strLocalServerAddress;
                    this.imd.strRemoteServerName = this.imd.strRemoteServerAddress;
                }
            }
            catch (SocketException socketException) {
                this.logContext.write("D Socket exception, init failed");
                continue;
            }
            catch (Throwable t) {
                this.logContext.write("? Died in location 3", t);
                continue;
            }
            try {
                this.logContext.write("D process request");
                if (!this.processREQ()) continue;
                this.processRES();
            }
            catch (SocketException e) {
                this.logContext.write("D Error during request: " + e.toString());
            }
            catch (Throwable t) {
                this.logContext.write("? Error processing request/response", t);
            }
        }
        this.logContext.write("# " + this.getThreadName() + " exit");
    }

    public long timeLastUsed() {
        return this.lngTimeLastUsed;
    }
}

