/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.config;

import de.zwanzigeins.util.Application;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.IniManager;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.StrTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.config.Constants;
import net.zerotoaster.httpd.servlet.ServletContext_Impl;
import net.zerotoaster.httpd.servlet.SessionManager;
import net.zerotoaster.httpd.util.Helper;
import net.zerotoaster.httpd.util.HttpIniManager;

public class VHost_Configuration
extends Application
implements Constants {
    private Configuration cnfMaster = null;
    private LogContext logMaster = null;
    private Vector vecConfigFiles = null;
    private Hashtable hshVHosts = null;
    private SessionManager smManager = null;
    private int intCurrentDirDepth = 0;

    public VHost_Configuration(Configuration cnfMaster, LogContext logMaster, SessionManager smManager) {
        this.cnfMaster = cnfMaster;
        this.logMaster = logMaster;
        this.smManager = smManager;
        this.init();
    }

    private void addSpecialPathes(IniManager ini) {
        String strConfigDir = HelperPath.splitPath_getPath((String)ini.getFileName());
        strConfigDir = HelperPath.pathFixup((String)strConfigDir, (String)File.separator);
        strConfigDir = HelperPath.removeTrailingSlashes((String)strConfigDir);
        ini.setPropertyString("net.zerotoaster.httpd.", "configdir", strConfigDir);
        String strHTDOCS = ini.getPropertyString("VHOST", "documents", "htdocs");
        if (!HelperPath.isAbsolutePath((String)strHTDOCS)) {
            strHTDOCS = String.valueOf(strConfigDir) + File.separator + strHTDOCS;
        }
        strHTDOCS = HelperPath.pathFixup((String)strHTDOCS, (String)File.separator);
        strHTDOCS = HelperPath.removeTrailingSlashes((String)strHTDOCS);
        ini.setPropertyString("net.zerotoaster.httpd.", "htdocs", strHTDOCS);
        String strZT_ROOT = null;
        try {
            strZT_ROOT = new File("").getCanonicalPath();
        }
        catch (IOException iOException) {
            strZT_ROOT = new File("").getAbsolutePath();
        }
        strZT_ROOT = HelperPath.pathFixup((String)strZT_ROOT, (String)File.separator);
        strZT_ROOT = HelperPath.removeTrailingSlashes((String)strZT_ROOT);
        ini.setPropertyString("net.zerotoaster.httpd.", "zt_root", strZT_ROOT);
        String strTEMPFILES = ini.getPropertyString("VHOST", "tempfiles", "tempfiles");
        if (!HelperPath.isAbsolutePath((String)strTEMPFILES)) {
            strTEMPFILES = String.valueOf(strConfigDir) + File.separator + strTEMPFILES;
        }
        strTEMPFILES = HelperPath.pathFixup((String)strTEMPFILES, (String)File.separator);
        strTEMPFILES = HelperPath.removeTrailingSlashes((String)strTEMPFILES);
        new File(strTEMPFILES).mkdirs();
        ini.setPropertyString("net.zerotoaster.httpd.", "tempfiles", strTEMPFILES);
    }

    public void dispose() {
        this.blnDisposed = true;
        if (this.hshVHosts != null) {
            Enumeration e = this.hshVHosts.elements();
            while (e.hasMoreElements()) {
                ServletContext_Impl sc = ((HttpIniManager)((Object)e.nextElement())).getServletContext();
                if (sc == null) continue;
                sc.dispose();
            }
            this.hshVHosts.clear();
            this.hshVHosts = null;
        }
    }

    private final void find_configs_embedded(String string, String[] strConfigs) throws IOException {
        String strRoot = HelperPath.removeLeadingSlashes((String)string);
        strRoot = HelperPath.removeTrailingSlashes((String)strRoot);
        strRoot = HelperPath.pathFixup((String)strRoot, (String)"/");
        strRoot = "/" + strRoot + "/";
        int j = 0;
        while (j < strConfigs.length) {
            String strFile = HelperPath.buildRessourcePath((String)(String.valueOf(strRoot) + strConfigs[j]));
            InputStream is = this.getClass().getResourceAsStream(strFile);
            if (is != null) {
                if (!this.vecConfigFiles.contains(strFile)) {
                    this.vecConfigFiles.addElement(strFile);
                }
                Helper.close(is);
            }
            ++j;
        }
    }

    private final void find_configs_file(String string, String[] strConfigs) throws IOException {
        if (this.intCurrentDirDepth > this.cnfMaster.intVH_search_depth) {
            return;
        }
        this.log("D Searching " + string);
        ++this.intCurrentDirDepth;
        String strRoot = HelperPath.removeTrailingSlashes((String)string);
        File flRoot = new File(strRoot);
        String[] strFiles = flRoot.list();
        if (strFiles == null || strFiles.length == 0) {
            --this.intCurrentDirDepth;
            return;
        }
        int i = 0;
        while (i < strFiles.length) {
            File flTmp = new File(flRoot.getCanonicalPath(), strFiles[i]);
            if (flTmp.isDirectory()) {
                this.find_configs_file(flTmp.getCanonicalPath(), strConfigs);
            } else {
                int j = 0;
                while (j < strConfigs.length) {
                    String strFile;
                    if (StrTool.matches((String)strFiles[i], (String)strConfigs[j]) && !this.vecConfigFiles.contains(strFile = HelperPath.pathFixup((String)flTmp.getCanonicalPath(), (String)File.separator))) {
                        this.vecConfigFiles.addElement(strFile);
                    }
                    ++j;
                }
            }
            ++i;
        }
        --this.intCurrentDirDepth;
    }

    public final String[] getAllHosts() {
        String[] s = new String[this.hshVHosts.size()];
        int i = 0;
        Enumeration e = this.hshVHosts.keys();
        while (e.hasMoreElements()) {
            s[i++] = (String)e.nextElement();
        }
        return s;
    }

    public final HttpIniManager getIniManager(String strVHost) {
        HttpIniManager ini = null;
        if (strVHost != null) {
            ini = (HttpIniManager)((Object)this.hshVHosts.get(strVHost.toLowerCase()));
        }
        if (ini == null) {
            ini = (HttpIniManager)((Object)this.hshVHosts.get("@default@"));
        }
        return ini;
    }

    private final void init() {
        this.hshVHosts = new Hashtable();
        this.vecConfigFiles = new Vector(10, 5);
        int i = 0;
        while (i < this.cnfMaster.strVH_vhost_root.length) {
            try {
                this.intCurrentDirDepth = 0;
                if (Configuration.mode_nofile()) {
                    this.find_configs_embedded(this.cnfMaster.strVH_vhost_root[i], this.cnfMaster.strVH_cnf_file);
                } else {
                    this.find_configs_file(this.cnfMaster.strVH_vhost_root[i], this.cnfMaster.strVH_cnf_file);
                }
            }
            catch (IOException e) {
                this.log("? " + e.toString());
            }
            ++i;
        }
        this.log("D Found " + this.vecConfigFiles.size() + " configuration files");
        i = 0;
        while (i < this.vecConfigFiles.size()) {
            String strConfig = (String)this.vecConfigFiles.elementAt(i);
            this.log("D Loading " + strConfig);
            HttpIniManager ini = new HttpIniManager(strConfig, Configuration.mode_nofile());
            if (!ini.hasLoaded()) {
                this.log("? Config file '" + strConfig + "' missing or empty, abort");
                throw new InitializationException();
            }
            String[] strServers = ini.getPropertiesString("VHOST", "server_name");
            if (strServers.length == 0) {
                this.log("? Config file '" + strConfig + "' doesn't contain any 'server_name' entry, ignored");
            } else {
                this.addSpecialPathes(ini);
                if (this.cnfMaster.blnUseServlets) {
                    this.log("D ServletContext " + strConfig);
                    ini.setServletContext(new ServletContext_Impl(this.cnfMaster, ini, this.logMaster, this.smManager));
                }
                int j = 0;
                while (j < strServers.length) {
                    this.hshVHosts.put(strServers[j].toLowerCase(), ini);
                    ++j;
                }
            }
            ++i;
        }
        this.log("D Resolving 'extends' entries");
        Enumeration e = this.hshVHosts.elements();
        while (e.hasMoreElements()) {
            IniManager iniThis = (IniManager)e.nextElement();
            String[] strNames = iniThis.getPropertiesString("VHOST", "server_name");
            String strExtends = iniThis.getPropertyString("VHOST", "extends", "@default@");
            boolean blnDuplicate = false;
            int i2 = 0;
            while (i2 < strNames.length) {
                if (strNames[i2].equalsIgnoreCase(strExtends)) {
                    blnDuplicate = true;
                    break;
                }
                ++i2;
            }
            if (blnDuplicate) continue;
            IniManager iniMaster = (IniManager)this.hshVHosts.get(strExtends.toLowerCase());
            if (iniMaster == null) {
                this.log("? " + iniThis.getFileName() + " extends '" + strExtends + "' but cannot find a config which declares this - ignored");
                continue;
            }
            this.log("D " + iniThis.getFileName() + " extends " + iniMaster.getFileName());
            iniThis.setMaster(iniMaster);
        }
        if (!this.hshVHosts.containsKey("@default@")) {
            this.log("? VHost @default@ is not defined, abort");
            throw new InitializationException();
        }
        this.vecConfigFiles = null;
        this.log("# VHOST configuration loaded");
    }

    private final void log(String s) {
        if (this.logMaster != null) {
            this.logMaster.write(s);
        } else {
            System.out.println(">> " + s);
        }
    }

    public final void reload() {
        Hashtable hshOld = (Hashtable)this.hshVHosts.clone();
        this.dispose();
        this.blnDisposed = false;
        try {
            this.init();
        }
        catch (InitializationException initializationException) {
            this.log("! Reverting to old configuration");
            this.hshVHosts = (Hashtable)hshOld.clone();
        }
    }
}

