/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.collections;

import com.sun.java.util.collections.AbstractSequentialList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.ConcurrentModificationException;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.ListIterator;
import com.sun.java.util.collections.NoSuchElementException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private transient Entry header;
    private transient int size;

    public LinkedList() {
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
    }

    public LinkedList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object object = this.header.next.element;
        this.remove(this.header.next);
        return object;
    }

    public Object removeLast() {
        Object object = this.header.previous.element;
        this.remove(this.header.previous);
        return object;
    }

    public void addFirst(Object object) {
        this.addBefore(object, this.header.next);
    }

    public void addLast(Object object) {
        this.addBefore(object, this.header);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object object) {
        this.addBefore(object, this.header);
        return true;
    }

    public boolean remove(Object object) {
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        ++this.modCount;
        Entry entry = n == this.size ? this.header : this.entry(n);
        Entry entry2 = entry.previous;
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (n3 < n2) {
            Entry entry3;
            entry2.next = entry3 = new Entry(iterator.next(), entry, entry2);
            entry2 = entry3;
            ++n3;
        }
        entry.previous = entry2;
        this.size += n2;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public Object get(int n) {
        return this.entry((int)n).element;
    }

    public Object set(int n, Object object) {
        Entry entry = this.entry(n);
        Object object2 = entry.element;
        entry.element = object;
        return object2;
    }

    public void add(int n, Object object) {
        this.addBefore(object, n == this.size ? this.header : this.entry(n));
    }

    public Object remove(int n) {
        Entry entry = this.entry(n);
        this.remove(entry);
        return entry.element;
    }

    private Entry entry(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Entry entry = this.header;
        if (n < this.size / 2) {
            int n2 = 0;
            while (n2 <= n) {
                entry = entry.next;
                ++n2;
            }
        } else {
            int n3 = this.size;
            while (n3 > n) {
                entry = entry.previous;
                --n3;
            }
        }
        return entry;
    }

    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (entry.element == null) {
                    return n;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (object.equals(entry.element)) {
                    return n;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        return new ListItr(n);
    }

    private Entry addBefore(Object object, Entry entry) {
        Entry entry2;
        entry2.previous.next = entry2 = new Entry(object, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    private void remove(Entry entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
    }

    public Object clone() {
        return new LinkedList(this);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        int n2 = 0;
        while (n2 < n) {
            this.add(objectInputStream.readObject());
            ++n2;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n) {
            LinkedList.this = LinkedList.this;
            this.lastReturned = LinkedList.this.header;
            this.expectedModCount = LinkedList.this.modCount;
            if (n < 0 || n > LinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + LinkedList.this.size);
            }
            if (n < LinkedList.this.size / 2) {
                this.next = ((LinkedList)LinkedList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < n) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
                return;
            }
            this.next = LinkedList.this.header;
            this.nextIndex = LinkedList.this.size;
            while (this.nextIndex > n) {
                this.next = this.next.previous;
                --this.nextIndex;
            }
        }

        public boolean hasNext() {
            return this.nextIndex != LinkedList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            LinkedList.this.remove(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedList.this.header;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            if (this.lastReturned == LinkedList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = object;
        }

        public void add(Object object) {
            this.checkForComodification();
            this.lastReturned = LinkedList.this.header;
            LinkedList.this.addBefore(object, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }
}

