/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.io.IOException;
import java.io.Reader;
import rb.util.BufferedReaderRB;
import rb.util.CPCharacterPatternRB;

public class ExtendedReaderRB
extends BufferedReaderRB {
    long charsReadByFill = 0L;

    public ExtendedReaderRB(Reader reader) {
        super(reader);
    }

    public ExtendedReaderRB(Reader reader, int n) {
        super(reader, n);
    }

    protected void fill() throws IOException {
        super.fill();
        this.charsReadByFill += (long)(this.nChars - this.nextChar);
    }

    public int peek() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return -1;
            }
        }
        return this.cb[this.nextChar];
    }

    public String read(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n2 = this.nChars - this.nextChar;
            while (n >= n2) {
                stringBuffer.append(this.cb, this.nextChar, n2);
                n -= n2;
                this.fill();
                if (this.nChars == 0) {
                    throw new IOException("No more elements");
                }
                n2 = this.nChars - this.nextChar;
            }
            stringBuffer.append(this.cb, this.nextChar, n);
            this.nextChar += n;
        }
        return stringBuffer.toString();
    }

    public long readCount() {
        return this.charsReadByFill - (long)(this.nChars - this.nextChar);
    }

    public String readTo(CPCharacterPatternRB cPCharacterPatternRB) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(BufferedReaderRB.defaultExpectedLineLength);
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            do {
                int n = this.nextChar;
                while (n < this.nChars) {
                    if (cPCharacterPatternRB.matches(this.cb[n])) {
                        stringBuffer.append(this.cb, this.nextChar, n - this.nextChar);
                        this.nextChar = n;
                        return stringBuffer.toString();
                    }
                    ++n;
                }
                stringBuffer.append(this.cb, this.nextChar, n - this.nextChar);
                this.nextChar = n;
                this.fill();
            } while (this.nextChar < this.nChars);
        }
        return stringBuffer.toString();
    }

    public int skipTo(CPCharacterPatternRB cPCharacterPatternRB) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar < this.nChars) {
                    if (cPCharacterPatternRB.matches(this.cb[this.nextChar])) {
                        return this.cb[this.nextChar];
                    }
                    ++this.nextChar;
                    continue;
                }
                this.fill();
                if (this.nextChar >= this.nChars) break;
            }
        }
        return -1;
    }
}

