/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd.address;

import java.util.Enumeration;
import java.util.Vector;
import rb.httpd.address.ABEntry;
import rb.httpd.address.ABPerson;
import rb.util.StringUtil;
import rb.util.VectorRB;

public class ABAddress
extends ABEntry {
    String email = "\u0001";
    String fax = "\u0001";
    String tel = "\u0001";
    String country = "\u0001";
    String state = "\u0001";
    String city = "\u0001";
    String zip = "\u0001";
    String street = "\u0001";
    String house = "\u0001";
    String url = "\u0001";
    ABAddress parent;
    Vector children = new Vector();
    public static final String InheritTag = "\u0001";

    public String getAddressString() {
        String[] stringArray = new String[]{String.valueOf(this.street) + " " + this.house, String.valueOf(this.zip) + " " + this.city, this.state, this.country};
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(stringArray[0].trim());
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].trim().length() > 0) {
                stringBuffer.append(", " + stringArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFax() {
        return this.fax;
    }

    public ABAddress getFullAddress() {
        ABAddress aBAddress = new ABAddress();
        ABAddress aBAddress2 = this.getParent();
        if (aBAddress2 == null) {
            aBAddress2 = new ABAddress();
        }
        aBAddress.name = StringUtil.replace(this.name, InheritTag, aBAddress2.name);
        aBAddress.email = StringUtil.replace(this.email, InheritTag, aBAddress2.email);
        aBAddress.note = StringUtil.replace(this.note, InheritTag, aBAddress2.note);
        aBAddress.tel = StringUtil.replace(this.tel, InheritTag, aBAddress2.tel);
        aBAddress.fax = StringUtil.replace(this.fax, InheritTag, aBAddress2.fax);
        return aBAddress;
    }

    public String getFullEmail() {
        if (this.parent == null) {
            return this.email;
        }
        return StringUtil.replace(this.email, InheritTag, this.parent.email);
    }

    public String getFullURL() {
        if (this.parent == null) {
            return this.url;
        }
        return StringUtil.replace(this.url, InheritTag, this.parent.url);
    }

    public String getHouse() {
        return this.house;
    }

    public ABAddress getParent() {
        return this.parent;
    }

    public ABPerson getPerson() {
        try {
            return (ABPerson)this.children.firstElement();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getPhone() {
        return this.tel;
    }

    public String getState() {
        return this.state;
    }

    public String getStreet() {
        return this.street;
    }

    public synchronized VectorRB getSubAddresses() {
        VectorRB vectorRB = new VectorRB(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            try {
                vectorRB.addElement((ABAddress)enumeration.nextElement());
            }
            catch (ClassCastException classCastException) {}
        }
        return vectorRB;
    }

    public String getURL() {
        return this.url;
    }

    public String getZip() {
        return this.zip;
    }

    public boolean isLeaf() {
        return this.getPerson() != null;
    }

    void remove() {
        --this.book.addressCount;
        super.remove();
        if (this.parent != null) {
            this.parent.children.removeElement(this);
        }
        Object object = this.getSubAddresses().elements();
        while (object.hasMoreElements()) {
            ((ABEntry)object.nextElement()).remove();
        }
        object = this.getPerson();
        if (object != null) {
            ((ABPerson)object).addresses.removeElement(this);
        }
    }

    void setData(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, ABAddress aBAddress, ABPerson aBPerson) {
        this.setDataPrim(string, string2);
        this.email = string3;
        this.fax = string4;
        this.tel = string5;
        this.setParent(aBAddress);
        this.setPerson(aBPerson);
        this.url = string6;
        this.country = string7;
        this.state = string8;
        this.city = string9;
        this.zip = string10;
        this.street = string11;
        this.house = string12;
        this.book.log(this, "setAddress1", new long[]{ABEntry.getID(aBAddress), ABEntry.getID(aBPerson)}, new String[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12});
    }

    void setData(String string, String string2, String string3, String string4, String string5, String string6, ABAddress aBAddress, ABPerson aBPerson) {
        this.setDataPrim(string, string2);
        this.street = string3;
        this.email = string4;
        this.fax = string5;
        this.tel = string6;
        this.setParent(aBAddress);
        this.setPerson(aBPerson);
        this.book.log(this, "setAddress0", new long[]{ABEntry.getID(aBAddress), ABEntry.getID(aBPerson)}, new String[]{string, string2, string3, string4, string5, string6});
    }

    void setParent(ABAddress aBAddress) {
        if (this.parent == aBAddress) {
            return;
        }
        if (this.parent != null) {
            aBAddress.children.removeElement(this);
        }
        this.parent = aBAddress;
        if (this.parent != null) {
            aBAddress.children.addElement(this);
        }
    }

    void setPerson(ABPerson aBPerson) {
        if (aBPerson == null) {
            return;
        }
        if (this.getPerson() == aBPerson) {
            return;
        }
        this.children.setSize(0);
        this.children.addElement(aBPerson);
        aBPerson.addresses.addElement(this);
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.id + " n:" + this.name + " t:" + this.tel + " f:" + this.fax + " e:" + this.email + " n:" + this.note + " c:" + this.children.size() + "]";
    }
}

