/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import rb.httpd.HttpAccessTable;
import rb.httpd.HttpClass;
import rb.httpd.RequestHeader;
import rb.httpd.ServerConstants;
import rb.util.StringUtil;

public class HttpRequestHeader
implements ServerConstants,
RequestHeader {
    String[] headerLines;
    String method = "";
    String protocol = "";
    String url = "";
    String urlClassName = "";
    String urlPath = "";
    String urlParameters = "";
    String processorClassName = "";
    String localAddress = "";
    String contentType = "";
    String boundary = "";
    long contentLength = -1L;

    void evaluate() throws IOException {
        if (this.headerLines.length < 1) {
            return;
        }
        String string = this.headerLines[0].trim();
        int n = string.indexOf(" ") + 1;
        this.method = string.substring(0, n).trim();
        string = string.substring(n).trim();
        n = string.lastIndexOf(" HTTP") + 1;
        this.protocol = string.substring(n).trim();
        this.setURL(string.substring(0, n).trim());
        int n2 = 1;
        while (n2 < this.headerLines.length) {
            string = this.headerLines[n2];
            n = string.indexOf(58) + 1;
            String string2 = string.substring(0, n - 1).toLowerCase();
            String string3 = string.substring(n).trim();
            if (string2.equals("content-length")) {
                this.contentLength = Long.parseLong(string3);
            }
            if (string2.equals("content-type")) {
                this.contentType = string3;
            }
            ++n2;
        }
        if (this.contentType.toLowerCase().startsWith("multipart/form-data") && (n2 = this.contentType.indexOf("=")) >= 0) {
            this.boundary = this.contentType.substring(n2 + 1);
        }
    }

    public String[] getLines() {
        return this.headerLines;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    String getProcessorClassName() {
        return this.processorClassName;
    }

    public String getURL() {
        return this.url;
    }

    public String getURLClassName() {
        return this.urlClassName;
    }

    public String getURLParameters() {
        return this.urlParameters;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    void readFrom(BufferedReader bufferedReader) throws IOException {
        String string;
        Vector<String> vector = new Vector<String>();
        while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        this.headerLines = new String[vector.size()];
        vector.copyInto(this.headerLines);
        this.evaluate();
    }

    void setURL(String string) throws IOException {
        String string2 = this.url = string;
        this.urlParameters = "";
        int n = this.url.indexOf(63);
        if (n >= 0) {
            string2 = this.url.substring(0, n);
            this.urlParameters = this.url.substring(n + 1);
        }
        string2 = HttpClass.fromURL(string2);
        this.urlPath = string2.substring(1);
        String string3 = HttpAccessTable.translateTable.translate(this.urlPath);
        this.urlPath = string3 != null ? string3 : "";
        String string4 = "";
        if (this.urlPath.startsWith("&")) {
            string4 = this.urlPath.substring("&".length());
            this.urlPath = "";
            this.urlClassName = string2;
            n = string4.indexOf(47);
            if (n >= 0) {
                this.urlPath = string4.substring(n + 1);
                string4 = string4.substring(0, n);
                this.urlClassName = string2.substring(0, string2.length() - this.urlPath.length() - 1);
            }
        }
        if (string4.indexOf(46) < 0) {
            string4 = String.valueOf(StringUtil.toLast(this.getClass().getName(), '.')) + "." + string4;
        }
        this.processorClassName = string4;
    }
}

