/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import solarex.quest.Quest;
import solarex.ship.Good;
import solarex.ship.Ship;
import solarex.ship.components.ShipComponent;
import solarex.ui.components.EquipmentWrapper;
import solarex.ui.components.QuestWrapper;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;

public class ShipInfoPanel
extends JPanel {
    private JLabel cabinsField;
    private JLabel cabinsLabel;
    private JLabel cargoLabel;
    private JList cargoList;
    private JLabel cargoModuleField;
    private JLabel cargoModuleLabel;
    private JLabel cashField;
    private JLabel cashLabel;
    private JPanel contenPanel;
    private JLabel descriptionField;
    private JLabel driveField;
    private JLabel driveLabel;
    private JList equipmentList;
    private JLabel installedEquipmentLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel questsLabel;
    private JList questsList;
    private JLabel sensorsField;
    private JLabel sensorsLabel;
    private JLabel shieldingField1;
    private JLabel shieldingLabel;
    private JLabel shipNameField;
    private JLabel titleLabel;

    public ShipInfoPanel(Ship ship) {
        ship.recalculateCargoSpace();
        this.initComponents();
        ComponentFactory.customizeScrollpane(this.jScrollPane1);
        ComponentFactory.customizeScrollpane(this.jScrollPane2);
        ComponentFactory.customizeScrollpane(this.jScrollPane3);
        this.shipNameField.setFont(FontFactory.getLabelHeading());
        this.cargoModuleLabel.setFont(FontFactory.getLabelHeading());
        this.driveLabel.setFont(FontFactory.getLabelHeading());
        this.cabinsLabel.setFont(FontFactory.getLabelHeading());
        this.sensorsLabel.setFont(FontFactory.getLabelHeading());
        this.cargoLabel.setFont(FontFactory.getLabelHeading());
        this.questsLabel.setFont(FontFactory.getLabelHeading());
        this.installedEquipmentLabel.setFont(FontFactory.getLabelHeading());
        this.shieldingLabel.setFont(FontFactory.getLabelHeading());
        this.cashLabel.setFont(FontFactory.getLabelHeading());
        this.cargoModuleField.setFont(FontFactory.getLarger());
        this.driveField.setFont(FontFactory.getLarger());
        this.cabinsField.setFont(FontFactory.getLarger());
        this.sensorsField.setFont(FontFactory.getLarger());
        this.shieldingField1.setFont(FontFactory.getLarger());
        this.cashField.setFont(FontFactory.getLarger());
        this.descriptionField.setFont(FontFactory.getNormal());
        this.cargoList.setFont(FontFactory.getLarger());
        this.questsList.setFont(FontFactory.getLarger());
        this.equipmentList.setFont(FontFactory.getLarger());
        this.descriptionField.setText("<html>Small but reliable, the Space Bug is usually the first ship of any space prospector. It is cheap to purchase and easy to repair, even with limited repair abilities or materials.<br><br>The biggest drawback of the ship the limited payload,  which even must be shared between cargo and equipment.  The ship can be controlled by a single person, but it doesn't even provide room and support for a second passenger unless a passenger cabin  is installed.</html>");
        this.fillComponentList(ship);
        this.fillCargoList(ship);
        this.fillQuestsList(ship);
    }

    private void fillComponentList(Ship ship) {
        DefaultListModel<EquipmentWrapper> shipModel = new DefaultListModel<EquipmentWrapper>();
        for (ShipComponent comp : ship.equipment.components) {
            shipModel.addElement(new EquipmentWrapper(comp));
        }
        this.equipmentList.setModel(shipModel);
        this.driveField.setText("" + ship.equipment.getHyperjumpRange() + " ly");
        this.cabinsField.setText("" + ship.equipment.getPassengerCapacity() + " persons");
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        this.cashField.setText(nf.format(ship.cargo.money) + " Cr");
        this.cargoModuleField.setText("" + ship.equipment.getWeight() + "/" + ship.equipmentSpace + " units");
    }

    private void fillCargoList(Ship ship) {
        DefaultListModel<String> model = new DefaultListModel<String>();
        boolean found = false;
        for (Good good : ship.cargo.goods) {
            if (good.units <= 0) continue;
            found = true;
            if (good.units == 1) {
                model.addElement("<html>&nbsp;" + good.units + " unit of " + good.type.toString().toLowerCase() + "</html>");
                continue;
            }
            model.addElement("<html>&nbsp;" + good.units + " units of " + good.type.toString().toLowerCase() + "</html>");
        }
        if (!found) {
            model.addElement("<html>&nbsp;No goods.</html>");
        }
        this.cargoList.setModel(model);
    }

    private void fillQuestsList(Ship ship) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        boolean found = false;
        for (Quest quest : ship.player.getQuests()) {
            QuestWrapper w = new QuestWrapper(quest);
            model.addElement(w);
            found = true;
        }
        if (!found) {
            model.addElement(" No quests.");
        }
        this.questsList.setModel(model);
    }

    private void initComponents() {
        this.contenPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.cashField = new JLabel();
        this.shipNameField = new JLabel();
        this.cashLabel = new JLabel();
        this.driveLabel = new JLabel();
        this.driveField = new JLabel();
        this.cargoModuleLabel = new JLabel();
        this.cargoModuleField = new JLabel();
        this.cabinsLabel = new JLabel();
        this.cabinsField = new JLabel();
        this.descriptionField = new JLabel();
        this.sensorsLabel = new JLabel();
        this.sensorsField = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.cargoList = new JList();
        this.cargoLabel = new JLabel();
        this.shieldingField1 = new JLabel();
        this.shieldingLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.equipmentList = new JList();
        this.installedEquipmentLabel = new JLabel();
        this.questsLabel = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.questsList = new JList();
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.contenPanel.setBackground(new Color(33, 33, 0));
        this.contenPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.contenPanel.setMinimumSize(new Dimension(800, 540));
        this.contenPanel.setPreferredSize(new Dimension(800, 540));
        this.contenPanel.setLayout(null);
        this.titleLabel.setFont(new Font("SansSerif", 1, 18));
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setText("Ship Information");
        this.contenPanel.add(this.titleLabel);
        this.titleLabel.setBounds(20, 10, 420, 40);
        this.cashField.setForeground(Color.white);
        this.cashField.setText("0$");
        this.contenPanel.add(this.cashField);
        this.cashField.setBounds(150, 220, 240, 30);
        this.shipNameField.setForeground(Color.orange);
        this.shipNameField.setText("Space Bug, a \"Tin Can\" class ship. ");
        this.contenPanel.add(this.shipNameField);
        this.shipNameField.setBounds(20, 60, 270, 30);
        this.cashLabel.setForeground(Color.green);
        this.cashLabel.setText("Cash:");
        this.contenPanel.add(this.cashLabel);
        this.cashLabel.setBounds(20, 220, 80, 30);
        this.driveLabel.setForeground(Color.green);
        this.driveLabel.setText("Drive Range:");
        this.contenPanel.add(this.driveLabel);
        this.driveLabel.setBounds(20, 110, 100, 30);
        this.driveField.setForeground(Color.white);
        this.driveField.setText("Short range interstellar jump drive");
        this.contenPanel.add(this.driveField);
        this.driveField.setBounds(150, 110, 290, 30);
        this.cargoModuleLabel.setForeground(Color.green);
        this.cargoModuleLabel.setText("Used Space:");
        this.contenPanel.add(this.cargoModuleLabel);
        this.cargoModuleLabel.setBounds(20, 130, 100, 30);
        this.cargoModuleField.setForeground(Color.white);
        this.cargoModuleField.setText("Standard cargo module (5t)");
        this.contenPanel.add(this.cargoModuleField);
        this.cargoModuleField.setBounds(150, 130, 290, 30);
        this.cabinsLabel.setForeground(Color.green);
        this.cabinsLabel.setText("Passenger Cap.:");
        this.contenPanel.add(this.cabinsLabel);
        this.cabinsLabel.setBounds(20, 150, 130, 30);
        this.cabinsField.setForeground(Color.white);
        this.cabinsField.setText("None (1 max.)");
        this.contenPanel.add(this.cabinsField);
        this.cabinsField.setBounds(150, 150, 290, 30);
        this.descriptionField.setForeground(Color.lightGray);
        this.descriptionField.setText("Ship description.");
        this.descriptionField.setVerticalAlignment(1);
        this.contenPanel.add(this.descriptionField);
        this.descriptionField.setBounds(400, 20, 370, 170);
        this.sensorsLabel.setForeground(Color.green);
        this.sensorsLabel.setText("Sensors:");
        this.contenPanel.add(this.sensorsLabel);
        this.sensorsLabel.setBounds(20, 170, 100, 30);
        this.sensorsField.setForeground(Color.white);
        this.sensorsField.setText("Standard optical sensors");
        this.contenPanel.add(this.sensorsField);
        this.sensorsField.setBounds(150, 170, 240, 30);
        this.cargoList.setBackground(Color.darkGray);
        this.cargoList.setForeground(Color.lightGray);
        this.cargoList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.cargoList);
        this.contenPanel.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(400, 220, 370, 130);
        this.cargoLabel.setForeground(Color.green);
        this.cargoLabel.setText("Cargo");
        this.contenPanel.add(this.cargoLabel);
        this.cargoLabel.setBounds(400, 180, 250, 30);
        this.shieldingField1.setForeground(Color.white);
        this.shieldingField1.setText("Low radiation shielding");
        this.contenPanel.add(this.shieldingField1);
        this.shieldingField1.setBounds(150, 190, 290, 30);
        this.shieldingLabel.setForeground(Color.green);
        this.shieldingLabel.setText("Shielding:");
        this.contenPanel.add(this.shieldingLabel);
        this.shieldingLabel.setBounds(20, 190, 100, 30);
        this.equipmentList.setBackground(Color.darkGray);
        this.equipmentList.setForeground(Color.lightGray);
        this.equipmentList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.equipmentList);
        this.contenPanel.add(this.jScrollPane2);
        this.jScrollPane2.setBounds(20, 290, 340, 240);
        this.installedEquipmentLabel.setForeground(Color.green);
        this.installedEquipmentLabel.setText("Installed Equipment");
        this.contenPanel.add(this.installedEquipmentLabel);
        this.installedEquipmentLabel.setBounds(20, 250, 250, 30);
        this.questsLabel.setForeground(Color.green);
        this.questsLabel.setText("Quests and jobs");
        this.contenPanel.add(this.questsLabel);
        this.questsLabel.setBounds(400, 360, 250, 30);
        this.questsList.setBackground(Color.darkGray);
        this.questsList.setForeground(Color.lightGray);
        this.questsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.questsList);
        this.contenPanel.add(this.jScrollPane3);
        this.jScrollPane3.setBounds(400, 400, 370, 130);
        this.add((Component)this.contenPanel, new GridBagConstraints());
    }
}

