/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import solarex.ship.Ship;
import solarex.ship.components.EquipmentFactory;
import solarex.ship.components.ShipComponent;
import solarex.system.Solar;
import solarex.ui.panels.SpaceStationPanel;
import solarex.util.ComponentFactory;
import solarex.util.FontFactory;

public class ShipComponentTrade
extends JPanel {
    private SpaceStationPanel spaceStationPanel;
    private Ship ship;
    private Solar station;
    private JList availableEquipmentList;
    private JButton buyButton;
    private JLabel cashLabel;
    private JTextArea equipmentDetailsArea;
    private JLabel headlineLabel;
    private JPanel installedComponentsPanel;
    private JList installedEquipmentList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton loungeButton;
    private JButton sellButton;
    private JPanel soldComponentsPanel;
    private JLabel spaceLabel;

    public ShipComponentTrade(Solar station, Ship ship, SpaceStationPanel spaceStationPanel) {
        this.spaceStationPanel = spaceStationPanel;
        this.ship = ship;
        this.station = station;
        this.initComponents();
        this.headlineLabel.setFont(FontFactory.getPanelHeading());
        this.fillComponentList();
        ComponentFactory.customizeButton(this.buyButton);
        ComponentFactory.customizeButton(this.loungeButton);
        ComponentFactory.customizeButton(this.sellButton);
        ComponentFactory.customizeScrollpane(this.jScrollPane1);
        ComponentFactory.customizeScrollpane(this.jScrollPane2);
        ComponentFactory.customizeScrollpane(this.jScrollPane3);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.soldComponentsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.availableEquipmentList = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.installedComponentsPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.installedEquipmentList = new JList();
        this.headlineLabel = new JLabel();
        this.buyButton = new JButton();
        this.sellButton = new JButton();
        this.jLabel3 = new JLabel();
        this.loungeButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.equipmentDetailsArea = new JTextArea();
        this.jLabel4 = new JLabel();
        this.spaceLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.cashLabel = new JLabel();
        this.setBackground(Color.black);
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setForeground(Color.green);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(0, 51, 51));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.jPanel1.setMinimumSize(new Dimension(800, 540));
        this.jPanel1.setPreferredSize(new Dimension(800, 540));
        this.jPanel1.setLayout(null);
        this.soldComponentsPanel.setLayout(new BorderLayout());
        this.availableEquipmentList.setBackground(Color.darkGray);
        this.availableEquipmentList.setFont(new Font("SansSerif", 0, 12));
        this.availableEquipmentList.setForeground(Color.lightGray);
        this.availableEquipmentList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.availableEquipmentList.setSelectionMode(0);
        this.availableEquipmentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ShipComponentTrade.this.availableEquipmentListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.availableEquipmentList);
        this.soldComponentsPanel.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add(this.soldComponentsPanel);
        this.soldComponentsPanel.setBounds(30, 170, 330, 160);
        this.jLabel1.setFont(new Font("SansSerif", 1, 12));
        this.jLabel1.setForeground(Color.green);
        this.jLabel1.setText("Installed Equipment");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(450, 140, 200, 30);
        this.jLabel2.setFont(new Font("SansSerif", 1, 12));
        this.jLabel2.setForeground(Color.green);
        this.jLabel2.setText("Available Equipment");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(30, 140, 200, 30);
        this.installedComponentsPanel.setLayout(new BorderLayout());
        this.installedEquipmentList.setBackground(Color.darkGray);
        this.installedEquipmentList.setFont(new Font("SansSerif", 0, 12));
        this.installedEquipmentList.setForeground(Color.lightGray);
        this.installedEquipmentList.setSelectionMode(0);
        this.installedEquipmentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ShipComponentTrade.this.installedEquipmentListValueChanged(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.installedEquipmentList);
        this.installedComponentsPanel.add((Component)this.jScrollPane2, "Center");
        this.jPanel1.add(this.installedComponentsPanel);
        this.installedComponentsPanel.setBounds(450, 170, 310, 160);
        this.headlineLabel.setFont(new Font("SansSerif", 1, 18));
        this.headlineLabel.setForeground(Color.white);
        this.headlineLabel.setText("Equipment Shop");
        this.jPanel1.add(this.headlineLabel);
        this.headlineLabel.setBounds(20, 10, 340, 40);
        this.buyButton.setText("Buy");
        this.buyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShipComponentTrade.this.buyButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buyButton);
        this.buyButton.setBounds(370, 170, 70, 25);
        this.sellButton.setText("Sell");
        this.sellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShipComponentTrade.this.sellButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.sellButton);
        this.sellButton.setBounds(370, 210, 70, 25);
        this.jLabel3.setFont(new Font("SansSerif", 0, 12));
        this.jLabel3.setForeground(Color.white);
        this.jLabel3.setText("<html>We offer the finest equipment for your ship! At totally reasonable prices, of course.</html>");
        this.jPanel1.add(this.jLabel3);
        this.jLabel3.setBounds(20, 60, 510, 20);
        this.loungeButton.setText("Return To Lounge");
        this.loungeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ShipComponentTrade.this.loungeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.loungeButton);
        this.loungeButton.setBounds(20, 500, 150, 25);
        this.jPanel2.setLayout(new BorderLayout());
        this.equipmentDetailsArea.setBackground(Color.darkGray);
        this.equipmentDetailsArea.setColumns(20);
        this.equipmentDetailsArea.setFont(new Font("Monospaced", 0, 12));
        this.equipmentDetailsArea.setForeground(Color.lightGray);
        this.equipmentDetailsArea.setRows(5);
        this.equipmentDetailsArea.setDisabledTextColor(Color.lightGray);
        this.equipmentDetailsArea.setEnabled(false);
        this.equipmentDetailsArea.setMargin(new Insets(4, 2, 2, 2));
        this.jScrollPane3.setViewportView(this.equipmentDetailsArea);
        this.jPanel2.add((Component)this.jScrollPane3, "Center");
        this.jPanel1.add(this.jPanel2);
        this.jPanel2.setBounds(30, 360, 730, 130);
        this.jLabel4.setFont(new Font("SansSerif", 1, 12));
        this.jLabel4.setForeground(Color.green);
        this.jLabel4.setText("Item Details");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(30, 330, 200, 30);
        this.spaceLabel.setFont(new Font("SansSerif", 0, 12));
        this.spaceLabel.setForeground(Color.white);
        this.spaceLabel.setHorizontalAlignment(11);
        this.spaceLabel.setText("0/0t");
        this.jPanel1.add(this.spaceLabel);
        this.spaceLabel.setBounds(70, 110, 120, 20);
        this.jLabel6.setFont(new Font("SansSerif", 1, 12));
        this.jLabel6.setForeground(Color.green);
        this.jLabel6.setText("Used Space:");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(30, 110, 80, 20);
        this.jLabel7.setFont(new Font("SansSerif", 1, 12));
        this.jLabel7.setForeground(Color.green);
        this.jLabel7.setText("Cash:");
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(30, 90, 60, 20);
        this.cashLabel.setFont(new Font("SansSerif", 0, 12));
        this.cashLabel.setForeground(Color.white);
        this.cashLabel.setHorizontalAlignment(11);
        this.cashLabel.setText("0$");
        this.jPanel1.add(this.cashLabel);
        this.cashLabel.setBounds(70, 90, 120, 20);
        this.add((Component)this.jPanel1, new GridBagConstraints());
    }

    private void loungeButtonActionPerformed(ActionEvent evt) {
        this.returnToLoungeButtonActionPerformed(evt);
    }

    private void returnToLoungeButtonActionPerformed(ActionEvent evt) {
        this.ship.recalculateCargoSpace();
        Container c = this.getParent();
        c.remove(this);
        c.add(this.spaceStationPanel);
        c.validate();
        c.repaint();
    }

    private void buyButtonActionPerformed(ActionEvent evt) {
        Object o = this.availableEquipmentList.getSelectedValue();
        if (o != null) {
            EquipmentWrapper wrap = (EquipmentWrapper)o;
            this.ship.equipment.addComponent(wrap.getComponent());
            this.ship.cargo.money -= (double)this.calculatePrice(wrap.getComponent().getBasePrice());
        }
        this.fillComponentList();
    }

    private void sellButtonActionPerformed(ActionEvent evt) {
        Object o = this.installedEquipmentList.getSelectedValue();
        if (o != null) {
            EquipmentWrapper wrap = (EquipmentWrapper)o;
            this.ship.equipment.removeComponent(wrap.getComponent());
            this.ship.cargo.money += (double)this.calculatePrice(wrap.getComponent().getBasePrice());
        }
        this.fillComponentList();
    }

    private void availableEquipmentListValueChanged(ListSelectionEvent evt) {
        Object o = this.availableEquipmentList.getSelectedValue();
        if (o != null) {
            EquipmentWrapper wrap = (EquipmentWrapper)o;
            this.showEquipmentDetails(wrap.getComponent());
        }
    }

    private void installedEquipmentListValueChanged(ListSelectionEvent evt) {
        Object o = this.installedEquipmentList.getSelectedValue();
        if (o != null) {
            EquipmentWrapper wrap = (EquipmentWrapper)o;
            this.showEquipmentDetails(wrap.getComponent());
        }
    }

    private void fillComponentList() {
        EquipmentFactory factory = new EquipmentFactory();
        DefaultListModel<EquipmentWrapper> model = new DefaultListModel<EquipmentWrapper>();
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.STANDARD_DRIVE)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.SINGLE_PASSENGER_CABIN)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.DOUBLE_PASSENGER_CABIN)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.LUXURY_PASSENGER_CABIN)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.FANFOSTAR)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.TROMPETECHOS)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.DRILLDOWN_DYNAMOS)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.SUPERSCOOPER)));
        model.addElement(new EquipmentWrapper(factory.create(EquipmentFactory.Component.INO_SLUURP)));
        this.availableEquipmentList.setModel(model);
        DefaultListModel<EquipmentWrapper> shipModel = new DefaultListModel<EquipmentWrapper>();
        for (ShipComponent comp : this.ship.equipment.components) {
            shipModel.addElement(new EquipmentWrapper(comp));
        }
        this.installedEquipmentList.setModel(shipModel);
        this.ship.recalculateCargoSpace();
        this.cashLabel.setText("" + this.ship.cargo.money + " Cr");
        this.spaceLabel.setText("" + this.ship.equipment.getWeight() + "/" + this.ship.equipmentSpace + " t");
    }

    private void showEquipmentDetails(ShipComponent comp) {
        StringBuilder buf = new StringBuilder();
        if (comp.getPassengerCapacity() > 0) {
            buf.append(" Passenger capacity: ").append(comp.getPassengerCapacity()).append("\n");
        }
        if (comp.getHyperjumpRange() > 0) {
            buf.append(" Hyperjump range:    ").append(comp.getHyperjumpRange()).append(" ly\n");
        }
        if (comp.getWeight() > 0) {
            buf.append(" Weight:             ").append(comp.getWeight()).append(" t\n");
        }
        if (comp.getMinOperatingTemp() > 0) {
            buf.append(" Min. oper. temp:    ").append(comp.getMinOperatingTemp()).append(" k\n");
        }
        if (comp.getMaxOperatingTemp() > 0) {
            buf.append(" Max. oper. temp:    ").append(comp.getMaxOperatingTemp()).append(" k\n");
        }
        if (comp.getBasePrice() > 0) {
            buf.append(" Price:              ").append(this.calculatePrice(comp.getBasePrice())).append(".00 Cr\n");
        }
        this.equipmentDetailsArea.setText(buf.toString());
    }

    private int calculatePrice(int basePrice) {
        int factor = 1200 / (this.station.society.techLevel + 6);
        int price = basePrice * factor;
        return price / 1000 * 10;
    }

    private class EquipmentWrapper {
        private ShipComponent comp;

        public EquipmentWrapper(ShipComponent comp) {
            this.comp = comp;
        }

        public String toString() {
            int hyper = this.comp.getHyperjumpRange();
            StringBuilder buf = new StringBuilder(" ");
            buf.append(this.comp.getName());
            buf.append(", ");
            buf.append(ShipComponentTrade.this.calculatePrice(this.comp.getBasePrice()));
            buf.append(".00$");
            return buf.toString();
        }

        private ShipComponent getComponent() {
            return this.comp;
        }
    }
}

