/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import solarex.evolution.World;
import solarex.galaxy.Galaxy;
import solarex.quest.Delivery;
import solarex.quest.Offering;
import solarex.quest.Quest;
import solarex.quest.WantedResource;
import solarex.ship.Cargo;
import solarex.ship.Good;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.components.QuestWrapper;
import solarex.ui.panels.SpaceStationPanel;
import solarex.ui.panels.TradePanel;
import solarex.util.ClockThread;
import solarex.util.ComponentFactory;
import solarex.util.Problem;
import solarex.util.RandomHelper;

public class BulletinBoardPanel
extends JPanel {
    private final Ship ship;
    private final Solar station;
    private final Galaxy galaxy;
    private final World world;
    private SpaceStationPanel spaceStationPanel;
    private final ImageCache imageCache;
    private JButton acceptButton;
    private JPanel contentPanel;
    private JButton declineButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton loungeButton;
    private JList newsList;
    private JLabel titleLabel;

    public BulletinBoardPanel(ImageCache imageCache, World world, Galaxy galaxy, Solar station, SpaceStationPanel spaceStationPanel, Ship ship) {
        this.imageCache = imageCache;
        this.world = world;
        this.spaceStationPanel = spaceStationPanel;
        this.ship = ship;
        this.station = station;
        this.galaxy = galaxy;
        this.initComponents();
        this.titleLabel.setText(station.name + " Bulletin Board");
        ComponentFactory.customizeButton(this.acceptButton);
        ComponentFactory.customizeButton(this.declineButton);
        ComponentFactory.customizeButton(this.loungeButton);
        this.buildOfferList(galaxy, station, ship);
        this.fillQuestsList(ship);
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.newsList = new JList();
        this.loungeButton = new JButton();
        this.jLabel1 = new JLabel();
        this.declineButton = new JButton();
        this.acceptButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(new Color(0, 51, 51));
        this.contentPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.contentPanel.setForeground(Color.green);
        this.contentPanel.setMinimumSize(new Dimension(800, 600));
        this.contentPanel.setPreferredSize(new Dimension(800, 540));
        this.contentPanel.setLayout(null);
        this.titleLabel.setFont(new Font("SansSerif", 1, 18));
        this.titleLabel.setForeground(Color.white);
        this.titleLabel.setText("XYZ Bulletin Board");
        this.contentPanel.add(this.titleLabel);
        this.titleLabel.setBounds(20, 10, 420, 40);
        this.jScrollPane1.setBackground(Color.darkGray);
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.newsList.setBackground(Color.darkGray);
        this.newsList.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 1));
        this.newsList.setFont(new Font("SansSerif", 1, 12));
        this.newsList.setForeground(Color.lightGray);
        this.newsList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.newsList.setSelectionMode(0);
        this.newsList.setFixedCellHeight(20);
        this.newsList.setSelectionBackground(new Color(0, 0, 51));
        this.newsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BulletinBoardPanel.this.newsListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.newsList);
        this.contentPanel.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(20, 90, 360, 390);
        this.loungeButton.setText("Return To Lounge");
        this.loungeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulletinBoardPanel.this.loungeButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.loungeButton);
        this.loungeButton.setBounds(20, 500, 140, 25);
        this.jLabel1.setFont(new Font("SansSerif", 1, 13));
        this.jLabel1.setForeground(Color.green);
        this.jLabel1.setText("Accepted Jobs");
        this.contentPanel.add(this.jLabel1);
        this.jLabel1.setBounds(410, 260, 310, 18);
        this.declineButton.setText("Decline");
        this.declineButton.setEnabled(false);
        this.contentPanel.add(this.declineButton);
        this.declineButton.setBounds(620, 210, 110, 25);
        this.acceptButton.setText("Accept");
        this.acceptButton.setEnabled(false);
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BulletinBoardPanel.this.acceptButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.acceptButton);
        this.acceptButton.setBounds(450, 210, 110, 25);
        this.jLabel2.setFont(new Font("SansSerif", 1, 13));
        this.jLabel2.setForeground(Color.green);
        this.jLabel2.setText("Offers, requests, jobs and quests");
        this.contentPanel.add(this.jLabel2);
        this.jLabel2.setBounds(20, 60, 310, 18);
        this.jLabel4.setFont(new Font("SansSerif", 1, 13));
        this.jLabel4.setForeground(Color.green);
        this.jLabel4.setText("Details");
        this.contentPanel.add(this.jLabel4);
        this.jLabel4.setBounds(410, 60, 310, 18);
        this.jScrollPane2.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jList1.setBackground(Color.darkGray);
        this.jList1.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 1));
        this.jList1.setFont(new Font("SansSerif", 0, 12));
        this.jList1.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jList1);
        this.contentPanel.add(this.jScrollPane2);
        this.jScrollPane2.setBounds(410, 290, 360, 190);
        this.jPanel1.setBackground(Color.darkGray);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel3.setBackground(Color.darkGray);
        this.jLabel3.setFont(new Font("SansSerif", 0, 12));
        this.jLabel3.setForeground(Color.lightGray);
        this.jLabel3.setVerticalAlignment(1);
        this.jLabel3.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 1));
        this.jPanel1.add((Component)this.jLabel3, "Center");
        this.contentPanel.add(this.jPanel1);
        this.jPanel1.setBounds(410, 90, 360, 100);
        this.add((Component)this.contentPanel, new GridBagConstraints());
    }

    private void loungeButtonActionPerformed(ActionEvent evt) {
        Container c = this.getParent();
        c.remove(this);
        c.add(this.spaceStationPanel);
        c.validate();
        c.repaint();
    }

    private void newsListValueChanged(ListSelectionEvent evt) {
        Object o = this.newsList.getSelectedValue();
        if (o != null) {
            QuestWrapper w = (QuestWrapper)o;
            Quest q = w.quest;
            this.jLabel3.setText(q.getQuestDetails());
        }
        this.acceptButton.setEnabled(o != null);
        this.declineButton.setEnabled(o != null);
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        Object o = this.newsList.getSelectedValue();
        if (o != null) {
            QuestWrapper w = (QuestWrapper)o;
            Quest quest = w.quest;
            Problem problem = quest.isAcceptable(this.ship);
            if (problem != Problem.NO_PROBLEM) {
                JOptionPane.showMessageDialog(this, problem.message);
            } else {
                boolean ok = quest.testSolved(this.galaxy, this.station, this.ship);
                if (ok) {
                    this.jLabel3.setText("");
                    quest.showSuccessMessage(this);
                } else {
                    this.ship.player.addQuest(quest);
                    DefaultListModel m = (DefaultListModel)this.jList1.getModel();
                    m.addElement(w);
                }
                DefaultListModel model = (DefaultListModel)this.newsList.getModel();
                model.removeElement(o);
            }
        }
    }

    private void buildOfferList(Galaxy galaxy, Solar station, Ship ship) {
        int day = ClockThread.getDayOfGame();
        Random rng = RandomHelper.createRNG((long)day + station.seed);
        List<Solar> settlements = galaxy.findSettlements(1, station.loca);
        Cargo cargo = TradePanel.createCargo(station);
        ArrayList<Good> rareGoods = new ArrayList<Good>();
        for (int i = 0; i < Good.Type.values().length; ++i) {
            if (cargo.goods[i].units != 0) continue;
            rareGoods.add(cargo.goods[i]);
        }
        DefaultListModel<QuestWrapper> model = new DefaultListModel<QuestWrapper>();
        Offering offering = new Offering(this.world, this.imageCache);
        model.addElement(new QuestWrapper(offering));
        int population = station.society.population + 1;
        for (Solar solar : settlements) {
            int n = rng.nextInt(6000 + 20000000 / population);
            int level = rng.nextInt(2000);
            Quest quest = null;
            if (n < 1100) {
                quest = new Delivery(level, solar);
                if (ship.player.getQuests().contains(quest)) {
                    quest = null;
                }
            } else if (n < 1200 && !rareGoods.isEmpty()) {
                Good good = (Good)rareGoods.get(rng.nextInt(rareGoods.size()));
                quest = cargo.illegalGoods[good.type.ordinal()] ? new WantedResource(-level / 2, solar, good) : new WantedResource(level, solar, good);
            }
            if (quest == null) continue;
            model.addElement(new QuestWrapper(quest));
        }
        this.newsList.setModel(model);
    }

    private void fillQuestsList(Ship ship) {
        DefaultListModel<QuestWrapper> model = new DefaultListModel<QuestWrapper>();
        for (Quest quest : ship.player.getQuests()) {
            QuestWrapper w = new QuestWrapper(quest);
            model.addElement(w);
        }
        this.jList1.setModel(model);
    }
}

