/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Graphics;
import solarex.ui.ImageCache;

public class HyperjumpPainter {
    private Color[] colors;
    private boolean active = false;
    private int time;
    private final ImageCache imageCache;

    public boolean isActive() {
        return this.active;
    }

    public boolean isDone() {
        return this.time > 3900;
    }

    public void start() {
        this.time = 0;
        this.active = true;
    }

    public void stop() {
        this.active = false;
    }

    public void moveJump(int deltaT) {
        this.time += deltaT;
    }

    public HyperjumpPainter(ImageCache imageCache) {
        this.imageCache = imageCache;
        this.colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float hue = 255.0f / (float)i;
            int rgb = Color.HSBtoRGB(hue, 1.0f, 0.95f);
            this.colors[i] = new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb >> 16 & 0xFF, 144);
        }
    }

    public void paint(Graphics gr, int width, int height) {
        gr.drawImage(this.imageCache.hyperspace.getImage(), 0, 0, width, height, null);
        for (int i = 0; i < 256; ++i) {
            gr.setColor(this.colors[i]);
            int dist = 1000 + i * 50 - this.time * 4;
            if (dist <= 0) continue;
            int radius = 10000 / dist;
            gr.drawOval(width / 2 - (radius + 10), height / 2 - (radius + 10), radius * 2 + 20, radius * 2 + 20);
            gr.drawOval(width / 2 - (radius + 5), height / 2 - (radius + 5), radius * 2 + 10, radius * 2 + 10);
            gr.drawOval(width / 2 - radius, height / 2 - radius, radius * 2, radius * 2);
        }
    }
}

