/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.JLabel;
import solarex.system.Solar;
import solarex.util.FontFactory;

public class BodyInfoLabel
extends JLabel {
    public BodyInfoLabel() {
        this.setVerticalAlignment(1);
        this.setOpaque(false);
        this.setForeground(Color.GREEN);
        Font font = FontFactory.getSmaller();
        this.setFont(font);
    }

    private double massToEarthMasses(double mass) {
        double earthMass = 5.974E21;
        return mass / 5.974E21;
    }

    private double massToSunMasses(double mass) {
        double sunMass = 1.989E27;
        double suns = mass / 1.989E27;
        return suns;
    }

    private double distanceToAU(double distance) {
        double earthDistance = 1.49597870691E8;
        return distance / 1.49597870691E8;
    }

    public void update(Solar body, boolean isExplored) {
        if (isExplored) {
            this.updateKnownBody(body);
        } else {
            this.updateStrangeBody(body);
        }
    }

    public void updateStrangeBody(Solar body) {
        String infoText = "<html>" + body.name + "<br>" + (body.btype == Solar.BodyType.SUN ? Solar.sunDescription[body.stype.ordinal()] : Solar.planetDescription[body.ptype.ordinal()]) + "<br>" + "Unexplored space body.<br>" + "No further data available." + "</html>";
        this.setText(infoText);
    }

    public void updateKnownBody(Solar body) {
        String nameLine;
        double m;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        String massStr = "";
        if (body.btype == Solar.BodyType.PLANET) {
            m = this.massToEarthMasses(body.mass);
            massStr = m < 1.0E-4 ? "Mass: <font color=white>" + nf.format(body.mass / 1000000.0) + " mt</font><br>" : "Mass: <font color=white>" + nf.format(m) + " earth masses</font><br>";
        } else if (body.btype == Solar.BodyType.SUN) {
            m = this.massToSunMasses(body.mass);
            massStr = "Mass: <font color=white>" + nf.format(m) + " sun masses</font><br>";
        }
        nf.setMaximumFractionDigits(2);
        String distanceStr = "";
        if (body.btype != Solar.BodyType.SUN && body.btype != Solar.BodyType.SPACEPORT) {
            double au = this.distanceToAU(body.orbit);
            distanceStr = au < 0.01 ? "Orbit: <font color=white>" + nf.format(body.orbit) + " km</font><br>" : "Orbit: <font color=white>" + nf.format(au) + " au</font><br>";
        }
        String popLine = "";
        if (body.society.population > 0) {
            nameLine = body.name + " - " + (Object)((Object)body.society.race);
            nf.setMaximumFractionDigits(0);
            int pop = body.society.population;
            popLine = pop < 1000 ? "Population: <font color=white>&lt;1000</font><br>" : (pop < 10000 ? "Population: <font color=white>&lt;10000</font><br>" : "Population: <font color=white>" + nf.format(pop / 1000 * 1000) + "</font><br>");
        } else {
            nameLine = body.name;
        }
        nf.setMaximumFractionDigits(2);
        String infoText = "<html>" + nameLine + "<br>" + (body.btype == Solar.BodyType.SUN ? Solar.sunDescription[body.stype.ordinal()] : Solar.planetDescription[body.ptype.ordinal()]) + "<br>" + popLine + "Radius: <font color=white>" + (body.btype == Solar.BodyType.STATION ? "&lt;1 km</font><br>" : nf.format(body.radius) + " km</font><br>") + massStr + (body.btype == Solar.BodyType.SUN ? "" : distanceStr + (body.btype == Solar.BodyType.PLANET ? "Temperature: <font color=white>" + body.eet + " Kelvin</font><br>" : "")) + "</html>";
        this.setText(infoText);
    }
}

