/*
 * Decompiled with CFR 0.152.
 */
package solarex.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import solarex.galaxy.SystemLocation;
import solarex.system.NameGenerator;
import solarex.system.Society;
import solarex.system.Vec3;
import solarex.util.RandomHelper;

public class Solar {
    public static final String[] planetDescription = new String[]{"A bare rock body", "An ice body", "A rock body with thin atmosphere", "A rock body with a dense atmosphere", "An earthlike planet", "A small gas giant", "A big gas giant", "A big planet with rings", "A carbon rich planet", "A space station", "A space port"};
    public static final String[] sunDescription = new String[]{"A medium size yellow star", "A small orange star", "A white dwarf star", "A red giant star", "A giant blue star", "A neutron star", "A stellar black hole", "A brown dwarf"};
    private static final double[] sunSurfaceTemperature = new double[]{6500.0, 5500.0, 100000.0, 5000.0, 12000.0, 1000000.0, 0.0, 1200.0};
    private static final double[] sunDensity = new double[]{1.408, 1.6, 1000000.0, 0.003, 0.1, 1100000.0, 1.1E15, 5.0};
    private static final double[] planetDensity = new double[]{5.427, 1.75, 3.933, 5.243, 5.515, 1.638, 1.326, 0.687, 4.0, 3.0};
    public final SystemLocation loca;
    private Solar parent;
    public ArrayList<Solar> children;
    public BodyType btype;
    public PlanetType ptype;
    public SunType stype;
    Random rng;
    public int radius;
    public double mass;
    public double orbit;
    public double rotationPeriod;
    public double orbitAngle;
    public Vec3 pos;
    public int eet;
    public String name;
    public String baseName;
    public Society society;
    public long seed;

    private double calcSunRadius(SunType type) {
        double rad;
        double mod = 0.5 - this.rng.nextDouble();
        double Ro = 695700.0;
        switch (type) {
            case S_YELLOW: {
                rad = 695700.0 * (1.0 + mod);
                break;
            }
            case S_ORANGE: {
                rad = 695700.0 * (1.0 + mod) / 2.0;
                break;
            }
            case S_BLUE_GIANT: {
                rad = 695700.0 * (1.0 + mod) * 5.0;
                break;
            }
            case S_RED_GIANT: {
                rad = 695700.0 * (1.0 + mod) * 15.0;
                break;
            }
            case S_WHITE_DWARF: {
                rad = 1390600.0 / (190.0 + 0.5 * mod * 110.0);
                break;
            }
            case S_NEUTRON: {
                rad = 11000.0 + 1000.0 * mod;
                break;
            }
            case S_BLACK_HOLE: {
                rad = 40.0 + 40.0 * mod;
                break;
            }
            case S_BROWN_DWARF: {
                rad = 120000.0 + 120000.0 * mod;
                break;
            }
            default: {
                rad = 1390600.0;
            }
        }
        return rad;
    }

    private static double calcVolume(double radius) {
        return Math.PI * 4 * radius * radius * radius / 3.0;
    }

    private static double calcPlanetMass(PlanetType ptype, double radius) {
        double v = Solar.calcVolume(radius);
        double mass = 1.0E9 * v * planetDensity[ptype.ordinal()];
        return mass;
    }

    private static double calcSunMass(SunType stype, double radius) {
        double v = Solar.calcVolume(radius);
        double m = v * sunDensity[stype.ordinal()];
        double mass = 1.0E9 * m;
        return mass;
    }

    private SunType randomSunType() {
        int[] weights = new int[]{16, 28, 12, 8, 4, 2, 1, 8};
        int index = RandomHelper.oneOfWeightedList(this.rng, weights);
        return SunType.values()[index];
    }

    final void calcPType() {
        this.ptype = PlanetType.BARE_ROCK;
        double temperatureFactor = 1.0;
        if (this.radius < 2500) {
            if (this.eet > 200) {
                if (this.rng.nextDouble() > 0.05) {
                    this.ptype = PlanetType.BARE_ROCK;
                    temperatureFactor = 0.9;
                } else {
                    this.ptype = PlanetType.GRAPHITE_ROCK;
                    temperatureFactor = 1.2;
                }
            } else {
                this.ptype = PlanetType.ICE;
                temperatureFactor = 0.8;
            }
        } else if (this.radius < 3600) {
            if (this.eet > 190) {
                if (this.rng.nextDouble() > 0.05) {
                    this.ptype = PlanetType.ATM_ROCK;
                } else {
                    this.ptype = PlanetType.GRAPHITE_ROCK;
                    temperatureFactor = 1.2;
                }
            } else {
                this.ptype = PlanetType.ICE;
            }
        } else if (this.radius < 12000) {
            if (this.rng.nextDouble() < 0.03) {
                this.ptype = PlanetType.GRAPHITE_ROCK;
                temperatureFactor = 1.2;
            } else if (this.eet > 275 && this.eet < 355) {
                if (this.rng.nextDouble() > 0.75) {
                    this.ptype = PlanetType.CLOUD;
                    temperatureFactor = 1.1;
                } else {
                    this.ptype = PlanetType.EARTH;
                }
            } else if (this.eet > 150 && this.eet < 800) {
                this.ptype = PlanetType.CLOUD;
                temperatureFactor = 1.2;
            } else {
                this.ptype = this.eet <= 150 ? PlanetType.ICE : PlanetType.BARE_ROCK;
            }
        } else if (this.radius < 30000) {
            this.ptype = PlanetType.SMALL_GAS;
            temperatureFactor = 1.15;
            if (this.rng.nextDouble() > 0.87) {
                if (this.eet > 150 && this.eet < 800) {
                    this.ptype = PlanetType.CLOUD;
                    temperatureFactor = 1.2;
                } else if (this.eet > 100) {
                    if (this.rng.nextDouble() < 0.03) {
                        this.ptype = PlanetType.GRAPHITE_ROCK;
                        temperatureFactor = 1.2;
                    } else {
                        this.ptype = PlanetType.ATM_ROCK;
                        temperatureFactor = 1.0;
                    }
                } else if (this.eet > 1200) {
                    this.ptype = PlanetType.BARE_ROCK;
                    temperatureFactor = 0.9;
                } else {
                    this.ptype = PlanetType.ICE;
                    temperatureFactor = 0.8;
                }
            }
        } else if (this.radius < 65000) {
            this.ptype = PlanetType.RINGS;
            temperatureFactor = 1.2;
            if (this.rng.nextDouble() > 0.88) {
                if (this.eet > 150 && this.eet < 800) {
                    this.ptype = PlanetType.CLOUD;
                    temperatureFactor = 1.2;
                } else if (this.eet > 100) {
                    if (this.rng.nextDouble() < 0.03) {
                        this.ptype = PlanetType.GRAPHITE_ROCK;
                        temperatureFactor = 1.2;
                    } else {
                        this.ptype = PlanetType.ATM_ROCK;
                        temperatureFactor = 1.0;
                    }
                } else if (this.eet > 1200) {
                    this.ptype = PlanetType.BARE_ROCK;
                    temperatureFactor = 0.9;
                } else {
                    this.ptype = PlanetType.ICE;
                    temperatureFactor = 0.8;
                }
            }
        } else {
            this.ptype = PlanetType.BIG_GAS;
            temperatureFactor = 1.5;
        }
        this.eet = (int)((double)this.eet * temperatureFactor);
        if (this.btype == BodyType.STATION) {
            this.ptype = PlanetType.STATION_1;
        }
    }

    private static double normverteilung(double x, double u, double s) {
        double e = Math.exp(-((x - u) * (x - u)) / (2.0 * s * s));
        double d = Math.sqrt(Math.PI * 2 * s * s);
        return e / d;
    }

    static double calcEET(SunType stype, double sun_rad, double sun_dist) {
        double area = sun_rad * sun_rad;
        double d2 = sun_dist * sun_dist;
        double t = sunSurfaceTemperature[stype.ordinal()];
        double t_in = t * area / d2 * 3.0E8;
        return Math.pow(t_in, 0.333333) + 25.0;
    }

    public Solar(Solar p, double minOrbit, int size, int number, int anz, BodyType aBtype) {
        double u;
        this.loca = p.loca;
        this.children = new ArrayList();
        this.pos = new Vec3();
        this.parent = p;
        this.rng = this.parent.rng;
        this.btype = aBtype;
        if (this.btype == BodyType.STATION) {
            this.name = "unnamed";
            this.ptype = PlanetType.STATION_1;
        } else {
            String base = this.parent.name.endsWith("Alpha") ? this.parent.name.substring(0, this.parent.name.length() - 6) : this.parent.name;
            this.name = base + " " + (number + 1);
        }
        double baseSize = Solar.normverteilung(number, (double)anz / 1.8, 1.5) * (double)size;
        this.radius = 493 + (int)(this.rng.nextDouble() * baseSize);
        this.orbit = minOrbit * 1.25 + this.rng.nextDouble() * (double)Math.min((long)minOrbit * 2L, 1000000000L);
        this.orbitAngle = u = this.rng.nextDouble() * 360.0 * Math.PI / 180.0;
        this.pos.x = Math.cos(u) * this.orbit;
        this.pos.y = Math.sin(u) * this.orbit;
        this.pos.z = 0.0;
        Solar the_sun = this;
        Vec3 zv = new Vec3();
        while (the_sun.parent != null) {
            zv.x += the_sun.pos.x;
            zv.y += the_sun.pos.y;
            zv.z += the_sun.pos.z;
            the_sun = the_sun.parent;
        }
        double sun_dist = Math.sqrt(zv.length2());
        this.eet = the_sun.children.size() > 0 && the_sun.children.get((int)0).btype == BodyType.SUN ? (int)Solar.calcEET(the_sun.stype, (double)the_sun.radius * 1.8, sun_dist) : (int)Solar.calcEET(the_sun.stype, the_sun.radius, sun_dist);
        this.calcPType();
        this.rotationPeriod = this.rng.nextGaussian() * 25.0 + 25.0;
        if (this.rotationPeriod < 4.0) {
            this.rotationPeriod = this.rng.nextDouble() * 24.0 * 365.0;
        }
        this.rotationPeriod *= 3600.0;
        this.mass = Solar.calcPlanetMass(this.ptype, this.radius);
        if (this.btype != BodyType.STATION && this.btype != BodyType.SPACEPORT && this.orbit > 15000.0 && this.radius > 2000) {
            if (this.rng.nextDouble() > 0.5) {
                int count = Math.min(5, (int)(this.rng.nextDouble() * (double)this.radius / 2000.0));
                double minRad = this.radius * 2;
                for (int i = 0; i < count; ++i) {
                    Solar planet = new Solar(this, minRad, this.radius / 2, i, count, BodyType.PLANET);
                    minRad = planet.orbit;
                    this.children.add(planet);
                }
            }
            double chance = Society.calcProbability(this.loca);
            if (this.rng.nextDouble() * 100.0 < 42.0 * chance) {
                Solar planet = new Solar(this, this.radius, this.radius / 4, 0, 1, BodyType.STATION);
                planet.radius /= 4;
                this.children.add(planet);
            }
        }
        this.seed = this.rng.nextLong();
    }

    public Solar getParent() {
        return this.parent;
    }

    public Solar root() {
        Solar root = this;
        for (Solar up = this.getParent(); up != null; up = up.getParent()) {
            root = up;
        }
        return root;
    }

    public Solar(SystemLocation loca, boolean create_children) {
        this.loca = loca;
        this.pos = new Vec3();
        this.children = new ArrayList();
        this.parent = null;
        this.rng = RandomHelper.createRNG();
        this.rng.setSeed(loca.systemSeed);
        this.stype = this.randomSunType();
        this.btype = BodyType.SUN;
        this.ptype = PlanetType.BARE_ROCK;
        this.baseName = this.name = NameGenerator.generateStarName(this.rng);
        this.radius = (int)this.calcSunRadius(this.stype);
        this.mass = Solar.calcSunMass(this.stype, this.radius);
        if (create_children) {
            int suns = (int)(this.rng.nextDouble() * 2.0);
            suns = this.createMultipleStars(suns, this.seed);
            int planets = 1 + (int)(this.rng.nextDouble() * 12.0);
            if (this.stype == SunType.S_BROWN_DWARF) {
                planets /= 5;
            } else if (this.stype == SunType.S_NEUTRON) {
                planets /= 6;
            } else if (this.stype == SunType.S_BLACK_HOLE) {
                planets /= 8;
            } else if (this.stype == SunType.S_BLUE_GIANT) {
                planets += (int)(this.rng.nextDouble() * 6.0);
                planets += (int)(this.rng.nextDouble() * 4.0);
            }
            double minRad = 36 * this.radius * (1 + suns);
            if (this.stype == SunType.S_WHITE_DWARF) {
                minRad *= 20.0;
            } else if (this.stype == SunType.S_NEUTRON) {
                minRad *= 1000.0;
            } else if (this.stype == SunType.S_BLACK_HOLE) {
                minRad *= 600000.0;
            } else if (this.stype == SunType.S_BLUE_GIANT && this.stype == SunType.S_RED_GIANT) {
                minRad *= 0.5;
            }
            this.createPlanets(planets, minRad);
        }
        this.seed = this.rng.nextLong();
    }

    private int createMultipleStars(int suns, long seed) {
        for (int i = 0; i < suns; ++i) {
            SunType[] options;
            switch (this.stype) {
                case S_BLUE_GIANT: {
                    options = new SunType[]{};
                    break;
                }
                case S_ORANGE: {
                    options = new SunType[]{SunType.S_ORANGE, SunType.S_WHITE_DWARF, SunType.S_BROWN_DWARF};
                    break;
                }
                case S_RED_GIANT: {
                    options = new SunType[]{SunType.S_YELLOW, SunType.S_ORANGE, SunType.S_WHITE_DWARF, SunType.S_BROWN_DWARF, SunType.S_NEUTRON};
                    break;
                }
                case S_WHITE_DWARF: {
                    options = new SunType[]{SunType.S_WHITE_DWARF, SunType.S_NEUTRON};
                    break;
                }
                case S_YELLOW: {
                    options = new SunType[]{SunType.S_YELLOW, SunType.S_ORANGE, SunType.S_WHITE_DWARF, SunType.S_BROWN_DWARF};
                    break;
                }
                case S_NEUTRON: 
                case S_BLACK_HOLE: 
                case S_BROWN_DWARF: {
                    options = new SunType[]{};
                    break;
                }
                default: {
                    options = new SunType[]{};
                }
            }
            if (options.length == 0) {
                suns = 0;
                continue;
            }
            SunType sunType = options[(int)(this.rng.nextDouble() * (double)options.length)];
            double sunRad = this.calcSunRadius(sunType);
            double factor = (double)this.radius / sunRad;
            factor = Math.min(0.95, factor * 0.8);
            sunRad *= factor;
            long oldSeed = this.loca.systemSeed;
            this.loca.systemSeed += 1234567890L;
            Solar sunBeta = new Solar(this.loca, false);
            this.loca.systemSeed = oldSeed;
            sunBeta.stype = sunType;
            sunBeta.radius = (int)sunRad;
            sunBeta.orbit = (sunRad + (double)this.radius) * 3.0;
            sunBeta.orbitAngle = 5.0;
            sunBeta.mass = Solar.calcSunMass(sunType, sunBeta.radius);
            sunBeta.pos.x = Math.cos(sunBeta.orbitAngle) * sunBeta.orbit;
            sunBeta.pos.y = Math.sin(sunBeta.orbitAngle) * sunBeta.orbit;
            sunBeta.pos.z = 0.0;
            this.children.add(sunBeta);
            this.baseName = this.name;
            sunBeta.name = this.name + " Beta";
            this.name = this.name + " Alpha";
        }
        return suns;
    }

    private void createPlanets(int planets, double minOrbit) {
        for (int i = 0; i < planets && minOrbit > 0.0; ++i) {
            Solar planet = new Solar(this, minOrbit, 380000, i, planets, BodyType.PLANET);
            minOrbit = planet.orbit;
            this.children.add(planet);
        }
    }

    public double calcSurfaceGravity() {
        double h = 6.674E-11;
        double m = this.mass * 1000.0;
        double r = this.radius * 1000;
        double gravity = 6.674E-11 * m / (r * r);
        return gravity;
    }

    public void listSettlements(List<Solar> list) {
        for (Solar body : this.children) {
            if (body.btype == BodyType.STATION || body.btype == BodyType.SPACEPORT) {
                list.add(body);
            }
            body.listSettlements(list);
        }
    }

    public Vec3 getAbsolutePosition() {
        Vec3 absPos = new Vec3(this.pos);
        for (Solar p = this.getParent(); p != null; p = p.getParent()) {
            absPos.add(p.pos);
        }
        return absPos;
    }

    public Solar findInRange(Vec3 point_pos, double maxRange) {
        Solar result;
        double range = 10.0;
        while ((result = this.findInRangeAux(point_pos, range)) == null && (range *= 10.0) < maxRange) {
        }
        return result;
    }

    private Solar findInRangeAux(Vec3 point_pos, double range) {
        Vec3 v = new Vec3(this.pos);
        v.sub(point_pos);
        Solar result = null;
        double dist = Math.sqrt(v.length2());
        if (dist < range) {
            range = dist;
            result = this;
        }
        Vec3 npos = new Vec3(point_pos);
        npos.sub(this.pos);
        for (int i = 0; i < this.children.size(); ++i) {
            Solar test = this.children.get(i).findInRangeAux(npos, range);
            if (test == null) continue;
            result = test;
        }
        return result;
    }

    public static enum SunType {
        S_YELLOW,
        S_ORANGE,
        S_WHITE_DWARF,
        S_RED_GIANT,
        S_BLUE_GIANT,
        S_NEUTRON,
        S_BLACK_HOLE,
        S_BROWN_DWARF;

    }

    public static enum PlanetType {
        BARE_ROCK,
        ICE,
        ATM_ROCK,
        CLOUD,
        EARTH,
        SMALL_GAS,
        BIG_GAS,
        RINGS,
        GRAPHITE_ROCK,
        STATION_1,
        SPACEPORT;

    }

    public static enum BodyType {
        SUN,
        PLANET,
        STATION,
        SPACEPORT;

    }
}

