/*
 * Decompiled with CFR 0.152.
 */
package solarex.system;

import java.util.Random;
import solarex.system.Society;

public class NameGenerator {
    private static final String[] starSyllables = new String[]{"a", "e", "i", "o", "u", "y", "al", "de", "gel", "ri", "be", "tei", "geu", "ze", "ge", "sil", "ste", "gro", "ker", "ti", "pel", "kon", "ons", "da", "tor", "se", "lie", "pe", "ben", "rei", "tur", "sel", "fie", "pam", "mer", "ni", "dri", "zin", "art", "wer", "den", "ke", "an", "sam", "ren", "di", "ma", "bar", "wei", "tel", "big", "ra", "ver", "mi", "ro", "la", "re", "zep", "tor", "tak", "ker", "ve", "der", "ri", "bo", "nis", "ta", "si", "min", "us", "run"};
    private static final String[] planetSyllables = new String[]{"a", "e", "i", "o", "u", "y", "mer", "cur", "ius", "ve", "nus", "ter", "ra", "ma", "rs", "ju", "pi", "nep", "tun", "ra", "plu", "to", "cha", "ron", "en", "ca", "le", "dus", "mi", "ran", "da", "ga", "ny", "med", "ti", "tan"};
    private static final String[] persons = new String[]{"Kopernikus", "Brahe", "Kepler", "Galilei", "Scheiner", "Huygens", "Cassini", "Halley", "Newton", "Messier", "Herschel", "Olbers", "Bessel", "Struve", "Schwabe", "Fizeau", "Foucault", "Leverrier", "Kirchhoff", "Schiaparelli", "Pickering", "Hale", "Wolf", "Kapteyn", "Leavitt", "Russel", "Einstein", "Curtis", "Eddington", "Hubble", "Tombaugh", "Lyot", "Jansky", "Oort", "Van Allen", "Bell", "Hooke", "Abbot", "Adams", "Agrippa", "Anderson", "Yuzhe", "Chongzhi", "Zwicky", "Young", "Wirtanen", "Westphal", "Whitford", "Vyssotsky", "Turner", "Song", "Suntzeff", "Steinheil", "Shoemaker", "Seyfert", "Chandra", "Peltier", "Piazzi", "Newcomb", "Mayer", "Mitchell", "Laplace", "Hansen", "Graham", "Goldberg", "Delaunay", "Denning", "Dyson", "Encke", "Gauss"};
    private static final String[] personsFloat = new String[]{"Aweio", "Uiomya", "Eeiadma", "Meowia", "Saulee", "Liyrino", "Aeiwouu", "Oiuuui", "Uiaoow", "Yiawou", "Uioaowaa", "Oouwuush", "Shooowa", "Geeshuuu", "Eemyuio", "Maowiee", "Sasaa", "Nouwaa", "Youush", "Saamaana", "Woumea", "Laamao", "Yiyowou", "Oulou", "Eemeea", "Neaowo", "Dlawee", "Jouwaa", "Yioyo", "Yee", "Daa", "Noua", "Ouwo", "Anou"};
    private static final String[] personsRock = new String[]{"Zkrmths", "Krtbrgd", "Prtsngra", "Drptwrt", "Krimprbt", "Tikimkrt", "Grtkrdrg", "Msntkrms", "Raknrtsk", "Zik", "Pst", "Krkro", "Snurkt", "Smargd", "Rkrit", "Tsikrk", "Catrmt", "Mgrek", "Grtok", "Raktrk", "Snrkit", "Prekrk", "Krkrtik", "Aktraps", "Zigzik", "Tict", "Pritr", "Zrn", "Aktr", "Emptk", "Krark", "Kikr", "Krtki"};
    private static final String[] personsBreath = new String[]{"Altramer", "Shetan", "Soanow", "Meroweni", "Parledo", "Winniwo", "Lamerat", "Poilygun", "Ferator", "Varioni", "Germigo", "Farantor", "Tormeg", "Megmeg", "Liawisu", "Ferontea", "Salabero", "Ergota", "Wowanoui", "Wykikro", "Zirmonag", "Mermimg", "Korwang", "Fremong", "Garawen", "Pelogon", "Diamana", "Dreogar", "Lonamer"};
    private static final String[] stations = new String[]{"Depot", "Station", "Habitat", "Structure", "Fort", "Outpost", "Lookout", "Spindle", "Wheel", "Box"};
    private static final String[] ports = new String[]{"Depot", "Transfer", "Main", "Central", "City", "Habitat", "Complex", "Port", "Structure", "Fort", "Outpost", "Lookout", "Starport", "Spaceport", "Branch", "Field", "Dock", "Launchpad", "Kontor", "Base"};

    private static String generateNameFromSyllables(Random rng, String[] syllables) {
        int n = 2 + rng.nextInt(2);
        StringBuffer buf = new StringBuffer();
        int lastSyllable = -1;
        for (int i = 0; i < n; ++i) {
            int syllable;
            do {
                syllable = rng.nextInt(syllables.length);
            } while (lastSyllable < 6 && syllable == lastSyllable);
            buf.append(syllables[syllable]);
            lastSyllable = syllable;
            if (i != 0 || rng.nextInt(17) > 2) continue;
            buf.append('\'');
        }
        String name = buf.toString();
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    public static String generateStarName(Random rng) {
        return NameGenerator.generateNameFromSyllables(rng, starSyllables);
    }

    public static String generatePlanetName(Random rng) {
        return NameGenerator.generateNameFromSyllables(rng, planetSyllables);
    }

    public static String generateStationName(Random rng) {
        StringBuffer buf = new StringBuffer();
        int desc = rng.nextInt(stations.length);
        int person = rng.nextInt(persons.length);
        if (desc < 3) {
            buf.append(persons[person]);
            buf.append(" ");
            buf.append(stations[desc]);
        } else {
            buf.append(stations[desc]);
            buf.append(" ");
            buf.append(persons[person]);
        }
        return buf.toString();
    }

    public static String generateStationName(Random rng, Society.Race race) {
        StringBuffer buf = new StringBuffer();
        int desc = rng.nextInt(stations.length);
        String person = race == Society.Race.Clonkniks ? "" + (char)(65 + rng.nextInt(26)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) : (race == Society.Race.Floatees ? personsFloat[rng.nextInt(personsFloat.length)] : (race == Society.Race.Poisonbreathers ? personsBreath[rng.nextInt(personsBreath.length)] : (race == Society.Race.Rockeaters ? personsRock[rng.nextInt(personsRock.length)] : persons[rng.nextInt(persons.length)])));
        if (desc < 3) {
            buf.append(person);
            buf.append(" ");
            buf.append(stations[desc]);
        } else {
            buf.append(stations[desc]);
            buf.append(" ");
            buf.append(person);
        }
        return buf.toString();
    }

    public static String generateSpaceportName(Random rng, Society.Race race) {
        StringBuffer buf = new StringBuffer();
        int desc = rng.nextInt(ports.length);
        String person = race == Society.Race.Clonkniks ? "" + (char)(65 + rng.nextInt(26)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) + (char)(48 + rng.nextInt(9)) : (race == Society.Race.Floatees ? personsFloat[rng.nextInt(personsFloat.length)] : (race == Society.Race.Poisonbreathers ? personsBreath[rng.nextInt(personsBreath.length)] : (race == Society.Race.Rockeaters ? personsRock[rng.nextInt(personsRock.length)] : persons[rng.nextInt(persons.length)])));
        if (desc < 7) {
            buf.append(person);
            buf.append(" ");
            buf.append(ports[desc]);
        } else {
            buf.append(ports[desc]);
            buf.append(" ");
            buf.append(person);
        }
        return buf.toString();
    }
}

