/*
 * Decompiled with CFR 0.152.
 */
package solarex.quest;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JOptionPane;
import solarex.galaxy.Galaxy;
import solarex.galaxy.SystemLocation;
import solarex.quest.Quest;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.util.Problem;

public class Delivery
implements Quest {
    private String successMessage;
    private String message;
    private String htmlMessage;
    private int price;
    private int requiredCapacity;
    private SystemLocation loca;

    public Delivery(BufferedReader reader) throws IOException {
        this.load(reader);
    }

    public Delivery(int level, Solar where) {
        this.loca = where.loca;
        Solar root = where.root();
        String name = root.baseName;
        if (level < 200) {
            this.message = "Group passage to " + where.name + " in system " + name + " wanted.";
            this.price = 500 + level;
            this.price -= this.price % 10;
            this.htmlMessage = "<html><font color='#BBEEBB'>&nbsp;" + this.message + "</font></html>";
            this.successMessage = "Thank you for bringing us to " + where.name + ".";
            this.requiredCapacity = 3 + level / 50;
        } else if (level < 500) {
            this.message = "Two passengers to " + where.name + " in system " + name + ".";
            this.price = 200 + (level - 200) / 2;
            this.price -= this.price % 5;
            this.htmlMessage = "<html><font color='#BBEEBB'>&nbsp;" + this.message + "</font></html>";
            this.successMessage = "Thank you for bringing us to " + where.name + ".";
            this.requiredCapacity = 2;
        } else if (level < 1500) {
            this.message = "Passage to " + where.name + " in system " + name + " wanted.";
            this.price = 100 + (level - 500) / 5;
            this.price -= this.price % 5;
            this.htmlMessage = "<html><font color='#BBEEBB'>&nbsp;" + this.message + "</font></html>";
            this.successMessage = "Thank you for bringing me to " + where.name + ".";
            this.requiredCapacity = 1;
        } else {
            this.price = 30 + (level - 1500) / 12;
            String m = this.price < 40 ? "Small parcel to " + where.name + " in system " + name + "." : (this.price > 55 ? "Large parcel to " + where.name + " in system " + name + "." : "Parcel to " + where.name + " in system " + name + ".");
            this.htmlMessage = "<html><font color='#BBBBFF'>&nbsp;" + m + "</font></html>";
            this.message = m;
            this.successMessage = "Thank you for delivering the parcel to " + where.name + ".";
            this.requiredCapacity = 0;
        }
    }

    @Override
    public String getQuestHeadline() {
        return this.htmlMessage;
    }

    @Override
    public String getQuestDetails() {
        return "<html>&nbsp;" + this.message + "<br><br>" + "&nbsp;Group size: <font color='#FFFFFF'>" + this.requiredCapacity + "</font>" + "<br>" + "&nbsp;Offer: <font color='#FFFFFF'>" + this.price + " Cr</font></html>";
    }

    @Override
    public Problem isAcceptable(Ship ship) {
        Problem result = Problem.NO_PROBLEM;
        if (ship.equipment.getPassengerCapacity() < this.requiredCapacity) {
            result = new Problem(1, "Your ship doesn't have enough free passenger cabins.");
        }
        return result;
    }

    @Override
    public boolean testSolved(Galaxy galaxy, Solar station, Ship ship) {
        boolean ok;
        boolean bl = ok = station != null && this.loca.equals(station.loca);
        if (ok) {
            ship.cargo.money += (double)this.price;
        }
        return ok;
    }

    @Override
    public void save(Writer writer) throws IOException {
        writer.write("<Deliveryquest>\n");
        writer.write("<version>1</version>\n");
        writer.write("<price>" + this.price + "</price>\n");
        writer.write("<s>" + this.successMessage + "</s>\n");
        writer.write("<s>" + this.htmlMessage + "</s>\n");
        writer.write("<s>" + this.message + "</s>\n");
        this.loca.save(writer);
        writer.write("</Deliveryquest>\n");
    }

    @Override
    public final void load(BufferedReader reader) throws IOException {
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        this.price = Integer.parseInt(tmp.substring(7, tmp.length() - 8));
        tmp = reader.readLine();
        this.successMessage = tmp.substring(3, tmp.length() - 4);
        tmp = reader.readLine();
        this.htmlMessage = tmp.substring(3, tmp.length() - 4);
        tmp = reader.readLine();
        this.message = tmp.substring(3, tmp.length() - 4);
        this.loca = new SystemLocation();
        this.loca.load(reader);
        reader.readLine();
    }

    @Override
    public void showSuccessMessage(Component component) {
        JOptionPane.showMessageDialog(component, this.successMessage + "\n" + "The " + this.price + " Cr have been transferred to your account.");
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Delivery) {
            Delivery other = (Delivery)o;
            return this.requiredCapacity == other.requiredCapacity && this.message.equals(other.message) && this.loca.equals(other.loca);
        }
        return false;
    }
}

