/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import micropolisj.engine.CityLocation;
import micropolisj.engine.CityProblem;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.Sound;
import micropolisj.gui.MainWindow;

public class EvaluationPane
extends JPanel
implements Micropolis.Listener {
    Micropolis engine;
    JLabel yesLbl;
    JLabel noLbl;
    JLabel[] voterProblemLbl;
    JLabel[] voterCountLbl;
    JLabel popLbl;
    JLabel deltaLbl;
    JLabel assessLbl;
    JLabel cityClassLbl;
    JLabel gameLevelLbl;
    JLabel scoreLbl;
    JLabel scoreDeltaLbl;
    static ResourceBundle cstrings = ResourceBundle.getBundle("micropolisj.CityStrings");
    static ResourceBundle gstrings = MainWindow.strings;

    public EvaluationPane(Micropolis _engine) {
        super(new BorderLayout());
        JButton dismissBtn = new JButton(gstrings.getString("dismiss-evaluation"));
        dismissBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EvaluationPane.this.onDismissClicked();
            }
        });
        this.add((Component)dismissBtn, "South");
        Box b1 = new Box(0);
        this.add((Component)b1, "Center");
        b1.add(this.makePublicOpinionPane());
        b1.add(new JSeparator(1));
        b1.add(this.makeStatisticsPane());
        assert (_engine != null);
        this.setEngine(_engine);
    }

    public void setEngine(Micropolis newEngine) {
        if (this.engine != null) {
            this.engine.removeListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addListener(this);
            this.loadEvaluation();
        }
    }

    private void onDismissClicked() {
        this.setVisible(false);
    }

    private JComponent makePublicOpinionPane() {
        JPanel me = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        GridBagConstraints c3 = new GridBagConstraints();
        c1.gridy = 0;
        c1.gridx = 0;
        c1.gridwidth = 2;
        c1.gridheight = 1;
        c1.weightx = 1.0;
        c1.fill = 0;
        c1.anchor = 11;
        JLabel headerLbl = new JLabel(gstrings.getString("public-opinion"));
        Font curFont = headerLbl.getFont();
        headerLbl.setFont(curFont.deriveFont(curFont.getStyle() | 1, (float)((double)curFont.getSize() * 1.2)));
        me.add((Component)headerLbl, c1);
        c1.gridy = 1;
        c1.insets = new Insets(3, 0, 3, 0);
        me.add((Component)new JLabel(gstrings.getString("public-opinion-1")), c1);
        c1.gridy = 4;
        me.add((Component)new JLabel(gstrings.getString("public-opinion-2")), c1);
        c2.gridx = 0;
        c2.gridy = 2;
        c2.gridheight = 1;
        c2.gridwidth = 1;
        c2.weightx = 1.0;
        c2.anchor = 13;
        c2.insets = new Insets(0, 0, 0, 4);
        me.add((Component)new JLabel(gstrings.getString("public-opinion-yes")), c2);
        c2.gridy = 3;
        me.add((Component)new JLabel(gstrings.getString("public-opinion-no")), c2);
        c3.gridx = 1;
        c3.gridheight = 1;
        c3.gridwidth = 1;
        c3.weightx = 1.0;
        c3.anchor = 17;
        c3.insets = new Insets(0, 4, 0, 0);
        c3.gridy = 2;
        this.yesLbl = new JLabel();
        me.add((Component)this.yesLbl, c3);
        c3.gridy = 3;
        this.noLbl = new JLabel();
        me.add((Component)this.noLbl, c3);
        c3.gridy = 5;
        c2.gridy = 5;
        int NUM_PROBS = 4;
        this.voterProblemLbl = new JLabel[4];
        this.voterCountLbl = new JLabel[4];
        for (int i = 0; i < 4; ++i) {
            this.voterProblemLbl[i] = new JLabel();
            me.add((Component)this.voterProblemLbl[i], c2);
            this.voterCountLbl[i] = new JLabel();
            me.add((Component)this.voterCountLbl[i], c3);
            c2.gridy = ++c3.gridy;
        }
        c1.gridy = 999;
        c1.weighty = 1.0;
        me.add((Component)new JLabel(), c1);
        return me;
    }

    private JComponent makeStatisticsPane() {
        JPanel me = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        GridBagConstraints c3 = new GridBagConstraints();
        c1.gridy = 0;
        c1.gridx = 0;
        c1.gridwidth = 2;
        c1.gridheight = 1;
        c1.weightx = 1.0;
        c1.fill = 0;
        c1.anchor = 11;
        c1.insets = new Insets(0, 0, 3, 0);
        JLabel headerLbl = new JLabel(gstrings.getString("statistics-head"));
        Font curFont = headerLbl.getFont();
        headerLbl.setFont(curFont.deriveFont(curFont.getStyle() | 1, (float)((double)curFont.getSize() * 1.2)));
        me.add((Component)headerLbl, c1);
        c1.gridy = 20;
        c1.insets = new Insets(9, 0, 3, 0);
        c1.fill = 3;
        JLabel header2Lbl = new JLabel(gstrings.getString("city-score-head"));
        me.add((Component)header2Lbl, c1);
        c2.gridx = 0;
        c2.gridheight = 1;
        c2.gridwidth = 1;
        c2.weightx = 0.5;
        c2.anchor = 13;
        c2.insets = new Insets(0, 0, 0, 4);
        c3.gridx = 1;
        c3.gridheight = 1;
        c3.gridwidth = 1;
        c3.weightx = 0.5;
        c3.anchor = 17;
        c3.insets = new Insets(0, 4, 0, 0);
        c3.gridy = 1;
        c2.gridy = 1;
        me.add((Component)new JLabel(gstrings.getString("stats-population")), c2);
        this.popLbl = new JLabel();
        me.add((Component)this.popLbl, c3);
        ++c3.gridy;
        c2.gridy = c3.gridy++;
        me.add((Component)new JLabel(gstrings.getString("stats-net-migration")), c2);
        this.deltaLbl = new JLabel();
        me.add((Component)this.deltaLbl, c3);
        c2.gridy = c3.gridy++;
        me.add((Component)new JLabel(gstrings.getString("stats-last-year")), c2);
        c2.gridy = c3.gridy++;
        me.add((Component)new JLabel(gstrings.getString("stats-assessed-value")), c2);
        this.assessLbl = new JLabel();
        me.add((Component)this.assessLbl, c3);
        c2.gridy = c3.gridy++;
        me.add((Component)new JLabel(gstrings.getString("stats-category")), c2);
        this.cityClassLbl = new JLabel();
        me.add((Component)this.cityClassLbl, c3);
        c2.gridy = c3.gridy;
        me.add((Component)new JLabel(gstrings.getString("stats-game-level")), c2);
        this.gameLevelLbl = new JLabel();
        me.add((Component)this.gameLevelLbl, c3);
        c3.gridy = 21;
        c2.gridy = 21;
        me.add((Component)new JLabel(gstrings.getString("city-score-current")), c2);
        this.scoreLbl = new JLabel();
        me.add((Component)this.scoreLbl, c3);
        c2.gridy = ++c3.gridy;
        me.add((Component)new JLabel(gstrings.getString("city-score-change")), c2);
        this.scoreDeltaLbl = new JLabel();
        me.add((Component)this.scoreDeltaLbl, c3);
        c1.gridy = 999;
        c1.weighty = 1.0;
        c1.insets = new Insets(0, 0, 0, 0);
        me.add((Component)new JLabel(), c1);
        return me;
    }

    @Override
    public void cityMessage(MicropolisMessage message, CityLocation loc) {
    }

    @Override
    public void citySound(Sound sound, CityLocation loc) {
    }

    @Override
    public void censusChanged() {
    }

    @Override
    public void demandChanged() {
    }

    @Override
    public void fundsChanged() {
    }

    @Override
    public void optionsChanged() {
    }

    @Override
    public void evaluationChanged() {
        this.loadEvaluation();
    }

    private void loadEvaluation() {
        NumberFormat pctFmt = NumberFormat.getPercentInstance();
        this.yesLbl.setText(pctFmt.format(0.01 * (double)this.engine.evaluation.cityYes));
        this.noLbl.setText(pctFmt.format(0.01 * (double)this.engine.evaluation.cityNo));
        for (int i = 0; i < this.voterProblemLbl.length; ++i) {
            int numVotes;
            CityProblem p = i < this.engine.evaluation.problemOrder.length ? this.engine.evaluation.problemOrder[i] : null;
            int n = numVotes = p != null ? this.engine.evaluation.problemVotes.get((Object)p) : 0;
            if (numVotes != 0) {
                this.voterProblemLbl[i].setText(cstrings.getString("problem." + p.name()));
                this.voterCountLbl[i].setText(pctFmt.format(0.01 * (double)numVotes));
                this.voterProblemLbl[i].setVisible(true);
                this.voterCountLbl[i].setVisible(true);
                continue;
            }
            this.voterProblemLbl[i].setVisible(false);
            this.voterCountLbl[i].setVisible(false);
        }
        NumberFormat nf = NumberFormat.getInstance();
        this.popLbl.setText(nf.format(this.engine.evaluation.cityPop));
        this.deltaLbl.setText(nf.format(this.engine.evaluation.deltaCityPop));
        this.assessLbl.setText(MainWindow.formatFunds(this.engine.evaluation.cityAssValue));
        this.cityClassLbl.setText(EvaluationPane.getCityClassName(this.engine.evaluation.cityClass));
        this.gameLevelLbl.setText(EvaluationPane.getGameLevelName(this.engine.gameLevel));
        this.scoreLbl.setText(nf.format(this.engine.evaluation.cityScore));
        this.scoreDeltaLbl.setText(nf.format(this.engine.evaluation.deltaCityScore));
    }

    static String getCityClassName(int cityClass) {
        return cstrings.getString("class." + cityClass);
    }

    static String getGameLevelName(int gameLevel) {
        return cstrings.getString("level." + gameLevel);
    }
}

