/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.Sound;
import micropolisj.gui.MicropolisDrawingArea;

public class DemandIndicator
extends JComponent
implements Micropolis.Listener {
    Micropolis engine;
    static final BufferedImage backgroundImage = DemandIndicator.loadImage("/demandg.png");
    static final Dimension MY_SIZE = new Dimension(backgroundImage.getWidth(), backgroundImage.getHeight());
    static final int UPPER_EDGE = 19;
    static final int LOWER_EDGE = 28;
    static final int MAX_LENGTH = 16;
    static final int RES_LEFT = 8;
    static final int COM_LEFT = 17;
    static final int IND_LEFT = 26;
    static final int BAR_WIDTH = 6;

    public void setEngine(Micropolis newEngine) {
        if (this.engine != null) {
            this.engine.removeListener(this);
        }
        this.engine = newEngine;
        if (this.engine != null) {
            this.engine.addListener(this);
        }
        this.repaint();
    }

    static BufferedImage loadImage(String resourceName) {
        URL iconUrl = MicropolisDrawingArea.class.getResource(resourceName);
        Image refImage = new ImageIcon(iconUrl).getImage();
        BufferedImage bi = new BufferedImage(refImage.getWidth(null), refImage.getHeight(null), 1);
        Graphics2D gr = bi.createGraphics();
        gr.drawImage(refImage, 0, 0, null);
        return bi;
    }

    @Override
    public Dimension getMinimumSize() {
        return MY_SIZE;
    }

    @Override
    public Dimension getPreferredSize() {
        return MY_SIZE;
    }

    @Override
    public Dimension getMaximumSize() {
        return MY_SIZE;
    }

    @Override
    public void paintComponent(Graphics gr1) {
        int comValve;
        Graphics2D gr = (Graphics2D)gr1;
        gr.drawImage((Image)backgroundImage, 0, 0, null);
        if (this.engine == null) {
            return;
        }
        int resValve = this.engine.getResValve();
        int ry0 = resValve <= 0 ? 28 : 19;
        int ry1 = ry0 - resValve / 100;
        if (ry1 - ry0 > 16) {
            ry1 = ry0 + 16;
        }
        if (ry1 - ry0 < -16) {
            ry1 = ry0 - 16;
        }
        int cy0 = (comValve = this.engine.getComValve()) <= 0 ? 28 : 19;
        int cy1 = cy0 - comValve / 100;
        int indValve = this.engine.getIndValve();
        int iy0 = indValve <= 0 ? 28 : 19;
        int iy1 = iy0 - indValve / 100;
        if (ry0 != ry1) {
            Rectangle resRect = new Rectangle(8, Math.min(ry0, ry1), 6, Math.abs(ry1 - ry0));
            gr.setColor(Color.GREEN);
            gr.fill(resRect);
            gr.setColor(Color.BLACK);
            gr.draw(resRect);
        }
        if (cy0 != cy1) {
            Rectangle comRect = new Rectangle(17, Math.min(cy0, cy1), 6, Math.abs(cy1 - cy0));
            gr.setColor(Color.BLUE);
            gr.fill(comRect);
            gr.setColor(Color.BLACK);
            gr.draw(comRect);
        }
        if (iy0 != iy1) {
            Rectangle indRect = new Rectangle(26, Math.min(iy0, iy1), 6, Math.abs(iy1 - iy0));
            gr.setColor(Color.YELLOW);
            gr.fill(indRect);
            gr.setColor(Color.BLACK);
            gr.draw(indRect);
        }
    }

    @Override
    public void demandChanged() {
        this.repaint();
    }

    @Override
    public void cityMessage(MicropolisMessage m, CityLocation p) {
    }

    @Override
    public void citySound(Sound sound, CityLocation p) {
    }

    @Override
    public void censusChanged() {
    }

    @Override
    public void evaluationChanged() {
    }

    @Override
    public void fundsChanged() {
    }

    @Override
    public void optionsChanged() {
    }
}

