/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityLocation;
import micropolisj.engine.CityRect;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisTool;
import micropolisj.engine.TileConstants;
import micropolisj.engine.TileSpec;
import micropolisj.engine.Tiles;
import micropolisj.engine.ToolEffect;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.ToolPreview;
import micropolisj.engine.ToolResult;
import micropolisj.engine.TranslatedToolEffect;

public class ToolStroke {
    final Micropolis city;
    final MicropolisTool tool;
    int xpos;
    int ypos;
    int xdest;
    int ydest;
    boolean inPreview;

    ToolStroke(Micropolis city, MicropolisTool tool, int xpos, int ypos) {
        this.city = city;
        this.tool = tool;
        this.xpos = xpos;
        this.ypos = ypos;
        this.xdest = xpos;
        this.ydest = ypos;
    }

    public final ToolPreview getPreview() {
        ToolEffect eff = new ToolEffect(this.city);
        this.inPreview = true;
        try {
            this.applyArea(eff);
        }
        finally {
            this.inPreview = false;
        }
        return eff.preview;
    }

    public final ToolResult apply() {
        ToolEffect eff = new ToolEffect(this.city);
        this.applyArea(eff);
        return eff.apply();
    }

    protected void applyArea(ToolEffectIfc eff) {
        CityRect r = this.getBounds();
        for (int i = 0; i < r.height; i += this.tool.getHeight()) {
            for (int j = 0; j < r.width; j += this.tool.getWidth()) {
                this.apply1(new TranslatedToolEffect(eff, r.x + j, r.y + i));
            }
        }
    }

    boolean apply1(ToolEffectIfc eff) {
        switch (this.tool) {
            case PARK: {
                return this.applyParkTool(eff);
            }
            case RESIDENTIAL: {
                return this.applyZone(eff, 244);
            }
            case COMMERCIAL: {
                return this.applyZone(eff, 427);
            }
            case INDUSTRIAL: {
                return this.applyZone(eff, 616);
            }
        }
        throw new Error("unexpected tool: " + (Object)((Object)this.tool));
    }

    public void dragTo(int xdest, int ydest) {
        this.xdest = xdest;
        this.ydest = ydest;
    }

    public CityRect getBounds() {
        CityRect r = new CityRect();
        r.x = this.xpos;
        if (this.tool.getWidth() >= 3) {
            --r.x;
        }
        if (this.xdest >= this.xpos) {
            r.width = ((this.xdest - this.xpos) / this.tool.getWidth() + 1) * this.tool.getWidth();
        } else {
            r.width = ((this.xpos - this.xdest) / this.tool.getWidth() + 1) * this.tool.getHeight();
            r.x += this.tool.getWidth() - r.width;
        }
        r.y = this.ypos;
        if (this.tool.getHeight() >= 3) {
            --r.y;
        }
        if (this.ydest >= this.ypos) {
            r.height = ((this.ydest - this.ypos) / this.tool.getHeight() + 1) * this.tool.getHeight();
        } else {
            r.height = ((this.ypos - this.ydest) / this.tool.getHeight() + 1) * this.tool.getHeight();
            r.y += this.tool.getHeight() - r.height;
        }
        return r;
    }

    public CityLocation getLocation() {
        return new CityLocation(this.xpos, this.ypos);
    }

    boolean applyZone(ToolEffectIfc eff, int base) {
        assert (TileConstants.isZoneCenter(base));
        TileSpec.BuildingInfo bi = Tiles.get(base).getBuildingInfo();
        if (bi == null) {
            throw new Error("Cannot applyZone to #" + base);
        }
        int cost = this.tool.getToolCost();
        boolean canBuild = true;
        for (int rowNum = 0; rowNum < bi.height; ++rowNum) {
            for (int columnNum = 0; columnNum < bi.width; ++columnNum) {
                int tileValue = eff.getTile(columnNum, rowNum);
                if ((tileValue &= 0x3FF) == 0) continue;
                if (this.city.autoBulldoze && TileConstants.canAutoBulldozeZ((char)tileValue)) {
                    ++cost;
                    continue;
                }
                canBuild = false;
            }
        }
        if (!canBuild) {
            eff.toolResult(ToolResult.UH_OH);
            return false;
        }
        eff.spend(cost);
        int i = 0;
        for (int rowNum = 0; rowNum < bi.height; ++rowNum) {
            for (int columnNum = 0; columnNum < bi.width; ++columnNum) {
                eff.setTile(columnNum, rowNum, (char)bi.members[i]);
                ++i;
            }
        }
        this.fixBorder(eff, bi.width, bi.height);
        return true;
    }

    void fixBorder(int left, int top, int right, int bottom) {
        ToolEffect eff = new ToolEffect(this.city, left, top);
        this.fixBorder(eff, right + 1 - left, bottom + 1 - top);
        eff.apply();
    }

    void fixBorder(ToolEffectIfc eff, int width, int height) {
        for (int x = 0; x < width; ++x) {
            this.fixZone(new TranslatedToolEffect(eff, x, 0));
            this.fixZone(new TranslatedToolEffect(eff, x, height - 1));
        }
        for (int y = 1; y < height - 1; ++y) {
            this.fixZone(new TranslatedToolEffect(eff, 0, y));
            this.fixZone(new TranslatedToolEffect(eff, width - 1, y));
        }
    }

    boolean applyParkTool(ToolEffectIfc eff) {
        int cost = this.tool.getToolCost();
        if (eff.getTile(0, 0) != 0) {
            if (!this.city.autoBulldoze) {
                eff.toolResult(ToolResult.UH_OH);
                return false;
            }
            if (TileConstants.isRubble(eff.getTile(0, 0))) {
                ++cost;
            } else {
                eff.toolResult(ToolResult.UH_OH);
                return false;
            }
        }
        int z = this.inPreview ? 0 : this.city.PRNG.nextInt(5);
        int tile = z < 4 ? 40 + z : 840;
        eff.spend(cost);
        eff.setTile(0, 0, tile);
        return true;
    }

    protected void fixZone(int xpos, int ypos) {
        ToolEffect eff = new ToolEffect(this.city, xpos, ypos);
        this.fixZone(eff);
        eff.apply();
    }

    protected void fixZone(ToolEffectIfc eff) {
        this.fixSingle(eff);
        this.fixSingle(new TranslatedToolEffect(eff, 0, -1));
        this.fixSingle(new TranslatedToolEffect(eff, -1, 0));
        this.fixSingle(new TranslatedToolEffect(eff, 1, 0));
        this.fixSingle(new TranslatedToolEffect(eff, 0, 1));
    }

    private void fixSingle(ToolEffectIfc eff) {
        int tile = eff.getTile(0, 0);
        if (TileConstants.isRoadDynamic(tile)) {
            int adjTile = 0;
            if (TileConstants.roadConnectsSouth(eff.getTile(0, -1))) {
                adjTile |= 1;
            }
            if (TileConstants.roadConnectsWest(eff.getTile(1, 0))) {
                adjTile |= 2;
            }
            if (TileConstants.roadConnectsNorth(eff.getTile(0, 1))) {
                adjTile |= 4;
            }
            if (TileConstants.roadConnectsEast(eff.getTile(-1, 0))) {
                adjTile |= 8;
            }
            eff.setTile(0, 0, TileConstants.RoadTable[adjTile]);
        } else if (TileConstants.isRailDynamic(tile)) {
            int adjTile = 0;
            if (TileConstants.railConnectsSouth(eff.getTile(0, -1))) {
                adjTile |= 1;
            }
            if (TileConstants.railConnectsWest(eff.getTile(1, 0))) {
                adjTile |= 2;
            }
            if (TileConstants.railConnectsNorth(eff.getTile(0, 1))) {
                adjTile |= 4;
            }
            if (TileConstants.railConnectsEast(eff.getTile(-1, 0))) {
                adjTile |= 8;
            }
            eff.setTile(0, 0, TileConstants.RailTable[adjTile]);
        } else if (TileConstants.isWireDynamic(tile)) {
            int adjTile = 0;
            if (TileConstants.wireConnectsSouth(eff.getTile(0, -1))) {
                adjTile |= 1;
            }
            if (TileConstants.wireConnectsWest(eff.getTile(1, 0))) {
                adjTile |= 2;
            }
            if (TileConstants.wireConnectsNorth(eff.getTile(0, 1))) {
                adjTile |= 4;
            }
            if (TileConstants.wireConnectsEast(eff.getTile(-1, 0))) {
                adjTile |= 8;
            }
            eff.setTile(0, 0, TileConstants.WireTable[adjTile]);
        }
    }
}

