/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.CityRect;
import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisTool;
import micropolisj.engine.TileConstants;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.ToolStroke;
import micropolisj.engine.TranslatedToolEffect;

class RoadLikeTool
extends ToolStroke {
    RoadLikeTool(Micropolis city, MicropolisTool tool, int xpos, int ypos) {
        super(city, tool, xpos, ypos);
    }

    @Override
    protected void applyArea(ToolEffectIfc eff) {
        while (this.applyForward(eff) && this.applyBackward(eff)) {
        }
    }

    boolean applyBackward(ToolEffectIfc eff) {
        boolean anyChange = false;
        CityRect b = this.getBounds();
        for (int i = b.height - 1; i >= 0; --i) {
            for (int j = b.width - 1; j >= 0; --j) {
                TranslatedToolEffect tte = new TranslatedToolEffect(eff, b.x + j, b.y + i);
                anyChange = anyChange || this.applySingle(tte);
            }
        }
        return anyChange;
    }

    boolean applyForward(ToolEffectIfc eff) {
        boolean anyChange = false;
        CityRect b = this.getBounds();
        for (int i = 0; i < b.height; ++i) {
            for (int j = 0; j < b.width; ++j) {
                TranslatedToolEffect tte = new TranslatedToolEffect(eff, b.x + j, b.y + i);
                anyChange = anyChange || this.applySingle(tte);
            }
        }
        return anyChange;
    }

    @Override
    public CityRect getBounds() {
        assert (this.tool.getWidth() == 1);
        assert (this.tool.getHeight() == 1);
        if (Math.abs(this.xdest - this.xpos) >= Math.abs(this.ydest - this.ypos)) {
            CityRect r = new CityRect();
            r.x = Math.min(this.xpos, this.xdest);
            r.width = Math.abs(this.xdest - this.xpos) + 1;
            r.y = this.ypos;
            r.height = 1;
            return r;
        }
        CityRect r = new CityRect();
        r.x = this.xpos;
        r.width = 1;
        r.y = Math.min(this.ypos, this.ydest);
        r.height = Math.abs(this.ydest - this.ypos) + 1;
        return r;
    }

    boolean applySingle(ToolEffectIfc eff) {
        switch (this.tool) {
            case RAIL: {
                return this.applyRailTool(eff);
            }
            case ROADS: {
                return this.applyRoadTool(eff);
            }
            case WIRE: {
                return this.applyWireTool(eff);
            }
        }
        throw new Error("Unexpected tool: " + (Object)((Object)this.tool));
    }

    boolean applyRailTool(ToolEffectIfc eff) {
        if (this.layRail(eff)) {
            this.fixZone(eff);
            return true;
        }
        return false;
    }

    boolean applyRoadTool(ToolEffectIfc eff) {
        if (this.layRoad(eff)) {
            this.fixZone(eff);
            return true;
        }
        return false;
    }

    boolean applyWireTool(ToolEffectIfc eff) {
        if (this.layWire(eff)) {
            this.fixZone(eff);
            return true;
        }
        return false;
    }

    private boolean layRail(ToolEffectIfc eff) {
        int RAIL_COST = 20;
        int TUNNEL_COST = 100;
        int cost = 20;
        char tile = (char)eff.getTile(0, 0);
        tile = TileConstants.neutralizeRoad(tile);
        switch (tile) {
            case '\u0002': 
            case '\u0003': 
            case '\u0004': {
                cost = 100;
                char eTile = TileConstants.neutralizeRoad(eff.getTile(1, 0));
                if (eTile == '\u00dd' || eTile == '\u00e0' || eTile >= '\u00e2' && eTile <= '\u00ed') {
                    eff.setTile(0, 0, 224);
                    break;
                }
                char wTile = TileConstants.neutralizeRoad(eff.getTile(-1, 0));
                if (wTile == '\u00dd' || wTile == '\u00e0' || wTile > '\u00e1' && wTile < '\u00ee') {
                    eff.setTile(0, 0, 224);
                    break;
                }
                char sTile = TileConstants.neutralizeRoad(eff.getTile(0, 1));
                if (sTile == '\u00de' || sTile == '\u00ee' || sTile > '\u00e0' && sTile < '\u00ed') {
                    eff.setTile(0, 0, 225);
                    break;
                }
                char nTile = TileConstants.neutralizeRoad(eff.getTile(0, -1));
                if (nTile == '\u00de' || nTile == '\u00ee' || nTile > '\u00e0' && nTile < '\u00ed') {
                    eff.setTile(0, 0, 225);
                    break;
                }
                return false;
            }
            case '\u00d2': {
                eff.setTile(0, 0, 222);
                break;
            }
            case '\u00d3': {
                eff.setTile(0, 0, 221);
                break;
            }
            case 'B': {
                eff.setTile(0, 0, 238);
                break;
            }
            case 'C': {
                eff.setTile(0, 0, 237);
                break;
            }
            default: {
                if (tile != '\u0000') {
                    if (this.city.autoBulldoze && TileConstants.canAutoBulldozeRRW(tile)) {
                        ++cost;
                    } else {
                        return false;
                    }
                }
                eff.setTile(0, 0, 226);
            }
        }
        eff.spend(cost);
        return true;
    }

    private boolean layRoad(ToolEffectIfc eff) {
        int ROAD_COST = 10;
        int BRIDGE_COST = 50;
        int cost = 10;
        char tile = (char)eff.getTile(0, 0);
        switch (tile) {
            case '\u0002': 
            case '\u0003': 
            case '\u0004': {
                cost = 50;
                char eTile = TileConstants.neutralizeRoad(eff.getTile(1, 0));
                if (eTile == '\u00ee' || eTile == '@' || eTile >= 'B' && eTile <= 'M') {
                    eff.setTile(0, 0, 64);
                    break;
                }
                char wTile = TileConstants.neutralizeRoad(eff.getTile(-1, 0));
                if (wTile == '\u00ee' || wTile == '@' || wTile >= 'B' && wTile <= 'L') {
                    eff.setTile(0, 0, 64);
                    break;
                }
                char sTile = TileConstants.neutralizeRoad(eff.getTile(0, 1));
                if (sTile == '\u00ed' || sTile == 'N' || sTile >= 'A' && sTile <= 'L') {
                    eff.setTile(0, 0, 65);
                    break;
                }
                char nTile = TileConstants.neutralizeRoad(eff.getTile(0, -1));
                if (nTile == '\u00ed' || nTile == 'N' || nTile >= 'A' && nTile <= 'L') {
                    eff.setTile(0, 0, 65);
                    break;
                }
                return false;
            }
            case '\u00d2': {
                eff.setTile(0, 0, 78);
                break;
            }
            case '\u00d3': {
                eff.setTile(0, 0, 77);
                break;
            }
            case '\u00e2': {
                eff.setTile(0, 0, 237);
                break;
            }
            case '\u00e3': {
                eff.setTile(0, 0, 238);
                break;
            }
            default: {
                if (tile != '\u0000') {
                    if (this.city.autoBulldoze && TileConstants.canAutoBulldozeRRW(tile)) {
                        ++cost;
                    } else {
                        return false;
                    }
                }
                eff.setTile(0, 0, 66);
            }
        }
        eff.spend(cost);
        return true;
    }

    private boolean layWire(ToolEffectIfc eff) {
        int WIRE_COST = 5;
        int UNDERWATER_WIRE_COST = 25;
        int cost = 5;
        char tile = (char)eff.getTile(0, 0);
        tile = TileConstants.neutralizeRoad(tile);
        switch (tile) {
            case '\u0002': 
            case '\u0003': 
            case '\u0004': {
                cost = 25;
                int tmp = eff.getTile(1, 0);
                char tmpn = TileConstants.neutralizeRoad(tmp);
                if (TileConstants.isConductive(tmp) && tmpn != 'M' && tmpn != '\u00dd' && tmpn != '\u00d0') {
                    eff.setTile(0, 0, 209);
                    break;
                }
                tmp = eff.getTile(-1, 0);
                tmpn = TileConstants.neutralizeRoad(tmp);
                if (TileConstants.isConductive(tmp) && tmpn != 'M' && tmpn != '\u00dd' && tmpn != '\u00d0') {
                    eff.setTile(0, 0, 209);
                    break;
                }
                tmp = eff.getTile(0, 1);
                tmpn = TileConstants.neutralizeRoad(tmp);
                if (TileConstants.isConductive(tmp) && tmpn != 'N' && tmpn != '\u00de' && tmpn != '\u00d1') {
                    eff.setTile(0, 0, 208);
                    break;
                }
                tmp = eff.getTile(0, -1);
                tmpn = TileConstants.neutralizeRoad(tmp);
                if (TileConstants.isConductive(tmp) && tmpn != 'N' && tmpn != '\u00de' && tmpn != '\u00d1') {
                    eff.setTile(0, 0, 208);
                    break;
                }
                return false;
            }
            case 'B': {
                eff.setTile(0, 0, 77);
                break;
            }
            case 'C': {
                eff.setTile(0, 0, 78);
                break;
            }
            case '\u00e2': {
                eff.setTile(0, 0, 221);
                break;
            }
            case '\u00e3': {
                eff.setTile(0, 0, 222);
                break;
            }
            default: {
                if (tile != '\u0000') {
                    if (this.city.autoBulldoze && TileConstants.canAutoBulldozeRRW(tile)) {
                        ++cost;
                    } else {
                        return false;
                    }
                }
                eff.setTile(0, 0, 210);
            }
        }
        eff.spend(cost);
        return true;
    }
}

