/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import micropolisj.engine.AirplaneSprite;
import micropolisj.engine.BudgetNumbers;
import micropolisj.engine.CityBudget;
import micropolisj.engine.CityDimension;
import micropolisj.engine.CityEval;
import micropolisj.engine.CityLocation;
import micropolisj.engine.EarthquakeListener;
import micropolisj.engine.ExplosionSprite;
import micropolisj.engine.GameLevel;
import micropolisj.engine.HelicopterSprite;
import micropolisj.engine.MapListener;
import micropolisj.engine.MapScanner;
import micropolisj.engine.MapState;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.MonsterSprite;
import micropolisj.engine.ShipSprite;
import micropolisj.engine.Sound;
import micropolisj.engine.Speed;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TerrainBehavior;
import micropolisj.engine.TileBehavior;
import micropolisj.engine.TileConstants;
import micropolisj.engine.TileSpec;
import micropolisj.engine.Tiles;
import micropolisj.engine.ToolEffect;
import micropolisj.engine.ToolEffectIfc;
import micropolisj.engine.TornadoSprite;
import micropolisj.engine.TrainSprite;
import micropolisj.engine.ZoneStatus;

public class Micropolis {
    static final Random DEFAULT_PRNG = new Random();
    Random PRNG;
    char[][] map;
    boolean[][] powerMap;
    int[][] landValueMem;
    public int[][] pollutionMem;
    public int[][] crimeMem;
    public int[][] popDensity;
    int[][] trfDensity;
    int[][] terrainMem;
    public int[][] rateOGMem;
    int[][] fireStMap;
    public int[][] fireRate;
    int[][] policeMap;
    public int[][] policeMapEffect;
    int[][] comRate;
    static final int DEFAULT_WIDTH = 120;
    static final int DEFAULT_HEIGHT = 100;
    public final CityBudget budget = new CityBudget(this);
    public boolean autoBulldoze = true;
    public boolean autoBudget = false;
    public Speed simSpeed = Speed.NORMAL;
    public boolean noDisasters = false;
    public int gameLevel;
    boolean autoGo;
    int poweredZoneCount;
    int unpoweredZoneCount;
    int roadTotal;
    int railTotal;
    int firePop;
    int resZoneCount;
    int comZoneCount;
    int indZoneCount;
    int resPop;
    int comPop;
    int indPop;
    int hospitalCount;
    int churchCount;
    int policeCount;
    int fireStationCount;
    int stadiumCount;
    int coalCount;
    int nuclearCount;
    int seaportCount;
    int airportCount;
    int totalPop;
    int lastCityPop;
    int lastRoadTotal;
    int lastRailTotal;
    int lastTotalPop;
    int lastFireStationCount;
    int lastPoliceCount;
    int trafficMaxLocationX;
    int trafficMaxLocationY;
    int pollutionMaxLocationX;
    int pollutionMaxLocationY;
    int crimeMaxLocationX;
    int crimeMaxLocationY;
    public int centerMassX;
    public int centerMassY;
    CityLocation meltdownLocation;
    CityLocation crashLocation;
    int needHospital;
    int needChurch;
    int crimeAverage;
    int pollutionAverage;
    int landValueAverage;
    int trafficAverage;
    int resValve;
    int comValve;
    int indValve;
    boolean resCap;
    boolean comCap;
    boolean indCap;
    int crimeRamp;
    int polluteRamp;
    public int cityTax = 7;
    public double roadPercent = 1.0;
    public double policePercent = 1.0;
    public double firePercent = 1.0;
    int taxEffect = 7;
    int roadEffect = 32;
    int policeEffect = 1000;
    int fireEffect = 1000;
    int cashFlow;
    boolean newPower;
    int floodCnt;
    int floodX;
    int floodY;
    public int cityTime;
    int scycle;
    int fcycle;
    int acycle;
    public CityEval evaluation;
    ArrayList<Sprite> sprites = new ArrayList();
    static final int VALVERATE = 2;
    public static final int CENSUSRATE = 4;
    static final int TAXFREQ = 48;
    ArrayList<Listener> listeners = new ArrayList();
    ArrayList<MapListener> mapListeners = new ArrayList();
    ArrayList<EarthquakeListener> earthquakeListeners = new ArrayList();
    static final int[] TaxTable = new int[]{200, 150, 120, 100, 80, 50, 30, 0, -10, -40, -100, -150, -200, -250, -300, -350, -400, -450, -500, -550, -600};
    public History history = new History();
    Map<String, TileBehavior> tileBehaviors;
    Stack<CityLocation> powerPlants = new Stack();
    static final double[] RLevels = new double[]{0.7, 0.9, 1.2};
    static final double[] FLevels = new double[]{1.4, 1.2, 0.8};
    public ArrayList<FinancialHistory> financialHistory = new ArrayList();
    static final int POLICE_STATION_MAINTENANCE = 100;
    static final int FIRE_STATION_MAINTENANCE = 100;
    static final int[] MltdwnTab = new int[]{30000, 20000, 10000};

    public void spend(int amount) {
        this.budget.totalFunds -= amount;
        this.fireFundsChanged();
    }

    public Micropolis() {
        this(120, 100);
    }

    public Micropolis(int width, int height) {
        this.PRNG = DEFAULT_PRNG;
        this.evaluation = new CityEval(this);
        this.init(width, height);
        this.initTileBehaviors();
    }

    protected void init(int width, int height) {
        this.map = new char[height][width];
        this.powerMap = new boolean[height][width];
        int hX = (width + 1) / 2;
        int hY = (height + 1) / 2;
        this.landValueMem = new int[hY][hX];
        this.pollutionMem = new int[hY][hX];
        this.crimeMem = new int[hY][hX];
        this.popDensity = new int[hY][hX];
        this.trfDensity = new int[hY][hX];
        int qX = (width + 3) / 4;
        int qY = (height + 3) / 4;
        this.terrainMem = new int[qY][qX];
        int smX = (width + 7) / 8;
        int smY = (height + 7) / 8;
        this.rateOGMem = new int[smY][smX];
        this.fireStMap = new int[smY][smX];
        this.policeMap = new int[smY][smX];
        this.policeMapEffect = new int[smY][smX];
        this.fireRate = new int[smY][smX];
        this.comRate = new int[smY][smX];
        this.centerMassX = hX;
        this.centerMassY = hY;
    }

    void fireCensusChanged() {
        for (Listener l : this.listeners) {
            l.censusChanged();
        }
    }

    void fireCityMessage(MicropolisMessage message, CityLocation loc) {
        for (Listener l : this.listeners) {
            l.cityMessage(message, loc);
        }
    }

    void fireCitySound(Sound sound, CityLocation loc) {
        for (Listener l : this.listeners) {
            l.citySound(sound, loc);
        }
    }

    void fireDemandChanged() {
        for (Listener l : this.listeners) {
            l.demandChanged();
        }
    }

    void fireEarthquakeStarted() {
        for (EarthquakeListener l : this.earthquakeListeners) {
            l.earthquakeStarted();
        }
    }

    void fireEvaluationChanged() {
        for (Listener l : this.listeners) {
            l.evaluationChanged();
        }
    }

    void fireFundsChanged() {
        for (Listener l : this.listeners) {
            l.fundsChanged();
        }
    }

    void fireMapOverlayDataChanged(MapState overlayDataType) {
        for (MapListener l : this.mapListeners) {
            l.mapOverlayDataChanged(overlayDataType);
        }
    }

    void fireOptionsChanged() {
        for (Listener l : this.listeners) {
            l.optionsChanged();
        }
    }

    void fireSpriteMoved(Sprite sprite) {
        for (MapListener l : this.mapListeners) {
            l.spriteMoved(sprite);
        }
    }

    void fireTileChanged(int xpos, int ypos) {
        for (MapListener l : this.mapListeners) {
            l.tileChanged(xpos, ypos);
        }
    }

    void fireWholeMapChanged() {
        for (MapListener l : this.mapListeners) {
            l.wholeMapChanged();
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void addEarthquakeListener(EarthquakeListener l) {
        this.earthquakeListeners.add(l);
    }

    public void removeEarthquakeListener(EarthquakeListener l) {
        this.earthquakeListeners.remove(l);
    }

    public void addMapListener(MapListener l) {
        this.mapListeners.add(l);
    }

    public void removeMapListener(MapListener l) {
        this.mapListeners.remove(l);
    }

    public int getWidth() {
        return this.map[0].length;
    }

    public int getHeight() {
        return this.map.length;
    }

    public char getTile(int xpos, int ypos) {
        return (char)(this.map[ypos][xpos] & 0x3FF);
    }

    public char getTileRaw(int xpos, int ypos) {
        return this.map[ypos][xpos];
    }

    boolean isTileDozeable(ToolEffectIfc eff) {
        int myTile = eff.getTile(0, 0);
        TileSpec ts = Tiles.get(myTile);
        if (ts.canBulldoze) {
            return true;
        }
        if (ts.owner != null) {
            int baseTile = eff.getTile(-ts.ownerOffsetX, -ts.ownerOffsetY);
            return ts.owner.tileNumber != baseTile;
        }
        return false;
    }

    boolean isTileDozeable(int xpos, int ypos) {
        return this.isTileDozeable(new ToolEffect(this, xpos, ypos));
    }

    public boolean isTilePowered(int xpos, int ypos) {
        return (this.getTileRaw(xpos, ypos) & 0x8000) == 32768;
    }

    public void setTile(int xpos, int ypos, char newTile) {
        assert ((newTile & 0x3FF) == newTile);
        if (this.map[ypos][xpos] != newTile) {
            this.map[ypos][xpos] = newTile;
            this.fireTileChanged(xpos, ypos);
        }
    }

    public void setTilePower(int xpos, int ypos, boolean power) {
        this.map[ypos][xpos] = (char)(this.map[ypos][xpos] & 0xFFFF7FFF | (power ? 32768 : 0));
    }

    public final boolean testBounds(int xpos, int ypos) {
        return xpos >= 0 && xpos < this.getWidth() && ypos >= 0 && ypos < this.getHeight();
    }

    final boolean hasPower(int x, int y) {
        return this.powerMap[y][x];
    }

    public boolean isBudgetTime() {
        return this.cityTime != 0 && this.cityTime % 48 == 0 && (this.fcycle + 1) % 16 == 10 && (this.acycle + 1) % 2 == 0;
    }

    void step() {
        this.fcycle = (this.fcycle + 1) % 1024;
        this.simulate(this.fcycle % 16);
    }

    void clearCensus() {
        this.poweredZoneCount = 0;
        this.unpoweredZoneCount = 0;
        this.firePop = 0;
        this.roadTotal = 0;
        this.railTotal = 0;
        this.resPop = 0;
        this.comPop = 0;
        this.indPop = 0;
        this.resZoneCount = 0;
        this.comZoneCount = 0;
        this.indZoneCount = 0;
        this.hospitalCount = 0;
        this.churchCount = 0;
        this.policeCount = 0;
        this.fireStationCount = 0;
        this.stadiumCount = 0;
        this.coalCount = 0;
        this.nuclearCount = 0;
        this.seaportCount = 0;
        this.airportCount = 0;
        this.powerPlants.clear();
        for (int y = 0; y < this.fireStMap.length; ++y) {
            for (int x = 0; x < this.fireStMap[y].length; ++x) {
                this.fireStMap[y][x] = 0;
                this.policeMap[y][x] = 0;
            }
        }
    }

    void simulate(int mod16) {
        int band = this.getWidth() / 8;
        switch (mod16) {
            case 0: {
                this.scycle = (this.scycle + 1) % 1024;
                ++this.cityTime;
                if (this.scycle % 2 == 0) {
                    this.setValves();
                }
                this.clearCensus();
                break;
            }
            case 1: {
                this.mapScan(0 * band, 1 * band);
                break;
            }
            case 2: {
                this.mapScan(1 * band, 2 * band);
                break;
            }
            case 3: {
                this.mapScan(2 * band, 3 * band);
                break;
            }
            case 4: {
                this.mapScan(3 * band, 4 * band);
                break;
            }
            case 5: {
                this.mapScan(4 * band, 5 * band);
                break;
            }
            case 6: {
                this.mapScan(5 * band, 6 * band);
                break;
            }
            case 7: {
                this.mapScan(6 * band, 7 * band);
                break;
            }
            case 8: {
                this.mapScan(7 * band, this.getWidth());
                break;
            }
            case 9: {
                if (this.cityTime % 4 == 0) {
                    this.takeCensus();
                    if (this.cityTime % 48 == 0) {
                        this.takeCensus2();
                    }
                    this.fireCensusChanged();
                }
                this.collectTaxPartial();
                if (this.cityTime % 48 != 0) break;
                this.collectTax();
                this.evaluation.cityEvaluation();
                break;
            }
            case 10: {
                if (this.scycle % 5 == 0) {
                    this.decROGMem();
                }
                this.decTrafficMem();
                this.fireMapOverlayDataChanged(MapState.TRAFFIC_OVERLAY);
                this.fireMapOverlayDataChanged(MapState.TRANSPORT);
                this.fireMapOverlayDataChanged(MapState.ALL);
                this.fireMapOverlayDataChanged(MapState.RESIDENTIAL);
                this.fireMapOverlayDataChanged(MapState.COMMERCIAL);
                this.fireMapOverlayDataChanged(MapState.INDUSTRIAL);
                this.doMessages();
                break;
            }
            case 11: {
                this.powerScan();
                this.fireMapOverlayDataChanged(MapState.POWER_OVERLAY);
                this.newPower = true;
                break;
            }
            case 12: {
                this.ptlScan();
                break;
            }
            case 13: {
                this.crimeScan();
                break;
            }
            case 14: {
                this.popDenScan();
                break;
            }
            case 15: {
                this.fireAnalysis();
                this.doDisasters();
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
    }

    private int computePopDen(int x, int y, char tile) {
        if (tile == '\u00f4') {
            return this.doFreePop(x, y);
        }
        if (tile < '\u01a7') {
            return TileConstants.residentialZonePop(tile);
        }
        if (tile < '\u0264') {
            return TileConstants.commercialZonePop(tile) * 8;
        }
        if (tile < '\u02b5') {
            return TileConstants.industrialZonePop(tile) * 8;
        }
        return 0;
    }

    private static int[][] doSmooth(int[][] tem) {
        int h = tem.length;
        int w = tem[0].length;
        int[][] tem2 = new int[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int z = tem[y][x];
                if (x > 0) {
                    z += tem[y][x - 1];
                }
                if (x + 1 < w) {
                    z += tem[y][x + 1];
                }
                if (y > 0) {
                    z += tem[y - 1][x];
                }
                if (y + 1 < h) {
                    z += tem[y + 1][x];
                }
                if ((z /= 4) > 255) {
                    z = 255;
                }
                tem2[y][x] = z;
            }
        }
        return tem2;
    }

    public void calculateCenterMass() {
        this.popDenScan();
    }

    private void popDenScan() {
        int y;
        int x;
        int xtot = 0;
        int ytot = 0;
        int zoneCount = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        int[][] tem = new int[(height + 1) / 2][(width + 1) / 2];
        for (x = 0; x < width; ++x) {
            for (y = 0; y < height; ++y) {
                char tile = this.getTile(x, y);
                if (!TileConstants.isZoneCenter(tile)) continue;
                int den = this.computePopDen(x, y, tile) * 8;
                if (den > 254) {
                    den = 254;
                }
                tem[y / 2][x / 2] = den;
                xtot += x;
                ytot += y;
                ++zoneCount;
            }
        }
        tem = Micropolis.doSmooth(tem);
        tem = Micropolis.doSmooth(tem);
        tem = Micropolis.doSmooth(tem);
        for (x = 0; x < (width + 1) / 2; ++x) {
            for (y = 0; y < (height + 1) / 2; ++y) {
                this.popDensity[y][x] = 2 * tem[y][x];
            }
        }
        this.distIntMarket();
        if (zoneCount != 0) {
            this.centerMassX = xtot / zoneCount;
            this.centerMassY = ytot / zoneCount;
        } else {
            this.centerMassX = (width + 1) / 2;
            this.centerMassY = (height + 1) / 2;
        }
        this.fireMapOverlayDataChanged(MapState.POPDEN_OVERLAY);
        this.fireMapOverlayDataChanged(MapState.GROWTHRATE_OVERLAY);
    }

    private void distIntMarket() {
        for (int y = 0; y < this.comRate.length; ++y) {
            for (int x = 0; x < this.comRate[y].length; ++x) {
                int z = this.getDisCC(x * 4, y * 4);
                z /= 4;
                this.comRate[y][x] = z = 64 - z;
            }
        }
    }

    private void decROGMem() {
        for (int y = 0; y < this.rateOGMem.length; ++y) {
            for (int x = 0; x < this.rateOGMem[y].length; ++x) {
                int z = this.rateOGMem[y][x];
                if (z == 0) continue;
                if (z > 0) {
                    int[] nArray = this.rateOGMem[y];
                    int n = x;
                    nArray[n] = nArray[n] - 1;
                    if (z <= 200) continue;
                    this.rateOGMem[y][x] = 200;
                    continue;
                }
                if (z >= 0) continue;
                int[] nArray = this.rateOGMem[y];
                int n = x;
                nArray[n] = nArray[n] + 1;
                if (z >= -200) continue;
                this.rateOGMem[y][x] = -200;
            }
        }
    }

    private void decTrafficMem() {
        for (int y = 0; y < this.trfDensity.length; ++y) {
            for (int x = 0; x < this.trfDensity[y].length; ++x) {
                int z = this.trfDensity[y][x];
                if (z == 0) continue;
                this.trfDensity[y][x] = z > 200 ? z - 34 : (z > 24 ? z - 24 : 0);
            }
        }
    }

    void crimeScan() {
        this.policeMap = this.smoothFirePoliceMap(this.policeMap);
        this.policeMap = this.smoothFirePoliceMap(this.policeMap);
        this.policeMap = this.smoothFirePoliceMap(this.policeMap);
        for (int sy = 0; sy < this.policeMap.length; ++sy) {
            for (int sx = 0; sx < this.policeMap[sy].length; ++sx) {
                this.policeMapEffect[sy][sx] = this.policeMap[sy][sx];
            }
        }
        int count = 0;
        int sum = 0;
        int cmax = 0;
        for (int hy = 0; hy < this.landValueMem.length; ++hy) {
            for (int hx = 0; hx < this.landValueMem[hy].length; ++hx) {
                int val = this.landValueMem[hy][hx];
                if (val != 0) {
                    ++count;
                    int z = 128 - val + this.popDensity[hy][hx];
                    z = Math.min(300, z);
                    z -= this.policeMap[hy / 4][hx / 4];
                    z = Math.min(250, z);
                    this.crimeMem[hy][hx] = z = Math.max(0, z);
                    sum += z;
                    if (z <= cmax && (z != cmax || this.PRNG.nextInt(4) != 0)) continue;
                    cmax = z;
                    this.crimeMaxLocationX = hx * 2;
                    this.crimeMaxLocationY = hy * 2;
                    continue;
                }
                this.crimeMem[hy][hx] = 0;
            }
        }
        this.crimeAverage = count != 0 ? sum / count : 0;
        this.fireMapOverlayDataChanged(MapState.POLICE_OVERLAY);
    }

    void doDisasters() {
        if (this.floodCnt > 0) {
            --this.floodCnt;
        }
        int[] DisChance = new int[]{480, 240, 60};
        if (this.noDisasters) {
            return;
        }
        if (this.PRNG.nextInt(DisChance[this.gameLevel] + 1) != 0) {
            return;
        }
        switch (this.PRNG.nextInt(9)) {
            case 0: 
            case 1: {
                this.setFire();
                break;
            }
            case 2: 
            case 3: {
                this.makeFlood();
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.makeTornado();
                break;
            }
            case 6: {
                this.makeEarthquake();
                break;
            }
            case 7: 
            case 8: {
                if (this.pollutionAverage <= 60) break;
                this.makeMonster();
            }
        }
    }

    private int[][] smoothFirePoliceMap(int[][] omap) {
        int smX = omap[0].length;
        int smY = omap.length;
        int[][] nmap = new int[smY][smX];
        for (int sy = 0; sy < smY; ++sy) {
            for (int sx = 0; sx < smX; ++sx) {
                int edge = 0;
                if (sx > 0) {
                    edge += omap[sy][sx - 1];
                }
                if (sx + 1 < smX) {
                    edge += omap[sy][sx + 1];
                }
                if (sy > 0) {
                    edge += omap[sy - 1][sx];
                }
                if (sy + 1 < smY) {
                    edge += omap[sy + 1][sx];
                }
                edge = edge / 4 + omap[sy][sx];
                nmap[sy][sx] = edge / 2;
            }
        }
        return nmap;
    }

    void fireAnalysis() {
        this.fireStMap = this.smoothFirePoliceMap(this.fireStMap);
        this.fireStMap = this.smoothFirePoliceMap(this.fireStMap);
        this.fireStMap = this.smoothFirePoliceMap(this.fireStMap);
        for (int sy = 0; sy < this.fireStMap.length; ++sy) {
            for (int sx = 0; sx < this.fireStMap[sy].length; ++sx) {
                this.fireRate[sy][sx] = this.fireStMap[sy][sx];
            }
        }
        this.fireMapOverlayDataChanged(MapState.FIRE_OVERLAY);
    }

    private boolean testForCond(CityLocation loc, int dir) {
        int xsave = loc.x;
        int ysave = loc.y;
        boolean rv = false;
        if (this.movePowerLocation(loc, dir)) {
            char t = this.getTile(loc.x, loc.y);
            rv = TileConstants.isConductive(t) && t != '\u0330' && t != '\u02ee' && !this.hasPower(loc.x, loc.y);
        }
        loc.x = xsave;
        loc.y = ysave;
        return rv;
    }

    private boolean movePowerLocation(CityLocation loc, int dir) {
        switch (dir) {
            case 0: {
                if (loc.y > 0) {
                    --loc.y;
                    return true;
                }
                return false;
            }
            case 1: {
                if (loc.x + 1 < this.getWidth()) {
                    ++loc.x;
                    return true;
                }
                return false;
            }
            case 2: {
                if (loc.y + 1 < this.getHeight()) {
                    ++loc.y;
                    return true;
                }
                return false;
            }
            case 3: {
                if (loc.x > 0) {
                    --loc.x;
                    return true;
                }
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    void powerScan() {
        for (boolean[] bb : this.powerMap) {
            Arrays.fill(bb, false);
        }
        int maxPower = this.coalCount * 700 + this.nuclearCount * 2000;
        int numPower = 0;
        while (!this.powerPlants.isEmpty()) {
            int conNum;
            CityLocation loc = this.powerPlants.pop();
            int aDir = 4;
            do {
                if (++numPower > maxPower) {
                    this.sendMessage(MicropolisMessage.BROWNOUTS_REPORT);
                    return;
                }
                this.movePowerLocation(loc, aDir);
                this.powerMap[loc.y][loc.x] = true;
                conNum = 0;
                for (int dir = 0; dir < 4 && conNum < 2; ++dir) {
                    if (!this.testForCond(loc, dir)) continue;
                    ++conNum;
                    aDir = dir;
                }
                if (conNum <= 1) continue;
                this.powerPlants.add(new CityLocation(loc.x, loc.y));
            } while (conNum != 0);
        }
    }

    void addTraffic(int mapX, int mapY, int traffic) {
        int z = this.trfDensity[mapY / 2][mapX / 2];
        if ((z += traffic) > 240 && this.PRNG.nextInt(6) == 0) {
            z = 240;
            this.trafficMaxLocationX = mapX;
            this.trafficMaxLocationY = mapY;
            HelicopterSprite copter = (HelicopterSprite)this.getSprite(SpriteKind.COP);
            if (copter != null) {
                copter.destX = mapX;
                copter.destY = mapY;
            }
        }
        this.trfDensity[mapY / 2][mapX / 2] = z;
    }

    public int getFireStationCoverage(int xpos, int ypos) {
        return this.fireRate[ypos / 8][xpos / 8];
    }

    public int getLandValue(int xpos, int ypos) {
        if (this.testBounds(xpos, ypos)) {
            return this.landValueMem[ypos / 2][xpos / 2];
        }
        return 0;
    }

    public int getTrafficDensity(int xpos, int ypos) {
        if (this.testBounds(xpos, ypos)) {
            return this.trfDensity[ypos / 2][xpos / 2];
        }
        return 0;
    }

    void ptlScan() {
        int qX = (this.getWidth() + 3) / 4;
        int qY = (this.getHeight() + 3) / 4;
        int[][] qtem = new int[qY][qX];
        int landValueTotal = 0;
        int landValueCount = 0;
        int HWLDX = (this.getWidth() + 1) / 2;
        int HWLDY = (this.getHeight() + 1) / 2;
        int[][] tem = new int[HWLDY][HWLDX];
        for (int x = 0; x < HWLDX; ++x) {
            for (int y = 0; y < HWLDY; ++y) {
                int plevel = 0;
                int lvflag = 0;
                int zx = 2 * x;
                int zy = 2 * y;
                for (int mx = zx; mx <= zx + 1; ++mx) {
                    for (int my = zy; my <= zy + 1; ++my) {
                        char tile = this.getTile(mx, my);
                        if (tile == '\u0000') continue;
                        if (tile < ',') {
                            int[] nArray = qtem[y / 2];
                            int n = x / 2;
                            nArray[n] = nArray[n] + 15;
                            continue;
                        }
                        plevel += TileConstants.getPollutionValue(tile);
                        if (!TileConstants.isConstructed(tile)) continue;
                        ++lvflag;
                    }
                }
                if (plevel < 0) {
                    plevel = 250;
                }
                if (plevel > 255) {
                    plevel = 255;
                }
                tem[y][x] = plevel;
                if (lvflag != 0) {
                    int dis = 34 - this.getDisCC(x, y);
                    dis *= 4;
                    dis += this.terrainMem[y / 2][x / 2];
                    dis -= this.pollutionMem[y][x];
                    if (this.crimeMem[y][x] > 190) {
                        dis -= 20;
                    }
                    if (dis > 250) {
                        dis = 250;
                    }
                    if (dis < 1) {
                        dis = 1;
                    }
                    this.landValueMem[y][x] = dis;
                    landValueTotal += dis;
                    ++landValueCount;
                    continue;
                }
                this.landValueMem[y][x] = 0;
            }
        }
        this.landValueAverage = landValueCount != 0 ? landValueTotal / landValueCount : 0;
        tem = Micropolis.doSmooth(tem);
        tem = Micropolis.doSmooth(tem);
        int pcount = 0;
        int ptotal = 0;
        int pmax = 0;
        for (int x = 0; x < HWLDX; ++x) {
            for (int y = 0; y < HWLDY; ++y) {
                int z;
                this.pollutionMem[y][x] = z = tem[y][x];
                if (z == 0) continue;
                ++pcount;
                ptotal += z;
                if (z <= pmax && (z != pmax || this.PRNG.nextInt(4) != 0)) continue;
                pmax = z;
                this.pollutionMaxLocationX = 2 * x;
                this.pollutionMaxLocationY = 2 * y;
            }
        }
        this.pollutionAverage = pcount != 0 ? ptotal / pcount : 0;
        this.terrainMem = this.smoothTerrain(qtem);
        this.fireMapOverlayDataChanged(MapState.POLLUTE_OVERLAY);
        this.fireMapOverlayDataChanged(MapState.LANDVALUE_OVERLAY);
    }

    public CityLocation getLocationOfMaxPollution() {
        return new CityLocation(this.pollutionMaxLocationX, this.pollutionMaxLocationY);
    }

    void setValves() {
        int z2;
        double normResPop = (double)this.resPop / 8.0;
        this.totalPop = (int)(normResPop + (double)this.comPop + (double)this.indPop);
        double employment = normResPop != 0.0 ? (double)(this.history.com[1] + this.history.ind[1]) / normResPop : 1.0;
        double migration = normResPop * (employment - 1.0);
        double BIRTH_RATE = 0.02;
        double births = normResPop * 0.02;
        double projectedResPop = normResPop + migration + births;
        double temp = this.history.com[1] + this.history.ind[1];
        double laborBase = temp != 0.0 ? (double)this.history.res[1] / temp : 1.0;
        laborBase = Math.max(0.0, Math.min(1.3, laborBase));
        double internalMarket = (normResPop + (double)this.comPop + (double)this.indPop) / 3.7;
        double projectedComPop = internalMarket * laborBase;
        int z = this.gameLevel;
        temp = 1.0;
        switch (z) {
            case 0: {
                temp = 1.2;
                break;
            }
            case 1: {
                temp = 1.1;
                break;
            }
            case 2: {
                temp = 0.98;
            }
        }
        double projectedIndPop = (double)this.indPop * laborBase * temp;
        if (projectedIndPop < 5.0) {
            projectedIndPop = 5.0;
        }
        double resRatio = normResPop != 0.0 ? projectedResPop / normResPop : 1.3;
        double comRatio = this.comPop != 0 ? projectedComPop / (double)this.comPop : projectedComPop;
        double indRatio = this.indPop != 0 ? projectedIndPop / (double)this.indPop : projectedIndPop;
        if (resRatio > 2.0) {
            resRatio = 2.0;
        }
        if (comRatio > 2.0) {
            comRatio = 2.0;
        }
        if (indRatio > 2.0) {
            indRatio = 2.0;
        }
        if ((z2 = this.taxEffect + this.gameLevel) > 20) {
            z2 = 20;
        }
        resRatio = (resRatio - 1.0) * 600.0 + (double)TaxTable[z2];
        comRatio = (comRatio - 1.0) * 600.0 + (double)TaxTable[z2];
        indRatio = (indRatio - 1.0) * 600.0 + (double)TaxTable[z2];
        this.resValve += (int)resRatio;
        this.comValve += (int)comRatio;
        this.indValve += (int)indRatio;
        if (this.resValve > 2000) {
            this.resValve = 2000;
        } else if (this.resValve < -2000) {
            this.resValve = -2000;
        }
        if (this.comValve > 1500) {
            this.comValve = 1500;
        } else if (this.comValve < -1500) {
            this.comValve = -1500;
        }
        if (this.indValve > 1500) {
            this.indValve = 1500;
        } else if (this.indValve < -1500) {
            this.indValve = -1500;
        }
        if (this.resCap && this.resValve > 0) {
            this.resValve = 0;
        }
        if (this.comCap && this.comValve > 0) {
            this.comValve = 0;
        }
        if (this.indCap && this.indValve > 0) {
            this.indValve = 0;
        }
        this.fireDemandChanged();
    }

    int[][] smoothTerrain(int[][] qtem) {
        int QWX = qtem[0].length;
        int QWY = qtem.length;
        int[][] mem = new int[QWY][QWX];
        for (int y = 0; y < QWY; ++y) {
            for (int x = 0; x < QWX; ++x) {
                int z = 0;
                if (x > 0) {
                    z += qtem[y][x - 1];
                }
                if (x + 1 < QWX) {
                    z += qtem[y][x + 1];
                }
                if (y > 0) {
                    z += qtem[y - 1][x];
                }
                if (y + 1 < QWY) {
                    z += qtem[y + 1][x];
                }
                mem[y][x] = z / 4 + qtem[y][x] / 2;
            }
        }
        return mem;
    }

    int getDisCC(int x, int y) {
        int ydis;
        assert (x >= 0 && x <= this.getWidth() / 2);
        assert (y >= 0 && y <= this.getHeight() / 2);
        int xdis = Math.abs(x - this.centerMassX / 2);
        int z = xdis + (ydis = Math.abs(y - this.centerMassY / 2));
        if (z > 32) {
            return 32;
        }
        return z;
    }

    void initTileBehaviors() {
        HashMap<String, TileBehavior> bb = new HashMap<String, TileBehavior>();
        bb.put("FIRE", new TerrainBehavior(this, TerrainBehavior.B.FIRE));
        bb.put("FLOOD", new TerrainBehavior(this, TerrainBehavior.B.FLOOD));
        bb.put("RADIOACTIVE", new TerrainBehavior(this, TerrainBehavior.B.RADIOACTIVE));
        bb.put("ROAD", new TerrainBehavior(this, TerrainBehavior.B.ROAD));
        bb.put("RAIL", new TerrainBehavior(this, TerrainBehavior.B.RAIL));
        bb.put("EXPLOSION", new TerrainBehavior(this, TerrainBehavior.B.EXPLOSION));
        bb.put("RESIDENTIAL", new MapScanner(this, MapScanner.B.RESIDENTIAL));
        bb.put("HOSPITAL_CHURCH", new MapScanner(this, MapScanner.B.HOSPITAL_CHURCH));
        bb.put("COMMERCIAL", new MapScanner(this, MapScanner.B.COMMERCIAL));
        bb.put("INDUSTRIAL", new MapScanner(this, MapScanner.B.INDUSTRIAL));
        bb.put("COAL", new MapScanner(this, MapScanner.B.COAL));
        bb.put("NUCLEAR", new MapScanner(this, MapScanner.B.NUCLEAR));
        bb.put("FIRESTATION", new MapScanner(this, MapScanner.B.FIRESTATION));
        bb.put("POLICESTATION", new MapScanner(this, MapScanner.B.POLICESTATION));
        bb.put("STADIUM_EMPTY", new MapScanner(this, MapScanner.B.STADIUM_EMPTY));
        bb.put("STADIUM_FULL", new MapScanner(this, MapScanner.B.STADIUM_FULL));
        bb.put("AIRPORT", new MapScanner(this, MapScanner.B.AIRPORT));
        bb.put("SEAPORT", new MapScanner(this, MapScanner.B.SEAPORT));
        this.tileBehaviors = bb;
    }

    void mapScan(int x0, int x1) {
        for (int x = x0; x < x1; ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                this.mapScanTile(x, y);
            }
        }
    }

    void mapScanTile(int xpos, int ypos) {
        char tile = this.getTile(xpos, ypos);
        String behaviorStr = TileConstants.getTileBehavior(tile);
        if (behaviorStr == null) {
            return;
        }
        TileBehavior b = this.tileBehaviors.get(behaviorStr);
        if (b == null) {
            throw new Error("Unknown behavior: " + behaviorStr);
        }
        b.processTile(xpos, ypos);
    }

    void generateShip() {
        int edge = this.PRNG.nextInt(4);
        if (edge == 0) {
            for (int x = 4; x < this.getWidth() - 2; ++x) {
                if (this.getTile(x, 0) != '\u0004') continue;
                this.makeShipAt(x, 0, 5);
                return;
            }
        } else if (edge == 1) {
            for (int y = 1; y < this.getHeight() - 2; ++y) {
                if (this.getTile(0, y) != '\u0004') continue;
                this.makeShipAt(0, y, 7);
                return;
            }
        } else if (edge == 2) {
            for (int x = 4; x < this.getWidth() - 2; ++x) {
                if (this.getTile(x, this.getHeight() - 1) != '\u0004') continue;
                this.makeShipAt(x, this.getHeight() - 1, 1);
                return;
            }
        } else {
            for (int y = 1; y < this.getHeight() - 2; ++y) {
                if (this.getTile(this.getWidth() - 1, y) != '\u0004') continue;
                this.makeShipAt(this.getWidth() - 1, y, 7);
                return;
            }
        }
    }

    Sprite getSprite(SpriteKind kind) {
        for (Sprite s : this.sprites) {
            if (s.kind != kind) continue;
            return s;
        }
        return null;
    }

    boolean hasSprite(SpriteKind kind) {
        return this.getSprite(kind) != null;
    }

    void makeShipAt(int xpos, int ypos, int edge) {
        assert (!this.hasSprite(SpriteKind.SHI));
        this.sprites.add(new ShipSprite(this, xpos, ypos, edge));
    }

    void generateCopter(int xpos, int ypos) {
        if (!this.hasSprite(SpriteKind.COP)) {
            this.sprites.add(new HelicopterSprite(this, xpos, ypos));
        }
    }

    void generatePlane(int xpos, int ypos) {
        if (!this.hasSprite(SpriteKind.AIR)) {
            this.sprites.add(new AirplaneSprite(this, xpos, ypos));
        }
    }

    void generateTrain(int xpos, int ypos) {
        if (this.totalPop > 20 && !this.hasSprite(SpriteKind.TRA) && this.PRNG.nextInt(26) == 0) {
            this.sprites.add(new TrainSprite(this, xpos, ypos));
        }
    }

    int doFreePop(int xpos, int ypos) {
        int count = 0;
        for (int x = xpos - 1; x <= xpos + 1; ++x) {
            for (int y = ypos - 1; y <= ypos + 1; ++y) {
                char loc;
                if (!this.testBounds(x, y) || (loc = this.getTile(x, y)) < '\u00f9' || loc > '\u0104') continue;
                ++count;
            }
        }
        return count;
    }

    void takeCensus() {
        int resMax = 0;
        int comMax = 0;
        int indMax = 0;
        for (int i = 118; i >= 0; --i) {
            if (this.history.res[i] > resMax) {
                resMax = this.history.res[i];
            }
            if (this.history.com[i] > comMax) {
                comMax = this.history.res[i];
            }
            if (this.history.ind[i] > indMax) {
                indMax = this.history.ind[i];
            }
            this.history.res[i + 1] = this.history.res[i];
            this.history.com[i + 1] = this.history.com[i];
            this.history.ind[i + 1] = this.history.ind[i];
            this.history.crime[i + 1] = this.history.crime[i];
            this.history.pollution[i + 1] = this.history.pollution[i];
            this.history.money[i + 1] = this.history.money[i];
        }
        this.history.resMax = resMax;
        this.history.comMax = comMax;
        this.history.indMax = indMax;
        this.history.res[0] = this.resPop / 8;
        this.history.com[0] = this.comPop;
        this.history.ind[0] = this.indPop;
        this.crimeRamp += (this.crimeAverage - this.crimeRamp) / 4;
        this.history.crime[0] = Math.min(255, this.crimeRamp);
        this.polluteRamp += (this.pollutionAverage - this.polluteRamp) / 4;
        this.history.pollution[0] = Math.min(255, this.polluteRamp);
        int moneyScaled = this.cashFlow / 20 + 128;
        if (moneyScaled < 0) {
            moneyScaled = 0;
        }
        if (moneyScaled > 255) {
            moneyScaled = 255;
        }
        this.history.money[0] = moneyScaled;
        this.history.cityTime = this.cityTime;
        this.needHospital = this.hospitalCount < this.resPop / 256 ? 1 : (this.hospitalCount > this.resPop / 256 ? -1 : 0);
        this.needChurch = this.churchCount < this.resPop / 256 ? 1 : (this.churchCount > this.resPop / 256 ? -1 : 0);
    }

    void takeCensus2() {
        int resMax = 0;
        int comMax = 0;
        int indMax = 0;
        for (int i = 238; i >= 120; --i) {
            if (this.history.res[i] > resMax) {
                resMax = this.history.res[i];
            }
            if (this.history.com[i] > comMax) {
                comMax = this.history.res[i];
            }
            if (this.history.ind[i] > indMax) {
                indMax = this.history.ind[i];
            }
            this.history.res[i + 1] = this.history.res[i];
            this.history.com[i + 1] = this.history.com[i];
            this.history.ind[i + 1] = this.history.ind[i];
            this.history.crime[i + 1] = this.history.crime[i];
            this.history.pollution[i + 1] = this.history.pollution[i];
            this.history.money[i + 1] = this.history.money[i];
        }
        this.history.res[120] = this.resPop / 8;
        this.history.com[120] = this.comPop;
        this.history.ind[120] = this.indPop;
        this.history.crime[120] = this.history.crime[0];
        this.history.pollution[120] = this.history.pollution[0];
        this.history.money[120] = this.history.money[0];
    }

    void collectTaxPartial() {
        this.lastRoadTotal = this.roadTotal;
        this.lastRailTotal = this.railTotal;
        this.lastTotalPop = this.totalPop;
        this.lastFireStationCount = this.fireStationCount;
        this.lastPoliceCount = this.policeCount;
        BudgetNumbers b = this.generateBudget();
        this.budget.taxFund += b.taxIncome;
        this.budget.roadFundEscrow -= b.roadFunded;
        this.budget.fireFundEscrow -= b.fireFunded;
        this.budget.policeFundEscrow -= b.policeFunded;
        this.taxEffect = b.taxRate;
        this.roadEffect = b.roadRequest != 0 ? (int)Math.floor(32.0 * (double)b.roadFunded / (double)b.roadRequest) : 32;
        this.policeEffect = b.policeRequest != 0 ? (int)Math.floor(1000.0 * (double)b.policeFunded / (double)b.policeRequest) : 1000;
        this.fireEffect = b.fireRequest != 0 ? (int)Math.floor(1000.0 * (double)b.fireFunded / (double)b.fireRequest) : 1000;
    }

    void collectTax() {
        int revenue = this.budget.taxFund / 48;
        int expenses = -(this.budget.roadFundEscrow + this.budget.fireFundEscrow + this.budget.policeFundEscrow) / 48;
        FinancialHistory hist = new FinancialHistory();
        hist.cityTime = this.cityTime;
        hist.taxIncome = revenue;
        hist.operatingExpenses = expenses;
        this.cashFlow = revenue - expenses;
        this.spend(-this.cashFlow);
        hist.totalFunds = this.budget.totalFunds;
        this.financialHistory.add(0, hist);
        this.budget.taxFund = 0;
        this.budget.roadFundEscrow = 0;
        this.budget.fireFundEscrow = 0;
        this.budget.policeFundEscrow = 0;
    }

    public BudgetNumbers generateBudget() {
        BudgetNumbers b = new BudgetNumbers();
        b.taxRate = Math.max(0, this.cityTax);
        b.roadPercent = Math.max(0.0, this.roadPercent);
        b.firePercent = Math.max(0.0, this.firePercent);
        b.policePercent = Math.max(0.0, this.policePercent);
        b.previousBalance = this.budget.totalFunds;
        b.taxIncome = (int)Math.round((double)(this.lastTotalPop * this.landValueAverage / 120 * b.taxRate) * FLevels[this.gameLevel]);
        assert (b.taxIncome >= 0);
        b.roadRequest = (int)Math.round((double)(this.lastRoadTotal + this.lastRailTotal * 2) * RLevels[this.gameLevel]);
        b.fireRequest = 100 * this.lastFireStationCount;
        b.policeRequest = 100 * this.lastPoliceCount;
        b.roadFunded = (int)Math.round((double)b.roadRequest * b.roadPercent);
        b.fireFunded = (int)Math.round((double)b.fireRequest * b.firePercent);
        b.policeFunded = (int)Math.round((double)b.policeRequest * b.policePercent);
        int yumDuckets = this.budget.totalFunds + b.taxIncome;
        assert (yumDuckets >= 0);
        if (yumDuckets >= b.roadFunded) {
            if ((yumDuckets -= b.roadFunded) >= b.fireFunded) {
                if ((yumDuckets -= b.fireFunded) >= b.policeFunded) {
                    yumDuckets -= b.policeFunded;
                } else {
                    assert (b.policeRequest != 0);
                    b.policeFunded = yumDuckets;
                    b.policePercent = (double)b.policeFunded / (double)b.policeRequest;
                    yumDuckets = 0;
                }
            } else {
                assert (b.fireRequest != 0);
                b.fireFunded = yumDuckets;
                b.firePercent = (double)b.fireFunded / (double)b.fireRequest;
                b.policeFunded = 0;
                b.policePercent = 0.0;
                yumDuckets = 0;
            }
        } else {
            assert (b.roadRequest != 0);
            b.roadFunded = yumDuckets;
            b.roadPercent = (double)b.roadFunded / (double)b.roadRequest;
            b.fireFunded = 0;
            b.firePercent = 0.0;
            b.policeFunded = 0;
            b.policePercent = 0.0;
        }
        b.operatingExpenses = b.roadFunded + b.fireFunded + b.policeFunded;
        b.newBalance = b.previousBalance + b.taxIncome - b.operatingExpenses;
        return b;
    }

    int getPopulationDensity(int xpos, int ypos) {
        return this.popDensity[ypos / 2][xpos / 2];
    }

    void doMeltdown(int xpos, int ypos) {
        this.meltdownLocation = new CityLocation(xpos, ypos);
        this.makeExplosion(xpos - 1, ypos - 1);
        this.makeExplosion(xpos - 1, ypos + 2);
        this.makeExplosion(xpos + 2, ypos - 1);
        this.makeExplosion(xpos + 2, ypos + 2);
        for (int x = xpos - 1; x < xpos + 3; ++x) {
            for (int y = ypos - 1; y < ypos + 3; ++y) {
                this.setTile(x, y, (char)(56 + this.PRNG.nextInt(4)));
            }
        }
        for (int z = 0; z < 200; ++z) {
            char t;
            int y;
            int x = xpos - 20 + this.PRNG.nextInt(41);
            if (!this.testBounds(x, y = ypos - 15 + this.PRNG.nextInt(31)) || TileConstants.isZoneCenter(t = this.map[y][x]) || !TileConstants.isCombustible(t) && t != '\u0000') continue;
            this.setTile(x, y, '4');
        }
        this.clearMes();
        this.sendMessageAt(MicropolisMessage.MELTDOWN_REPORT, xpos, ypos);
    }

    void loadHistoryArray(int[] array, DataInputStream dis) throws IOException {
        for (int i = 0; i < 240; ++i) {
            array[i] = dis.readShort();
        }
    }

    void writeHistoryArray(int[] array, DataOutputStream out) throws IOException {
        for (int i = 0; i < 240; ++i) {
            out.writeShort(array[i]);
        }
    }

    void loadMisc(DataInputStream dis) throws IOException {
        dis.readShort();
        dis.readShort();
        this.resPop = dis.readShort();
        this.comPop = dis.readShort();
        this.indPop = dis.readShort();
        this.resValve = dis.readShort();
        this.comValve = dis.readShort();
        this.indValve = dis.readShort();
        this.cityTime = dis.readInt();
        this.crimeRamp = dis.readShort();
        this.polluteRamp = dis.readShort();
        this.landValueAverage = dis.readShort();
        this.crimeAverage = dis.readShort();
        this.pollutionAverage = dis.readShort();
        this.gameLevel = dis.readShort();
        this.evaluation.cityClass = dis.readShort();
        this.evaluation.cityScore = dis.readShort();
        for (int i = 18; i < 50; ++i) {
            dis.readShort();
        }
        this.budget.totalFunds = dis.readInt();
        this.autoBulldoze = dis.readShort() != 0;
        this.autoBudget = dis.readShort() != 0;
        this.autoGo = dis.readShort() != 0;
        dis.readShort();
        this.taxEffect = this.cityTax = (int)dis.readShort();
        short simSpeedAsInt = dis.readShort();
        this.simSpeed = simSpeedAsInt >= 0 && simSpeedAsInt <= 4 ? Speed.values()[simSpeedAsInt] : Speed.NORMAL;
        long n = dis.readInt();
        this.policePercent = (double)n / 65536.0;
        n = dis.readInt();
        this.firePercent = (double)n / 65536.0;
        n = dis.readInt();
        this.roadPercent = (double)n / 65536.0;
        for (int i = 64; i < 120; ++i) {
            dis.readShort();
        }
        if (this.cityTime < 0) {
            this.cityTime = 0;
        }
        if (this.cityTax < 0 || this.cityTax > 20) {
            this.cityTax = 7;
        }
        if (this.gameLevel < 0 || this.gameLevel > 2) {
            this.gameLevel = 0;
        }
        if (this.evaluation.cityClass < 0 || this.evaluation.cityClass > 5) {
            this.evaluation.cityClass = 0;
        }
        if (this.evaluation.cityScore < 1 || this.evaluation.cityScore > 999) {
            this.evaluation.cityScore = 500;
        }
        this.resCap = false;
        this.comCap = false;
        this.indCap = false;
    }

    void writeMisc(DataOutputStream out) throws IOException {
        int i;
        out.writeShort(0);
        out.writeShort(0);
        out.writeShort(this.resPop);
        out.writeShort(this.comPop);
        out.writeShort(this.indPop);
        out.writeShort(this.resValve);
        out.writeShort(this.comValve);
        out.writeShort(this.indValve);
        out.writeInt(this.cityTime);
        out.writeShort(this.crimeRamp);
        out.writeShort(this.polluteRamp);
        out.writeShort(this.landValueAverage);
        out.writeShort(this.crimeAverage);
        out.writeShort(this.pollutionAverage);
        out.writeShort(this.gameLevel);
        out.writeShort(this.evaluation.cityClass);
        out.writeShort(this.evaluation.cityScore);
        for (i = 18; i < 50; ++i) {
            out.writeShort(0);
        }
        out.writeInt(this.budget.totalFunds);
        out.writeShort(this.autoBulldoze ? 1 : 0);
        out.writeShort(this.autoBudget ? 1 : 0);
        out.writeShort(this.autoGo ? 1 : 0);
        out.writeShort(1);
        out.writeShort(this.cityTax);
        out.writeShort(this.simSpeed.ordinal());
        out.writeInt((int)(this.policePercent * 65536.0));
        out.writeInt((int)(this.firePercent * 65536.0));
        out.writeInt((int)(this.roadPercent * 65536.0));
        for (i = 64; i < 120; ++i) {
            out.writeShort(0);
        }
    }

    void loadMap(DataInputStream dis) throws IOException {
        for (int x = 0; x < 120; ++x) {
            for (int y = 0; y < 100; ++y) {
                int z = dis.readShort();
                this.map[y][x] = (char)(z &= 0xFFFF83FF);
            }
        }
    }

    void writeMap(DataOutputStream out) throws IOException {
        for (int x = 0; x < 120; ++x) {
            for (int y = 0; y < 100; ++y) {
                int z = this.map[y][x];
                if (TileConstants.isConductive(z & 0x3FF)) {
                    z |= 0x4000;
                }
                if (TileConstants.isCombustible(z & 0x3FF)) {
                    z |= 0x2000;
                }
                if (this.isTileDozeable(x, y)) {
                    z |= 0x1000;
                }
                if (TileConstants.isAnimated(z & 0x3FF)) {
                    z |= 0x800;
                }
                if (TileConstants.isZoneCenter(z & 0x3FF)) {
                    z |= 0x400;
                }
                out.writeShort(z);
            }
        }
    }

    public void load(File filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        if (fis.getChannel().size() > 27120L) {
            byte[] bbHeader = new byte[128];
            fis.read(bbHeader);
        }
        this.load(fis);
    }

    void checkPowerMap() {
        this.coalCount = 0;
        this.nuclearCount = 0;
        this.powerPlants.clear();
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                char tile = this.getTile(x, y);
                if (tile == '\u0330') {
                    ++this.nuclearCount;
                    this.powerPlants.add(new CityLocation(x, y));
                    continue;
                }
                if (tile != '\u02ee') continue;
                ++this.coalCount;
                this.powerPlants.add(new CityLocation(x, y));
            }
        }
        this.powerScan();
        this.newPower = true;
    }

    public void load(InputStream inStream) throws IOException {
        DataInputStream dis = new DataInputStream(inStream);
        this.loadHistoryArray(this.history.res, dis);
        this.loadHistoryArray(this.history.com, dis);
        this.loadHistoryArray(this.history.ind, dis);
        this.loadHistoryArray(this.history.crime, dis);
        this.loadHistoryArray(this.history.pollution, dis);
        this.loadHistoryArray(this.history.money, dis);
        this.loadMisc(dis);
        this.loadMap(dis);
        dis.close();
        this.checkPowerMap();
        this.fireWholeMapChanged();
        this.fireDemandChanged();
        this.fireFundsChanged();
    }

    public void save(File filename) throws IOException {
        this.save(new FileOutputStream(filename));
    }

    public void save(OutputStream outStream) throws IOException {
        DataOutputStream out = new DataOutputStream(outStream);
        this.writeHistoryArray(this.history.res, out);
        this.writeHistoryArray(this.history.com, out);
        this.writeHistoryArray(this.history.ind, out);
        this.writeHistoryArray(this.history.crime, out);
        this.writeHistoryArray(this.history.pollution, out);
        this.writeHistoryArray(this.history.money, out);
        this.writeMisc(out);
        this.writeMap(out);
        out.close();
    }

    public void toggleAutoBudget() {
        this.autoBudget = !this.autoBudget;
        this.fireOptionsChanged();
    }

    public void toggleAutoBulldoze() {
        this.autoBulldoze = !this.autoBulldoze;
        this.fireOptionsChanged();
    }

    public void toggleDisasters() {
        this.noDisasters = !this.noDisasters;
        this.fireOptionsChanged();
    }

    public void setSpeed(Speed newSpeed) {
        this.simSpeed = newSpeed;
        this.fireOptionsChanged();
    }

    public void animate() {
        this.acycle = (this.acycle + 1) % 960;
        if (this.acycle % 2 == 0) {
            this.step();
        }
        this.moveObjects();
        this.animateTiles();
    }

    public Sprite[] allSprites() {
        return this.sprites.toArray(new Sprite[0]);
    }

    void moveObjects() {
        for (Sprite sprite : this.allSprites()) {
            sprite.move();
            if (sprite.frame != 0) continue;
            this.sprites.remove(sprite);
        }
    }

    void animateTiles() {
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                char tilevalue = this.map[y][x];
                TileSpec spec = Tiles.get(tilevalue & 0x3FF);
                if (spec == null || spec.animNext == null) continue;
                int flags = tilevalue & 0xFC00;
                this.setTile(x, y, (char)(spec.animNext.tileNumber | flags));
            }
        }
    }

    public int getCityPopulation() {
        return this.lastCityPop;
    }

    void makeSound(int x, int y, Sound sound) {
        this.fireCitySound(sound, new CityLocation(x, y));
    }

    public void makeEarthquake() {
        this.makeSound(this.centerMassX, this.centerMassY, Sound.EXPLOSION_LOW);
        this.fireEarthquakeStarted();
        this.sendMessageAt(MicropolisMessage.EARTHQUAKE_REPORT, this.centerMassX, this.centerMassY);
        int time = this.PRNG.nextInt(701) + 300;
        for (int z = 0; z < time; ++z) {
            int x = this.PRNG.nextInt(this.getWidth());
            int y = this.PRNG.nextInt(this.getHeight());
            assert (this.testBounds(x, y));
            if (!TileConstants.isVulnerable(this.getTile(x, y))) continue;
            if (this.PRNG.nextInt(4) != 0) {
                this.setTile(x, y, (char)(44 + this.PRNG.nextInt(4)));
                continue;
            }
            this.setTile(x, y, (char)(56 + this.PRNG.nextInt(8)));
        }
    }

    void setFire() {
        int y;
        int x = this.PRNG.nextInt(this.getWidth());
        char t = this.getTile(x, y = this.PRNG.nextInt(this.getHeight()));
        if (TileConstants.isArsonable(t)) {
            this.setTile(x, y, (char)(56 + this.PRNG.nextInt(8)));
            this.crashLocation = new CityLocation(x, y);
            this.sendMessageAt(MicropolisMessage.FIRE_REPORT, x, y);
        }
    }

    public void makeFire() {
        for (int t = 0; t < 40; ++t) {
            int y;
            int x = this.PRNG.nextInt(this.getWidth());
            char tile = this.getTile(x, y = this.PRNG.nextInt(this.getHeight()));
            if (TileConstants.isZoneCenter(tile) || !TileConstants.isCombustible(tile) || tile <= '\u0015' || tile >= '\u033a') continue;
            this.setTile(x, y, (char)(56 + this.PRNG.nextInt(8)));
            this.sendMessageAt(MicropolisMessage.FIRE_REPORT, x, y);
            return;
        }
    }

    public boolean makeMeltdown() {
        ArrayList<CityLocation> candidates = new ArrayList<CityLocation>();
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                if (this.getTile(x, y) != '\u0330') continue;
                candidates.add(new CityLocation(x, y));
            }
        }
        if (candidates.isEmpty()) {
            return false;
        }
        int i = this.PRNG.nextInt(candidates.size());
        CityLocation p = (CityLocation)candidates.get(i);
        this.doMeltdown(p.x, p.y);
        return true;
    }

    public void makeMonster() {
        MonsterSprite monster = (MonsterSprite)this.getSprite(SpriteKind.GOD);
        if (monster != null) {
            monster.soundCount = 1;
            monster.count = 1000;
            monster.flag = false;
            monster.destX = this.pollutionMaxLocationX;
            monster.destY = this.pollutionMaxLocationY;
            return;
        }
        for (int i = 0; i < 300; ++i) {
            int y;
            int x = this.PRNG.nextInt(this.getWidth() - 19) + 10;
            char t = this.getTile(x, y = this.PRNG.nextInt(this.getHeight() - 9) + 5);
            if (t != '\u0002') continue;
            this.makeMonsterAt(x, y);
            return;
        }
        this.makeMonsterAt(this.getWidth() / 2, this.getHeight() / 2);
    }

    void makeMonsterAt(int xpos, int ypos) {
        assert (!this.hasSprite(SpriteKind.GOD));
        this.sprites.add(new MonsterSprite(this, xpos, ypos));
        this.sendMessageAt(MicropolisMessage.MONSTER_REPORT, xpos, ypos);
    }

    public void makeTornado() {
        TornadoSprite tornado = (TornadoSprite)this.getSprite(SpriteKind.TOR);
        if (tornado != null) {
            tornado.count = 200;
            return;
        }
        int xpos = this.PRNG.nextInt(this.getWidth() - 19) + 10;
        int ypos = this.PRNG.nextInt(this.getHeight() - 19) + 10;
        this.sprites.add(new TornadoSprite(this, xpos, ypos));
        this.sendMessageAt(MicropolisMessage.TORNADO_REPORT, xpos, ypos);
    }

    public void makeFlood() {
        int[] DX = new int[]{0, 1, 0, -1};
        int[] DY = new int[]{-1, 0, 1, 0};
        for (int z = 0; z < 300; ++z) {
            int y;
            int x = this.PRNG.nextInt(this.getWidth());
            char tile = this.getTile(x, y = this.PRNG.nextInt(this.getHeight()));
            if (!TileConstants.isRiverEdge(tile)) continue;
            for (int t = 0; t < 4; ++t) {
                char c;
                int xx = x + DX[t];
                int yy = y + DY[t];
                if (!this.testBounds(xx, yy) || !TileConstants.isFloodable(c = this.map[yy][xx])) continue;
                this.setTile(xx, yy, '0');
                this.floodCnt = 30;
                this.sendMessageAt(MicropolisMessage.FLOOD_REPORT, xx, yy);
                this.floodX = xx;
                this.floodY = yy;
                return;
            }
        }
    }

    void killZone(int xpos, int ypos, int zoneTile) {
        int[] nArray = this.rateOGMem[ypos / 8];
        int n = xpos / 8;
        nArray[n] = nArray[n] - 20;
        assert (TileConstants.isZoneCenter(zoneTile));
        CityDimension dim = TileConstants.getZoneSizeFor(zoneTile);
        assert (dim != null);
        assert (dim.width >= 3);
        assert (dim.height >= 3);
        int zoneBase = (zoneTile & 0x3FF) - 1 - dim.width;
        this.shutdownZone(xpos, ypos, dim);
    }

    void powerZone(int xpos, int ypos, CityDimension zoneSize) {
        assert (zoneSize.width >= 3);
        assert (zoneSize.height >= 3);
        for (int dx = 0; dx < zoneSize.width; ++dx) {
            for (int dy = 0; dy < zoneSize.height; ++dy) {
                int x = xpos - 1 + dx;
                int y = ypos - 1 + dy;
                char tile = this.getTileRaw(x, y);
                TileSpec ts = Tiles.get(tile & 0x3FF);
                if (ts == null || ts.onPower == null) continue;
                this.setTile(x, y, (char)(ts.onPower.tileNumber | tile & 0xFC00));
            }
        }
    }

    void shutdownZone(int xpos, int ypos, CityDimension zoneSize) {
        assert (zoneSize.width >= 3);
        assert (zoneSize.height >= 3);
        for (int dx = 0; dx < zoneSize.width; ++dx) {
            for (int dy = 0; dy < zoneSize.height; ++dy) {
                int x = xpos - 1 + dx;
                int y = ypos - 1 + dy;
                char tile = this.getTileRaw(x, y);
                TileSpec ts = Tiles.get(tile & 0x3FF);
                if (ts == null || ts.onShutdown == null) continue;
                this.setTile(x, y, (char)(ts.onShutdown.tileNumber | tile & 0xFC00));
            }
        }
    }

    void makeExplosion(int xpos, int ypos) {
        this.makeExplosionAt(xpos * 16 + 8, ypos * 16 + 8);
    }

    void makeExplosionAt(int x, int y) {
        this.sprites.add(new ExplosionSprite(this, x, y));
    }

    void checkGrowth() {
        if (this.cityTime % 4 == 0) {
            int newPop = (this.resPop + this.comPop * 8 + this.indPop * 8) * 20;
            if (this.lastCityPop != 0) {
                MicropolisMessage z = null;
                if (this.lastCityPop < 500000 && newPop >= 500000) {
                    z = MicropolisMessage.POP_500K_REACHED;
                } else if (this.lastCityPop < 100000 && newPop >= 100000) {
                    z = MicropolisMessage.POP_100K_REACHED;
                } else if (this.lastCityPop < 50000 && newPop >= 50000) {
                    z = MicropolisMessage.POP_50K_REACHED;
                } else if (this.lastCityPop < 10000 && newPop >= 10000) {
                    z = MicropolisMessage.POP_10K_REACHED;
                } else if (this.lastCityPop < 2000 && newPop >= 2000) {
                    z = MicropolisMessage.POP_2K_REACHED;
                }
                if (z != null) {
                    this.sendMessage(z);
                }
            }
            this.lastCityPop = newPop;
        }
    }

    void doMessages() {
        this.checkGrowth();
        int totalZoneCount = this.resZoneCount + this.comZoneCount + this.indZoneCount;
        int powerCount = this.nuclearCount + this.coalCount;
        int z = this.cityTime % 64;
        switch (z) {
            case 1: {
                if (totalZoneCount / 4 < this.resZoneCount) break;
                this.sendMessage(MicropolisMessage.NEED_RES);
                break;
            }
            case 5: {
                if (totalZoneCount / 8 < this.comZoneCount) break;
                this.sendMessage(MicropolisMessage.NEED_COM);
                break;
            }
            case 10: {
                if (totalZoneCount / 8 < this.indZoneCount) break;
                this.sendMessage(MicropolisMessage.NEED_IND);
                break;
            }
            case 14: {
                if (totalZoneCount <= 10 || totalZoneCount * 2 <= this.roadTotal) break;
                this.sendMessage(MicropolisMessage.NEED_ROADS);
                break;
            }
            case 18: {
                if (totalZoneCount <= 50 || totalZoneCount <= this.railTotal) break;
                this.sendMessage(MicropolisMessage.NEED_RAILS);
                break;
            }
            case 22: {
                if (totalZoneCount <= 10 || powerCount != 0) break;
                this.sendMessage(MicropolisMessage.NEED_POWER);
                break;
            }
            case 26: {
                boolean bl = this.resCap = this.resPop > 500 && this.stadiumCount == 0;
                if (!this.resCap) break;
                this.sendMessage(MicropolisMessage.NEED_STADIUM);
                break;
            }
            case 28: {
                boolean bl = this.indCap = this.indPop > 70 && this.seaportCount == 0;
                if (!this.indCap) break;
                this.sendMessage(MicropolisMessage.NEED_SEAPORT);
                break;
            }
            case 30: {
                boolean bl = this.comCap = this.comPop > 100 && this.airportCount == 0;
                if (!this.comCap) break;
                this.sendMessage(MicropolisMessage.NEED_AIRPORT);
                break;
            }
            case 32: {
                int TM = this.unpoweredZoneCount + this.poweredZoneCount;
                if (TM == 0 || !((double)this.poweredZoneCount / (double)TM < 0.7)) break;
                this.sendMessage(MicropolisMessage.BLACKOUTS);
                break;
            }
            case 35: {
                if (this.pollutionAverage <= 60) break;
                this.sendMessage(MicropolisMessage.HIGH_POLLUTION);
                break;
            }
            case 42: {
                if (this.crimeAverage <= 100) break;
                this.sendMessage(MicropolisMessage.HIGH_CRIME);
                break;
            }
            case 45: {
                if (this.totalPop <= 60 || this.fireStationCount != 0) break;
                this.sendMessage(MicropolisMessage.NEED_FIRESTATION);
                break;
            }
            case 48: {
                if (this.totalPop <= 60 || this.policeCount != 0) break;
                this.sendMessage(MicropolisMessage.NEED_POLICE);
                break;
            }
            case 51: {
                if (this.cityTax <= 12) break;
                this.sendMessage(MicropolisMessage.HIGH_TAXES);
                break;
            }
            case 54: {
                if (this.roadEffect >= 20 || this.roadTotal <= 30) break;
                this.sendMessage(MicropolisMessage.ROADS_NEED_FUNDING);
                break;
            }
            case 57: {
                if (this.fireEffect >= 700 || this.totalPop <= 20) break;
                this.sendMessage(MicropolisMessage.FIRE_NEED_FUNDING);
                break;
            }
            case 60: {
                if (this.policeEffect >= 700 || this.totalPop <= 20) break;
                this.sendMessage(MicropolisMessage.POLICE_NEED_FUNDING);
                break;
            }
            case 63: {
                if (this.trafficAverage <= 60) break;
                this.sendMessage(MicropolisMessage.HIGH_TRAFFIC);
                break;
            }
        }
    }

    void clearMes() {
    }

    void sendMessage(MicropolisMessage message) {
        this.fireCityMessage(message, null);
    }

    void sendMessageAt(MicropolisMessage message, int x, int y) {
        this.fireCityMessage(message, new CityLocation(x, y));
    }

    public ZoneStatus queryZoneStatus(int xpos, int ypos) {
        ZoneStatus zs = new ZoneStatus();
        zs.building = TileConstants.getDescriptionNumber(this.getTile(xpos, ypos));
        int z = this.popDensity[ypos / 2][xpos / 2] / 64 % 4;
        zs.popDensity = z + 1;
        z = this.landValueMem[ypos / 2][xpos / 2];
        z = z < 30 ? 4 : (z < 80 ? 5 : (z < 150 ? 6 : 7));
        zs.landValue = z + 1;
        z = this.crimeMem[ypos / 2][xpos / 2] / 64 % 4 + 8;
        zs.crimeLevel = z + 1;
        z = Math.max(13, this.pollutionMem[ypos / 2][xpos / 2] / 64 % 4 + 12);
        zs.pollution = z + 1;
        z = this.rateOGMem[ypos / 8][xpos / 8];
        z = z < 0 ? 16 : (z == 0 ? 17 : (z <= 100 ? 18 : 19));
        zs.growthRate = z + 1;
        return zs;
    }

    public int getResValve() {
        return this.resValve;
    }

    public int getComValve() {
        return this.comValve;
    }

    public int getIndValve() {
        return this.indValve;
    }

    public void setGameLevel(int newLevel) {
        assert (GameLevel.isValid(newLevel));
        this.gameLevel = newLevel;
        this.fireOptionsChanged();
    }

    public void setFunds(int totalFunds) {
        this.budget.totalFunds = totalFunds;
    }

    public static class FinancialHistory {
        public int cityTime;
        public int totalFunds;
        public int taxIncome;
        public int operatingExpenses;
    }

    public static class History {
        public int cityTime;
        public int[] res = new int[240];
        public int[] com = new int[240];
        public int[] ind = new int[240];
        public int[] money = new int[240];
        public int[] pollution = new int[240];
        public int[] crime = new int[240];
        int resMax;
        int comMax;
        int indMax;
    }

    public static interface Listener {
        public void cityMessage(MicropolisMessage var1, CityLocation var2);

        public void citySound(Sound var1, CityLocation var2);

        public void censusChanged();

        public void demandChanged();

        public void evaluationChanged();

        public void fundsChanged();

        public void optionsChanged();
    }
}

