/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.MonsterSprite;
import micropolisj.engine.Sound;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TornadoSprite;

public class HelicopterSprite
extends Sprite {
    int count;
    int destX;
    int destY;
    int origX;
    int origY;
    static int[] CDx = new int[]{0, 0, 3, 5, 3, 0, -3, -5, -3};
    static int[] CDy = new int[]{0, -5, -3, 0, 3, 5, 3, 0, -3};
    static final int SOUND_FREQ = 200;

    public HelicopterSprite(Micropolis engine, int xpos, int ypos) {
        super(engine, SpriteKind.COP);
        this.x = xpos * 16 + 8;
        this.y = ypos * 16 + 8;
        this.width = 32;
        this.height = 32;
        this.offx = -16;
        this.offy = -16;
        this.destX = this.city.PRNG.nextInt(this.city.getWidth()) * 16 + 8;
        this.destY = this.city.PRNG.nextInt(this.city.getHeight()) * 16 + 8;
        this.origX = this.x;
        this.origY = this.y;
        this.count = 1500;
        this.frame = 5;
    }

    @Override
    public void moveImpl() {
        int ypos;
        int xpos;
        if (this.count > 0) {
            --this.count;
        }
        if (this.count == 0) {
            if (this.city.hasSprite(SpriteKind.GOD)) {
                MonsterSprite monster = (MonsterSprite)this.city.getSprite(SpriteKind.GOD);
                this.destX = monster.x;
                this.destY = monster.y;
            } else if (this.city.hasSprite(SpriteKind.TOR)) {
                TornadoSprite tornado = (TornadoSprite)this.city.getSprite(SpriteKind.TOR);
                this.destX = tornado.x;
                this.destY = tornado.y;
            } else {
                this.destX = this.origX;
                this.destY = this.origY;
            }
            if (HelicopterSprite.getDis(this.x, this.y, this.origX, this.origY) < 30) {
                this.frame = 0;
                return;
            }
        }
        if (this.city.acycle % 200 == 0 && this.city.getTrafficDensity(xpos = this.x / 16, ypos = this.y / 16) > 170 && this.city.PRNG.nextInt(8) == 0) {
            this.city.sendMessageAt(MicropolisMessage.HEAVY_TRAFFIC_REPORT, xpos, ypos);
            this.city.makeSound(xpos, ypos, Sound.HEAVYTRAFFIC);
        }
        int z = this.frame;
        if (this.city.acycle % 3 == 0) {
            int d = HelicopterSprite.getDir(this.x, this.y, this.destX, this.destY);
            this.frame = z = HelicopterSprite.turnTo(z, d);
        }
        this.x += CDx[z];
        this.y += CDy[z];
    }
}

