/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import micropolisj.engine.Micropolis;
import micropolisj.engine.MicropolisMessage;
import micropolisj.engine.Sound;
import micropolisj.engine.Sprite;
import micropolisj.engine.SpriteKind;
import micropolisj.engine.TileConstants;

public class ExplosionSprite
extends Sprite {
    public ExplosionSprite(Micropolis engine, int x, int y) {
        super(engine, SpriteKind.EXP);
        this.x = x;
        this.y = y;
        this.width = 48;
        this.height = 48;
        this.offx = -24;
        this.offy = -24;
        this.frame = 1;
    }

    @Override
    public void moveImpl() {
        if (this.city.acycle % 2 == 0) {
            if (this.frame == 1) {
                this.city.makeSound(this.x / 16, this.y / 16, Sound.EXPLOSION_HIGH);
                this.city.sendMessageAt(MicropolisMessage.EXPLOSION_REPORT, this.x / 16, this.y / 16);
            }
            ++this.frame;
        }
        if (this.frame > 6) {
            this.frame = 0;
            this.startFire(this.x / 16, this.y / 16);
            this.startFire(this.x / 16 - 1, this.y / 16 - 1);
            this.startFire(this.x / 16 + 1, this.y / 16 - 1);
            this.startFire(this.x / 16 - 1, this.y / 16 + 1);
            this.startFire(this.x / 16 + 1, this.y / 16 + 1);
            return;
        }
    }

    void startFire(int xpos, int ypos) {
        if (!this.city.testBounds(xpos, ypos)) {
            return;
        }
        char t = this.city.getTile(xpos, ypos);
        if (!TileConstants.isCombustible(t) && t != '\u0000') {
            return;
        }
        if (TileConstants.isZoneCenter(t)) {
            return;
        }
        this.city.setTile(xpos, ypos, (char)(56 + this.city.PRNG.nextInt(4)));
    }
}

