/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.build_tool;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class RearrangeTiles {
    static final int DEST_COLUMNS = 16;
    static final int TILE_SIZE = 16;

    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        Image srcImage = new ImageIcon(inputFile.toString()).getImage();
        int srcCols = srcImage.getWidth(null) / 16;
        int srcRows = srcImage.getHeight(null) / 16;
        int ntiles = srcRows * srcCols;
        int destCols = 16;
        int destRows = (ntiles + destCols - 1) / destCols;
        BufferedImage buf = new BufferedImage(256, 16 * destRows, 1);
        Graphics2D gr = buf.createGraphics();
        for (int i = 0; i < ntiles; ++i) {
            int srcRow = i / srcCols;
            int srcCol = i % srcCols;
            int destRow = i / destCols;
            int destCol = i % destCols;
            gr.drawImage(srcImage, destCol * 16, destRow * 16, (destCol + 1) * 16, (destRow + 1) * 16, srcCol * 16, srcRow * 16, (srcCol + 1) * 16, (srcRow + 1) * 16, null);
        }
        ImageIO.write((RenderedImage)buf, "png", outputFile);
    }
}

