/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.build_tool;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import micropolisj.engine.TileSpec;

public class MakeTiles {
    static HashMap<String, String> tileData = new HashMap();
    static HashMap<String, SourceImage> loadedImages = new HashMap();
    static final Charset UTF8 = Charset.forName("UTF-8");
    static int SKIP_TILES = 0;
    static int COUNT_TILES = -1;
    static final int STD_SIZE = 16;
    static int TILE_SIZE = 16;
    static File stagingDir = new File("generated");

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Wrong number of arguments");
        }
        if (System.getProperty("tile_size") != null) {
            TILE_SIZE = Integer.parseInt(System.getProperty("tile_size"));
        }
        if (System.getProperty("skip_tiles") != null) {
            SKIP_TILES = Integer.parseInt(System.getProperty("skip_tiles"));
        }
        if (System.getProperty("tile_count") != null) {
            COUNT_TILES = Integer.parseInt(System.getProperty("tile_count"));
        }
        File recipeFile = new File(args[0]);
        File outputDir = new File(args[1]);
        MakeTiles.generateFromRecipe(recipeFile, outputDir);
    }

    static void generateFromRecipe(File recipeFile, File outputDir) throws IOException {
        Properties recipe = new Properties();
        recipe.load(new InputStreamReader((InputStream)new FileInputStream(recipeFile), UTF8));
        String[] tileNames = TileSpec.generateTileNames(recipe);
        int ntiles = COUNT_TILES == -1 ? tileNames.length : COUNT_TILES;
        BufferedImage buf = new BufferedImage(TILE_SIZE, TILE_SIZE * ntiles, 1);
        Graphics2D gr = buf.createGraphics();
        for (int i = 0; i < ntiles; ++i) {
            int tileNumber = SKIP_TILES + i;
            if (tileNumber < 0 || tileNumber >= tileNames.length) continue;
            String tileName = tileNames[tileNumber];
            String rawSpec = recipe.getProperty(tileName);
            assert (rawSpec != null);
            TileSpec tileSpec = TileSpec.parse(tileNumber, tileName, rawSpec, recipe);
            FrameSpec ref = MakeTiles.parseFrameSpec(tileSpec);
            if (ref == null) continue;
            MakeTiles.drawTo(ref, gr, 0, TILE_SIZE * i);
        }
        outputDir.mkdirs();
        File outputFile = new File(outputDir, "tiles.png");
        System.out.println("Generating tiles array: " + outputFile);
        ImageIO.write((RenderedImage)buf, "png", outputFile);
        File indexFile = new File(outputDir, "tiles.idx");
        System.out.println("Generating tiles index: " + indexFile);
        MakeTiles.writeIndexFile(tileNames, indexFile);
    }

    static void writeIndexFile(String[] tileNames, File indexFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(indexFile));
        for (int i = 0; i < tileNames.length; ++i) {
            out.printf("%s %d\n", tileNames[i], i);
        }
        out.close();
    }

    static void drawTo(FrameSpec ref, Graphics2D gr, int destX, int destY) throws IOException {
        if (ref.background != null) {
            MakeTiles.drawTo(ref.background, gr, destX, destY);
        }
        SourceImage sourceImg = ref.image;
        gr.drawImage(sourceImg.image, destX, destY, destX + TILE_SIZE, destY + TILE_SIZE, ref.offsetX * sourceImg.basisSize / 16, ref.offsetY * sourceImg.basisSize / 16, (ref.offsetX + 16) * sourceImg.basisSize / 16, (ref.offsetY + 16) * sourceImg.basisSize / 16, null);
    }

    static FrameSpec parseFrameSpec(TileSpec spec) throws IOException {
        FrameSpec result = null;
        for (String layerStr : spec.getImages()) {
            FrameSpec rv = new FrameSpec();
            rv.background = result;
            result = rv;
            String[] parts = layerStr.split("@", 2);
            rv.image = MakeTiles.loadImage(parts[0]);
            if (parts.length < 2) continue;
            String offsetInfo = parts[1];
            if ((parts = offsetInfo.split(",")).length >= 1) {
                rv.offsetX = Integer.parseInt(parts[0]);
            }
            if (parts.length < 2) continue;
            rv.offsetY = Integer.parseInt(parts[1]);
        }
        return result;
    }

    static File findInkscape() {
        File[] pathsToTry;
        String exeName = "inkscape";
        if (System.getProperty("os.name").startsWith("Windows")) {
            exeName = exeName + ".exe";
        }
        for (File p : pathsToTry = new File[]{new File("/usr/bin"), new File("c:\\Program Files\\Inkscape"), new File("c:\\Program Files (x86)\\Inkscape")}) {
            File f = new File(p, exeName);
            if (!f.exists()) continue;
            return f;
        }
        throw new Error("INKSCAPE not installed (or not found)");
    }

    static File renderSvg(String fileName, File svgFile) throws IOException {
        int exit_value;
        File pngFile = new File(stagingDir, fileName + "_" + TILE_SIZE + "x" + TILE_SIZE + ".png");
        if (pngFile.exists() && pngFile.lastModified() > svgFile.lastModified()) {
            return pngFile;
        }
        File inkscapeBin = MakeTiles.findInkscape();
        System.out.println("Generating raster image: " + pngFile);
        if (pngFile.exists()) {
            pngFile.delete();
        } else {
            pngFile.getParentFile().mkdirs();
        }
        String[] cmdline = new String[]{inkscapeBin.toString(), "--export-dpi=" + (double)TILE_SIZE * 90.0 / 16.0, "--export-png=" + pngFile.toString(), svgFile.toString()};
        Process p = Runtime.getRuntime().exec(cmdline);
        try {
            exit_value = p.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (exit_value != 0) {
            throw new RuntimeException("Helper exit status: " + exit_value);
        }
        if (!pngFile.exists()) {
            throw new RuntimeException("File not found: " + pngFile);
        }
        return pngFile;
    }

    static SourceImage loadImage(String fileName) throws IOException {
        if (!loadedImages.containsKey(fileName)) {
            loadedImages.put(fileName, MakeTiles.loadImageReal(fileName));
        }
        return loadedImages.get(fileName);
    }

    static SourceImage loadImageReal(String fileName) throws IOException {
        File pngFile = null;
        File svgFile = new File(fileName + "_" + TILE_SIZE + "x" + TILE_SIZE + ".svg");
        if (svgFile.exists()) {
            pngFile = MakeTiles.renderSvg(fileName, svgFile);
        } else {
            svgFile = new File(fileName + ".svg");
            if (svgFile.exists()) {
                pngFile = MakeTiles.renderSvg(fileName, svgFile);
            }
        }
        if (pngFile != null && pngFile.exists()) {
            ImageIcon ii = new ImageIcon(pngFile.toString());
            return new SourceImage(ii.getImage(), TILE_SIZE);
        }
        pngFile = new File(fileName + "_" + TILE_SIZE + "x" + TILE_SIZE + ".png");
        if (pngFile.exists()) {
            ImageIcon ii = new ImageIcon(pngFile.toString());
            return new SourceImage(ii.getImage(), TILE_SIZE);
        }
        pngFile = new File(fileName + ".png");
        if (pngFile.exists()) {
            ImageIcon ii = new ImageIcon(pngFile.toString());
            return new SourceImage(ii.getImage(), 16);
        }
        throw new IOException("File not found: " + fileName + ".{svg,png}");
    }

    static class FrameSpec {
        FrameSpec background;
        SourceImage image;
        int offsetX;
        int offsetY;

        FrameSpec() {
        }
    }

    static class SourceImage {
        Image image;
        int basisSize;

        SourceImage(Image image, int basisSize) {
            this.image = image;
            this.basisSize = basisSize;
        }
    }
}

