/*
 * Decompiled with CFR 0.152.
 */
package life.v41d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Panel;
import life.v41d.LifeButton;
import life.v41d.LifeCell;
import life.v41d.LifeGen;

class LifeGUI
extends Panel {
    private int fieldWidth;
    private int fieldHeight;
    private int fieldSizeX;
    private int fieldSizeY;
    private int cellMagnitude;
    private int pixelsPerCell;
    private int ppc;
    private int ppc2;
    private boolean specialCase;
    private Color fgColor = new Color(0, 0, 160);
    private Color bgColor = Color.lightGray;
    private Color gridColor = Color.gray;
    private boolean grids;
    private int toolbarHeight;
    public int oX = 1;
    public int oY = 1;
    public int xOrig;
    public int yOrig;
    private Graphics g;
    private boolean viewChanged = true;
    private int[] xTranslate;
    private int[] yTranslate;
    private boolean boundsCheck = true;
    private boolean[][] field;
    private boolean[] column;

    public boolean getState(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.fieldSizeX && n2 < this.fieldSizeY) {
            return this.field[n][n2];
        }
        return false;
    }

    public void toggleState(int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this.fieldSizeX && n2 < this.fieldSizeY) {
            boolean[] blArray = this.field[n];
            int n3 = n2;
            blArray[n3] = blArray[n3] ^ true;
        }
    }

    public void setState(int n, int n2, boolean bl) {
        if (n >= 0 && n2 >= 0 && n < this.fieldSizeX && n2 < this.fieldSizeY) {
            this.field[n][n2] = bl;
        }
    }

    LifeGUI(int n, int n2, int n3, int n4, boolean bl) {
        this.fieldWidth = n;
        this.fieldHeight = n2;
        this.cellMagnitude = n3;
        this.grids = bl;
        this.toolbarHeight = n4;
        this.moveTo(0, 0);
    }

    public void moveTo(int n, int n2) {
        this.buildNewField();
        this.xOrig = n - this.fieldSizeX / 2;
        this.yOrig = n2 - this.fieldSizeY / 2;
    }

    public int getCenterX() {
        return this.xOrig + this.fieldSizeX / 2;
    }

    public int getCenterY() {
        return this.yOrig + this.fieldSizeY / 2;
    }

    private void buildNewField() {
        this.pixelsPerCell = 1 << this.cellMagnitude;
        int n = this.fieldWidth / this.pixelsPerCell;
        int n2 = this.fieldHeight / this.pixelsPerCell;
        boolean[][] blArray = new boolean[n][n2];
        if (this.field != null) {
            this.xOrig += (this.fieldSizeX - n) / 2;
            this.yOrig += (this.fieldSizeY - n2) / 2;
        }
        this.field = blArray;
        this.fieldSizeX = n;
        this.fieldSizeY = n2;
        this.ppc = this.pixelsPerCell - (this.cellMagnitude > 1 && this.grids ? 1 : 0);
        if (!LifeButton.clearRectBroken) {
            this.ppc2 = this.ppc;
            this.specialCase = false;
        } else {
            this.ppc2 = this.ppc - 1;
            this.specialCase = this.ppc2 == 0;
        }
        this.createTranslationTables();
    }

    private void createTranslationTables() {
        this.xTranslate = new int[this.fieldSizeX];
        int n = 0;
        while (n < this.fieldSizeX) {
            this.xTranslate[n] = n * this.pixelsPerCell + this.oX;
            ++n;
        }
        this.yTranslate = new int[this.fieldSizeY];
        int n2 = 0;
        while (n2 < this.fieldSizeY) {
            this.yTranslate[n2] = n2 * this.pixelsPerCell + this.oY;
            ++n2;
        }
    }

    public Color newColor(String string) {
        Color color = null;
        if (string != null) {
            try {
                color = new Color(Integer.parseInt(string, 16));
            }
            catch (NumberFormatException numberFormatException) {
                color = null;
            }
        }
        return color;
    }

    public void setColors(String string, String string2, String string3) {
        Color color = this.newColor(string);
        if (color != null) {
            this.fgColor = color;
        }
        if ((color = this.newColor(string2)) != null) {
            this.bgColor = color;
        }
        if ((color = this.newColor(string3)) != null) {
            this.gridColor = color;
        }
    }

    public boolean setZoom(int n) {
        if (this.cellMagnitude == n) {
            return false;
        }
        this.cellMagnitude = n;
        this.buildNewField();
        this.viewChanged = true;
        return true;
    }

    public int getZoom() {
        return this.cellMagnitude;
    }

    public int getCellsAcross() {
        return this.fieldSizeX;
    }

    public int getCellsDown() {
        return this.fieldSizeY;
    }

    public int getPixelsPerCell() {
        return this.pixelsPerCell;
    }

    public int convertAppletToFieldX(int n) {
        return n - this.oX >> this.cellMagnitude;
    }

    public int convertAppletToFieldY(int n) {
        return n - this.oY - this.toolbarHeight >> this.cellMagnitude;
    }

    public int convertFieldToUniverseX(int n) {
        return n + this.xOrig;
    }

    public int convertFieldToUniverseY(int n) {
        return n + this.yOrig;
    }

    public void setGraphicsContext(Graphics graphics) {
        this.g = graphics;
        this.g.setColor(this.fgColor);
        this.g.setXORMode(this.bgColor);
    }

    public void drawCell(int n, int n2) {
        this.drawCell(n, n2, this.getState(n, n2));
    }

    public void drawCell(int n, int n2, boolean bl) {
        if (bl) {
            this.g.fillRect(this.xTranslate[n], this.yTranslate[n2], this.ppc, this.ppc);
        } else if (this.specialCase) {
            this.g.setColor(this.bgColor);
            this.g.fillRect(this.xTranslate[n], this.yTranslate[n2], 1, 1);
            this.g.setColor(this.fgColor);
        } else {
            this.g.clearRect(this.xTranslate[n], this.yTranslate[n2], this.ppc2, this.ppc2);
        }
    }

    public void drawGrid() {
        int n = this.oX - 1;
        int n2 = this.oY - 1;
        this.g.setPaintMode();
        this.g.clearRect(this.oX, this.oY, this.fieldWidth + this.oX, this.fieldHeight + this.oY);
        this.g.setColor(this.gridColor);
        if (this.cellMagnitude > 1 && this.grids) {
            int n3 = 0;
            while (n3 <= this.fieldSizeY) {
                this.g.drawLine(n, n3 * this.pixelsPerCell + n2, this.fieldWidth + n, n3 * this.pixelsPerCell + n2);
                ++n3;
            }
            int n4 = 0;
            while (n4 <= this.fieldSizeX) {
                this.g.drawLine(n4 * this.pixelsPerCell + n, n2, n4 * this.pixelsPerCell + n, this.fieldHeight + n2);
                ++n4;
            }
        } else {
            int n5 = this.fieldWidth + this.oX;
            int n6 = this.fieldHeight + this.oY;
            this.g.drawLine(n, n2, n5, n2);
            this.g.drawLine(n, n6, n5, n6);
            this.g.drawLine(n, n2, n, n6);
            this.g.drawLine(n5, n2, n5, n6);
        }
        this.g.setColor(this.fgColor);
        this.g.setXORMode(this.bgColor);
    }

    public boolean cellState(int n, int n2) {
        return this.getState(n, n2);
    }

    public void changeCell(int n, int n2) {
        this.toggleState(n, n2);
    }

    public void changeCell(int n, int n2, boolean bl) {
        this.setState(n, n2, bl);
    }

    public void clear() {
        this.field = new boolean[this.fieldSizeX][this.fieldSizeY];
        this.createTranslationTables();
    }

    private void updateCell(int n, int n2, boolean bl) {
        if (this.boundsCheck) {
            if (n < 0 || n >= this.fieldSizeX) {
                return;
            }
            this.column = this.field[n];
            if (n2 < 0 || n2 >= this.fieldSizeY) {
                return;
            }
        } else {
            this.column = this.field[n];
        }
        if (this.column[n2] != bl) {
            this.column[n2] = bl;
            this.g.fillRect(this.xTranslate[n], this.yTranslate[n2], this.ppc, this.ppc);
        }
    }

    private void updateCel(int n, int n2, boolean bl) {
        if (this.boundsCheck && (n < 0 || n >= this.fieldSizeX || n2 < 0 || n2 >= this.fieldSizeY)) {
            return;
        }
        if (this.column[n2] != bl) {
            this.column[n2] = bl;
            this.g.fillRect(this.xTranslate[n], this.yTranslate[n2], this.ppc, this.ppc);
        }
    }

    private boolean display_p(LifeGen lifeGen) {
        LifeCell lifeCell = lifeGen.display;
        while (lifeCell != null) {
            LifeCell lifeCell2 = lifeCell.DisplayNext;
            if ((lifeCell.flags & 2) != 0) {
                lifeGen.removeFromDisplay(lifeCell);
            }
            int n = lifeCell.x * 16 - this.xOrig;
            int n2 = lifeCell.y * 16 - this.yOrig;
            if (n + 16 < 0 || n + 1 > this.fieldSizeX || n2 + 16 < 0 || n2 + 1 > this.fieldSizeY) {
                lifeGen.removeFromDisplay(lifeCell);
            } else {
                int n3 = n2 + 1;
                int n4 = n3 + 1;
                int n5 = n4 + 1;
                int n6 = n5 + 1;
                int n7 = n6 + 1;
                int n8 = n7 + 1;
                int n9 = n8 + 1;
                int n10 = n9 + 1;
                int n11 = n10 + 1;
                int n12 = n11 + 1;
                int n13 = n12 + 1;
                int n14 = n13 + 1;
                int n15 = n14 + 1;
                int n16 = n15 + 1;
                int n17 = n16 + 1;
                this.boundsCheck = n < 0 || n + 15 >= this.fieldSizeX || n2 < 0 || n17 >= this.fieldSizeY;
                short s = lifeCell.p[0];
                short s2 = lifeCell.p[2];
                short s3 = lifeCell.p[4];
                short s4 = lifeCell.p[6];
                this.updateCell(n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.p[1];
                s2 = lifeCell.p[3];
                s3 = lifeCell.p[5];
                s4 = lifeCell.p[7];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.p[8];
                s2 = lifeCell.p[10];
                s3 = lifeCell.p[12];
                s4 = lifeCell.p[14];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.p[9];
                s2 = lifeCell.p[11];
                s3 = lifeCell.p[13];
                s4 = lifeCell.p[15];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
            }
            lifeCell = lifeCell2;
        }
        return true;
    }

    private boolean display_q(LifeGen lifeGen) {
        LifeCell lifeCell = lifeGen.display;
        while (lifeCell != null) {
            LifeCell lifeCell2 = lifeCell.DisplayNext;
            if ((lifeCell.flags & 2) != 0) {
                lifeGen.removeFromDisplay(lifeCell);
            }
            int n = lifeCell.x * 16 - this.xOrig + 1;
            int n2 = lifeCell.y * 16 - this.yOrig + 1;
            if (n + 15 < 0 || n > this.fieldSizeX || n2 + 15 < 0 || n2 > this.fieldSizeY) {
                lifeGen.removeFromDisplay(lifeCell);
            } else {
                int n3 = n2 + 1;
                int n4 = n3 + 1;
                int n5 = n4 + 1;
                int n6 = n5 + 1;
                int n7 = n6 + 1;
                int n8 = n7 + 1;
                int n9 = n8 + 1;
                int n10 = n9 + 1;
                int n11 = n10 + 1;
                int n12 = n11 + 1;
                int n13 = n12 + 1;
                int n14 = n13 + 1;
                int n15 = n14 + 1;
                int n16 = n15 + 1;
                int n17 = n16 + 1;
                this.boundsCheck = n < 0 || n + 15 >= this.fieldSizeX || n2 < 0 || n17 >= this.fieldSizeY;
                short s = lifeCell.q[0];
                short s2 = lifeCell.q[2];
                short s3 = lifeCell.q[4];
                short s4 = lifeCell.q[6];
                this.updateCell(n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.q[1];
                s2 = lifeCell.q[3];
                s3 = lifeCell.q[5];
                s4 = lifeCell.q[7];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.q[8];
                s2 = lifeCell.q[10];
                s3 = lifeCell.q[12];
                s4 = lifeCell.q[14];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
                s = lifeCell.q[9];
                s2 = lifeCell.q[11];
                s3 = lifeCell.q[13];
                s4 = lifeCell.q[15];
                this.updateCell(++n, n2, (s & 0x8000) != 0);
                this.updateCel(n, n3, (s & 0x2000) != 0);
                this.updateCel(n, n4, (s & 0x800) != 0);
                this.updateCel(n, n5, (s & 0x200) != 0);
                this.updateCel(n, n6, (s2 & 0x8000) != 0);
                this.updateCel(n, n7, (s2 & 0x2000) != 0);
                this.updateCel(n, n8, (s2 & 0x800) != 0);
                this.updateCel(n, n9, (s2 & 0x200) != 0);
                this.updateCel(n, n10, (s3 & 0x8000) != 0);
                this.updateCel(n, n11, (s3 & 0x2000) != 0);
                this.updateCel(n, n12, (s3 & 0x800) != 0);
                this.updateCel(n, n13, (s3 & 0x200) != 0);
                this.updateCel(n, n14, (s4 & 0x8000) != 0);
                this.updateCel(n, n15, (s4 & 0x2000) != 0);
                this.updateCel(n, n16, (s4 & 0x800) != 0);
                this.updateCel(n, n17, (s4 & 0x200) != 0);
                this.updateCell(++n, n2, (s & 0x4000) != 0);
                this.updateCel(n, n3, (s & 0x1000) != 0);
                this.updateCel(n, n4, (s & 0x400) != 0);
                this.updateCel(n, n5, (s & 0x100) != 0);
                this.updateCel(n, n6, (s2 & 0x4000) != 0);
                this.updateCel(n, n7, (s2 & 0x1000) != 0);
                this.updateCel(n, n8, (s2 & 0x400) != 0);
                this.updateCel(n, n9, (s2 & 0x100) != 0);
                this.updateCel(n, n10, (s3 & 0x4000) != 0);
                this.updateCel(n, n11, (s3 & 0x1000) != 0);
                this.updateCel(n, n12, (s3 & 0x400) != 0);
                this.updateCel(n, n13, (s3 & 0x100) != 0);
                this.updateCel(n, n14, (s4 & 0x4000) != 0);
                this.updateCel(n, n15, (s4 & 0x1000) != 0);
                this.updateCel(n, n16, (s4 & 0x400) != 0);
                this.updateCel(n, n17, (s4 & 0x100) != 0);
                this.updateCell(++n, n2, (s & 0x80) != 0);
                this.updateCel(n, n3, (s & 0x20) != 0);
                this.updateCel(n, n4, (s & 8) != 0);
                this.updateCel(n, n5, (s & 2) != 0);
                this.updateCel(n, n6, (s2 & 0x80) != 0);
                this.updateCel(n, n7, (s2 & 0x20) != 0);
                this.updateCel(n, n8, (s2 & 8) != 0);
                this.updateCel(n, n9, (s2 & 2) != 0);
                this.updateCel(n, n10, (s3 & 0x80) != 0);
                this.updateCel(n, n11, (s3 & 0x20) != 0);
                this.updateCel(n, n12, (s3 & 8) != 0);
                this.updateCel(n, n13, (s3 & 2) != 0);
                this.updateCel(n, n14, (s4 & 0x80) != 0);
                this.updateCel(n, n15, (s4 & 0x20) != 0);
                this.updateCel(n, n16, (s4 & 8) != 0);
                this.updateCel(n, n17, (s4 & 2) != 0);
                this.updateCell(++n, n2, (s & 0x40) != 0);
                this.updateCel(n, n3, (s & 0x10) != 0);
                this.updateCel(n, n4, (s & 4) != 0);
                this.updateCel(n, n5, (s & 1) != 0);
                this.updateCel(n, n6, (s2 & 0x40) != 0);
                this.updateCel(n, n7, (s2 & 0x10) != 0);
                this.updateCel(n, n8, (s2 & 4) != 0);
                this.updateCel(n, n9, (s2 & 1) != 0);
                this.updateCel(n, n10, (s3 & 0x40) != 0);
                this.updateCel(n, n11, (s3 & 0x10) != 0);
                this.updateCel(n, n12, (s3 & 4) != 0);
                this.updateCel(n, n13, (s3 & 1) != 0);
                this.updateCel(n, n14, (s4 & 0x40) != 0);
                this.updateCel(n, n15, (s4 & 0x10) != 0);
                this.updateCel(n, n16, (s4 & 4) != 0);
                this.updateCel(n, n17, (s4 & 1) != 0);
            }
            lifeCell = lifeCell2;
        }
        return true;
    }

    public void updateAll(LifeGen lifeGen) {
        if (this.viewChanged) {
            lifeGen.freshenView();
            this.viewChanged = false;
        }
        if (lifeGen.qCycle) {
            this.display_q(lifeGen);
        } else {
            this.display_p(lifeGen);
        }
    }
}

