/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.ColorPanel;
import biogenesis.GeneticCode;
import biogenesis.GeneticCodePanel;
import biogenesis.GraphPanel;
import biogenesis.InfoAndColor;
import biogenesis.MainWindow;
import biogenesis.Messages;
import biogenesis.Organism;
import biogenesis.VisibleWorld;
import biogenesis.World;
import biogenesis.WorldStatistics;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class StatisticsWindow
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 700L;
    private JButton updateButton;
    private JButton closeButton;
    private World world;
    private VisibleWorld visibleWorld;
    private WorldStatistics worldStatistics;
    private List<Organism> organisms;

    public StatisticsWindow(MainWindow w, WorldStatistics ws, List<Organism> os) {
        super(w);
        this.world = w.getWorld();
        this.visibleWorld = w.getVisibleWorld();
        this.worldStatistics = ws;
        this.organisms = os;
        this.setDefaultCloseOperation(2);
        this.setTitle(Messages.getString("T_STATISTICS"));
        this.setComponents();
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private void setComponents() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(1);
        GraphPanel populationGraphPanel = new GraphPanel(100, 80);
        populationGraphPanel.addGraph(this.worldStatistics.getDeathList(), Math.max(this.worldStatistics.getAveragePopulation(), (double)this.worldStatistics.getMaxDeaths()), 0.0, Color.RED, Messages.getString("T_DEATHS"));
        populationGraphPanel.addGraph(this.worldStatistics.getBirthList(), Math.max(this.worldStatistics.getAveragePopulation(), (double)this.worldStatistics.getMaxBirth()), 0.0, Color.GREEN, Messages.getString("T_BIRTHS"));
        populationGraphPanel.addGraph(this.worldStatistics.getPopulationList(), this.worldStatistics.getMaxPopulation(), 0.0, Color.WHITE, Messages.getString("T_POPULATION"));
        populationGraphPanel.updateLegend();
        JPanel popStatsPanel = new JPanel();
        popStatsPanel.setLayout(new BoxLayout(popStatsPanel, 1));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AVERAGE_POPULATION")) + nf.format(this.worldStatistics.getAveragePopulation())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AVERAGE_BIRTH_RATE")) + nf.format(this.worldStatistics.getAverageBirths())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AVERAGE_MORTALITY_RATE")) + nf.format(this.worldStatistics.getAverageDeaths())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AVERAGE_INFECTIONS_RATE")) + nf.format(this.worldStatistics.getAverageInfections())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_GENERATED_ORGANISMS")) + nf.format(this.worldStatistics.getCreatedOrganisms())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MAXIMUM_POPULATION")) + nf.format(this.worldStatistics.getMaxPopulation())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMaxPopulationTime())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MINIMUM_POPULATION")) + nf.format(this.worldStatistics.getMinPopulation())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMinPopulationTime())));
        popStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MASS_EXTINTIONS")) + nf.format(this.worldStatistics.getMassExtintions())));
        JPanel populationPanel = new JPanel();
        populationPanel.setLayout(new BorderLayout());
        populationPanel.add((Component)populationGraphPanel, "Center");
        populationPanel.add((Component)popStatsPanel, "South");
        TitledBorder title = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), Messages.getString("T_POPULATION"), 1, 2);
        populationPanel.setBorder(title);
        GraphPanel atmosphereGraphPanel = new GraphPanel(100, 80);
        atmosphereGraphPanel.addGraph(this.worldStatistics.getOxygenList(), this.worldStatistics.getMaxOxygen(), this.worldStatistics.getMinOxygen(), Color.BLUE, Messages.getString("T_OXYGEN"));
        atmosphereGraphPanel.addGraph(this.worldStatistics.getCarbonDioxideList(), this.worldStatistics.getMaxCarbonDioxide(), this.worldStatistics.getMinCarbonDioxide(), Color.WHITE, Messages.getString("T_CARBON_DIOXIDE"));
        atmosphereGraphPanel.updateLegend();
        JPanel atmosphereStatsPanel = new JPanel();
        atmosphereStatsPanel.setLayout(new BoxLayout(atmosphereStatsPanel, 1));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MAXIMUM_CARBON_DIOXIDE")) + nf.format(this.worldStatistics.getMaxCarbonDioxide())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMaxCarbonDioxideTime())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MINIMUM_CARBON_DIOXIDE")) + nf.format(this.worldStatistics.getMinCarbonDioxide())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMinCarbonDioxideTime())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MAXIMUM_OXYGEN")) + nf.format(this.worldStatistics.getMaxOxygen())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMaxOxygenTime())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_MINIMUM_OXYGEN")) + nf.format(this.worldStatistics.getMinOxygenTime())));
        atmosphereStatsPanel.add(new JLabel(String.valueOf(Messages.getString("T_AT_TIME")) + nf.format(this.worldStatistics.getMinOxygenTime())));
        JPanel atmospherePanel = new JPanel();
        atmospherePanel.setLayout(new BorderLayout());
        atmospherePanel.add((Component)atmosphereGraphPanel, "Center");
        atmospherePanel.add((Component)atmosphereStatsPanel, "South");
        title = BorderFactory.createTitledBorder(BorderFactory.createBevelBorder(0), Messages.getString("T_ATMOSPHERE"), 1, 2);
        atmospherePanel.setBorder(title);
        JPanel worldHistoryPanel = new JPanel();
        worldHistoryPanel.setLayout(new BoxLayout(worldHistoryPanel, 1));
        worldHistoryPanel.add(populationPanel);
        worldHistoryPanel.add(atmospherePanel);
        title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("T_WORLD_HISTORY"), 1, 2);
        worldHistoryPanel.setBorder(title);
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel currentStatePanel = new JPanel();
        currentStatePanel.setLayout(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        currentStatePanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_TIME")) + this.world.getTime()), gbc);
        gbc.gridx = 2;
        currentStatePanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_OXYGEN2")) + nf.format(this.world.getO2())), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        currentStatePanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_POPULATION2")) + this.world.getPopulation()), gbc);
        gbc.gridx = 2;
        currentStatePanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_CARBON_DIOXIDE2")) + nf.format(this.world.getCO2())), gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        currentStatePanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_REMAINS_OF_BEINGS")) + this.world.getNCorpses()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.anchor = 17;
        currentStatePanel.add((Component)new JLabel(Messages.getString("T_COLOR_PROPORTION")), gbc);
        ColorPanel colorPanel = this.createColorPanel();
        gbc.gridx = 2;
        currentStatePanel.add((Component)colorPanel, gbc);
        title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("T_CURRENT_STATE"), 1, 2);
        currentStatePanel.setBorder(title);
        this.worldStatistics.findBestAliveBeings(this.organisms);
        JPanel notableBeingsPanel = new JPanel();
        notableBeingsPanel.setLayout(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 1;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_ALIVE_BEING_HAVING_THE_MOST_CHILDREN")), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_BEING_HAVING_THE_MOST_CHILDREN")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        GeneticCodePanel aliveMostChildrenPanel = new GeneticCodePanel(this.worldStatistics.getAliveBeingMostChildren(), this.visibleWorld);
        notableBeingsPanel.add((Component)aliveMostChildrenPanel, gbc);
        gbc.gridx = 2;
        GeneticCodePanel mostChildrenPanel = new GeneticCodePanel(this.worldStatistics.getBeingMostChildren(), this.visibleWorld);
        notableBeingsPanel.add((Component)mostChildrenPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_CHILDREN")) + this.worldStatistics.getAliveBeingMostChildrenNumber()), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_CHILDREN")) + this.worldStatistics.getBeingMostChildrenNumber()), gbc);
        gbc.gridy = 4;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_TIME")) + this.worldStatistics.getBeingMostChildrenTime()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 5;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_ALIVE_BEING_HAVING_THE_MOST_VICTIMS")), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_BEING_HAVING_THE_MOST_VICTIMS")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 6;
        GeneticCodePanel aliveMostKillsPanel = new GeneticCodePanel(this.worldStatistics.getAliveBeingMostKills(), this.visibleWorld);
        notableBeingsPanel.add((Component)aliveMostKillsPanel, gbc);
        gbc.gridx = 2;
        GeneticCodePanel mostKillsPanel = new GeneticCodePanel(this.worldStatistics.getBeingMostKills(), this.visibleWorld);
        notableBeingsPanel.add((Component)mostKillsPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 7;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_VICTIMS")) + this.worldStatistics.getAliveBeingMostKillsNumber()), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_VICTIMS")) + this.worldStatistics.getBeingMostKillsNumber()), gbc);
        gbc.gridy = 8;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_TIME")) + this.worldStatistics.getBeingMostKillsTime()), gbc);
        gbc.gridx = 1;
        gbc.gridy = 9;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_ALIVE_BEING_HAVING_THE_MOST_INFECTED")), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(Messages.getString("T_BEING_HAVING_THE_MOST_INFECTED")), gbc);
        gbc.gridx = 1;
        gbc.gridy = 10;
        GeneticCodePanel aliveMostInfectionsPanel = new GeneticCodePanel(this.worldStatistics.getAliveBeingMostInfections(), this.visibleWorld);
        notableBeingsPanel.add((Component)aliveMostInfectionsPanel, gbc);
        gbc.gridx = 2;
        GeneticCodePanel mostInfectionsPanel = new GeneticCodePanel(this.worldStatistics.getBeingMostInfections(), this.visibleWorld);
        notableBeingsPanel.add((Component)mostInfectionsPanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 11;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_INFECTED")) + this.worldStatistics.getAliveBeingMostInfectionsNumber()), gbc);
        gbc.gridx = 2;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_NUMBER_OF_INFECTED")) + this.worldStatistics.getBeingMostInfectionsNumber()), gbc);
        gbc.gridy = 12;
        notableBeingsPanel.add((Component)new JLabel(String.valueOf(Messages.getString("T_TIME")) + this.worldStatistics.getBeingMostInfectionsTime()), gbc);
        title = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getString("T_REMARKABLE_ORGANISMS"), 1, 2);
        notableBeingsPanel.setBorder(title);
        JPanel buttonsPanel = new JPanel();
        this.updateButton = new JButton(Messages.getString("T_UPDATE"));
        this.closeButton = new JButton(Messages.getString("T_CLOSE"));
        buttonsPanel.add(this.updateButton);
        buttonsPanel.add(this.closeButton);
        this.updateButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.add(currentStatePanel);
        leftPanel.add(notableBeingsPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(worldHistoryPanel);
        rightPanel.add(buttonsPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)leftPanel, "West");
        this.getContentPane().add((Component)rightPanel, "East");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorPanel createColorPanel() {
        int j;
        ColorPanel colorPanel = new ColorPanel();
        colorPanel.setPreferredSize(new Dimension(100, 20));
        Object[] colorCounter = new InfoAndColor[]{new InfoAndColor(0, Color.GREEN), new InfoAndColor(0, Color.RED), new InfoAndColor(0, Color.BLUE), new InfoAndColor(0, Color.CYAN), new InfoAndColor(0, Color.WHITE), new InfoAndColor(0, Color.GRAY), new InfoAndColor(0, Color.YELLOW)};
        List<Organism> list = this.organisms;
        synchronized (list) {
            Iterator<Organism> it = this.organisms.iterator();
            while (it.hasNext()) {
                GeneticCode gc = it.next().getGeneticCode();
                int i = 0;
                while (i < gc.getNGenes()) {
                    Color c = gc.getGene(i).getColor();
                    j = 0;
                    while (j < 7) {
                        if (c.equals(((InfoAndColor)colorCounter[j]).color)) {
                            ++((InfoAndColor)colorCounter[j]).info;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        Arrays.sort(colorCounter);
        j = 6;
        while (j >= 0) {
            colorPanel.addColor(((InfoAndColor)colorCounter[j]).info, ((InfoAndColor)colorCounter[j]).color);
            --j;
        }
        return colorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.updateButton) {
            this.getContentPane().removeAll();
            this.setComponents();
            this.pack();
            this.invalidate();
        }
        if (e.getSource() == this.closeButton) {
            this.dispose();
        }
    }
}

